/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import SSS.Actor;
import SSS.Behaviour;
import SSS.BehaviourParameter;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Level;
import java.util.Map;
import org.flixel.event.FlxSpriteCollisionEvent;

public class WorkShopBehaviour
extends Behaviour {
    boolean m_bConsumed = false;
    boolean m_bRegisteredInBlocManager = false;
    Actor m_fakeActor = new Actor();

    public WorkShopBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = true;
    }

    @Override
    public void init() {
        this._registerInBlocManager();
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void onParamsChanged() {
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_DrillFake: {
                break;
            }
            case eGenericMessage_Drill: {
                this._handleDrillMessage(_sender);
            }
        }
    }

    protected void _handleDrillMessage(Actor _sender) {
    }

    protected void _destroy() {
        if (!this.m_bConsumed) {
            this.m_bConsumed = true;
            this.m_owner.Level().removeActorsToPhysic(this.m_owner);
            this._unregisterInBlocManager();
        }
    }

    protected void _workshopDrill() {
        boolean bCanBeConsumed = true;
        int amount = 0;
        PlayerBehaviour playerBehaviour = (PlayerBehaviour)this.m_owner.Level().MainPlayer().getBehaviour("player");
        for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
            Actor.eActorMaterial material;
            amount = matAmount.getValue().getValue();
            if (amount <= 0 || amount <= playerBehaviour.getCollectableAmount(material = Actor.MaterialNameEnumDictionnary.get(matAmount.getKey()))) continue;
            bCanBeConsumed = false;
            break;
        }
        playerBehaviour.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ResetCollectableNeededCounters, this.m_owner);
        if (bCanBeConsumed) {
            for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
                amount = matAmount.getValue().getValue();
                if (amount <= 0) continue;
                this.m_fakeActor.Material(Actor.MaterialNameEnumDictionnary.get(matAmount.getKey()));
                int i = 0;
                while (i < amount) {
                    playerBehaviour.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DecrementMaterialStock, this.m_fakeActor);
                    ++i;
                }
            }
            Actor.eActorMaterial drillMat = Actor.MaterialNameEnumDictionnary.get(this.getStringParameter("unlockableMat"));
            Actor.SetCanBeDrilled(drillMat, true);
            this._destroy();
        } else {
            for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
                amount = matAmount.getValue().getValue();
                if (amount <= 0) continue;
                this.m_fakeActor.Material(Actor.MaterialNameEnumDictionnary.get(matAmount.getKey()));
                int i = 0;
                while (i < amount) {
                    playerBehaviour.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_IncrementMaterialStockNeeded, this.m_fakeActor);
                    ++i;
                }
            }
            this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsion, this.m_owner);
        }
    }

    protected void _registerInBlocManager() {
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Play || this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Test) {
            this.m_bRegisteredInBlocManager = true;
            this.m_owner.Level().BlocManager().registerUnremovableBloc(this.m_owner);
        }
    }

    protected void _unregisterInBlocManager() {
        if (this.m_bRegisteredInBlocManager) {
            this.m_owner.Level().BlocManager().unregisterUnremovableBloc(this.m_owner);
        }
    }
}

