/*
 * Decompiled with CFR 0.152.
 */
package SSS;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Content.XDocument;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.BTM.PlayState;
import SSS.Behaviour;
import SSS.BehaviourParameter;
import SSS.Behaviours.BTM.DoorBehaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.BlocManager;
import SSS.Managers.BTM.BlocksSoundsManager;
import SSS.Managers.BTM.DialogDataBase;
import SSS.Managers.BTM.DialogManager;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.Particle.ParticleManager;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.SaveManager;
import SSS.Managers.BTM.SwitchObserver;
import SSS.Managers.FileManager;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.LauncherState;
import SSS.States.BTM.LevelSelectionState;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.OnlineLevelBrowsingState;
import SSS.States.BTM.PauseFakeState;
import SSS.Tween.TweenManager;
import SSS.UI.MenuEditor;
import SSS.Util.Debug;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import SSS.editor.Editor;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class Level {
    protected ArrayList<Actor> m_actorsGarbage = new ArrayList(30);
    protected ArrayList<Actor> m_toRecomputeGroundAnim = new ArrayList(30);
    String m_name = "tmp";
    String m_version = "0.0.0.0";
    boolean m_bManagerDestroyed = false;
    LevelGroup m_group = null;
    protected boolean m_bGuidePauseAllowed = true;
    Vector2 m_leftBottom = new Vector2(0.0f, 0.0f);
    Vector2 m_rightTop = new Vector2(Float.MAX_VALUE, Float.MIN_VALUE);
    Vector2 m_bboxShift = Vector2.Zero();
    Vector2 m_bboxShiftOld = Vector2.Zero();
    int m_lastUpdateFrameId;
    boolean m_bAllowMaincharacterMove = true;
    boolean m_bAllowEnnemiesMove = true;
    MenuEditor m_menu;
    PauseFakeState m_pauseMenu;
    boolean m_bAllowEdit = true;
    boolean m_bPause = false;
    SwitchObserver m_switchObserver = null;
    DialogManager m_dialogManager = null;
    ParticleManager m_particlesManager = null;
    BlocksSoundsManager m_blocSoundManager = null;
    TweenManager m_tweenerManager = null;
    BlocManager m_blocManager = null;
    boolean m_bReturnToHubRequested = false;
    boolean m_bReturnToMainMenu = false;
    boolean m_bGoToThanks = false;
    boolean m_bLoadLevelInUniverseRequested = false;
    boolean m_bLoadLevelSequenceRequested = false;
    boolean m_bNextLevel = true;
    String m_LoadLevelSequenceRequestedName;
    eLevelMode m_mode = eLevelMode.eLevelMode_Unknown;
    ArrayList<CallbackSimple> LevelJustLoaded = null;
    ArrayList<CallbackSimple> LevelBeingDestroy = null;
    ArrayList<CallbackSimple> LevelModeChanged = null;
    boolean m_bRestart = false;
    Editor m_editor;
    Actor m_player = null;
    PlayerBehaviour m_playerBehaviour = null;
    protected ArrayList<Actor> m_puzzleOnOffListeners = new ArrayList(30);
    protected SssGroup m_ennemiesToCollide = new SssGroup();
    boolean m_bPuzzleMode = false;
    boolean m_bCheckTracks = true;
    int m_soundSpawnerCount = 0;
    SssGroup m_layerActiveIsoDisplay;
    SssGroup m_layerPassiveIsoDisplay;
    SssGroup m_layersTiledBackground;
    ArrayList<SssGroup> m_layersBackground;
    SssGroup m_layerPhysics;
    SssGroup m_layerPieceProjection = null;
    SssGroup m_layerBlocDelimiter = null;
    SssGroup m_layerPostProcess = null;
    SssGroup m_layerPlayer;
    ArrayList<SssGroup> m_layersForeground;
    SssGroup m_layerPortal;
    SssGroup m_layerParticleEffects;
    SssGroup m_layerVignettage;
    FlxSprite m_vignettage = null;
    SssGroup m_layerHud;
    Actor m_playerSpawnpoint = null;
    ResourcesLibrary m_resourceLibrary = null;
    CallbackSimple m_returnToLevelHubAutoSaveComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Level.this._returnToLevelHubAutoSaveComplete(_sender, _args);
        }
    };
    CallbackSimple m_returnToMainMenuAutoSaveComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Level.this._returnToMainMenuAutoSaveComplete(_sender, _args);
        }
    };
    CallbackSimple m_goToThanksFadeComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Level.this._goToThanksFadeComplete(_sender, _args);
        }
    };
    static String EmptyLevel = "<Level name=\"tmp\" lbx=\"0\" lby=\"0\" rtx=\"64\" rty=\"-64\"><Layer type=\"SSSLayerType_Player\" id=\"0\"><Actor x=\"0\" y=\"3\" friendly=\"player\"/></Layer></Level>";
    static String EmptyLevelFlaged = "<Level name=\"[n]\" lbx=\"0\" lby=\"0\" rtx=\"64\" rty=\"-64\"><Layer type=\"SSSLayerType_Player\" id=\"0\"><Actor x=\"0\" y=\"3\" friendly=\"player\"/></Layer></Level>";

    public String Name() {
        return this.m_name;
    }

    public LevelGroup Group() {
        return this.m_group;
    }

    public boolean PlayableMode() {
        return this.Mode() == eLevelMode.eLevelMode_Test || this.Mode() == eLevelMode.eLevelMode_Play;
    }

    public void GuidePauseAllowed(boolean value) {
        this.m_bGuidePauseAllowed = value;
    }

    public boolean GuidePauseAllowed() {
        return this.m_bGuidePauseAllowed;
    }

    public Vector2 LeftBottom() {
        return this.m_leftBottom;
    }

    public Vector2 RightTop() {
        return this.m_rightTop;
    }

    public float getWidth() {
        return this.m_rightTop.X - this.m_leftBottom.X;
    }

    public float getHeight() {
        return this.m_leftBottom.Y - this.m_rightTop.Y;
    }

    public boolean AllowMaincharacterMove() {
        return this.m_bAllowMaincharacterMove;
    }

    public void AllowMaincharacterMove(boolean value) {
        this.m_bAllowMaincharacterMove = value;
    }

    public boolean AllowEnnemiesMove() {
        return this.m_bAllowEnnemiesMove;
    }

    public void AllowEnnemiesMove(boolean value) {
        this.m_bAllowEnnemiesMove = value;
        if (this.m_layerPlayer != null) {
            Actor actor = null;
            Actor.eGenericMessage message = this.m_bAllowEnnemiesMove ? Actor.eGenericMessage.eGenericMessage_UnFreezeEnnemy : Actor.eGenericMessage.eGenericMessage_FreezeEnnemy;
            int i = 0;
            while (i < this.m_layerPlayer.members.size()) {
                actor = (Actor)this.m_layerPlayer.members.get(i);
                if (actor != null) {
                    actor.handleGenericMessage(message, this.m_player);
                }
                ++i;
            }
        }
    }

    public boolean isEditMenuVisible() {
        return this.m_menu.Visible();
    }

    public boolean Pause() {
        return this.m_bPause;
    }

    public SwitchObserver SwitchObserver() {
        return this.m_switchObserver;
    }

    public DialogManager DialogManager() {
        return this.m_dialogManager;
    }

    public ParticleManager ParticleManager() {
        return this.m_particlesManager;
    }

    public BlocksSoundsManager BlocSoundManager() {
        return this.m_blocSoundManager;
    }

    public TweenManager TweenManager() {
        return this.m_tweenerManager;
    }

    public BlocManager BlocManager() {
        return this.m_blocManager;
    }

    public eLevelMode Mode() {
        return this.m_mode;
    }

    public void addLevelJustLoaded(CallbackSimple _callback) {
        if (this.LevelJustLoaded == null) {
            this.LevelJustLoaded = new ArrayList();
        }
        this.LevelJustLoaded.add(_callback);
    }

    public void addLevelBeingDestroy(CallbackSimple _callback) {
        if (this.LevelBeingDestroy == null) {
            this.LevelBeingDestroy = new ArrayList();
        }
        this.LevelBeingDestroy.add(_callback);
    }

    public void addLevelModeChanged(CallbackSimple _callback) {
        if (this.LevelModeChanged == null) {
            this.LevelModeChanged = new ArrayList();
        }
        this.LevelModeChanged.add(_callback);
    }

    public Editor Editor() {
        return this.m_editor;
    }

    public Actor MainPlayer() {
        return this.m_player;
    }

    public PlayerBehaviour MainPlayerBehaviour() {
        return this.m_playerBehaviour;
    }

    public void addPuzzleModeChangedListener(Actor _actor) {
        this.m_puzzleOnOffListeners.add(_actor);
    }

    public void removePuzzleModeChangedListener(Actor _actor) {
        this.m_puzzleOnOffListeners.remove(_actor);
    }

    public SssGroup Ennemies() {
        return this.m_ennemiesToCollide;
    }

    public void addEnnemyToCollide(Actor _actor) {
        this.m_ennemiesToCollide.add(_actor);
    }

    public void removeEnnemyToCollide(Actor _actor) {
        this.m_ennemiesToCollide.remove(_actor);
    }

    public boolean PuzzleMode() {
        return this.m_bPuzzleMode;
    }

    public void PuzzleMode(boolean value) {
        this._changlePuzzleMode(value);
    }

    protected void _changlePuzzleMode(boolean _newValue) {
        if (_newValue != this.m_bPuzzleMode) {
            this.m_bPuzzleMode = _newValue;
            if (this.m_bPuzzleMode) {
                int i = 0;
                while (i < this.m_puzzleOnOffListeners.size()) {
                    this.m_puzzleOnOffListeners.get(i).handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PuzzleModeEnter, null);
                    ++i;
                }
                this.m_blocSoundManager.muteLoopedSounds(true);
            } else {
                int i = 0;
                while (i < this.m_puzzleOnOffListeners.size()) {
                    this.m_puzzleOnOffListeners.get(i).handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PuzzleModeLeave, null);
                    ++i;
                }
                this.m_blocSoundManager.muteLoopedSounds(false);
            }
        }
    }

    public void incrementSoundSpawnerCount() {
        this.m_bCheckTracks = false;
    }

    public SssGroup LayerIso() {
        return this.m_layerActiveIsoDisplay;
    }

    public SssGroup LayerPassiveIso() {
        return this.m_layerPassiveIsoDisplay;
    }

    public SssGroup LayersTiledBackground() {
        return this.m_layersTiledBackground;
    }

    public ArrayList<SssGroup> LayerBackGround() {
        return this.m_layersBackground;
    }

    public SssGroup LayerPhysics() {
        return this.m_layerPhysics;
    }

    public SssGroup LayerPieceProjection() {
        return this.m_layerPieceProjection;
    }

    public SssGroup LayerBlocDelimiter() {
        return this.m_layerBlocDelimiter;
    }

    public SssGroup LayerPostProcess() {
        return this.m_layerPostProcess;
    }

    public SssGroup LayerPlayer() {
        return this.m_layerPlayer;
    }

    public ArrayList<SssGroup> LayerForeGround() {
        return this.m_layersForeground;
    }

    public SssGroup LayerPortal() {
        return this.m_layerPortal;
    }

    public SssGroup LayerParticleEffects() {
        return this.m_layerParticleEffects;
    }

    public SssGroup LayerVignettage() {
        return this.m_layerVignettage;
    }

    public SssGroup LayerHud() {
        return this.m_layerHud;
    }

    public float PlayerSpawnX() {
        return this.m_playerSpawnpoint != null ? this.m_playerSpawnpoint.getCenterX() : 0.0f;
    }

    public float PlayerSpawnY() {
        return this.m_playerSpawnpoint != null ? this.m_playerSpawnpoint.getCenterY() : 0.0f;
    }

    public void setPlayerSpawnPoint(Actor _actor) {
        if (this.m_playerSpawnpoint != null && !this.m_playerSpawnpoint.equals(_actor)) {
            this.removeActorFromLayer(this.m_layerPlayer, this.m_playerSpawnpoint, true);
            this.m_playerSpawnpoint.kill();
            this.m_playerSpawnpoint = null;
            this.m_playerSpawnpoint = _actor;
        } else if (this.m_playerSpawnpoint == null) {
            this.m_playerSpawnpoint = _actor;
        }
    }

    public Level(boolean _bWarning_FakeLevel) {
        this.m_resourceLibrary = ResourcesLibrary.Instance();
        this.m_layerHud = new SssGroup();
        this.m_player = new Actor();
    }

    public Level(PlayState _state, eLevelMode _mode) {
        this.m_resourceLibrary = ResourcesLibrary.Instance();
        FlxG.DoFollowAvailable(true);
        this.m_bManagerDestroyed = false;
        this._setMode(_mode, false);
        this._buildLayers();
        this.m_editor = new Editor(this);
        this.m_editor.initDefaultLevel();
        this.m_menu = new MenuEditor(this);
        this.m_pauseMenu = new PauseFakeState(_state, null);
        this.m_pauseMenu.create();
        this.registerLayer(_state);
        this.m_player = this.m_editor.instanciateActor("player", this);
        this.m_player.createComponents(this, false);
        this.m_playerBehaviour = (PlayerBehaviour)this.m_player.getBehaviour("player");
        this.addActorToLayer(this.LayerPlayer(), this.m_player);
        this._levelJustLoaded(null, null);
        this._syncEditorDependingMode();
        this.m_lastUpdateFrameId = FlxG.FrameId + 1;
    }

    public boolean hasLevelsSequence(String _sequenceName) {
        return this.m_editor.hasLevelsSequence(_sequenceName);
    }

    public ArrayList<String> getLevelsSequences() {
        return this.m_editor.getLevelsSequences();
    }

    public void allowEdit(boolean _bAllowEdit) {
        this.m_bAllowEdit = _bAllowEdit;
    }

    public boolean allowEdit() {
        return this.m_bAllowEdit;
    }

    public void launchFirstLevelInSequence(String _sequenceName) {
        String name = this.m_editor.getFirstLevelInSequence(_sequenceName);
        GameVars.LevelSequence(_sequenceName);
        this.loadLevel(name, null);
    }

    public void loadLevel(String name, LevelGroup group) {
        this.m_group = group;
        this.m_editor.leaveEditMode();
        this.unload();
        if (!this.LoadLevel(name, false)) {
            return;
        }
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            if (this.m_mode == eLevelMode.eLevelMode_Play) {
                this.enterPlayMode(false);
            } else {
                this.enterEditMode(true);
            }
        } else {
            this.enterPlayMode(false);
        }
        this._placePlayerAtSpawnpoint();
        this.m_menu.Visible(false);
    }

    protected void _checkLaunchNextLevelInSequence() {
        if (this.m_bLoadLevelSequenceRequested) {
            String name;
            this.m_bLoadLevelSequenceRequested = false;
            if (this.hasLevelsSequence(this.m_LoadLevelSequenceRequestedName) && (name = this.m_editor.getLevelNextToLevel(this.m_name, this.m_LoadLevelSequenceRequestedName, !this.m_bNextLevel)) != null) {
                this.m_editor.leaveEditMode();
                this.unload();
                this.LoadLevel(name, false);
                this.enterPlayMode(false);
                this._placePlayerAtSpawnpoint();
                this.m_menu.Visible(false);
            }
        }
    }

    protected void _checkRestartLevel() {
        if (this.m_bRestart) {
            this.m_bRestart = false;
            this.m_playerBehaviour.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_RestartLevel, null);
        }
    }

    public void returnToLevelHub() {
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            this.m_returnToLevelHubAutoSaveComplete.onCallback(this, null);
        } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
            this.m_returnToLevelHubAutoSaveComplete.onCallback(this, null);
        } else {
            SaveManager.Instance().saveGameDataThreaded(this.m_returnToLevelHubAutoSaveComplete);
        }
    }

    public void returnToMainMenu(boolean _save) {
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            this._returnToMainMenuAutoSaveComplete(null, null);
        } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
            this._returnToMainMenuAutoSaveComplete(null, null);
        } else if (_save) {
            SaveManager.Instance().saveGameDataThreaded(this.m_returnToMainMenuAutoSaveComplete);
        } else {
            this._returnToMainMenuAutoSaveComplete(null, null);
        }
    }

    public void goToTanksLevel() {
        SaveManager.Instance().saveGameDataThreaded(this.m_goToThanksFadeComplete);
    }

    protected void _returnToLevelHubAutoSaveComplete(Object sender, Object e) {
        this.m_bReturnToHubRequested = true;
    }

    protected void _goToThanksFadeComplete(Object sender, Object e) {
        this.m_bGoToThanks = true;
    }

    protected void _returnToMainMenuAutoSaveComplete(Object sender, Object e) {
        this.m_bReturnToMainMenu = true;
    }

    protected void _checkGoToThanksLevel() {
        if (this.m_bGoToThanks) {
            this.m_bGoToThanks = false;
            FlxG.state(new PlayState(true, false, "THANKS", "Specials"));
        }
    }

    protected void _checkReturnToMainMenu() {
        if (this.m_bReturnToMainMenu) {
            this.m_bReturnToMainMenu = false;
            if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                FlxG.state(new OnlineLevelBrowsingState(false, true));
            } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
                FlxG.state(new OnlineLevelBrowsingState(true, true));
            } else {
                FlxG.state(new MenuMainState(true, false));
            }
        }
    }

    protected void _checkReturnToLevelHub() {
        if (this.m_bReturnToHubRequested) {
            this.m_bReturnToHubRequested = false;
            if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                FlxG.state(new OnlineLevelBrowsingState(false, true));
            } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
                FlxG.state(new OnlineLevelBrowsingState(true, true));
            } else {
                FlxG.state(new LevelSelectionState(true, null, this.Name()));
            }
        }
    }

    protected void _returnToSafeState() {
        if (GameVars.GameMode() == GameMode.GameMode_Main) {
            FlxG.state(new MenuMainState(true, false));
        } else {
            FlxG.state(new MenuMainState(true, false));
        }
    }

    protected void _checkLaunchNextLevelInUniverse() {
        if (this.m_bLoadLevelInUniverseRequested) {
            this.m_bLoadLevelInUniverseRequested = false;
            if (this.m_bNextLevel) {
                this.m_playerBehaviour.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_GoToNextLevelInUniverse, null);
            } else {
                this.m_playerBehaviour.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_GoToPreviousLevelInUniverse, null);
            }
        }
    }

    public void launchNextLevelInUniverseDeffered() {
        this.m_bLoadLevelInUniverseRequested = true;
        this.m_bNextLevel = true;
    }

    public void launchPreviousLevelInUniverseDeffered() {
        this.m_bLoadLevelInUniverseRequested = true;
        this.m_bNextLevel = false;
    }

    public void launchNextLevelInSequenceDeffered(String _sequenceName) {
        this.m_bLoadLevelSequenceRequested = true;
        this.m_bNextLevel = true;
        this.m_LoadLevelSequenceRequestedName = _sequenceName;
    }

    public void launchPreviousLevelInSequenceDeferred(String _sequenceName) {
        this.m_bLoadLevelSequenceRequested = true;
        this.m_bNextLevel = false;
        this.m_LoadLevelSequenceRequestedName = _sequenceName;
    }

    protected void _flushRecomputeGroundAnimList() {
        if (this.m_toRecomputeGroundAnim.size() > 0) {
            for (Actor a : this.m_toRecomputeGroundAnim) {
                if (!a.hasFlag(Actor.eSpecialFlag.eSpecialFlag_GroundToBeRecomputed)) continue;
                a.removeFlag(Actor.eSpecialFlag.eSpecialFlag_GroundToBeRecomputed);
                if (a.hasFlag(Actor.eSpecialFlag.eSpecialFlag_PassiveIso)) {
                    this._transferIsoPassiveActorToIsoActive(a);
                }
                this.m_blocManager.computeAutoAnimForActor(a);
            }
            this.m_toRecomputeGroundAnim.clear();
        }
    }

    public void addToRecomputeGroundAnimActor(Actor _actor) {
        if (!_actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_GroundToBeRecomputed)) {
            _actor.addFlag(Actor.eSpecialFlag.eSpecialFlag_GroundToBeRecomputed);
            this.m_toRecomputeGroundAnim.add(_actor);
        }
    }

    protected void _tmpFlushToDeleteList() {
        if (this.m_actorsGarbage.size() > 0) {
            for (Actor a : this.m_actorsGarbage) {
                this._realRemoveActorFromLayer(a.TmpDeleteLayer(), a);
                a.kill();
            }
            this.m_actorsGarbage.clear();
        }
    }

    protected void _addActorToGarbage(Actor _actor, SssGroup _layer) {
        _actor.TmpDeleteLayer(_layer);
        this.m_actorsGarbage.add(_actor);
    }

    public void destroy() {
        if (!this.m_bManagerDestroyed) {
            this._destructManagers();
        }
    }

    protected void _setMode(eLevelMode _mode, boolean _bCheckAutoSave) {
        _bCheckAutoSave = true;
        if (this.m_mode != _mode) {
            eLevelMode oldMode = this.m_mode;
            this.m_mode = _mode;
            if (_bCheckAutoSave) {
                this._checkLoadSave(oldMode, this.m_mode);
            }
            if (this.LevelModeChanged != null) {
                int i = 0;
                while (i < this.LevelModeChanged.size()) {
                    this.LevelModeChanged.get(i).onCallback(this, null);
                    ++i;
                }
            }
        }
    }

    protected void _computeBBoxShifted() {
        this._computeLayerBBox(this.m_layerPhysics, true);
        this.m_bboxShift.X = -this.m_leftBottom.X;
        this.m_bboxShift.Y = -this.m_leftBottom.Y;
        this.m_leftBottom.X += this.m_bboxShift.X;
        this.m_leftBottom.Y += this.m_bboxShift.Y;
        this.m_rightTop.X += this.m_bboxShift.X;
        this.m_rightTop.Y += this.m_bboxShift.Y;
    }

    protected void _reinitShift() {
        this.m_bboxShiftOld = this.m_bboxShift;
        this.m_bboxShift = Vector2.Zero();
    }

    protected void _computeLayerBBox(FlxGroup _layer, boolean _bInitMinMax) {
        Actor actor = null;
        if (_layer.members.size() > 0) {
            if (_bInitMinMax) {
                actor = (Actor)_layer.members.get(0);
                this.m_leftBottom.X = this.m_rightTop.X = actor.x;
                this.m_leftBottom.Y = this.m_rightTop.Y = actor.y;
            }
            this._updateMinMax((Actor)_layer.members.get(0));
            int i = 0;
            while (i < _layer.members.size()) {
                actor = (Actor)_layer.members.get(i);
                this._updateMinMax(actor);
                ++i;
            }
        }
    }

    protected void _updateMinMax(Actor _actor) {
        float tmp = _actor.x + _actor.width;
        if (this.m_rightTop.X < tmp) {
            this.m_rightTop.X = tmp;
        } else if (this.m_leftBottom.X > _actor.x) {
            this.m_leftBottom.X = _actor.x;
        }
        tmp = _actor.y + _actor.height;
        if (this.m_rightTop.Y > _actor.y) {
            this.m_rightTop.Y = _actor.y;
        } else if (this.m_leftBottom.Y < tmp) {
            this.m_leftBottom.Y = tmp;
        }
    }

    protected void _checkLoadSave(eLevelMode _oldMode, eLevelMode _newMode) {
        float savex = 0.0f;
        float savey = 0.0f;
        boolean bRestorePos = false;
        if (this.m_player != null) {
            savex = this.m_player.x;
            savey = this.m_player.y;
            bRestorePos = true;
        }
        if (_oldMode == eLevelMode.eLevelMode_Edit && (_newMode == eLevelMode.eLevelMode_Play || _newMode == eLevelMode.eLevelMode_Test)) {
            this.SaveLevel(this.m_name);
            this.LoadLevel(this.m_name, false);
            if (bRestorePos && _newMode == eLevelMode.eLevelMode_Test) {
                this.m_player.x = savex + this.m_bboxShiftOld.X;
                this.m_player.y = savey + this.m_bboxShiftOld.Y;
            }
        } else if (_newMode == eLevelMode.eLevelMode_Edit && (_oldMode == eLevelMode.eLevelMode_Play || _oldMode == eLevelMode.eLevelMode_Test)) {
            this.LoadLevel(this.m_name, true);
            if (bRestorePos) {
                this.m_player.x = savex;
                this.m_player.y = savey;
            }
        }
    }

    protected void _syncEditorDependingMode() {
        switch (this.m_mode) {
            case eLevelMode_Edit: {
                this.m_editor.enterEditMode();
            }
        }
    }

    public void recomputeGround() {
        BlocManager.RecomputeGround(this.m_layerPhysics, this.m_editor.getActorCursor());
    }

    public void enterPlayMode(boolean _bCheckAutoSave) {
        if (this.m_mode != eLevelMode.eLevelMode_Play) {
            this.m_editor.leaveEditMode();
            this._setMode(eLevelMode.eLevelMode_Play, _bCheckAutoSave);
        }
        this.m_editor.hideCursorActor();
    }

    public void enterTestMode() {
        if (this.m_mode != eLevelMode.eLevelMode_Test) {
            this.m_editor.leaveEditMode();
            this._setMode(eLevelMode.eLevelMode_Test, true);
        }
        this.m_editor.hideCursorActor();
    }

    public void enterEditMode() {
        this.enterEditMode(false);
    }

    protected void enterEditMode(boolean _bForced) {
        if (this.m_mode != eLevelMode.eLevelMode_Edit || _bForced) {
            this.m_editor.enterEditMode();
            this._setMode(eLevelMode.eLevelMode_Edit, true);
        }
        MusicManager.Instance().playTracks(null, null, 0.0f, true);
    }

    public boolean inEditMode() {
        return this.m_editor != null ? Editor.EditMode() : false;
    }

    public void SaveLevel(String _name) {
        if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
            return;
        }
        this.m_name = _name;
        this.save(_name);
    }

    public boolean LoadLevel(String _loadName, boolean _enterEditModeBeforeLoading) {
        boolean bLoaded = this.load(_loadName);
        if (!bLoaded) {
            this._checkGameVersionAndSafeState();
            return false;
        }
        if (this.PlayableMode()) {
            this.m_vignettage = this.m_editor.instanciateSprite("vignettage");
            this.m_vignettage.color(Color.Black());
            this.m_vignettage.scrollFactor = Vector2.Zero();
            this.m_vignettage.UseRounding(false);
            this.m_vignettage.x = (float)FlxG.width * 0.5f - this.m_vignettage.width * 0.5f;
            this.m_vignettage.y = (float)FlxG.height * 0.5f - this.m_vignettage.height * 0.5f;
            this.m_vignettage.scale((float)(FlxG.width + 8) / this.m_vignettage.width);
            this.LayerVignettage().add(this.m_vignettage);
            this.m_pauseMenu.updatePauseScreenTitle();
        }
        this.m_editor.onLevelLoaded();
        return true;
    }

    public void colorizeForBlocMode(Color _color, boolean _puzzleColorize) {
        this.colorizeForBlocMode(this.m_layersTiledBackground, _color, null, _puzzleColorize);
        this.colorizeForBlocMode(this.m_layerPhysics, _color, null, _puzzleColorize);
        for (FlxGroup flxGroup : this.m_layersBackground) {
            this.colorizeForBlocMode(flxGroup, _color, null, _puzzleColorize);
        }
        this.colorizeForBlocMode(this.m_layerPassiveIsoDisplay, _color, null, _puzzleColorize);
        for (FlxGroup flxGroup : this.m_layersForeground) {
            this.colorizeForBlocMode(flxGroup, _color, null, _puzzleColorize);
        }
        this.colorizeForBlocMode(this.m_layerPlayer, _color, this.m_player, _puzzleColorize);
    }

    public void colorizeForBlocMode(FlxGroup _layer, Color _color, Actor _exceptionOrNil, boolean _puzzleColorize) {
        Actor actor = null;
        int i = 0;
        while (i < _layer.members.size()) {
            actor = (Actor)_layer.members.get(i);
            if (!(actor == null || _exceptionOrNil != null && actor.equals(_exceptionOrNil))) {
                if (actor.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
                    if (_puzzleColorize) {
                        actor.color().multiply(_color);
                    } else {
                        actor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ActorInitDefaultColor, null);
                    }
                } else {
                    actor.color(_color);
                }
            }
            ++i;
        }
    }

    protected void _buildLayers() {
        this.m_layersBackground = new ArrayList();
        this.m_layersForeground = new ArrayList();
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_TiledBackground);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Background);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Background);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Portal);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_PieceProjection);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_BlocDelimiter);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Physics);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Player);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_PassiveIsoRendering);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_ActiveIsoRendering);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Foreground);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Foreground);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_ParticleEffects);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_PostProcess);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Vignettage);
        this._addLayer(SssGroup.SSSLayerType.SSSLayerType_Hud);
    }

    protected void _addLayer(SssGroup.SSSLayerType _layerType) {
        SssGroup layer = new SssGroup();
        layer.LayerType(_layerType);
        switch (_layerType) {
            case SSSLayerType_TiledBackground: {
                this.m_layersTiledBackground = layer;
                break;
            }
            case SSSLayerType_Foreground: {
                this.m_layersForeground.add(layer);
                break;
            }
            case SSSLayerType_Background: {
                this.m_layersBackground.add(layer);
                break;
            }
            case SSSLayerType_Player: {
                if (this.m_layerPlayer == null) {
                    this.m_layerPlayer = layer;
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_Physics: {
                if (this.m_layerPhysics == null) {
                    this.m_layerPhysics = layer;
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_PieceProjection: {
                if (this.m_layerPieceProjection == null) {
                    this.m_layerPieceProjection = layer;
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_PostProcess: {
                if (this.m_layerPostProcess == null) {
                    this.m_layerPostProcess = layer;
                    this.m_layerPostProcess.scrollFactor = Vector2.Zero();
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_BlocDelimiter: {
                if (this.m_layerBlocDelimiter == null) {
                    this.m_layerBlocDelimiter = layer;
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_ParticleEffects: {
                if (this.m_layerParticleEffects == null) {
                    this.m_layerParticleEffects = layer;
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_Vignettage: {
                if (this.m_layerVignettage == null) {
                    this.m_layerVignettage = layer;
                    this.m_layerVignettage.scrollFactor = Vector2.Zero();
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_Portal: {
                if (this.m_layerPortal == null) {
                    this.m_layerPortal = layer;
                    this.m_layerPortal.scrollFactor = Vector2.Zero();
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_Hud: {
                if (this.m_layerHud == null) {
                    this.m_layerHud = layer;
                    this.m_layerHud.scrollFactor = Vector2.Zero();
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_ActiveIsoRendering: {
                if (this.m_layerActiveIsoDisplay == null) {
                    this.m_layerActiveIsoDisplay = layer;
                    break;
                }
                layer = null;
                break;
            }
            case SSSLayerType_PassiveIsoRendering: {
                if (this.m_layerPassiveIsoDisplay == null) {
                    this.m_layerPassiveIsoDisplay = layer;
                    break;
                }
                layer = null;
                break;
            }
            default: {
                layer = null;
            }
        }
    }

    public Actor instanciateActor(String _friendly) {
        return this.m_resourceLibrary.InstanciateActor(_friendly, this);
    }

    public FlxSprite instanciateSprite(String _friendly) {
        return this.m_resourceLibrary.InstanciateSprite(_friendly);
    }

    public void registerLayer(FlxState _ownerState) {
        _ownerState.add(this.m_layersTiledBackground);
        _ownerState.add(this.m_layersBackground.get(0));
        _ownerState.add(this.m_layersBackground.get(1));
        _ownerState.add(this.m_layerPortal);
        _ownerState.add(this.m_layerActiveIsoDisplay);
        _ownerState.add(this.m_layerPassiveIsoDisplay);
        for (FlxGroup flxGroup : this.m_layersForeground) {
            _ownerState.add(flxGroup);
        }
        _ownerState.add(this.m_layerBlocDelimiter);
        _ownerState.add(this.m_layerParticleEffects);
        _ownerState.add(this.m_layerPostProcess);
        _ownerState.add(this.m_layerVignettage);
        _ownerState.add(this.m_layerHud);
        this.m_editor.registerLayer(_ownerState);
        this.m_pauseMenu.registerLayer();
        this.m_menu.registerLayer(_ownerState);
    }

    public void update() {
        if (this.m_bManagerDestroyed && this.PlayableMode()) {
            return;
        }
        this.m_lastUpdateFrameId = FlxG.FrameId;
        this._tmpFlushToDeleteList();
        this._flushRecomputeGroundAnimList();
        this._handleInput();
        if (this.m_menu.Visible()) {
            this.m_menu.update();
        } else if (this.m_mode == eLevelMode.eLevelMode_Edit) {
            this.m_editor.update();
        }
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            this.m_menu.checkShortcuts();
        }
        this.m_pauseMenu.update();
        if (this.m_mode != eLevelMode.eLevelMode_Edit) {
            this.m_player.checkCollisions();
            if (!this.m_playerBehaviour.DebugGrabMove()) {
                this.m_blocManager.collideFast(this.m_player);
            }
            if (this.m_ennemiesToCollide.members.size() > 0) {
                int e = 0;
                while (e < this.m_ennemiesToCollide.members.size()) {
                    this.m_blocManager.collideFast((Actor)this.m_ennemiesToCollide.members.get(e));
                    ++e;
                }
            }
        }
        if (!this.m_bPause && this.m_mode != eLevelMode.eLevelMode_Edit) {
            this.m_dialogManager.update();
            this.m_blocManager.update();
            this.m_particlesManager.update();
            this.m_tweenerManager.update();
            this.m_blocSoundManager.update();
        }
        this._checkLaunchNextLevelInSequence();
        this._checkRestartLevel();
        this._checkGoToThanksLevel();
        this._checkLaunchNextLevelInUniverse();
        this._checkReturnToLevelHub();
        this._checkReturnToMainMenu();
        this._checkTracks();
    }

    protected void _checkTracks() {
        if (this.m_bCheckTracks) {
            if (this.m_soundSpawnerCount == 0) {
                MusicManager.Instance().playTracks(null, null, 1.0f, false);
            }
            this.m_bCheckTracks = false;
        }
    }

    protected void _handleInput() {
        if (this.PlayableMode()) {
            if (this.allowEdit() && InputManager.IsNewButtonPress(Buttons.Back)) {
                this.m_menu.Visible(!this.m_menu.Visible());
            }
            if (InputManager.IsNewButtonPress(Buttons.Start) || !this.m_bPause && InputManager.IsNewGuidePress() && this.GuidePauseAllowed() || this.m_bPause && InputManager.IsNewButtonPress(Buttons.A) || !this.m_bPause && FlxG.justLostFocus() || MACRO.ALLOW_MOUSE_PAUSE && InputManager.IsLeftMouseButtonPress() && !this.m_menu.Visible()) {
                this.m_pauseMenu.togglePause();
                this.m_bPause = this.m_pauseMenu.Pause();
                FlxG.DoFollowAvailable(!this.m_pauseMenu.Pause());
            }
        } else if (InputManager.IsNewButtonPress(Buttons.Start) || InputManager.IsNewButtonPress(Buttons.Back)) {
            this.m_menu.Visible(!this.m_menu.Visible());
        }
    }

    protected void _levelJustLoaded(Object sender, Object e) {
        this._placePlayerAtSpawnpoint();
        this._setupFollowAndBounce();
    }

    protected void _setupFollowAndBounce() {
    }

    protected void _placePlayerAtSpawnpoint() {
        if (this.m_playerSpawnpoint != null && this.m_mode == eLevelMode.eLevelMode_Play) {
            this.m_player.x = this.m_playerSpawnpoint.x + (float)this.m_player.offset.X * 0.5f;
            this.m_player.y = this.m_playerSpawnpoint.y + this.m_playerSpawnpoint.height - this.m_player.height;
        }
    }

    protected void _levelBeingDestroy(Object sender, Object e) {
        FlxG.follow(null, 0.0f);
    }

    public void unload() {
        for (FlxGroup flxGroup : this.m_layersBackground) {
            this._detroyLayer(flxGroup);
        }
        for (FlxGroup flxGroup : this.m_layersForeground) {
            this._detroyLayer(flxGroup);
        }
        this._detroyLayer(this.m_layersTiledBackground);
        this._detroyLayer(this.m_layerPhysics);
        this._detroyLayer(this.m_layerPlayer);
        this._detroyLayer(this.m_layerPortal);
        this._detroyLayer(this.m_layerPassiveIsoDisplay);
        this._detroyLayer(this.m_layerActiveIsoDisplay);
        this._detroyLayer(this.m_layerBlocDelimiter);
        this._detroyLayer(this.m_layerPieceProjection);
        this._detroyLayer(this.m_layerParticleEffects);
        this._detroyLayer(this.m_layerPostProcess);
        this._detroyLayer(this.m_layerVignettage);
        this._detroyLayer(this.m_layerHud);
        this._destructManagers();
        this._destructSwitchObserver();
        if (this.m_player != null) {
            this.m_player.kill();
            this.m_player = null;
            this.m_playerBehaviour = null;
        }
        this.m_puzzleOnOffListeners.clear();
        this.m_ennemiesToCollide.destroy();
    }

    public void newLevel() {
        this._loadDefaultLevel();
        this.enterEditMode();
    }

    protected void _initLayers(boolean _bEdit) {
        this._initLayer(this.m_layersTiledBackground, _bEdit);
        for (FlxGroup flxGroup : this.m_layersBackground) {
            this._initLayer(flxGroup, _bEdit);
        }
        for (FlxGroup flxGroup : this.m_layersForeground) {
            this._initLayer(flxGroup, _bEdit);
        }
        this._initLayer(this.m_layerPhysics, _bEdit);
        this._initLayer(this.m_layerPassiveIsoDisplay, _bEdit);
        this._initLayer(this.m_layerPlayer, _bEdit);
        if (!_bEdit) {
            this._initDoors();
        }
    }

    protected void _initLayer(FlxGroup _layer, boolean _bEdit) {
        int i = 0;
        while (i < _layer.members.size()) {
            Actor actor = (Actor)_layer.members.get(i);
            actor.createComponents(this, _bEdit);
            ++i;
        }
    }

    protected void _detroyLayer(FlxGroup _layer) {
        _layer.destroy();
    }

    protected String _buildLevelContentXmlString() {
        this._computeBBoxShifted();
        int id = 0;
        String res = "";
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(String.format("<Level name=\"%1$s\" lbx=\"%2$s\" lby=\"%3$s\" rtx=\"%4$s\" rty=\"%5$s\" version=\"%6$s\">\n", this.m_name, Float.toString(this.m_leftBottom.X), Float.toString(this.m_leftBottom.Y), Float.toString(this.m_rightTop.X), Float.toString(this.m_rightTop.Y), GameVars.GameVersion()));
        id = 0;
        for (SssGroup layer : this.m_layersBackground) {
            this._writeLayer(stringWriter, layer, id);
            ++id;
        }
        id = 0;
        this._writeLayer(stringWriter, this.m_layerPhysics, id);
        id = 0;
        this._writeLayer(stringWriter, this.m_layerPlayer, id);
        id = 0;
        for (SssGroup layer : this.m_layersForeground) {
            this._writeLayer(stringWriter, layer, id);
            ++id;
        }
        stringWriter.append("</Level>\n");
        res = stringWriter.toString();
        this._reinitShift();
        return res;
    }

    protected void _writeLayer(StringWriter _stringWriter, SssGroup _layer, int _id) {
        _stringWriter.append(String.format("<Layer type=\"%1$s\" id=\"%2$s\">\n", new Object[]{_layer.LayerType(), _id}));
        Actor actor = null;
        Actor cursor = this.m_editor != null ? this.m_editor.getActorCursor() : null;
        int i = 0;
        while (i < _layer.members.size()) {
            actor = (Actor)_layer.members.get(i);
            if (actor != null && !actor.equals(cursor)) {
                actor.x += this.m_bboxShift.X;
                actor.y += this.m_bboxShift.Y;
                if (actor.HasBehavioursParamsOverride()) {
                    _stringWriter.append(String.format("\t<Actor x=\"%1$s\" y=\"%2$s\" friendly=\"%3$s\">\n", actor.IndexPosX(), actor.IndexPosY(), actor.FriendlyName()));
                    Actor referenceActor = this.m_editor.getLibraryActor(actor.FriendlyName());
                    for (Behaviour b : actor.Behaviours()) {
                        BehaviourParameter<Object> param;
                        if (!b.HasParamOverride()) continue;
                        _stringWriter.append(String.format("\t\t<ParamsOverride id=\"%1$s\">\n", b.Id()));
                        Behaviour referenceBehaviour = referenceActor.getBehaviour(b.Id());
                        if (b.IntParamsDictionary() != null) {
                            for (Map.Entry<String, BehaviourParameter<Number>> entry : b.IntParamsDictionary().entrySet()) {
                                param = entry.getValue();
                                if (!param.isEditable() || referenceBehaviour.getIntParameter(entry.getKey()) == ((Integer)param.getValue()).intValue()) continue;
                                _stringWriter.append(String.format("\t\t\t<Param id=\"%1$s\" type=\"int\" value=\"%2$s\"/>\n", entry.getKey(), Integer.toString((Integer)entry.getValue().getValue())));
                            }
                        }
                        if (b.FloatParamsDictionary() != null) {
                            for (Map.Entry<String, BehaviourParameter<Object>> entry : b.FloatParamsDictionary().entrySet()) {
                                param = entry.getValue();
                                if (!param.isEditable() || referenceBehaviour.getFloatParameter(entry.getKey()) == ((Float)param.getValue()).floatValue()) continue;
                                _stringWriter.append(String.format("\t\t\t<Param id=\"%1$s\" type=\"float\" value=\"%2$s\"/>\n", entry.getKey(), Float.toString(((Float)entry.getValue().getValue()).floatValue())));
                            }
                        }
                        if (b.StringParamsDictionary() != null) {
                            for (Map.Entry<String, BehaviourParameter<Object>> entry : b.StringParamsDictionary().entrySet()) {
                                param = entry.getValue();
                                if (!param.isEditable() || referenceBehaviour.getStringParameter(entry.getKey()).equals(entry.getValue())) continue;
                                _stringWriter.append(String.format("\t\t\t<Param id=\"%1$s\" type=\"string\" value=\"%2$s\"/>\n", entry.getKey(), entry.getValue().getValue()));
                            }
                        }
                        _stringWriter.append("\t\t</ParamsOverride>\n");
                    }
                    _stringWriter.append("\t</Actor>\n");
                } else {
                    _stringWriter.append(String.format("\t<Actor x=\"%1$s\" y=\"%2$s\" friendly=\"%3$s\"/>\n", actor.IndexPosX(), actor.IndexPosY(), actor.FriendlyName()));
                }
            }
            ++i;
        }
        _stringWriter.append("</Layer>\n");
    }

    protected void _reinitPlayer() {
        Actor actor = null;
        int i = 0;
        while ((this.m_player == null || this.m_playerSpawnpoint == null) && i < this.m_layerPlayer.members.size()) {
            actor = (Actor)this.m_layerPlayer.members.get(i);
            if (this.m_player == null && actor.Material() == Actor.eActorMaterial.eActorMaterial_Player) {
                this.m_player = actor;
                if (this.m_mode == eLevelMode.eLevelMode_Edit) {
                    this.m_player.createComponents(this, false);
                }
                this.m_playerBehaviour = (PlayerBehaviour)this.m_player.getBehaviour("player");
            } else if (this.m_playerSpawnpoint == null && actor.FriendlyName().equals("spawn_player")) {
                this.setPlayerSpawnPoint(actor);
            }
            ++i;
        }
        this._placePlayerAtSpawnpoint();
        this._setupFollowAndBounce();
    }

    protected void _loadFromXmlString(String _xmlContent) {
        Document doc = FlxG.Content().CreateXDocument(_xmlContent);
        this._loadFromXmlDoc(doc);
    }

    protected boolean _loadFromXmlDoc(Document _doc) {
        this._loadLevelAttributes(_doc);
        return this._loadLayers(_doc);
    }

    protected void _loadLevelAttributes(Document _doc) {
        Element elemLevel = _doc.getDocumentElement();
        this.m_name = elemLevel.getAttribute("name");
        this.m_leftBottom.X = Float.parseFloat(elemLevel.getAttribute("lbx"));
        this.m_leftBottom.Y = Float.parseFloat(elemLevel.getAttribute("lby"));
        this.m_rightTop.X = Float.parseFloat(elemLevel.getAttribute("rtx"));
        this.m_rightTop.Y = Float.parseFloat(elemLevel.getAttribute("rty"));
        String version = elemLevel.getAttribute("version");
        this.m_version = version != null && version.length() > 0 ? version : "1.0.0.0";
        this._buildManagers();
        this._buildSwitchObserver();
    }

    protected boolean _loadLayers(Document _doc) {
        boolean bRes = true;
        Element elemLevel = _doc.getDocumentElement();
        Element elemLayer = null;
        NodeList elemLayerNodeList = elemLevel.getElementsByTagName("Layer");
        int elemLayerId = 0;
        while (elemLayerId < elemLayerNodeList.getLength()) {
            elemLayer = (Element)elemLayerNodeList.item(elemLayerId);
            String type = elemLayer.getAttribute("type");
            SssGroup.SSSLayerType layerType = SssGroup.SSSLayerType.valueOf(type);
            int id = Integer.parseInt(elemLayer.getAttribute("id"));
            Actor actor = null;
            SssGroup layer = null;
            switch (layerType) {
                case SSSLayerType_Background: {
                    layer = this.m_layersBackground.get(id);
                    break;
                }
                case SSSLayerType_Foreground: {
                    layer = this.m_layersForeground.get(id);
                    break;
                }
                case SSSLayerType_Physics: {
                    layer = this.m_layerPhysics;
                    break;
                }
                case SSSLayerType_Player: {
                    layer = this.m_layerPlayer;
                    break;
                }
            }
            boolean safeActorInstanciation = GameVars.GameCommunityMode();
            Element elemActor = null;
            NodeList elemActorNodeList = elemLayer.getElementsByTagName("Actor");
            int elemActorId = 0;
            while (elemActorId < elemActorNodeList.getLength()) {
                elemActor = (Element)elemActorNodeList.item(elemActorId);
                String friendly = elemActor.getAttribute("friendly");
                int x = Integer.parseInt(elemActor.getAttribute("x"));
                int y = Integer.parseInt(elemActor.getAttribute("y"));
                if (safeActorInstanciation) {
                    actor = this.m_resourceLibrary.InstanciateActorSafe(friendly, this);
                    if (actor == null) {
                        bRes = false;
                    }
                } else {
                    actor = this.m_resourceLibrary.InstanciateActor(friendly, this);
                }
                if (actor != null) {
                    actor.IndexPosX(x);
                    actor.IndexPosY(y);
                    if (elemActor.hasChildNodes()) {
                        this._loadParamsOverrides(elemActor, actor);
                    }
                    this.addActorToLayer(layer, actor);
                }
                ++elemActorId;
            }
            ++elemLayerId;
        }
        return bRes;
    }

    protected void _checkGameVersionAndSafeState() {
        if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
            String name = "/Community/CommunityLevels/" + GameVars.LastCommunityPlayedLevelArchiveName() + ".btm";
            FileManager.Instance().deleteFile(name);
            if (GameVars.GameVersion().compareTo(this.m_version) < 0) {
                OnlineLevelBrowsingState.NextStartAction(OnlineLevelBrowsingState.eLoadAction.ErrorTryToLoadLevelFromFuture, this.m_version);
                if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                    FlxG.state(new OnlineLevelBrowsingState(false, true));
                } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
                    FlxG.state(new OnlineLevelBrowsingState(true, true));
                }
            } else {
                this._returnToSafeState();
            }
        } else {
            this._returnToSafeState();
        }
    }

    protected void _loadParamsOverrides(Element _elemActor, Actor _actor) {
        Element elemParamsOverride = null;
        NodeList elemParamsOverrideNodeList = _elemActor.getElementsByTagName("ParamsOverride");
        int elemParamsOverrideId = 0;
        while (elemParamsOverrideId < elemParamsOverrideNodeList.getLength()) {
            elemParamsOverride = (Element)elemParamsOverrideNodeList.item(elemParamsOverrideId);
            String id = elemParamsOverride.getAttribute("id");
            Behaviour behaviour = _actor.getBehaviour(id);
            Element elemParam = null;
            NodeList elemParamNodeList = elemParamsOverride.getElementsByTagName("Param");
            int elemParamId = 0;
            while (elemParamId < elemParamNodeList.getLength()) {
                elemParam = (Element)elemParamNodeList.item(elemParamId);
                String idParam = elemParam.getAttribute("id");
                String typeParam = elemParam.getAttribute("type");
                String valueParam = elemParam.getAttribute("value");
                behaviour.overrideParameter(idParam, typeParam, valueParam);
                ++elemParamId;
            }
            behaviour.onLoadParamOverrideDone();
            ++elemParamsOverrideId;
        }
    }

    protected void _buildManagers() {
        if (this.m_mode == eLevelMode.eLevelMode_Test || this.m_mode == eLevelMode.eLevelMode_Play) {
            this.m_tweenerManager = new TweenManager();
            this.m_blocManager = new BlocManager(this);
            this.m_dialogManager = new DialogManager(this);
            this.m_particlesManager = new ParticleManager(this);
            this.m_blocSoundManager = new BlocksSoundsManager(this);
            this.m_bManagerDestroyed = false;
        } else {
            this._destructManagers();
        }
    }

    protected void _destructManagers() {
        this.m_blocManager = null;
        this.m_dialogManager = null;
        this.m_particlesManager = null;
        if (this.m_blocSoundManager != null) {
            this.m_blocSoundManager.destroy();
        }
        this.m_blocSoundManager = null;
        this.m_bManagerDestroyed = true;
    }

    protected void _buildSwitchObserver() {
        if (this.m_mode == eLevelMode.eLevelMode_Test || this.m_mode == eLevelMode.eLevelMode_Play) {
            this.m_switchObserver = new SwitchObserver(this);
        } else {
            this._destructSwitchObserver();
        }
    }

    protected void _destructSwitchObserver() {
        this.m_switchObserver = null;
    }

    public boolean load(String _loadName) {
        Document doc;
        boolean bLoaded;
        block39: {
            bLoaded = false;
            String filename = "sss/level/" + _loadName;
            doc = null;
            ByteArrayInputStream bis = null;
            try {
                if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                    if (MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                        filename = "/Community/MyWorkspace/" + GameVars.LastCommunityEditLevelFolderName() + "/" + GameVars.LastCommunityEditLevelXmlName();
                        if (MACRO.ENCRYPT_LEVEL_EDITOR_FILES) {
                            String decryptContent = FileManager.Instance().getTextFileContent(String.valueOf(filename) + ".xml.dat", true);
                            if (decryptContent != null) {
                                doc = XDocument.Parse(decryptContent);
                            } else if (MACRO.DEBUG) {
                                doc = XDocument.Instance().loadDocument(String.valueOf(filename) + ".xml");
                            }
                        } else if (MACRO.DEBUG) {
                            try {
                                doc = XDocument.Instance().loadDocument(String.valueOf(filename) + ".xml");
                            }
                            catch (Exception e) {
                                String decryptContent = FileManager.Instance().getTextFileContent(String.valueOf(filename) + ".xml.dat", true);
                                if (decryptContent != null) {
                                    doc = XDocument.Parse(decryptContent);
                                }
                            }
                        } else {
                            doc = XDocument.Instance().loadDocument(String.valueOf(filename) + ".xml");
                        }
                    } else {
                        doc = XDocument.Parse(GameVars.LastLevelFakeEditContent());
                    }
                } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
                    String archiveFilename = "/Community/CommunityLevels/" + GameVars.LastCommunityPlayedLevelArchiveName();
                    filename = GameVars.LastCommunityPlayedLevelXmlName();
                    bis = FileManager.Instance().getZipArchiveStreamItem(String.valueOf(archiveFilename) + ".btm", String.valueOf(filename) + ".xml", String.valueOf(filename) + ".xml.dat");
                    doc = XDocument.Instance().loadDocument(bis);
                    if (MACRO.DEBUG && MACRO.DEBUG_WRITE_XML_LEVEL_COMMUNITY_LOADED) {
                        FileManager.Instance().writeTextFileContent("/Community/readable/" + GameVars.LastCommunityPlayedLevelArchiveName() + ".xml", false, XDocument.Instance().getStringContentFromDoc(doc));
                    }
                    bis.close();
                } else if (!MACRO.ALLOW_SAVE_LEVEL_ON_DISK && GameVars.LastLevelFakeEdit() != null && _loadName.equals(GameVars.LastLevelFakeEdit()) && GameVars.LastLevelFakeEditContent() != null) {
                    doc = XDocument.Parse(GameVars.LastLevelFakeEditContent());
                    GameVars.LastLevelFakeEdit(null);
                    GameVars.LastLevelFakeEditContent(null);
                } else if (LauncherState.AllowEdit()) {
                    doc = XDocument.Instance().loadDocument(String.valueOf(Utility.GetContentPath(Utility.eContentPath.eContentPath_Level)) + _loadName + ".xml");
                } else if (!GameVars.UserEditAllowed()) {
                    doc = FlxG.Content().LoadXDocument(filename);
                }
                if (!GameVars.GameCommunityMode()) break block39;
                Document docDataBase = null;
                String lastLevelName = "";
                if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                    lastLevelName = GameVars.LastCommunityEditLevelXmlName();
                    String dataBaseFilename = "/Community/MyWorkspace/" + GameVars.LastCommunityEditLevelFolderName() + "/Dialogs.xml";
                    if (FileManager.Instance().fileExists(dataBaseFilename)) {
                        docDataBase = XDocument.Instance().loadDocument(dataBaseFilename);
                    }
                } else {
                    lastLevelName = GameVars.LastCommunityPlayedLevelXmlName();
                    String dataBaseFilename = "/Community/CommunityLevels/" + GameVars.LastCommunityPlayedLevelArchiveName() + ".btm";
                    ByteArrayInputStream bisDataBase = FileManager.Instance().getZipArchiveStreamItem(dataBaseFilename, "Dialogs.xml", null);
                    if (bisDataBase != null) {
                        docDataBase = XDocument.Instance().loadDocument(bisDataBase);
                        try {
                            bisDataBase.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (docDataBase != null) {
                    try {
                        DialogDataBase.Instance().populateCustomDatabase(lastLevelName, docDataBase, true);
                    }
                    catch (Exception e) {
                        DialogDataBase.Instance().clearCustomDatabase();
                    }
                } else {
                    DialogDataBase.Instance().clearCustomDatabase();
                }
            }
            catch (Exception e) {
                Debug.Assert(false, e.getMessage());
                doc = null;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._checkGameVersionAndSafeState();
            }
        }
        if (doc != null) {
            this.unload();
            bLoaded = this._loadFromXmlDoc(doc);
        }
        if (bLoaded) {
            this._loadEnd();
        }
        return bLoaded;
    }

    protected void _loadEnd() {
        this._reinitPlayer();
        if (this.PlayableMode()) {
            this._initLayers(false);
        } else {
            this._initLayers(true);
        }
        if (this.PlayableMode()) {
            this.m_layerActiveIsoDisplay.SpecialSortRendering(true);
        } else {
            this.m_layerActiveIsoDisplay.SpecialSortRendering(true);
        }
        this._notifyLevelJustLoaded();
    }

    public void addDoor(DoorBehaviour _door) {
        this.m_switchObserver.addDoor(_door);
    }

    protected void _initDoors() {
        this.m_switchObserver.initializeDoorsAndSwitches();
    }

    protected void _loadDefaultLevel() {
        this.unload();
        this._loadFromXmlString(EmptyLevel);
        this._loadEnd();
    }

    public void save(String _saveName) {
        if (this.m_mode == eLevelMode.eLevelMode_Edit) {
            this.m_editor.hideCursorActor();
        }
        String content = this._buildLevelContentXmlString();
        String filename = null;
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            filename = "/Community/MyWorkspace/" + GameVars.LastCommunityEditLevelFolderName() + "/" + GameVars.LastCommunityEditLevelXmlName() + ".xml";
        } else {
            if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
                return;
            }
            filename = String.valueOf(Utility.GetContentPath(Utility.eContentPath.eContentPath_Level)) + _saveName + ".xml";
        }
        try {
            if (!MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                GameVars.LastLevelFakeEdit(_saveName);
                GameVars.LastLevelFakeEditContent(content);
            } else if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                if (MACRO.ENCRYPT_LEVEL_EDITOR_FILES) {
                    FileManager.Instance().writeTextFileContent(String.valueOf(filename) + ".dat", true, content);
                } else {
                    FileManager.Instance().writeTextFileContent(filename, false, content);
                }
            } else {
                FileOutputStream fos = new FileOutputStream(filename);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                out.write(content);
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.m_mode == eLevelMode.eLevelMode_Edit) {
            this.m_editor.showCursorActor();
        }
    }

    protected void _notifyLevelJustLoaded() {
        if (this.LevelJustLoaded != null) {
            int i = 0;
            while (i < this.LevelJustLoaded.size()) {
                this.LevelJustLoaded.get(i).onCallback(this, null);
                ++i;
            }
        }
    }

    protected void _notifyLevelBeingDestroyed() {
        if (this.LevelBeingDestroy != null) {
            int i = 0;
            while (i < this.LevelBeingDestroy.size()) {
                this.LevelBeingDestroy.get(i).onCallback(this, null);
                ++i;
            }
        }
    }

    public void overlapActorWithEnnemies(Actor _actor, Behaviour _callbackBehaviour, int _callbackId) {
        Utility.SssU_overlap(this.m_ennemiesToCollide, _actor, _callbackBehaviour, _callbackId);
    }

    public void addActorToLayer(SssGroup _layer, Actor _actor) {
        boolean bIsoPassive = _actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_PassiveIso);
        if (bIsoPassive && this.PlayableMode()) {
            this.m_layerPassiveIsoDisplay.add(_actor);
        } else {
            _layer.add(_actor);
            if (_layer.LayerType() == SssGroup.SSSLayerType.SSSLayerType_Physics || _layer.LayerType() == SssGroup.SSSLayerType.SSSLayerType_Player) {
                this.m_layerActiveIsoDisplay.add(_actor);
            }
        }
    }

    protected void _transferIsoPassiveActorToIsoActive(Actor _actor) {
        if (_actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_PassiveIso)) {
            this.m_layerPassiveIsoDisplay.members.remove(_actor);
            _actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_PassiveIso);
            this.addActorToLayer(this.m_layerPhysics, _actor);
        }
    }

    public void removeActorFromLayer(SssGroup _layer, Actor _actor, boolean _direct) {
        if (!_direct) {
            this._addActorToGarbage(_actor, _layer);
        } else {
            this._realRemoveActorFromLayer(_layer, _actor);
        }
    }

    public void _realRemoveActorFromLayer(SssGroup _layer, Actor _actor) {
        _layer.members.remove(_actor);
        if (_layer.LayerType() == SssGroup.SSSLayerType.SSSLayerType_Physics || _layer.LayerType() == SssGroup.SSSLayerType.SSSLayerType_Player) {
            this.m_layerActiveIsoDisplay.members.remove(_actor);
        }
    }

    public void materializeActorsInBlocManager(Actor _actor) {
        this.m_layerPhysics.add(_actor);
        _actor.createComponents(this, false);
    }

    public void materializeActorsInBlocManager(Actor[] _actor, boolean _bAddToBlocManager) {
        int i = 0;
        while (i < _actor.length) {
            Actor act = _actor[i];
            this.materializeActorsInBlocManager(act);
            ++i;
        }
    }

    public void restart() {
        this.m_bRestart = true;
    }

    public void removeActorsToPhysic(Actor _actor) {
        this.removeActorFromLayer(this.m_layerPhysics, _actor, false);
        _actor.kill();
    }

    public void sortIsoLayer(SssGroup m_delimiterLayer) {
    }

    public void resetContent() {
        String currentName = "tmp";
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            currentName = GameVars.LastCommunityEditLevelXmlName();
        }
        String content = EmptyLevelFlaged.replace("[n]", currentName);
        this.unload();
        this._loadFromXmlString(content);
        this._loadEnd();
    }

    public static enum eLevelMode {
        eLevelMode_Unknown,
        eLevelMode_Edit,
        eLevelMode_Test,
        eLevelMode_Play;

    }
}

