/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import SSS.API.GameAPI;
import SSS.API.GameAPIManager;
import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Level;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.LoginManager;
import SSS.Stats.Achievement;
import java.util.ArrayList;
import java.util.HashMap;
import precompiler.MACRO;

public class AchievementManager {
    public static ArrayList<String> ACH_FrenchConnexionBTM = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("pixel");
            this.add("oneeye");
            this.add("rayman");
        }
    };
    public static ArrayList<String> ACH_B_T_M = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("boulderdash");
            this.add("tetris");
            this.add("minecraft");
        }
    };
    HashMap<String, Achievement> m_achievements = null;
    ArrayList<String> m_deferredAchievements = new ArrayList(20);
    ArrayList<String> m_nextFrameAchievements = new ArrayList(20);
    HashMap<String, Integer> m_rasters = null;
    GameAPI m_api = GameAPIManager.GameAPI();
    ArrayList<String> m_the80sLevelList = null;
    boolean m_bCheck80sAch = false;
    static AchievementManager m_Instance = null;

    public static AchievementManager Instance() {
        if (m_Instance == null) {
            m_Instance = new AchievementManager();
        }
        return m_Instance;
    }

    AchievementManager() {
    }

    public void update() {
        if (this.m_nextFrameAchievements.size() > 0) {
            for (String ach : this.m_nextFrameAchievements) {
                this.unlockAchievement(ach);
            }
            this.m_nextFrameAchievements.clear();
        }
        this.m_api.UpdateFrame();
    }

    public boolean isAchievementUnlocked(String _ID) {
        if (this.m_achievements.containsKey(_ID)) {
            return this.m_achievements.get(_ID).Validated();
        }
        return false;
    }

    public void unlockAchievementNextFrame(String _ID) {
        if (!this.m_nextFrameAchievements.contains(_ID)) {
            this.m_nextFrameAchievements.add(_ID);
        }
    }

    public void unlockAchievement(String _ID) {
        Achievement ach;
        if (this.m_achievements != null && this.m_achievements.containsKey(_ID) && !(ach = this.m_achievements.get(_ID)).Validated()) {
            this.m_api.SetAchievement(_ID);
        }
    }

    public void buildAchievements() {
        this._buildBTMAchievements();
    }

    protected void _buildBTMAchievements() {
        ArrayList<Achievement> achievements = new ArrayList<Achievement>(20);
        this.m_achievements = new HashMap(20);
        achievements.add(new Achievement("ACH_ONE_HUNDRED", false, false));
        achievements.add(new Achievement("ACH_TETROBOT_1_0", false, false));
        achievements.add(new Achievement("ACH_TETROBOT_1_1", false, false));
        achievements.add(new Achievement("ACH_TETROBOT_1_2", false, false));
        achievements.add(new Achievement("ACH_FIRST_BTM", false, false));
        achievements.add(new Achievement("ACH_10_BTM", false, false));
        achievements.add(new Achievement("ACH_20_BTM", false, false));
        achievements.add(new Achievement("ACH_40_BTM", false, false));
        achievements.add(new Achievement("ACH_GREEN_STAR", false, false));
        achievements.add(new Achievement("ACH_10_STARS", false, false));
        achievements.add(new Achievement("ACH_20_STARS", false, false));
        achievements.add(new Achievement("ACH_40_STARS", false, false));
        achievements.add(new Achievement("ACH_FIREWORK", false, false));
        achievements.add(new Achievement("ACH_SANDMAN", false, false));
        achievements.add(new Achievement("ACH_COLLATERAL_DAMAGE", false, false));
        achievements.add(new Achievement("ACH_CREDITS", false, false));
        achievements.add(new Achievement("ACH_TETRIS", false, false));
        achievements.add(new Achievement("ACH_NANORESET", false, false));
        achievements.add(new Achievement("ACH_10_BONUS", false, false));
        achievements.add(new Achievement("ACH_20_BONUS_REAL", false, false));
        achievements.add(new Achievement("ACH_KISS_A_SLIME", false, false));
        achievements.add(new Achievement("ACH_SQUASH_SLIME", false, false));
        achievements.add(new Achievement("ACH_AAAAAA", false, false));
        achievements.add(new Achievement("ACH_B_T_M", false, false));
        achievements.add(new Achievement("ACH_FRENCH_TOUCH", false, false));
        achievements.add(new Achievement("ACH_IJLOSTZ", false, false));
        achievements.add(new Achievement("ACH_FINISH_GAME", false, false));
        achievements.add(new Achievement("ACH_80s", false, false));
        achievements.add(new Achievement("ACH_CITIZEN", false, false));
        achievements.add(new Achievement("ACH_PLAYTEST", false, false));
        achievements.add(new Achievement("ACH_GROUP", false, false));
        achievements.add(new Achievement("ACH_CHOCOLATE", false, false));
        for (Achievement ach : achievements) {
            if (this.m_api.IsAchievementAchevied(ach.ID())) {
                ach.Validated(true);
            }
            this.m_achievements.put(ach.ID(), ach);
        }
        this.m_rasters = new HashMap(10);
        this._initRasters();
        if (!this.isAchievementUnlocked("ACH_80s")) {
            this.m_bCheck80sAch = true;
        }
    }

    public void saveLoadTimeCheckSaveBasedAchievments() {
        LevelGroup chocolateGroup;
        LevelGroup bonusGroup;
        LevelGroup mainGroup;
        if (!this.isAchievementUnlocked("ACH_ONE_HUNDRED")) {
            LoginManager.Instance().computeCurrentMainCompletion();
            float mainCompletion = LoginManager.Instance().getCurrentSlotMainCompletionValue();
            if (mainCompletion >= 100.0f) {
                AchievementManager.Instance().unlockAchievement("ACH_ONE_HUNDRED");
            }
        }
        if (GameVars.PlayerCanDoLines() > 0 && !this.isAchievementUnlocked("ACH_TETROBOT_1_0")) {
            AchievementManager.Instance().unlockAchievement("ACH_TETROBOT_1_0");
        }
        if (GameVars.MaxDrillableMatId() >= Actor.eActorMaterial.eActorMaterial_Iron.ordinal() && !this.isAchievementUnlocked("ACH_TETROBOT_1_1")) {
            AchievementManager.Instance().unlockAchievementDeferred("ACH_TETROBOT_1_1");
        }
        if (GameVars.MaxDrillableMatId() >= Actor.eActorMaterial.eActorMaterial_Jade.ordinal() && !this.isAchievementUnlocked("ACH_TETROBOT_1_2")) {
            AchievementManager.Instance().unlockAchievementDeferred("ACH_TETROBOT_1_2");
        }
        if ((mainGroup = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_AVENTURE_NAME)) != null) {
            int numPAR;
            int numBTM;
            if (!this.isAchievementUnlocked("ACH_FINISH_GAME") && mainGroup.isLevelDone("THE LOCK")) {
                this.unlockAchievement("ACH_FINISH_GAME");
            }
            if ((numBTM = mainGroup.getBTMFoundNumber()) >= 1 && !this.isAchievementUnlocked("ACH_FIRST_BTM")) {
                this.unlockAchievement("ACH_FIRST_BTM");
            }
            if (numBTM >= 10 && !this.isAchievementUnlocked("ACH_10_BTM")) {
                this.unlockAchievement("ACH_10_BTM");
            }
            if (numBTM >= 20 && !this.isAchievementUnlocked("ACH_20_BTM")) {
                this.unlockAchievement("ACH_20_BTM");
            }
            if (numBTM >= 40 && !this.isAchievementUnlocked("ACH_40_BTM")) {
                this.unlockAchievement("ACH_40_BTM");
            }
            if (numBTM >= 3) {
                if (!this.isAchievementUnlocked("ACH_FRENCH_TOUCH") && mainGroup.hasBTMdone(ACH_FrenchConnexionBTM)) {
                    this.unlockAchievement("ACH_FRENCH_TOUCH");
                }
                if (!this.isAchievementUnlocked("ACH_B_T_M") && mainGroup.hasBTMdone(ACH_B_T_M)) {
                    this.unlockAchievement("ACH_B_T_M");
                }
            }
            if ((numPAR = mainGroup.getPARFoundNumber()) >= 10 && !this.isAchievementUnlocked("ACH_10_STARS")) {
                this.unlockAchievement("ACH_10_STARS");
            }
            if (numPAR >= 20 && !this.isAchievementUnlocked("ACH_20_STARS")) {
                this.unlockAchievement("ACH_20_STARS");
            }
            if (numPAR >= 40 && !this.isAchievementUnlocked("ACH_40_STARS")) {
                this.unlockAchievement("ACH_40_STARS");
            }
            if (!this.isAchievementUnlocked("ACH_GREEN_STAR") && mainGroup.isAnyLevelGreenStared()) {
                this.unlockAchievement("ACH_GREEN_STAR");
            }
        }
        if ((bonusGroup = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_BONUS_CHAPTER_NAME)) != null) {
            int numBonusDone = bonusGroup.getLevelDoneNumber();
            if (numBonusDone >= 10 && !this.isAchievementUnlocked("ACH_10_BONUS")) {
                this.unlockAchievement("ACH_10_BONUS");
            }
            if (numBonusDone >= 20 && !this.isAchievementUnlocked("ACH_20_BONUS_REAL")) {
                this.unlockAchievement("ACH_20_BONUS_REAL");
            }
        }
        if ((chocolateGroup = LevelDataBase.Instance().getLevelGroup("Chocolate")) != null && !this.isAchievementUnlocked("ACH_CHOCOLATE") && chocolateGroup.getLevelDoneNumber() >= chocolateGroup.getLevelNumber(false)) {
            this.unlockAchievement("ACH_CHOCOLATE");
        }
    }

    protected void _check80sAch(LevelInfo lvlInfo) {
        if (this.m_bCheck80sAch) {
            if (this.m_the80sLevelList == null) {
                LevelGroup lvlGroup = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_AVENTURE_NAME);
                this.m_the80sLevelList = lvlGroup.buildLevelFriendlyNamesList();
            }
            if (this.m_the80sLevelList.contains(lvlInfo.FriendlyName())) {
                this.m_the80sLevelList.remove(lvlInfo.FriendlyName());
                if (this.m_the80sLevelList.size() == 0) {
                    this.unlockAchievement("ACH_80s");
                    this.m_bCheck80sAch = false;
                }
            }
        }
    }

    protected void _initRasters() {
        this.m_rasters.put("RAS_BURNED_BLOCKS", 0);
        this.m_rasters.put("RAS_SLIME_DIED", 0);
        this.m_rasters.put("RAS_LINES", 0);
    }

    public void incrementRaster(String _ID, int _value) {
        if (this.m_rasters.containsKey(_ID)) {
            this.m_rasters.put(_ID, this.m_rasters.get(_ID) + _value);
        }
    }

    public int getRasterValue(String _ID) {
        if (this.m_rasters.containsKey(_ID)) {
            return this.m_rasters.get(_ID);
        }
        return 0;
    }

    public void unlockAchievementDeferred(String _ID) {
        if (!this.m_deferredAchievements.contains(_ID)) {
            this.m_deferredAchievements.add(_ID);
        }
    }

    public void resetAchievementDeferred() {
        this._initRasters();
        this.m_deferredAchievements.clear();
    }

    public void gatherAchievementDeferred(Level _levelOrNil) {
        for (String ID : this.m_deferredAchievements) {
            this.unlockAchievement(ID);
        }
        if (_levelOrNil != null) {
            LevelInfo lvlInfo;
            if (GameVars.GameMode() == GameMode.GameMode_Bonus) {
                lvlInfo = LevelDataBase.Instance().getLevelInfo(_levelOrNil);
                if (lvlInfo != null) {
                    int numSandLeft;
                    if (lvlInfo.FriendlyName().equals("THE INVADER")) {
                        int numWoodBurned = this.m_rasters.get("RAS_BURNED_BLOCKS");
                        if (numWoodBurned == 0) {
                            this.unlockAchievement("ACH_FIREWORK");
                        }
                    } else if (lvlInfo.FriendlyName().equals("AN ICE GLITCH") && (numSandLeft = _levelOrNil.MainPlayerBehaviour().getCollectableAmount(Actor.eActorMaterial.eActorMaterial_Sand)) >= 4) {
                        this.unlockAchievement("ACH_SANDMAN");
                    }
                }
                this.checkBonusAchievements();
            } else if (GameVars.GameMode() == GameMode.GameMode_Main) {
                lvlInfo = LevelDataBase.Instance().getLevelInfo(_levelOrNil);
                this._check80sAch(lvlInfo);
                if (lvlInfo.FriendlyName().equals("COLLATERAL DAMAGE")) {
                    int numSlimeKilled = this.m_rasters.get("RAS_SLIME_DIED");
                    if (numSlimeKilled == 0) {
                        this.unlockAchievement("ACH_COLLATERAL_DAMAGE");
                    }
                } else if (lvlInfo.FriendlyName().equals("THE LOCK")) {
                    this.unlockAchievement("ACH_FINISH_GAME");
                }
            } else if (GameVars.GameMode() == GameMode.GameMode_Unknown && _levelOrNil.Group() != null && _levelOrNil.Group().Flag() == LevelGroup.eSpecialFlag.FeaturesLevels && (lvlInfo = LevelDataBase.Instance().getLevelInfo(_levelOrNil)).FriendlyName().equals("CHOCOLATE CASTLE")) {
                this.unlockAchievement("ACH_CHOCOLATE");
            }
        }
        this.resetAchievementDeferred();
    }

    public void checkBonusAchievements() {
        LevelGroup lvlGroup;
        if (!(this.isAchievementUnlocked("ACH_10_BONUS") && this.isAchievementUnlocked("ACH_20_BONUS_REAL") || (lvlGroup = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_BONUS_CHAPTER_NAME)) == null)) {
            int numLevelDone = lvlGroup.getLevelDoneNumber();
            if (numLevelDone >= 10) {
                this.unlockAchievement("ACH_10_BONUS");
            }
            if (numLevelDone >= 20) {
                this.unlockAchievement("ACH_20_BONUS_REAL");
            }
        }
    }

    public void checkOneHundredAchievement() {
        if (!AchievementManager.Instance().isAchievementUnlocked("ACH_ONE_HUNDRED")) {
            LoginManager.Instance().computeCurrentMainCompletion();
            float mainCompletion = LoginManager.Instance().getCurrentSlotMainCompletionValue();
            if (mainCompletion >= 100.0f) {
                AchievementManager.Instance().unlockAchievement("ACH_ONE_HUNDRED");
            }
        }
    }
}

