/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Point;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Level;
import SSS.Util.Debug;
import SSS.Util.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxObject;
import org.flixel.FlxU;
import org.flixel.event.FlxSpriteCollisionEvent;

public class BlocManager {
    public static ref<Integer> idCol = new ref<Integer>(0);
    public static ref<Integer> idLine = new ref<Integer>(0);
    public static ref<Integer> idCol2 = new ref<Integer>(0);
    public static ref<Integer> idLine2 = new ref<Integer>(0);
    public static ref<Integer> li = new ref<Integer>(0);
    public static ref<Integer> co = new ref<Integer>(0);
    public static ref<Integer> colId = new ref<Integer>(0);
    public static ref<Integer> lineId = new ref<Integer>(0);
    public static ref<Integer> idCo = new ref<Integer>(0);
    public static ref<Integer> idLi = new ref<Integer>(0);
    public static ref<Integer> m_idColLast = new ref<Integer>(0);
    public static ref<Integer> m_idLineLast = new ref<Integer>(0);
    public static ref<Integer> m_colCheckId = new ref<Integer>(0);
    public static ref<Integer> m_lineCheckId = new ref<Integer>(0);
    public static ref<Integer> baseIdCol = new ref<Integer>(0);
    public static ref<Integer> baseIdLine = new ref<Integer>(0);
    public static ref<Float> leftx = new ref<Float>(Float.valueOf(0.0f));
    public static ref<Float> rightx = new ref<Float>(Float.valueOf(0.0f));
    public static ref<Integer> zoneDelimiterUsed = new ref<Integer>(0);
    public static ref<Actor> up = new ref<Object>(null);
    public static ref<Actor> down = new ref<Object>(null);
    public static ref<Actor> left = new ref<Object>(null);
    public static ref<Actor> right = new ref<Object>(null);
    public static ref<Actor.eActorMaterial> m_landingMaterial = new ref<Object>(null);
    public int _idCol = 0;
    public int _idLine = 0;
    public Actor _upActor = null;
    public Actor _downActor = null;
    public Actor _leftActor = null;
    public Actor _rightActor = null;
    public Actor _leftTopActor = null;
    public Actor _leftDownActor = null;
    public Actor _rightTopActor = null;
    public Actor _rightDownActor = null;
    FlxSpriteCollisionEvent m_collisionEvent = new FlxSpriteCollisionEvent(null, null);
    Level m_level;
    float m_gridTick;
    int m_gridWidthInBloc;
    int m_gridHeightInBloc;
    Actor[][] m_2dGridRemovable = null;
    Actor[][] m_2dGridUnremovable = null;
    ArrayList<Line> m_lines = new ArrayList(20);
    ArrayList<Line> m_linesDone = new ArrayList(20);
    ArrayList<Line> m_linesHilight = new ArrayList(20);
    float m_hilightTimer = 0.0f;
    float m_hilightValue = 0.0f;
    final float HilightSpeed = 10.0f;
    final float MinAlphaHilight = 0.2f;
    ref<Actor> m_upActorRef = new ref<Object>(null);
    ref<Actor> m_downActorRef = new ref<Object>(null);
    ref<Actor> m_leftActorRef = new ref<Object>(null);
    ref<Actor> m_rightActorRef = new ref<Object>(null);
    protected static Point[] LinkedOffsets = new Point[]{new Point(1, 0), new Point(-1, 0), new Point(0, 1), new Point(0, -1)};
    static final int mNone = 0;
    static final int mTL = 1;
    static final int mTM = 2;
    static final int mTR = 4;
    static final int mML = 8;
    static final int mMR = 16;
    static final int mBL = 32;
    static final int mBM = 64;
    static final int mBR = 128;
    static Point[] Offsets = new Point[]{new Point(1, 0), new Point(1, 1), new Point(0, -1), new Point(0, 1), new Point(-1, -1), new Point(-1, 0)};
    static int[] OffsetsMasks = new int[]{2, 4, 8, 16, 32, 64};
    static final int m0 = 0;
    static final int m1 = 96;
    static final int m2 = 64;
    static final int m3 = 8;
    static final int m4 = 16;
    static final int m5 = 20;
    static final int m6 = 2;
    static final int m7 = 80;
    static final int m8 = 112;
    static final int m9 = 116;
    static final int m10 = 84;
    static final int m11 = 72;
    static final int m12 = 10;
    static final int m13 = 18;
    static final int m14 = 24;
    static final int m15 = 28;
    static final int m16 = 66;
    static final int m17 = 98;
    static final int m18 = 82;
    static final int m19 = 114;
    static final int m20 = 88;
    static final int m21 = 92;
    static final int m22 = 74;
    static final int m23 = 26;
    static final int m24 = 90;
    static HashMap<Integer, String> MasksAnim = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "0");
            this.put(96, "1");
            this.put(64, "2");
            this.put(8, "3");
            this.put(16, "4");
            this.put(20, "5");
            this.put(2, "6");
            this.put(80, "7");
            this.put(112, "8");
            this.put(116, "9");
            this.put(84, "10");
            this.put(72, "11");
            this.put(10, "12");
            this.put(18, "13");
            this.put(24, "14");
            this.put(28, "15");
            this.put(66, "16");
            this.put(98, "17");
            this.put(82, "18");
            this.put(114, "19");
            this.put(88, "20");
            this.put(92, "21");
            this.put(74, "22");
            this.put(26, "23");
            this.put(90, "24");
        }
    };

    public int MaxValidColId() {
        return this.m_gridWidthInBloc - 1;
    }

    public int MinValidColId() {
        return 0;
    }

    public int MaxValidLineId() {
        return this.m_gridHeightInBloc - 1;
    }

    public int MinValidLineId() {
        return 0;
    }

    public BlocManager(Level _ownerLevel) {
        this.m_level = _ownerLevel;
        float lvlw = this.m_level.getWidth();
        float lvlh = this.m_level.getHeight();
        Debug.Assert(lvlh > 0.0f && lvlw > 0.0f);
        this.m_gridTick = GameVars.BlocManagerTick() * GameVars.TileStep();
        this.m_gridWidthInBloc = (int)(lvlw / (float)GameVars.TileStep() + 0.5f);
        this.m_gridHeightInBloc = (int)(lvlh / (float)GameVars.TileStep() + 0.5f);
        int modulo = this.m_gridWidthInBloc % GameVars.BlocManagerTick();
        if (modulo > 0) {
            this.m_gridWidthInBloc = this.m_gridWidthInBloc - modulo + GameVars.BlocManagerTick();
        }
        Debug.Assert(this.m_gridWidthInBloc > 0 && this.m_gridHeightInBloc > 0);
        this.m_2dGridRemovable = new Actor[this.m_gridHeightInBloc][this.m_gridWidthInBloc];
        this.m_2dGridUnremovable = new Actor[this.m_gridHeightInBloc][this.m_gridWidthInBloc];
    }

    public Actor isCollidingWithBlocBelow(Actor _actor, float _bottomMarginOffset) {
        Actor aRes = null;
        int idCol = 0;
        int idLine = 0;
        this._getPointGridLocationNoCheck(_actor.x, _actor.y, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        int maxIterLine = 2;
        int iterLine = 0;
        --idLine;
        float actorBottom = _actor.getBottom() + _bottomMarginOffset;
        while (aRes == null && idLine >= 0 && iterLine < maxIterLine) {
            Actor gridActor = this.m_2dGridRemovable[idLine][idCol];
            if (gridActor != null && gridActor.getTop() <= actorBottom) {
                aRes = gridActor;
            } else {
                gridActor = this.m_2dGridUnremovable[idLine][idCol];
                if (gridActor != null && gridActor.getTop() <= actorBottom) {
                    aRes = gridActor;
                }
            }
            ++iterLine;
            --idLine;
        }
        return aRes;
    }

    public boolean isBlocSlotOccupied(int _idLine, int _idCol, Actor _dontConsiderThisActor) {
        boolean bRes = false;
        if (_idLine >= 0 && _idCol >= 0 && _idLine < this.m_gridHeightInBloc && _idCol < this.m_gridWidthInBloc) {
            Actor a = this.m_2dGridRemovable[_idLine][_idCol];
            if (a != null && !a.equals(_dontConsiderThisActor)) {
                bRes = true;
            }
            if (!bRes && (a = this.m_2dGridUnremovable[_idLine][_idCol]) != null && !a.equals(_dontConsiderThisActor)) {
                bRes = true;
            }
        }
        return bRes;
    }

    public boolean isBlocSlotOccupied(int _idLine, int _idCol) {
        boolean bRes = false;
        if (_idLine >= 0 && _idCol >= 0 && _idLine < this.m_gridHeightInBloc && _idCol < this.m_gridWidthInBloc) {
            bRes = this.m_2dGridRemovable[_idLine][_idCol] != null || this.m_2dGridUnremovable[_idLine][_idCol] != null;
        }
        return bRes;
    }

    public void positionateActorOnGrid(Actor _actor, int _idLine, int _idCol) {
        _actor.x = _idCol * GameVars.TileStep();
        _actor.y = -(_idLine + 1) * GameVars.TileStep();
    }

    public Actor getActorInBlocSlot(int _idLine, int _idCol, boolean _onlyRemovableActor) {
        Actor res = null;
        if (_idLine >= 0 && _idCol >= 0 && _idLine < this.m_gridHeightInBloc && _idCol < this.m_gridWidthInBloc && (res = this.m_2dGridRemovable[_idLine][_idCol]) == null && !_onlyRemovableActor) {
            res = this.m_2dGridUnremovable[_idLine][_idCol];
        }
        return res;
    }

    public Actor getGroundActorInBlocSlot(int _idLine, int _idCol) {
        Actor res = null;
        if (_idLine >= 0 && _idCol >= 0 && _idLine < this.m_gridHeightInBloc && _idCol < this.m_gridWidthInBloc) {
            res = this.m_2dGridUnremovable[_idLine][_idCol];
        }
        return res;
    }

    public void diffuseRecomputeAutoAnimFlag(Actor _actor) {
        this.getActorGridLocation(_actor, idCo, idLi);
        int idLi = BlocManager.idLi.get();
        int idCo = BlocManager.idCo.get();
        int coBeg = Math.max(idCo - 1, this.MinValidColId());
        int coEnd = Math.min(idCo + 1, this.MaxValidColId());
        int liBeg = Math.max(idLi - 1, this.MinValidLineId());
        int liEnd = Math.min(idLi + 1, this.MaxValidLineId());
        Actor act = null;
        int li = liBeg;
        while (li <= liEnd) {
            int co = coBeg;
            while (co <= coEnd) {
                act = this.m_2dGridUnremovable[li][co];
                if (act != null && act.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim && !act.Dying() && !act.hasFlag(Actor.eSpecialFlag.eSpecialFlag_GroundToBeRemoved)) {
                    act.Level().addToRecomputeGroundAnimActor(act);
                }
                ++co;
            }
            ++li;
        }
    }

    public void sendMessageToBlocId(int _idLine, int _idCol, Actor.eGenericMessage _message, Actor _sender) {
        Actor act;
        if (_idLine >= 0 && _idCol >= 0 && _idLine < this.m_gridHeightInBloc && _idCol < this.m_gridWidthInBloc && (act = this.m_2dGridRemovable[_idLine][_idCol]) != null && !act.Dying()) {
            act.handleGenericMessage(_message, _sender);
        }
    }

    public boolean isBlocSlotBelowOccupied(Actor _actor) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        if (idLine > 0) {
            return this.m_2dGridRemovable[idLine - 1][idCol] != null || this.m_2dGridUnremovable[idLine - 1][idCol] != null;
        }
        return true;
    }

    public boolean isBlocSlotBelowOccupied(Actor _actor, boolean _bExcludingActor) {
        if (_bExcludingActor) {
            int idCol = 0;
            int idLine = 0;
            this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
            idCol = BlocManager.idCol.get();
            idLine = BlocManager.idLine.get();
            if (idLine > 0) {
                Actor act1 = this.m_2dGridRemovable[idLine - 1][idCol];
                Actor act2 = this.m_2dGridUnremovable[idLine - 1][idCol];
                if (act1 != null && _actor.equals(act1)) {
                    act1 = null;
                }
                if (act2 != null && _actor.equals(act2)) {
                    act2 = null;
                }
                return act1 != null || act2 != null;
            }
            return true;
        }
        return this.isBlocSlotBelowOccupied(_actor);
    }

    public boolean isBottomGridBloc(Actor _actor) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        return idLine == 0;
    }

    public void getNeighbourActors(Actor _centralActor, ref<Actor> _upActorRef, ref<Actor> _downActorRef, ref<Actor> _leftActorRef, ref<Actor> _rightActorRef) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_centralActor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        if (idLine < this.m_gridHeightInBloc - 1) {
            this._upActor = this.m_2dGridRemovable[idLine + 1][idCol];
            if (this._upActor == null) {
                this._upActor = this.m_2dGridUnremovable[idLine + 1][idCol];
            }
        } else {
            this._upActor = null;
        }
        if (idLine > 0) {
            this._downActor = this.m_2dGridRemovable[idLine - 1][idCol];
            if (this._downActor == null) {
                this._downActor = this.m_2dGridUnremovable[idLine - 1][idCol];
            }
        } else {
            this._downActor = null;
        }
        if (idCol > 0) {
            this._leftActor = this.m_2dGridRemovable[idLine][idCol - 1];
            if (this._leftActor == null) {
                this._leftActor = this.m_2dGridUnremovable[idLine][idCol - 1];
            }
        } else {
            this._leftActor = null;
        }
        if (idCol < this.m_gridWidthInBloc - 1) {
            this._rightActor = this.m_2dGridRemovable[idLine][idCol + 1];
            if (this._rightActor == null) {
                this._rightActor = this.m_2dGridUnremovable[idLine][idCol + 1];
            }
        } else {
            this._rightActor = null;
        }
        _upActorRef.set(this._upActor);
        _downActorRef.set(this._downActor);
        _leftActorRef.set(this._leftActor);
        _rightActorRef.set(this._rightActor);
    }

    public boolean isAnyNeighbourActorsDiagonalsSameMaterial(Actor _centralActor) {
        this.m_upActorRef.set(null);
        this.m_downActorRef.set(null);
        this.m_leftActorRef.set(null);
        this.m_rightActorRef.set(null);
        this.getNeighbourActors(_centralActor, this.m_upActorRef, this.m_downActorRef, this.m_leftActorRef, this.m_rightActorRef);
        Actor act = this.m_upActorRef.get();
        if (act != null && act.Material() == _centralActor.Material()) {
            return true;
        }
        act = this.m_downActorRef.get();
        if (act != null && act.Material() == _centralActor.Material()) {
            return true;
        }
        act = this.m_leftActorRef.get();
        if (act != null && act.Material() == _centralActor.Material()) {
            return true;
        }
        act = this.m_rightActorRef.get();
        return act != null && act.Material() == _centralActor.Material();
    }

    public void getNeighbourActorsDiagonals(Actor _centralActor, ref<Actor> _leftTopActorRef, ref<Actor> _leftDownActorRef, ref<Actor> _rightTopActorRef, ref<Actor> _rightDownActorRef) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_centralActor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        if (idLine < this.m_gridHeightInBloc - 1 && idCol > 0) {
            this._leftTopActor = this.m_2dGridRemovable[idLine + 1][idCol - 1];
            if (this._leftTopActor == null) {
                this._leftTopActor = this.m_2dGridUnremovable[idLine + 1][idCol - 1];
            }
        } else {
            this._leftTopActor = null;
        }
        if (idLine > 0 && idCol > 0) {
            this._leftDownActor = this.m_2dGridRemovable[idLine - 1][idCol - 1];
            if (this._leftDownActor == null) {
                this._leftDownActor = this.m_2dGridUnremovable[idLine - 1][idCol - 1];
            }
        } else {
            this._leftDownActor = null;
        }
        if (idCol < this.m_gridWidthInBloc - 1 && idLine < this.m_gridHeightInBloc - 1) {
            this._rightTopActor = this.m_2dGridRemovable[idLine + 1][idCol + 1];
            if (this._rightTopActor == null) {
                this._rightTopActor = this.m_2dGridUnremovable[idLine + 1][idCol + 1];
            }
        } else {
            this._rightTopActor = null;
        }
        if (idLine > 0 && idCol < this.m_gridWidthInBloc - 1) {
            this._rightDownActor = this.m_2dGridRemovable[idLine - 1][idCol + 1];
            if (this._rightDownActor == null) {
                this._rightDownActor = this.m_2dGridUnremovable[idLine - 1][idCol + 1];
            }
        } else {
            this._rightDownActor = null;
        }
        _leftTopActorRef.set(this._leftTopActor);
        _leftDownActorRef.set(this._leftDownActor);
        _rightTopActorRef.set(this._rightTopActor);
        _rightDownActorRef.set(this._rightDownActor);
    }

    public Actor getActorInBlocSlotBelow(Actor _actor) {
        Actor act = null;
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        if (idLine > 0 && (act = this.m_2dGridRemovable[idLine - 1][idCol]) == null) {
            act = this.m_2dGridUnremovable[idLine - 1][idCol];
        }
        return act;
    }

    public boolean isAlignedWithGrid(Actor _actor) {
        return _actor.x % (float)GameVars.TileStep() == 0.0f && _actor.y % (float)GameVars.TileStep() == 0.0f;
    }

    public void registerRemovableBloc(Actor _actor, ref<Integer> _idCol, ref<Integer> _idLine, boolean _bSafe) {
        this._getActorGridLocation(_actor, _idCol, _idLine);
        this.registerRemovableBloc(_actor, _bSafe);
    }

    public void registerRemovableBloc(Actor _actor, boolean _bSafe) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        if (!_bSafe) {
            Debug.Assert(this.m_2dGridRemovable[idLine][idCol] == null);
        }
        this.m_2dGridRemovable[idLine][idCol] = _actor;
        if (!GameVars.UseHologramZone()) {
            this._checkLine(idCol, idLine);
        }
    }

    public void registerRemovableBloc(Actor _actor) {
        this.registerRemovableBloc(_actor, false);
    }

    public void hilightLineHologramArea(int _leftTopLineId, int _leftTopColId) {
        this.unhilightLines();
        int start = GameVars.HologramBlocHeight() > 0 ? _leftTopLineId - 1 : this.m_gridHeightInBloc - 1;
        int end = GameVars.HologramBlocHeight() > 0 ? _leftTopLineId - GameVars.HologramBlocHeight() : 0;
        int idLine = start;
        while (idLine >= end) {
            if (idLine >= 0 && idLine < this.m_gridHeightInBloc) {
                this._checkLineGeneric(_leftTopColId, idLine, true);
            }
            --idLine;
        }
    }

    public void unhilightLines() {
        if (this.m_linesHilight.size() > 0) {
            for (Line line : this.m_linesHilight) {
                line.unhilight();
            }
            this.m_linesHilight.clear();
        }
    }

    public void checkHologramArea(int _leftTopLineId, int _leftTopColId) {
        int start = GameVars.HologramBlocHeight() > 0 ? _leftTopLineId - 1 : this.m_gridHeightInBloc - 1;
        int end = GameVars.HologramBlocHeight() > 0 ? _leftTopLineId - GameVars.HologramBlocHeight() : 0;
        int idLine = start;
        while (idLine >= end) {
            if (idLine >= 0 && idLine < this.m_gridHeightInBloc) {
                this._checkLineGeneric(_leftTopColId, idLine, false);
            }
            --idLine;
        }
    }

    public void registerUnremovableBloc(Actor _actor) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        Debug.Assert(this.m_2dGridUnremovable[idLine][idCol] == null);
        this.m_2dGridUnremovable[idLine][idCol] = _actor;
    }

    protected void _checkLine(int _idCol, int _idLine) {
        int idColBegin = _idCol - _idCol % GameVars.BlocManagerTick();
        this._checkLineGeneric(idColBegin, _idLine, false);
    }

    protected void _checkLineGeneric(int _idColBegin, int _idLine, boolean _bCheckHilightLine) {
        int idColEnd = _idColBegin + GameVars.BlocManagerTick();
        boolean bLineComplete = true;
        Actor actor = null;
        int iCol = _idColBegin;
        while (iCol < idColEnd) {
            actor = this.m_2dGridRemovable[_idLine][iCol];
            if (actor == null || actor.Dying()) {
                bLineComplete = false;
                break;
            }
            ++iCol;
        }
        if (bLineComplete) {
            Line line = new Line();
            int iCol2 = _idColBegin;
            while (iCol2 < idColEnd) {
                line.addActorToLine(this.m_2dGridRemovable[_idLine][iCol2]);
                ++iCol2;
            }
            if (_bCheckHilightLine) {
                this.m_linesHilight.add(line);
            } else {
                this.m_lines.add(line);
            }
        }
    }

    public void unregisterRemovableBlocAt(Actor _actor, int _idCol, int _idLine) {
        Debug.Assert(this.m_2dGridRemovable[_idLine][_idCol].equals(_actor));
        this.m_2dGridRemovable[_idLine][_idCol] = null;
    }

    public void unregisterRemovableBlocAtSafe(Actor _actor, int _idCol, int _idLine) {
        Actor actor = this.m_2dGridRemovable[_idLine][_idCol];
        if (actor != null && _actor.equals(actor)) {
            this.m_2dGridRemovable[_idLine][_idCol] = null;
        }
    }

    public void unregisterRemovableBloc(Actor _actor) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        Debug.Assert(this.m_2dGridRemovable[idLine][idCol] != null);
        this.m_2dGridRemovable[idLine][idCol] = null;
    }

    public void unregisterRemovableBlocSafe(Actor _actor) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        Actor actor = this.m_2dGridRemovable[idLine][idCol];
        if (actor != null && _actor.equals(actor)) {
            this.m_2dGridRemovable[idLine][idCol] = null;
        }
    }

    public void unregisterUnremovableBloc(Actor _actor) {
        int idCol = 0;
        int idLine = 0;
        this._getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        idCol = BlocManager.idCol.get();
        idLine = BlocManager.idLine.get();
        Debug.Assert(this.m_2dGridUnremovable[idLine][idCol] != null);
        this.m_2dGridUnremovable[idLine][idCol] = null;
    }

    public void init() {
    }

    public void deinit() {
    }

    public void getZoneDelimiter(Actor[] _actors, ref<Float> _leftx, ref<Float> _rigthx, ref<Integer> _numZone) {
        int minId;
        Debug.Assert(_actors.length > 0);
        int maxId = minId = this._getActorZoneId(_actors[0]);
        int tmp = 0;
        int i = 1;
        while (i < _actors.length) {
            tmp = this._getActorZoneId(_actors[i]);
            if (tmp < minId) {
                minId = tmp;
            } else if (tmp > maxId) {
                maxId = tmp;
            }
            ++i;
        }
        _numZone.set(maxId - minId + 1);
        _leftx.set(Float.valueOf(1.0f * (float)minId * (float)GameVars.BlocManagerTick() * (float)GameVars.TileStep()));
        _rigthx.set(Float.valueOf(1.0f * (float)(maxId + 1) * (float)GameVars.BlocManagerTick() * (float)GameVars.TileStep()));
    }

    public void getZoneDelimiter(Actor _actor, ref<Float> _leftx, ref<Float> _rigthx, ref<Integer> _numZone) {
        int minId = this._getActorZoneId(_actor);
        _numZone.set(1);
        _leftx.set(Float.valueOf(1.0f * (float)minId * (float)GameVars.BlocManagerTick() * (float)GameVars.TileStep()));
        _rigthx.set(Float.valueOf(1.0f * (float)(minId + 1) * (float)GameVars.BlocManagerTick() * (float)GameVars.TileStep()));
    }

    protected int _getActorZoneId(Actor _actor) {
        int id = (int)(_actor.x / this.m_gridTick);
        return id;
    }

    protected void _getActorGridLocation(Actor _actor, ref<Integer> _idCol, ref<Integer> _idLine) {
        this.getPointGridLocation(_actor.x, _actor.y + _actor.height, _idCol, _idLine);
    }

    public void getLeftRightPointGridLocationHologramZone(float _camerax, float _cameray, ref<Integer> _idColRef, ref<Integer> _idLineRef) {
        this._getPointGridLocationNoCheck(_camerax, _cameray, _idColRef, _idLineRef);
        this._idCol = _idColRef.get() - GameVars.HologramBlocWidth() / 2;
        this._idLine = _idLineRef.get() + GameVars.HologramBlocHeight() / 2;
        if (GameVars.HologramBlocHeight() % 2 == 0) {
            ++this._idLine;
        }
        if (this._idCol < 0) {
            this._idCol = 0;
        } else if (this._idCol + GameVars.HologramBlocWidth() >= this.m_gridWidthInBloc) {
            this._idCol = this.m_gridWidthInBloc - GameVars.HologramBlocWidth() - 1;
        }
        if (this._idLine - GameVars.HologramBlocHeight() < 0) {
            this._idLine = GameVars.HologramBlocHeight();
        } else if (this._idLine > this.m_gridHeightInBloc) {
            this._idLine = this.m_gridHeightInBloc;
        }
    }

    public boolean isOverlappingExistingBlocs(Actor _actor) {
        boolean bOverlap = true;
        this._getPointGridLocationNoCheck(_actor.x, _actor.y + _actor.height, idCol, idLine);
        int idCol = BlocManager.idCol.get();
        int idLine = BlocManager.idLine.get();
        bOverlap = idCol < 0 || idCol >= this.m_gridWidthInBloc || idLine < 0 || idLine >= this.m_gridHeightInBloc ? true : this.m_2dGridRemovable[idLine][idCol] != null || this.m_2dGridUnremovable[idLine][idCol] != null;
        return bOverlap;
    }

    public boolean isLinkedToExistingBlocs(Actor _actor) {
        boolean bLinked = false;
        this._getPointGridLocationNoCheck(_actor.x, _actor.y + _actor.height, idCol, idLine);
        int idCol = BlocManager.idCol.get();
        int idLine = BlocManager.idLine.get();
        if (idCol < 0 || idCol >= this.m_gridWidthInBloc || idLine < 0 || idLine >= this.m_gridHeightInBloc) {
            bLinked = false;
        } else {
            int i = 0;
            while (!bLinked && i < LinkedOffsets.length) {
                Point off = LinkedOffsets[i];
                bLinked = this.isBlocSlotOccupied(idLine + off.Y, idCol + off.X);
                ++i;
            }
        }
        return bLinked;
    }

    public void getPointGridLocation(float _x, float _boty, ref<Integer> _idCol, ref<Integer> _idLine) {
        this._getPointGridLocationNoCheck(_x, _boty, _idCol, _idLine);
    }

    public void getPointGridLocationNoCheck(float _x, float _boty, ref<Integer> _idCol, ref<Integer> _idLine) {
        this._getPointGridLocationNoCheck(_x, _boty, _idCol, _idLine);
    }

    public void getActorOffsetedGridLocationClamped(Actor _actor, float _offsetx, float _offsety, ref<Integer> _idCol, ref<Integer> _idLine) {
        this.getPointGridLocationClamped(_actor.x - _offsetx, _actor.y + _actor.height - _offsety, _idCol, _idLine);
    }

    public void getActorGridLocationClamped(Actor _actor, ref<Integer> _idCol, ref<Integer> _idLine) {
        this.getPointGridLocationClamped(_actor.x, _actor.y + _actor.height, _idCol, _idLine);
    }

    public void getActorGridLocation(Actor _actor, ref<Integer> _idCol, ref<Integer> _idLine) {
        this._getPointGridLocationNoCheck(_actor.x, _actor.y + _actor.height, _idCol, _idLine);
    }

    public void getPointGridLocationClamped(float _x, float _boty, ref<Integer> _idColRef, ref<Integer> _idLineRef) {
        this._getPointGridLocationNoCheck(_x, _boty, _idColRef, _idLineRef);
        if (this._idCol < 0) {
            this._idCol = 0;
        } else if (this._idCol >= this.m_gridWidthInBloc) {
            this._idCol = this.m_gridWidthInBloc;
        }
        if (this._idLine < 0) {
            this._idLine = 0;
        } else if (this._idLine >= this.m_gridHeightInBloc) {
            this._idLine = this.m_gridHeightInBloc;
        }
    }

    protected void _getPointGridLocationNoCheck(float _x, float _boty, ref<Integer> _idCol, ref<Integer> _idLine) {
        _idCol.set((int)(_x / (float)GameVars.TileStep()));
        _idLine.set((int)(-_boty / (float)GameVars.TileStep()));
    }

    public void update() {
        if (this.m_lines.size() > 0) {
            for (Line line : this.m_lines) {
                line.update();
                if (!line.Done()) continue;
                this.m_linesDone.add(line);
            }
            if (this.m_linesDone.size() > 0) {
                for (Line lineDone : this.m_linesDone) {
                    this.m_lines.remove(lineDone);
                }
                this.m_linesDone.clear();
            }
        }
        if (this.m_linesHilight.size() > 0) {
            this.m_hilightTimer += FlxG.elapsed;
            this.m_hilightValue = MathHelper.Lerp(0.2f, 1.0f, (float)Math.cos(this.m_hilightTimer * 10.0f) * 0.5f + 0.5f);
            for (Line line : this.m_linesHilight) {
                line.updateHilight(this.m_hilightValue);
            }
        }
    }

    public void collideFast(Actor _actorToCollide) {
        if (_actorToCollide == null) {
            return;
        }
        int offsetKernelX = (int)(_actorToCollide.width * GameVars.OneOverTileStep()) + 1;
        int offsetKernelY = (int)(_actorToCollide.height * GameVars.OneOverTileStep()) + 1;
        int idLineFactor = _actorToCollide.velocity.Y < 0.0f ? 1 : -1;
        int idColFactor = _actorToCollide.velocity.X < 0.0f ? 1 : -1;
        this.getActorGridLocation(_actorToCollide, colId, lineId);
        int colId = BlocManager.colId.get();
        int lineId = BlocManager.lineId.get();
        int iColOffset = -offsetKernelX;
        while (iColOffset <= offsetKernelX) {
            int iLineOffset = -offsetKernelY;
            while (iLineOffset <= offsetKernelY) {
                Actor actor = this.getActorInBlocSlot(lineId + iLineOffset * idLineFactor, colId + iColOffset * idColFactor, false);
                if (actor != null && !actor.equals(_actorToCollide) && !actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_NoCollidePhysic) && Utility.IsActorsPhysicsOverlappingFast(_actorToCollide, actor)) {
                    this.m_collisionEvent.Object1(actor);
                    this.m_collisionEvent.Object2(_actorToCollide);
                    FlxU.solveXCollision(this, this.m_collisionEvent);
                    FlxU.solveYCollision(this, this.m_collisionEvent);
                }
                ++iLineOffset;
            }
            ++iColOffset;
        }
    }

    public void computeLandingMaterial(Actor _actor, ref<Actor.eActorMaterial> _landingMaterial) {
        this.getActorGridLocation(_actor, colId, lineId);
        int colId = BlocManager.colId.get();
        int lineId = BlocManager.lineId.get();
        float mindist = Float.MAX_VALUE;
        float dist = 0.0f;
        Actor other = null;
        int l = lineId;
        while (l >= lineId - 1) {
            int c = colId - 1;
            while (c <= colId + 1) {
                other = this.getActorInBlocSlot(l, c, false);
                if (other != null) {
                    dist = other.getCenterX() - _actor.getCenterX();
                    if ((dist *= dist) < mindist) {
                        mindist = dist;
                        _landingMaterial.set(other.Material());
                    }
                }
                ++c;
            }
            --l;
        }
    }

    public void overlapFast(Actor _actorToOverlap, Behaviour _callbackBehaviour, int _callbackId) {
        this.overlapFastWithScale(_actorToOverlap, _callbackBehaviour, 1.0f, _callbackId);
    }

    public void overlapFastWithScale(Actor _actorToOverlap, Behaviour _callbackBehaviour, float _scale, int _callbackId) {
        int offsetKernelX = (int)(_actorToOverlap.width * GameVars.OneOverTileStep()) + 1;
        int offsetKernelY = (int)(_actorToOverlap.height * GameVars.OneOverTileStep()) + 1;
        this.getActorGridLocation(_actorToOverlap, colId, lineId);
        int colId = BlocManager.colId.get();
        int lineId = BlocManager.lineId.get();
        int iColOffset = -offsetKernelX;
        while (iColOffset <= offsetKernelX) {
            int iLineOffset = -offsetKernelY;
            while (iLineOffset <= offsetKernelY) {
                Actor actor = this.getActorInBlocSlot(lineId + iLineOffset, colId + iColOffset, false);
                if (actor != null && !actor.equals(_actorToOverlap) && Utility.IsActorsOverlappingFastWithScale(_actorToOverlap, actor, _scale)) {
                    this.m_collisionEvent.Object1(actor);
                    this.m_collisionEvent.Object2(_actorToOverlap);
                    _callbackBehaviour.onOverlapsCallback(this.m_collisionEvent, _callbackId);
                }
                ++iLineOffset;
            }
            ++iColOffset;
        }
    }

    public static void RecomputeGround(FlxGroup _layer, Actor _actorToAvoid) {
        Actor actor;
        int minColId = Integer.MAX_VALUE;
        int minLineId = Integer.MAX_VALUE;
        int maxColId = Integer.MIN_VALUE;
        int maxLineId = Integer.MIN_VALUE;
        int idCol = 0;
        int idLine = 0;
        Actor cursor = _actorToAvoid;
        for (FlxObject o : _layer.members) {
            actor = (Actor)o;
            if (actor == null || actor.equals(cursor)) continue;
            idCol = (int)(actor.x * GameVars.OneOverTileStep());
            idLine = (int)(-actor.y * GameVars.OneOverTileStep());
            minColId = Math.min(idCol, minColId);
            minLineId = Math.min(idLine, minLineId);
            maxColId = Math.max(idCol, maxColId);
            maxLineId = Math.max(idLine, maxLineId);
        }
        int shiftColId = -minColId;
        int shiftLineId = -minLineId;
        int numCol = maxColId - minColId + 1;
        int numLine = maxLineId - minLineId + 1;
        if (numCol > 0 && numLine > 0) {
            Actor[][] grid = new Actor[numLine][numCol];
            for (FlxObject o : _layer.members) {
                actor = (Actor)o;
                if (actor == null || actor.equals(cursor) || actor.Material() != Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim) continue;
                idCol = (int)(actor.x * GameVars.OneOverTileStep()) + shiftColId;
                idLine = (int)(-actor.y * GameVars.OneOverTileStep()) + shiftLineId;
                grid[idLine][idCol] = actor;
            }
            int mask = 0;
            Actor a = null;
            int li = 0;
            while (li < numLine) {
                int co = 0;
                while (co < numCol) {
                    a = grid[li][co];
                    mask = 0;
                    if (a != null) {
                        int k = 0;
                        while (k < Offsets.length) {
                            int kLi = li + BlocManager.Offsets[k].X;
                            int kCo = co + BlocManager.Offsets[k].Y;
                            if (kLi >= 0 && kLi < numLine && kCo >= 0 && kCo < numCol) {
                                if (grid[kLi][kCo] != null) {
                                    mask |= OffsetsMasks[k];
                                }
                            } else if (kLi >= numLine) {
                                mask |= OffsetsMasks[k];
                            }
                            ++k;
                        }
                        mask = BlocManager._removeSingleCornersFromMask(mask);
                        mask = BlocManager._removeTopNeighbourFromMask(mask);
                        if (MasksAnim.containsKey(mask = BlocManager._removeLeftNeighbourFromMask(mask))) {
                            a.play(MasksAnim.get(mask));
                            a.getBehaviour("physicsAuto").setStringParameter("animId", MasksAnim.get(mask));
                        } else {
                            a.play(MasksAnim.get(0));
                            a.getBehaviour("physicsAuto").setStringParameter("animId", MasksAnim.get(0));
                        }
                    }
                    ++co;
                }
                ++li;
            }
        }
    }

    public void computeAutoAnimForActor(Actor a) {
        this.getActorGridLocation(a, co, li);
        int li = BlocManager.li.get();
        int co = BlocManager.co.get();
        BlocManager._computeAutoAnimForActor(a, li, co, this.m_2dGridUnremovable, this.m_gridHeightInBloc, this.m_gridWidthInBloc);
    }

    protected static void _computeAutoAnimForActor(Actor a, int li, int co, Actor[][] grid, int numLine, int numCol) {
        int mask = 0;
        if (a != null) {
            int k = 0;
            while (k < Offsets.length) {
                int kLi = li + BlocManager.Offsets[k].X;
                int kCo = co + BlocManager.Offsets[k].Y;
                if (kLi >= 0 && kLi < numLine && kCo >= 0 && kCo < numCol && grid[kLi][kCo] != null) {
                    mask |= OffsetsMasks[k];
                }
                ++k;
            }
            mask = BlocManager._removeSingleCornersFromMask(mask);
            mask = BlocManager._removeTopNeighbourFromMask(mask);
            if (MasksAnim.containsKey(mask = BlocManager._removeLeftNeighbourFromMask(mask))) {
                a.play(MasksAnim.get(mask));
                a.getBehaviour("physicsAuto").setStringParameter("animId", MasksAnim.get(mask));
            } else {
                a.play(MasksAnim.get(0));
                a.getBehaviour("physicsAuto").setStringParameter("animId", MasksAnim.get(0));
            }
        }
    }

    static int _removeLeftNeighbourFromMask(int _mask) {
        if ((_mask & 8) > 0) {
            _mask &= 0xFFFFFFFE;
            _mask &= 0xFFFFFFDF;
        }
        return _mask;
    }

    static int _removeTopNeighbourFromMask(int _mask) {
        if ((_mask & 2) > 0) {
            _mask &= 0xFFFFFFFE;
            _mask &= 0xFFFFFFFB;
        }
        return _mask;
    }

    static int _removeSingleCornersFromMask(int _mask) {
        if ((_mask & 1) > 0 && (_mask & 8) == 0 && (_mask & 2) == 0) {
            _mask &= 0xFFFFFFFE;
        }
        if ((_mask & 4) > 0 && (_mask & 0x10) == 0 && (_mask & 2) == 0) {
            _mask &= 0xFFFFFFFB;
        }
        if ((_mask & 0x20) > 0 && (_mask & 8) == 0 && (_mask & 0x40) == 0) {
            _mask &= 0xFFFFFFDF;
        }
        if ((_mask & 0x80) > 0 && (_mask & 0x10) == 0 && (_mask & 0x40) == 0) {
            _mask &= 0xFFFFFF7F;
        }
        return _mask;
    }

    protected class Line {
        protected float m_timeBlinkLeft = GameVars.LineBlinkingTime();
        protected ArrayList<Actor> m_members = new ArrayList(GameVars.BlocManagerTick());
        protected boolean m_bDone = false;

        public boolean Done() {
            return this.m_bDone;
        }

        public void addActorToLine(Actor _actor) {
            this.m_members.add(_actor);
        }

        public void unhilight() {
            for (Actor a : this.m_members) {
                a.alpha(1.0f);
            }
        }

        public void updateHilight(float _alpha) {
            for (Actor a : this.m_members) {
                a.alpha(_alpha);
            }
        }

        public void update() {
            if (this.m_timeBlinkLeft >= 0.0f) {
                for (Actor a : this.m_members) {
                    boolean bl = a.visible = !a.visible;
                }
                this.m_timeBlinkLeft -= FlxG.elapsed;
            } else if (!this.m_bDone) {
                for (Actor a : this.m_members) {
                    a.Level().removeActorsToPhysic(a);
                }
                this.m_bDone = true;
            }
        }
    }
}

