/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.Level;
import java.util.HashMap;
import org.flixel.FlxSound;

public class BlocksSoundsManager {
    static HashMap<String, String> BlocSoundsLibrary = new HashMap(20);
    Level m_level = null;
    protected static boolean SoundInitialized = false;
    static FlxSound m_sndLanding = null;
    static FlxSound m_littleSlimCrush = null;
    static FlxSound m_sndBigDestroy = null;
    Vector2 m_sndBigDestroyEmitPos = Vector2.Zero();
    static FlxSound m_sndBlocOreGathered = null;
    static FlxSound m_sndFireDropBorn = null;
    Vector2 m_sndFireDropBornEmitPos = Vector2.Zero();
    static FlxSound m_sndFireDropSplash = null;
    Vector2 m_sndFireDropSplashEmitPos = Vector2.Zero();
    static FlxSound m_sndShakingDefault = null;
    static FlxSound m_sndShakingIce = null;
    static FlxSound m_sndShakingClay = null;
    static FlxSound m_sndShakingObsidian = null;
    static FlxSound m_sndShakingSand = null;
    static FlxSound m_sndFallLoop = null;
    int m_fallingBlocCounter = 0;
    static FlxSound m_sndFireLoop = null;
    int m_burningBlocCounter = 0;
    static FlxSound m_sndTntExplode = null;
    static FlxSound m_sndTntBip = null;
    boolean m_sndTntBipThisFrame = false;
    boolean m_sndSndBreakThisFrame = false;
    static FlxSound m_sndBlocBreak = null;
    static FlxSound m_sndBlocSpecial = null;
    static FlxSound m_sndTntTrigger = null;
    boolean m_sndTntTriggerThisFrame = false;
    ref<Integer> m_refIntHelper = new ref<Integer>(0);

    public static void AddSoundToLibrary(String _id, String _value) {
        BlocSoundsLibrary.put(_id, _value);
    }

    public BlocksSoundsManager(Level _level) {
        this.m_level = _level;
        this._buildSounds();
    }

    public void destroy() {
        m_sndFallLoop.stop();
        m_sndFireLoop.stop();
    }

    protected void _buildSounds() {
        if (!SoundInitialized) {
            m_sndBlocOreGathered = new FlxSound();
            m_sndBlocOreGathered.loadEmbedded(BlocSoundsLibrary.get("SndBlocOreGathered"), false, true, true);
            m_sndFireDropBorn = new FlxSound();
            m_sndFireDropBorn.loadEmbedded(BlocSoundsLibrary.get("SndBlocFireDropBorn"), false, true, true);
            m_sndFireDropSplash = new FlxSound();
            m_sndFireDropSplash.loadEmbedded(BlocSoundsLibrary.get("SndBlocFireDropSplash"), false, true, true);
            m_sndBigDestroy = new FlxSound();
            m_sndBigDestroy.loadEmbedded(BlocSoundsLibrary.get("SndBlocDestroy"), false, true, true);
            m_sndLanding = new FlxSound();
            m_sndLanding.loadEmbedded(BlocSoundsLibrary.get("SndBlocLand"), false, true, true);
            m_littleSlimCrush = new FlxSound();
            m_littleSlimCrush.loadEmbedded(BlocSoundsLibrary.get("SndSlimeCrush"), false, true, true);
            m_sndShakingDefault = new FlxSound();
            m_sndShakingDefault.loadEmbedded(BlocSoundsLibrary.get("SndBlocShakeDefault"), false, true, true);
            m_sndShakingIce = new FlxSound();
            m_sndShakingIce.loadEmbedded(BlocSoundsLibrary.get("SndBlocShakeIce"), false, true, true);
            m_sndShakingClay = new FlxSound();
            m_sndShakingClay.loadEmbedded(BlocSoundsLibrary.get("SndBlocShakeClay"), false, true, true);
            m_sndShakingObsidian = new FlxSound();
            m_sndShakingObsidian.loadEmbedded(BlocSoundsLibrary.get("SndBlocShakeObsidian"), false, true, true);
            m_sndShakingSand = new FlxSound();
            m_sndShakingSand.loadEmbedded(BlocSoundsLibrary.get("SndBlocShakeSand"), false, true, true);
            m_sndBlocBreak = new FlxSound();
            m_sndBlocBreak.loadEmbedded(BlocSoundsLibrary.get("SndBlocBreak"), false, true, true);
            m_sndBlocSpecial = new FlxSound();
            m_sndBlocSpecial.loadEmbedded(BlocSoundsLibrary.get("SndBlocSpecial"), false, true, true);
            m_sndFallLoop = new FlxSound();
            m_sndFallLoop.loadEmbedded(BlocSoundsLibrary.get("SndBlocFallLoop"), true, true, false);
            m_sndFireLoop = new FlxSound();
            m_sndFireLoop.loadEmbedded(BlocSoundsLibrary.get("SndBlocFireLoop"), true, true, false);
            m_sndTntExplode = new FlxSound();
            m_sndTntExplode.loadEmbedded(BlocSoundsLibrary.get("SndBlocTntExplode"), false, true, true);
            m_sndTntBip = new FlxSound();
            m_sndTntBip.loadEmbedded(BlocSoundsLibrary.get("SndBlocTntBip"), false, true, true);
            m_sndTntTrigger = new FlxSound();
            m_sndTntTrigger.loadEmbedded(BlocSoundsLibrary.get("SndBlocTntTrigger"), false, true, true);
            SoundInitialized = true;
        }
    }

    protected void _createSound(FlxSound _snd, String _id, boolean _bLoop) {
        _snd = new FlxSound();
        _snd.loadEmbedded(BlocSoundsLibrary.get(_id), _bLoop, true, !_bLoop);
    }

    public void muteLoopedSounds(boolean _bVolumeToZero) {
        float volume = _bVolumeToZero ? 0.0f : 1.0f;
        m_sndFireLoop.volume(volume);
        m_sndFallLoop.volume(volume);
    }

    public void update() {
        this.m_sndTntBipThisFrame = false;
        this.m_sndSndBreakThisFrame = false;
        this.m_sndTntTriggerThisFrame = false;
    }

    protected void _updateNearestSound(boolean _playThisFrame, FlxSound _sound, Vector2 _emitPos, float _nearestDistance) {
        if (_playThisFrame) {
            _sound.play(_emitPos.X, _emitPos.Y, this.m_level.MainPlayer().getCenterX(), this.m_level.MainPlayer().getCenterY());
            _playThisFrame = false;
            _nearestDistance = Float.MAX_VALUE;
        }
    }

    protected void _checkTriggerAttenuatedSound(Actor _triggerer, float _nearestDistance, Vector2 _emitPos, boolean _playThisFrame) {
        float d = this.m_level.MainPlayer().distanceSquared(_triggerer);
        if (d < _nearestDistance) {
            _nearestDistance = d;
            _emitPos.X = _triggerer.getCenterX();
            _emitPos.Y = _triggerer.getCenterY();
            _playThisFrame = true;
        }
    }

    public void triggerBlocSoundEvent(eBlocSoundEvent _sndEvent, Actor _triggerer) {
        switch (_sndEvent) {
            case eBlocSoundEvent_FireDropBorn: {
                break;
            }
            case eBlocSoundEvent_FireDropSplash: {
                break;
            }
            case eBlocSoundEvent_BigMamaDestroyBloc: {
                break;
            }
            case eBlocSoundEvent_AllOreGathered: {
                m_sndBlocOreGathered.play();
                break;
            }
            case eBlocSoundEvent_LittleSlimeCrush: {
                m_littleSlimCrush.play();
                break;
            }
            case eBlocSoundEvent_Land: {
                m_sndLanding.play();
                break;
            }
            case eBlocSoundEvent_Shake: {
                this._shakeDependingMaterial(_triggerer.Material());
                break;
            }
            case eBlocSoundEvent_FallBegin: {
                this.m_refIntHelper.set(this.m_fallingBlocCounter);
                this._loopingSoundBegin(m_sndFallLoop, this.m_refIntHelper);
                this.m_fallingBlocCounter = this.m_refIntHelper.get();
                break;
            }
            case eBlocSoundEvent_FallEnd: {
                this.m_refIntHelper.set(this.m_fallingBlocCounter);
                this._loopSoundEnd(m_sndFallLoop, this.m_refIntHelper);
                this.m_fallingBlocCounter = this.m_refIntHelper.get();
                break;
            }
            case eBlocSoundEvent_FireBegin: {
                this.m_refIntHelper.set(this.m_burningBlocCounter);
                this._loopingSoundBegin(m_sndFireLoop, this.m_refIntHelper);
                this.m_burningBlocCounter = this.m_refIntHelper.get();
                break;
            }
            case eBlocSoundEvent_FireEnd: {
                this.m_refIntHelper.set(this.m_burningBlocCounter);
                this._loopSoundEnd(m_sndFireLoop, this.m_refIntHelper);
                this.m_burningBlocCounter = this.m_refIntHelper.get();
                break;
            }
            case eBlocSoundEvent_TntTrigger: {
                if (this.m_sndTntTriggerThisFrame) break;
                m_sndTntTrigger.play();
                this.m_sndTntTriggerThisFrame = true;
                break;
            }
            case eBlocSoundEvent_TntExplode: {
                m_sndTntExplode.play();
                break;
            }
            case eBlocSoundEvent_TntBip: {
                if (this.m_sndTntBipThisFrame) break;
                m_sndTntBip.play();
                this.m_sndTntBipThisFrame = true;
                break;
            }
            case eBlocSoundEvent_BlockBreak: {
                if (this.m_sndSndBreakThisFrame) break;
                m_sndBlocBreak.play();
                this.m_sndSndBreakThisFrame = true;
                break;
            }
            case eBlocSoundEvent_BlockSpecial: {
                m_sndBlocSpecial.play();
            }
        }
    }

    protected void _shakeDependingMaterial(Actor.eActorMaterial _material) {
        switch (_material) {
            case eActorMaterial_Ice: {
                m_sndShakingIce.play();
                break;
            }
            case eActorMaterial_Clay: {
                m_sndShakingClay.play();
                break;
            }
            case eActorMaterial_Obsidian: {
                m_sndShakingObsidian.play();
                break;
            }
            case eActorMaterial_Sand: {
                m_sndShakingSand.play();
                break;
            }
            default: {
                m_sndShakingDefault.play();
            }
        }
    }

    protected void _loopingSoundBegin(FlxSound _snd, ref<Integer> _counterRef) {
        int _counter = _counterRef.get();
        if (_counter == 0 && !_snd.playing()) {
            _snd.play();
        }
        _counterRef.set(++_counter);
    }

    protected void _loopSoundEnd(FlxSound _snd, ref<Integer> _counterRef) {
        int _counter = _counterRef.get();
        if (_counter > 0) {
            if (--_counter == 0) {
                _snd.stop();
            }
        } else {
            _snd.stop();
        }
        _counterRef.set(_counter);
    }

    public static enum eBlocSoundEvent {
        eBlocSoundEvent_Land,
        eBlocSoundEvent_Shake,
        eBlocSoundEvent_FallBegin,
        eBlocSoundEvent_FallEnd,
        eBlocSoundEvent_FireBegin,
        eBlocSoundEvent_FireEnd,
        eBlocSoundEvent_TntTrigger,
        eBlocSoundEvent_TntBip,
        eBlocSoundEvent_TntExplode,
        eBlocSoundEvent_BigMamaDestroyBloc,
        eBlocSoundEvent_FireDropBorn,
        eBlocSoundEvent_FireDropSplash,
        eBlocSoundEvent_LittleSlimeCrush,
        eBlocSoundEvent_AllOreGathered,
        eBlocSoundEvent_BlockBreak,
        eBlocSoundEvent_BlockSpecial;

    }
}

