/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import SSS.BTM.GameVars;
import SSS.Managers.BTM.Dialog.Dialog;
import SSS.Util.Debug;
import java.util.HashMap;
import org.flixel.FlxG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DialogDataBase {
    HashMap<String, Dialog> m_dialogDataBase = new HashMap(100);
    String m_customLevelName = "";
    HashMap<String, Dialog> m_customDialogDataBase = new HashMap(20);
    boolean m_bLoaded = false;
    protected static DialogDataBase m_Instance = null;

    public HashMap<String, Dialog> DialogDataBaseValues() {
        return this.m_dialogDataBase;
    }

    public static DialogDataBase Instance() {
        if (m_Instance == null) {
            m_Instance = new DialogDataBase();
        }
        return m_Instance;
    }

    protected DialogDataBase() {
    }

    public Dialog getDialog(String _id) {
        if (GameVars.GameCommunityMode()) {
            if (this.m_customDialogDataBase.size() > 0 && this.m_customDialogDataBase.containsKey(_id)) {
                return this.m_customDialogDataBase.get(_id);
            }
            String[] dialogStepsContent = _id.split(";;;");
            Dialog newDlg = new Dialog("DLG_ID_COMMUNITY", true, 0.0f);
            if (dialogStepsContent != null) {
                int i = 0;
                while (i < dialogStepsContent.length) {
                    String bubbleContent = dialogStepsContent[i].replace(";;", "[r]");
                    newDlg.addStep(bubbleContent, "guy_silhouette", 0.0f);
                    ++i;
                }
            } else {
                newDlg.addStep("ERROR", "guy_silhouette", 0.0f);
            }
            return newDlg;
        }
        return this.m_dialogDataBase.get(_id);
    }

    public void load() {
        if (!this.m_bLoaded) {
            this._load();
            this.m_bLoaded = true;
        }
    }

    protected void _load() {
        Document doc = null;
        try {
            doc = FlxG.Content().LoadXDocument("sss/metainfos/Dialogs");
        }
        catch (Exception e) {
            Debug.Assert(false, String.format("Error Loading dialogDatabase file: \n{0}", e.getMessage()));
        }
        if (doc != null) {
            this._populateDatabase(doc);
        }
    }

    public void populateCustomDatabase(String _customLevelName, Document _doc, boolean _bForce) {
        if (_bForce || !this.m_customLevelName.equals(_customLevelName)) {
            this.m_customLevelName = _customLevelName;
            this.m_customDialogDataBase.clear();
            this._populateMap(_doc, this.m_customDialogDataBase, "guy_silhouette");
        }
    }

    public void clearCustomDatabase() {
        this.m_customLevelName = "";
        this.m_customDialogDataBase.clear();
    }

    protected void _populateMap(Document _doc, HashMap<String, Dialog> _mapToFill, String _defaultIconAnimOrNil) {
        String timerAttrib = null;
        float fTimer = 0.0f;
        NodeList dialogsNodeList = _doc.getElementsByTagName("Dialogs");
        Element elemDialogs = null;
        Element elemDialog = null;
        Element elemDialogStep = null;
        NodeList dlgNodeList = null;
        NodeList elemDialogStepNodeList = null;
        int dialogs = 0;
        while (dialogs < dialogsNodeList.getLength()) {
            elemDialogs = (Element)dialogsNodeList.item(dialogs);
            dlgNodeList = elemDialogs.getElementsByTagName("Dialog");
            int dlg = 0;
            while (dlg < dlgNodeList.getLength()) {
                elemDialog = (Element)dlgNodeList.item(dlg);
                boolean bNeedValitation = !elemDialog.getAttribute("needValidation").equals("0");
                fTimer = !bNeedValitation ? Float.parseFloat(elemDialog.getAttribute("timer")) : 0.0f;
                Dialog dialog = new Dialog(elemDialog.getAttribute("id"), bNeedValitation, fTimer);
                elemDialogStepNodeList = elemDialog.getElementsByTagName("DialogStep");
                int dlgStep = 0;
                while (dlgStep < elemDialogStepNodeList.getLength()) {
                    elemDialogStep = (Element)elemDialogStepNodeList.item(dlgStep);
                    fTimer = 0.0f;
                    if (!bNeedValitation && (timerAttrib = elemDialogStep.getAttribute("timer")) != null && timerAttrib.length() > 0) {
                        fTimer = Float.parseFloat(timerAttrib);
                    }
                    dialog.addStep(elemDialogStep.getAttribute("txtId"), _defaultIconAnimOrNil != null ? _defaultIconAnimOrNil : elemDialogStep.getAttribute("portraitAnim"), fTimer);
                    ++dlgStep;
                }
                _mapToFill.put(dialog.Id(), dialog);
                ++dlg;
            }
            ++dialogs;
        }
    }

    protected void _populateDatabase(Document _doc) {
        String timerAttrib = null;
        float fTimer = 0.0f;
        NodeList dialogsNodeList = _doc.getElementsByTagName("Dialogs");
        Element elemDialogs = null;
        Element elemDialog = null;
        Element elemDialogStep = null;
        NodeList dlgNodeList = null;
        NodeList elemDialogStepNodeList = null;
        int dialogs = 0;
        while (dialogs < dialogsNodeList.getLength()) {
            elemDialogs = (Element)dialogsNodeList.item(dialogs);
            dlgNodeList = elemDialogs.getElementsByTagName("Dialog");
            int dlg = 0;
            while (dlg < dlgNodeList.getLength()) {
                elemDialog = (Element)dlgNodeList.item(dlg);
                boolean bNeedValitation = !elemDialog.getAttribute("needValidation").equals("0");
                fTimer = !bNeedValitation ? Float.parseFloat(elemDialog.getAttribute("timer")) : 0.0f;
                Dialog dialog = new Dialog(elemDialog.getAttribute("id"), bNeedValitation, fTimer);
                elemDialogStepNodeList = elemDialog.getElementsByTagName("DialogStep");
                int dlgStep = 0;
                while (dlgStep < elemDialogStepNodeList.getLength()) {
                    elemDialogStep = (Element)elemDialogStepNodeList.item(dlgStep);
                    fTimer = 0.0f;
                    if (!bNeedValitation && (timerAttrib = elemDialogStep.getAttribute("timer")) != null && timerAttrib.length() > 0) {
                        fTimer = Float.parseFloat(timerAttrib);
                    }
                    dialog.addStep(elemDialogStep.getAttribute("txtId"), elemDialogStep.getAttribute("portraitAnim"), fTimer);
                    ++dlgStep;
                }
                this.m_dialogDataBase.put(dialog.Id(), dialog);
                ++dlg;
            }
            ++dialogs;
        }
    }
}

