/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.Level;
import SSS.Managers.BTM.Dialog.Dialog;
import SSS.Managers.BTM.DialogDataBase;
import SSS.Managers.BTM.TextDataBase;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import precompiler.MACRO;

public class DialogManager {
    public static boolean ForceDisplayDialogs = false;
    protected eDialogState m_dialogState = eDialogState.eDialogState_Inactive;
    protected Level m_level = null;
    protected FlxSprite m_bubble = null;
    protected FlxText m_txt = null;
    protected FlxSprite m_portrait = null;
    protected FlxSprite m_button = null;
    protected FlxText m_txtSkip = null;
    protected String m_txtSkipStr = "";
    protected TweenManager m_tweenManager = null;
    protected FlxText m_buttonKeyText = null;
    protected FlxSprite m_iconKeyText = null;
    float m_buttonKeyTextOffsetX = 0.0f;
    float m_buttonKeyTextOffsetY = 0.0f;
    protected Dialog m_dialog = null;
    protected FlxSound m_sndEntrance = null;
    protected FlxSound m_sndExit = null;
    protected FlxSound m_sndValid = null;
    protected FlxSound m_sndEntranceDefault = null;
    protected FlxSound m_sndExitDefault = null;
    protected FlxSound m_sndValidDefault = null;
    float m_timeMaxElapsed = 0.0f;
    float m_timeElapsed = 0.0f;
    protected int m_numDialogStep = 0;
    protected int m_dialogStep = 0;
    protected boolean m_bWaitForKey = true;
    static float TextOffsetY = -10.0f;

    public boolean isManagerInactive() {
        return this.m_dialogState == eDialogState.eDialogState_Inactive;
    }

    public int getNumDialogStep() {
        return this.m_numDialogStep;
    }

    public int getDialogStep() {
        return this.m_dialogStep;
    }

    public DialogManager(Level _level) {
        this.m_level = _level;
        this._build();
    }

    protected void _build() {
        this.m_sndEntranceDefault = new FlxSound();
        this.m_sndEntranceDefault.loadEmbedded("appel entrant", false, true, true);
        this.m_sndExitDefault = new FlxSound();
        this.m_sndExitDefault.loadEmbedded("appel sortant", false, true, true);
        this.m_sndValidDefault = new FlxSound();
        this.m_sndValidDefault.loadEmbedded("affiche txt", false, true, true);
        this.m_bubble = this.m_level.instanciateSprite("bialog_bubble");
        this.m_portrait = this.m_level.instanciateSprite("portraits");
        this.m_button = this.m_level.instanciateSprite("buttons_plalette");
        this.m_buttonKeyText = new FlxText(0.0f, 0.0f, 150.0f);
        this.m_buttonKeyText.alignment = FlxText.FlxJustification.Center;
        this.m_buttonKeyText.text(InputManager.GetFriendlyButtonName(Buttons.A, false));
        this.m_buttonKeyText.scrollFactor = Vector2.Zero();
        this.m_buttonKeyText.color(Color.Black());
        this.m_iconKeyText = new FlxSprite();
        this.m_iconKeyText.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/keyboard_key"));
        this.m_iconKeyText.scrollFactor = Vector2.Zero();
        this.m_bubble.scrollFactor = Vector2.Zero();
        this.m_portrait.scrollFactor = Vector2.Zero();
        this.m_button.scrollFactor = Vector2.Zero();
        this.m_bubble.x = (float)FlxG.width * 0.5f - this.m_bubble.width * 0.5f;
        this.m_portrait.x = this.m_bubble.x + 40.0f;
        this.m_portrait.y = this.m_bubble.y - 2.0f;
        this.m_button.x = this.m_bubble.x + this.m_bubble.width - this.m_button.width - 5.0f - 60.0f;
        this.m_button.y = this.m_bubble.y + this.m_bubble.height - this.m_button.height - 5.0f - 80.0f;
        this.m_iconKeyText.x = this.m_button.x + this.m_button.width * 0.5f - this.m_iconKeyText.width * 0.5f;
        this.m_iconKeyText.y = this.m_button.y + this.m_button.height * 0.5f - this.m_iconKeyText.height * 0.5f + 20.0f;
        this.m_buttonKeyText.x = this.m_iconKeyText.x + this.m_iconKeyText.width * 0.5f - this.m_buttonKeyText.width * 0.5f;
        this.m_buttonKeyText.y = this.m_iconKeyText.y + this.m_iconKeyText.height * 0.5f - this.m_buttonKeyText.height * 0.5f;
        float scale = Utility.GetTextButtonScale(this.m_iconKeyText, this.m_buttonKeyText);
        this.m_buttonKeyText.scale(scale);
        this.m_buttonKeyText.y -= 16.0f * scale * 0.5f;
        float posLeft = this.m_portrait.x + this.m_portrait.width + 5.0f;
        float posRight = this.m_button.x + this.m_button.width * 0.5f;
        this.m_txt = new FlxText(posLeft, this.m_bubble.y + this.m_bubble.height * 0.5f + TextOffsetY, posRight - posLeft);
        this.m_txt.UseSpecialBalises = true;
        this.m_txt.setFormat(null, 2.0f, this.m_txt.color(), FlxText.FlxJustification.Left, this.m_txt.backColor);
        this.m_bubble.visible = false;
        this.m_portrait.visible = false;
        this.m_button.visible = false;
        this.m_buttonKeyText.visible = false;
        this.m_iconKeyText.visible = false;
        this.m_txt.visible = false;
        this.m_txtSkip = new FlxText(this.m_bubble.x + this.m_bubble.width * 0.5f - 150.0f, this.m_bubble.y + this.m_bubble.height * 0.75f, 300.0f);
        this.m_txtSkip.text("");
        this.m_txtSkipStr = TextDataBase.Instance().getText("TXT_SKIP_ALL");
        this.m_txtSkip.setFormat(null, 1.1f, Color.White(), FlxText.FlxJustification.Center, Color.White());
        this.m_txtSkip.visible = false;
        this.m_level.LayerHud().add(this.m_bubble);
        this.m_level.LayerHud().add(this.m_portrait);
        this.m_level.LayerHud().add(this.m_button);
        this.m_level.LayerHud().add(this.m_iconKeyText);
        this.m_level.LayerHud().add(this.m_buttonKeyText);
        this.m_level.LayerHud().add(this.m_txt);
        this.m_level.LayerHud().add(this.m_txtSkip);
        this.m_tweenManager = new TweenManager();
    }

    public void startDialog(String _dialogId, FlxSound _sndEntranceOrNil, FlxSound _sndExitOrNil, FlxSound _sndValidOrNil) {
        this.m_dialog = DialogDataBase.Instance().getDialog(_dialogId);
        this.m_sndEntrance = _sndEntranceOrNil != null ? _sndEntranceOrNil : this.m_sndEntranceDefault;
        this.m_sndExit = _sndExitOrNil != null ? _sndExitOrNil : this.m_sndExitDefault;
        FlxSound flxSound = this.m_sndValid = _sndValidOrNil != null ? _sndValidOrNil : this.m_sndValidDefault;
        if (MACRO.DIALOG_VIEWER) {
            this.m_sndEntrance = null;
            this.m_sndExit = null;
            this.m_sndValid = null;
        }
        this.m_numDialogStep = this.m_dialog.DialogSteps().size();
        this.m_dialogStep = 0;
        this.m_bWaitForKey = this.m_dialog.NeedValidation();
        this.m_dialogState = eDialogState.eDialogState_Starting;
    }

    public void stopDialog() {
        if (this.m_dialogState != eDialogState.eDialogState_Inactive && this.m_dialogState != eDialogState.eDialogState_Ending) {
            this.m_dialogState = eDialogState.eDialogState_Ending;
            this.update();
        }
    }

    protected void _initStep() {
        this.m_portrait.play(this.m_dialog.DialogSteps().get(this.m_dialogStep).PortraitAnimId());
        this.m_txt.text(TextDataBase.Instance().getText(this.m_dialog.DialogSteps().get(this.m_dialogStep).TextId()));
        if (!this.m_bWaitForKey) {
            this.m_timeMaxElapsed = this.m_dialog.DialogSteps().get(this.m_dialogStep).Timer();
            this.m_timeElapsed = 0.0f;
        }
    }

    public boolean update() {
        if (this.m_dialogState != eDialogState.eDialogState_Inactive) {
            this.m_tweenManager.update();
        }
        switch (this.m_dialogState) {
            case eDialogState_Inactive: {
                break;
            }
            case eDialogState_Starting: {
                this.m_bubble.visible = false;
                this.m_portrait.visible = false;
                this.m_button.visible = false;
                this.m_buttonKeyText.visible = false;
                this.m_iconKeyText.visible = false;
                this.m_txt.visible = false;
                this.m_txtSkip.visible = false;
                this.m_numDialogStep = this.m_dialog.DialogSteps().size();
                this.m_dialogStep = 0;
                this.m_bWaitForKey = this.m_dialog.NeedValidation();
                if (this.m_bWaitForKey) {
                    this.m_level.MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DialogControlPlayerBegin, null);
                }
                if (this.m_sndEntrance != null) {
                    this.m_sndEntrance.play();
                }
                this._initStep();
                this.m_dialogState = eDialogState.eDialogState_Appearing;
                break;
            }
            case eDialogState_Appearing: {
                this.m_bubble.visible = true;
                this.m_portrait.visible = true;
                if (InputManager.IsAnyGamepadConnected()) {
                    this.m_buttonKeyText.visible = false;
                    this.m_iconKeyText.visible = false;
                    this.m_button.visible = this.m_bWaitForKey;
                    this.m_txtSkip.text("(" + InputManager.GetFriendlyButtonName(Buttons.B, false) + ")" + this.m_txtSkipStr);
                } else {
                    this.m_buttonKeyText.visible = this.m_bWaitForKey;
                    this.m_iconKeyText.visible = this.m_bWaitForKey;
                    this.m_button.visible = false;
                    this.m_txtSkip.text("[" + InputManager.GetFriendlyButtonName(Buttons.B, false) + "]" + this.m_txtSkipStr);
                }
                this.m_txt.visible = true;
                if (this.m_bWaitForKey) {
                    this.m_txtSkip.visible = true;
                    this.m_tweenManager.RemoveTweenable(this.m_txtSkip);
                    this.m_txtSkip.alpha(0.0f);
                    this.m_tweenManager.ToAlpha((Tweenable)this.m_txtSkip, 0.25f, 1.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
                }
                this.m_dialogState = eDialogState.eDialogState_Dialoging;
                break;
            }
            case eDialogState_Dialoging: {
                if (this.m_bWaitForKey) {
                    if (InputManager.IsNewButtonPress(Buttons.A)) {
                        this._nextDialogStep(false);
                        break;
                    }
                    if (!InputManager.IsNewButtonPress(Buttons.B)) break;
                    this._nextDialogStep(true);
                    break;
                }
                this.m_timeElapsed += FlxG.elapsed;
                if (!(this.m_timeElapsed > this.m_timeMaxElapsed)) break;
                this.m_timeElapsed = 0.0f;
                this._nextDialogStep(false);
                break;
            }
            case eDialogState_Disappearing: {
                if (this.m_bWaitForKey) {
                    this.m_level.MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DialogControlPlayerEnd, null);
                }
                this.m_dialogState = eDialogState.eDialogState_Ending;
                break;
            }
            case eDialogState_Ending: {
                if (this.m_bWaitForKey) {
                    this.m_tweenManager.RemoveTweenable(this.m_txtSkip);
                    this.m_txtSkip.alpha(0.0f);
                }
                this.m_txtSkip.visible = false;
                this.m_bubble.visible = false;
                this.m_portrait.visible = false;
                this.m_button.visible = false;
                this.m_buttonKeyText.visible = false;
                this.m_iconKeyText.visible = false;
                this.m_txt.visible = false;
                this.m_dialogState = eDialogState.eDialogState_Inactive;
            }
        }
        return false;
    }

    protected void _nextDialogStep(boolean _bForceFinish) {
        ++this.m_dialogStep;
        if (this.m_dialogStep >= this.m_dialog.DialogSteps().size() || _bForceFinish) {
            this.m_dialogState = eDialogState.eDialogState_Disappearing;
            if (this.m_sndExit != null) {
                this.m_sndExit.play();
            }
        } else {
            if (this.m_sndValid != null) {
                this.m_sndValid.play();
            }
            this._initStep();
        }
    }

    public void forceRefresh() {
        if (this.m_dialog != null && this.m_dialogStep < this.m_dialog.DialogSteps().size()) {
            this._initStep();
        }
    }

    public static enum eDialogState {
        eDialogState_Inactive,
        eDialogState_Starting,
        eDialogState_Appearing,
        eDialogState_Dialoging,
        eDialogState_Disappearing,
        eDialogState_Ending;

    }
}

