/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import SSS.Level;
import SSS.Managers.BTM.BTMInfo;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.flixel.FlxG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LevelDataBase {
    protected boolean m_bLoaded = false;
    protected static LevelDataBase m_Instance = null;
    HashMap<String, BTMInfo> m_BTMs = new HashMap(50);
    ArrayList<LevelGroup> m_levelGroups = new ArrayList(5);

    public static LevelDataBase Instance() {
        if (m_Instance == null) {
            m_Instance = new LevelDataBase();
        }
        return m_Instance;
    }

    public BTMInfo getBTM(String _id) {
        return this.m_BTMs.get(_id);
    }

    public ArrayList<LevelGroup> LevelsGroups() {
        return this.m_levelGroups;
    }

    public LevelGroup getLevelGroup(String _id) {
        LevelGroup res = null;
        int i = 0;
        while (i < this.m_levelGroups.size()) {
            LevelGroup lg = this.m_levelGroups.get(i);
            if (lg.Id().equals(_id)) {
                res = lg;
                break;
            }
            ++i;
        }
        return res;
    }

    public void cheatUnlockAllLevel(String _groupId) {
        LevelGroup lg = this.getLevelGroup(_groupId);
        if (lg != null) {
            for (LevelInfo li : lg.LevelInfos()) {
                li.Unlocked(true);
            }
        }
    }

    public void cheatUnlockAllBtm(String _groupIp) {
        LevelGroup lg = this.getLevelGroup(_groupIp);
        if (lg != null) {
            for (LevelInfo li : lg.LevelInfos()) {
                li.Unlocked(true);
                li.BTMFound(true);
            }
        }
    }

    public void cheatUnlockAllPar(String _groupIp) {
        LevelGroup lg = this.getLevelGroup(_groupIp);
        if (lg != null) {
            for (LevelInfo li : lg.LevelInfos()) {
                if (li.Cinematic()) continue;
                li.ParDone(true);
                li.ParBestValue(li.ParToReachValue());
            }
        }
    }

    public void updateLevelStats(String _group, String _levelName, boolean _bBTMfound, int _numCollectableLeft, boolean _bOpened, boolean _bDone) {
        LevelGroup lg = this.getLevelGroup(_group);
        if (lg != null) {
            lg.updateLevelInfo(_levelName, _bBTMfound, _numCollectableLeft, _bOpened, _bDone);
        }
    }

    public LevelInfo getLevelInfo(Level _level) {
        LevelInfo li = null;
        LevelGroup lg = _level.Group();
        if (lg != null) {
            li = lg.getLevelInfoOrNil(_level);
        }
        return li;
    }

    public int getLevelIndexInGroup(LevelGroup _lvlGroup, LevelInfo _lvlInfo) {
        if (_lvlGroup != null && _lvlInfo != null) {
            LevelInfo li = null;
            int i = 0;
            while (i < _lvlGroup.LevelInfos().size()) {
                li = _lvlGroup.LevelInfos().get(i);
                if (li != null && li.TargetLevelFile().equals(_lvlInfo.TargetLevelFile())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public LevelInfo getLevelInfo(String _levelId, String _groupId) {
        LevelGroup lg = this.getLevelGroup(_groupId);
        return this.getLevelInfo(_levelId, lg);
    }

    public LevelInfo getLevelInfo(String _levelId, LevelGroup _group) {
        LevelInfo li = null;
        if (_group != null) {
            li = _group.getLevelInfoOrNil(_levelId);
        }
        return li;
    }

    public LevelInfo getPreviousLevelInfoOrNil(String _levelId, LevelGroup _group) {
        return this.getPreviousNextLevelInfoOrNil(_levelId, _group, false);
    }

    public LevelInfo getNextLevelInfoOrNil(String _levelId, LevelGroup _group) {
        return this.getPreviousNextLevelInfoOrNil(_levelId, _group, true);
    }

    protected LevelInfo getPreviousNextLevelInfoOrNil(String _levelId, LevelGroup _group, boolean _bNext) {
        String nextLevelName;
        LevelInfo li = null;
        if (_group != null && (nextLevelName = this._getPreviousNextLevelName(_levelId, _group, false, _bNext)) != null) {
            li = this.getLevelInfo(nextLevelName, _group);
        }
        return li;
    }

    public String getNextLevelName(Level _refLevel, boolean _bUnlockNextLevelIfNotAlready) {
        return this._getPreviousNextLevelName(_refLevel, _bUnlockNextLevelIfNotAlready, true);
    }

    public void markTracksAsUnlocked(String _trackId) {
        LevelInfo lvlInfo;
        LevelGroup tracksGroup = this.getLevelGroup("Tracks");
        if (tracksGroup != null && (lvlInfo = tracksGroup.getLevelInfoWithFriendlyOrNil(_trackId)) != null && lvlInfo.TrackPlayer()) {
            lvlInfo.Unlocked(true);
        }
    }

    public void markLevelAsDone(Level _refLevel) {
        LevelInfo li;
        LevelGroup lg = _refLevel.Group();
        if (lg != null && (li = lg.getLevelInfoOrNil(_refLevel)) != null) {
            li.Done(true);
        }
    }

    public void markLevelAsOpened(Level _refLevel) {
        LevelInfo li;
        LevelGroup lg = _refLevel.Group();
        if (lg != null && (li = lg.getLevelInfoOrNil(_refLevel)) != null) {
            li.Opened(true);
            li.Unlocked(true);
        }
    }

    public String getPreviousLevelName(Level _refLevel, boolean _bUnlockNextLevelIfNotAlready) {
        return this._getPreviousNextLevelName(_refLevel, _bUnlockNextLevelIfNotAlready, false);
    }

    protected String _getPreviousNextLevelName(String _levelId, String _groupId, boolean _bUnlockNextLevelIfNotAlready, boolean _bNext) {
        if (_groupId != null && _groupId.length() > 0) {
            LevelGroup lg = this.getLevelGroup(_groupId);
            return this._getPreviousNextLevelName(_levelId, lg, _bUnlockNextLevelIfNotAlready, _bNext);
        }
        return null;
    }

    protected String _getPreviousNextLevelName(String _levelId, LevelGroup _group, boolean _bUnlockNextLevelIfNotAlready, boolean _bNext) {
        LevelInfo li;
        LevelGroup lg = _group;
        if (lg != null && (li = lg.getNextLevelInfoOrNil(_levelId, _bNext)) != null) {
            if (_bUnlockNextLevelIfNotAlready) {
                li.Unlocked(true);
            }
            return li.TargetLevelFile();
        }
        return null;
    }

    protected String _getPreviousNextLevelName(Level _refLevel, boolean _bUnlockNextLevelIfNotAlready, boolean _bNext) {
        return this._getPreviousNextLevelName(_refLevel.Name(), _refLevel.Group(), _bUnlockNextLevelIfNotAlready, _bNext);
    }

    protected LevelDataBase() {
        BTMInfo.CreateDefaultVisuals();
    }

    String getNextLevelInLevelGroup(String _levelGroup, String _levelName) {
        LevelGroup lg = this.getLevelGroup(_levelGroup);
        if (lg != null) {
            return lg.getNextLevelOrNil(_levelName, true);
        }
        return null;
    }

    public void load() {
        if (!this.m_bLoaded) {
            this._loadBTMs();
            this._loadLevelGroups();
            this.m_bLoaded = true;
        }
    }

    protected void _loadBTMs() {
        Document doc = FlxG.Content().LoadXDocument("sss/metainfos/BTMs");
        if (doc != null) {
            Element elem = (Element)doc.getElementsByTagName("BTMs").item(0);
            NodeList elemBTMNodeList = elem.getElementsByTagName("BTM");
            Element elemBTM = null;
            int elemBTMId = 0;
            while (elemBTMId < elemBTMNodeList.getLength()) {
                elemBTM = (Element)elemBTMNodeList.item(elemBTMId);
                String id = elemBTM.getAttribute("id");
                String tmId = elemBTM.getAttribute("tmId");
                if (tmId.length() == 0) {
                    tmId = null;
                }
                this.m_BTMs.put(id, new BTMInfo(id, tmId, elemBTM.getAttribute("paletteId"), elemBTM.getAttribute("animId"), elemBTM.getAttribute("descTxtId")));
                ++elemBTMId;
            }
        }
    }

    public void reloadLevelUniverse() {
        this.m_levelGroups.clear();
        this._loadLevelGroups();
    }

    public void clearLevelGroups() {
        for (LevelGroup levelGroup : this.m_levelGroups) {
            levelGroup.clearLevelInfo();
        }
    }

    protected void _loadLevelGroups() {
        Document doc = FlxG.Content().LoadXDocument("sss/metainfos/LevelUniverse");
        if (doc != null) {
            Element elem = (Element)doc.getElementsByTagName("LevelUniverse").item(0);
            String flagAttrib = null;
            NodeList elemLevelGroupNodeList = elem.getElementsByTagName("LevelGroup");
            Element elemLevelGroup = null;
            int elemLevelGroupId = 0;
            while (elemLevelGroupId < elemLevelGroupNodeList.getLength()) {
                elemLevelGroup = (Element)elemLevelGroupNodeList.item(elemLevelGroupId);
                String groupId = elemLevelGroup.getAttribute("id");
                flagAttrib = elemLevelGroup.getAttribute("flag");
                LevelGroup group = new LevelGroup(groupId, flagAttrib != null ? flagAttrib : null);
                group.loadFromNode(elemLevelGroup);
                this.m_levelGroups.add(group);
                ++elemLevelGroupId;
            }
        }
    }
}

