/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import SSS.Level;
import SSS.Managers.BTM.LevelInfo;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LevelGroup {
    eSpecialFlag m_flag = eSpecialFlag.None;
    protected String m_id = "";
    protected ArrayList<LevelInfo> m_levelInfos = new ArrayList(40);

    public eSpecialFlag Flag() {
        return this.m_flag;
    }

    public String Id() {
        return this.m_id;
    }

    public ArrayList<LevelInfo> LevelInfos() {
        return this.m_levelInfos;
    }

    public LevelGroup(String id, String _flagOrNil) {
        this.m_id = id;
        if (_flagOrNil != null) {
            if (_flagOrNil.equals("tracks")) {
                this.m_flag = eSpecialFlag.Tracks;
            } else if (_flagOrNil.equals("specials")) {
                this.m_flag = eSpecialFlag.Specials;
            } else if (_flagOrNil.equals("bonus")) {
                this.m_flag = eSpecialFlag.Bonuses;
            } else if (_flagOrNil.equals("slots")) {
                this.m_flag = eSpecialFlag.SavesSlots;
            } else if (_flagOrNil.equals("feature")) {
                this.m_flag = eSpecialFlag.FeaturesLevels;
            }
        }
    }

    public void loadFromNode(Element elemLevelGroup) {
        NodeList elemLevelNodeList = elemLevelGroup.getElementsByTagName("Level");
        Element elemLevel = null;
        int elemLevelId = 0;
        while (elemLevelId < elemLevelNodeList.getLength()) {
            elemLevel = (Element)elemLevelNodeList.item(elemLevelId);
            LevelInfo lvlInfo = new LevelInfo(this);
            lvlInfo.loadFromNode(elemLevel);
            this.m_levelInfos.add(lvlInfo);
            ++elemLevelId;
        }
    }

    public void updateLevelInfo(String _levelName, boolean _bBTMfound, int _collectableLeft, boolean _bOpened, boolean _bDone) {
        int i = 0;
        while (i < this.m_levelInfos.size()) {
            LevelInfo li = this.m_levelInfos.get(i);
            if (li.TargetLevelFile().equals(_levelName)) {
                li.updateInfo(_bBTMfound, _collectableLeft, _bOpened, _bDone);
                break;
            }
            ++i;
        }
    }

    public LevelInfo getLevelInfoOrNil(String _levelId) {
        LevelInfo li = null;
        int i = 0;
        while (i < this.m_levelInfos.size()) {
            if (this.m_levelInfos.get(i).TargetLevelFile().equals(_levelId)) {
                li = this.m_levelInfos.get(i);
                break;
            }
            ++i;
        }
        return li;
    }

    public LevelInfo getLevelInfoWithFriendlyOrNil(String _friendly) {
        int i = 0;
        while (i < this.m_levelInfos.size()) {
            LevelInfo li = this.m_levelInfos.get(i);
            if (li.FriendlyName().equals(_friendly)) {
                return li;
            }
            ++i;
        }
        return null;
    }

    public LevelInfo getLevelInfoOrNil(Level _level) {
        return this.getLevelInfoOrNil(_level.Name());
    }

    public LevelInfo getNextLevelInfoOrNil(String _nextToLevelName, boolean _bNext) {
        int index = -1;
        int i = 0;
        while (i < this.m_levelInfos.size()) {
            LevelInfo li = this.m_levelInfos.get(i);
            if (li.TargetLevelFile().equals(_nextToLevelName)) {
                if (_bNext) {
                    index = i + 1;
                    break;
                }
                index = i - 1;
                break;
            }
            ++i;
        }
        if (index >= 0 && index < this.m_levelInfos.size()) {
            return this.m_levelInfos.get(index);
        }
        return null;
    }

    public String getNextLevelOrNil(String _nextToLevelName, boolean _bNext) {
        LevelInfo li = this.getNextLevelInfoOrNil(_nextToLevelName, _bNext);
        if (li != null) {
            return li.TargetLevelFile();
        }
        return null;
    }

    public int getBTMFoundNumber() {
        int numBTMFound = 0;
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (lvlInfo.Cinematic() || !lvlInfo.BTMFound()) continue;
                ++numBTMFound;
            }
        }
        return numBTMFound;
    }

    public int getPARFoundNumber() {
        int numPARFound = 0;
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (lvlInfo.Cinematic() || !lvlInfo.ParDone()) continue;
                ++numPARFound;
            }
        }
        return numPARFound;
    }

    public int getLevelNumber(boolean bIncludeCinematics) {
        if (bIncludeCinematics) {
            return this.m_levelInfos.size();
        }
        int numLevel = 0;
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (lvlInfo.Cinematic()) continue;
                ++numLevel;
            }
        }
        return numLevel;
    }

    public boolean hasBTMdone(ArrayList<String> _listOfBTMsearch) {
        int numBTMcontained = 0;
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (lvlInfo.Cinematic() || !lvlInfo.BTMFound() || lvlInfo.BTM() == null || !_listOfBTMsearch.contains(lvlInfo.BTM().ID()) || ++numBTMcontained != _listOfBTMsearch.size()) continue;
                return true;
            }
        }
        return false;
    }

    public int getLevelDoneNumber() {
        int numLevelDone = 0;
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (lvlInfo.Cinematic() || !lvlInfo.Done()) continue;
                ++numLevelDone;
            }
        }
        return numLevelDone;
    }

    public void clearLevelInfo() {
        for (LevelInfo levelInfo : this.m_levelInfos) {
            levelInfo.clearInfo();
        }
    }

    public ArrayList<String> buildLevelFriendlyNamesList() {
        ArrayList<String> result = new ArrayList<String>(20);
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (lvlInfo.Cinematic()) continue;
                result.add(lvlInfo.FriendlyName());
            }
        }
        return result;
    }

    public boolean isLevelDone(String _levelFriendlyName) {
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (!lvlInfo.Done() || !lvlInfo.FriendlyName().equals(_levelFriendlyName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnyLevelGreenStared() {
        if (this.m_levelInfos != null) {
            for (LevelInfo lvlInfo : this.m_levelInfos) {
                if (!lvlInfo.Done() || !lvlInfo.ParDone() || lvlInfo.ParBestValue() <= lvlInfo.ParToReachValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum eSpecialFlag {
        None,
        Tracks,
        Bonuses,
        Specials,
        SavesSlots,
        FeaturesLevels;

    }
}

