/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Color;
import SSS.Managers.BTM.BTMInfo;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import org.w3c.dom.Element;

public class LevelInfo {
    protected String m_number = "";
    protected String m_friendlyName = "";
    protected String m_targetFile = "";
    protected boolean m_bCinematicLevel = false;
    protected boolean m_bTrackPlayer = false;
    protected boolean m_bUnlocked = false;
    protected int m_btmNeededToUnlock = 0;
    protected int m_starNeededToUnlock = 0;
    protected boolean m_bBTMFound = false;
    protected int m_parValue = Integer.MAX_VALUE;
    protected int m_bestParValue = 0;
    protected boolean m_bParDone = false;
    protected boolean m_Done = false;
    protected boolean m_Opened = false;
    protected BTMInfo m_btm = null;
    LevelGroup m_levelGroup = null;

    public String Number() {
        return this.m_number;
    }

    public String FriendlyName() {
        return this.m_friendlyName;
    }

    public String TargetLevelFile() {
        return this.m_targetFile;
    }

    public boolean Cinematic() {
        return this.m_bCinematicLevel;
    }

    public void Cinematic(boolean value) {
        this.m_bCinematicLevel = value;
    }

    public boolean TrackPlayer() {
        return this.m_bTrackPlayer;
    }

    public void TrackPlayer(boolean value) {
        this.m_bTrackPlayer = value;
    }

    public boolean Unlocked() {
        return this.m_bUnlocked;
    }

    public void Unlocked(boolean value) {
        this.m_bUnlocked = value;
    }

    public int BtmNeededToUnlock() {
        return this.m_btmNeededToUnlock;
    }

    public void BtmNeededToUnlock(int value) {
        this.m_btmNeededToUnlock = value;
    }

    public int StarNeededToUnlock() {
        return this.m_starNeededToUnlock;
    }

    public void StarNeededToUnlock(int value) {
        this.m_starNeededToUnlock = value;
    }

    public boolean BTMFound() {
        return this.m_bBTMFound;
    }

    public void BTMFound(boolean value) {
        this.m_bBTMFound = value;
    }

    public int ParToReachValue() {
        return this.m_parValue;
    }

    public int ParBestValue() {
        return this.m_bestParValue;
    }

    public void ParBestValue(int value) {
        this.m_bestParValue = value;
    }

    public boolean ParDone() {
        return this.m_bParDone;
    }

    public void ParDone(boolean value) {
        this.m_bParDone = value;
    }

    public boolean Done() {
        return this.m_Done;
    }

    public void Done(boolean value) {
        this.m_Done = value;
    }

    public boolean Opened() {
        return this.m_Opened;
    }

    public void Opened(boolean value) {
        this.m_Opened = value;
    }

    public BTMInfo BTM() {
        return this.m_btm;
    }

    public LevelInfo(LevelGroup _levelGroup) {
        this.m_levelGroup = _levelGroup;
    }

    public void loadFromNode(Element elemLevel) {
        String starNeeded;
        String btmNeeded;
        this.m_targetFile = elemLevel.getAttribute("target");
        this.m_friendlyName = elemLevel.getAttribute("friendly");
        this.m_number = elemLevel.getAttribute("num");
        this.m_parValue = Integer.parseInt(elemLevel.getAttribute("par"));
        this.m_bUnlocked = !elemLevel.getAttribute("unlocked").equals("0");
        String attribFlag = elemLevel.getAttribute("flag");
        boolean bl = this.m_bCinematicLevel = attribFlag != null ? attribFlag.equals("clap") : false;
        if (!this.m_bCinematicLevel) {
            boolean bl2 = this.m_bTrackPlayer = attribFlag != null ? attribFlag.equals("track") : false;
        }
        if ((btmNeeded = elemLevel.getAttribute("btmNeed")) != null && btmNeeded.length() > 0) {
            this.BtmNeededToUnlock(Integer.parseInt(btmNeeded));
        }
        if ((starNeeded = elemLevel.getAttribute("starNeed")) != null && starNeeded.length() > 0) {
            this.StarNeededToUnlock(Integer.parseInt(starNeeded));
        }
        this.m_btm = LevelDataBase.Instance().getBTM(elemLevel.getAttribute("btm"));
    }

    public void updateIconAnim() {
        if (this.m_btm != null) {
            if (this.m_bCinematicLevel) {
                this.m_bBTMFound = this.m_bUnlocked;
            }
            if ((this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.Bonuses || this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.FeaturesLevels) && this.m_Done) {
                this.m_btm.playBonusDone();
            } else if (!this.m_bUnlocked) {
                this.m_btm.playLockAnim();
            } else if (this.m_bBTMFound) {
                this.m_btm.playBTMFoundAnim();
            } else {
                this.m_btm.playUnLockAnim();
            }
            if (this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.Tracks) {
                this.m_btm.UseUnrevealedRepresentation(false);
            }
        }
    }

    public void clearInfo() {
        this.BTMFound(false);
        this.Done(false);
        this.ParDone(false);
        this.Unlocked(false);
    }

    public void changeColor(Color _color) {
        this.m_btm.changeColor(_color);
    }

    public void updateInfo(boolean _bBTMfound, int _collectableLeft, boolean _bOpened, boolean _bDone) {
        this.Unlocked(true);
        if (_collectableLeft > this.ParBestValue()) {
            this.ParBestValue(_collectableLeft);
        }
        if (_bBTMfound) {
            this.BTMFound(true);
        }
        if (_collectableLeft >= this.ParToReachValue()) {
            this.ParDone(true);
        }
        this.Opened(_bOpened);
        this.Done(_bDone);
    }
}

