/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Color;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.FileManager;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.MultipleLinesText;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxGroup;

public class NewsFeedManager {
    ArrayList<String> m_news;
    static int m_currentNewsId = 0;
    Thread m_phpInvoker = null;
    MultipleLinesText[] m_newsTexts;
    MultipleLinesText[] m_newsTextsCounter;
    int m_currentTextId = 0;
    TweenManager m_tween;
    float FadeTime = 0.5f;
    float m_delayBetweenNews = 4.0f;
    float m_timeElapsed = 0.0f;
    boolean m_bDoTextInit = false;
    boolean m_bReadyToDisplay = false;

    public void build(FlxGroup _layer) {
        this.m_newsTexts = new MultipleLinesText[2];
        this.m_newsTextsCounter = new MultipleLinesText[this.m_newsTexts.length];
        int i = 0;
        while (i < this.m_newsTexts.length) {
            MultipleLinesText text = new MultipleLinesText();
            text.initAttributes("", Color.White(), (float)FlxG.width * 0.5f, (float)FlxG.height * 0.95f, 1.1f, 1.0f, 1.2f);
            this.m_newsTexts[i] = text;
            _layer.add(text);
            MultipleLinesText textSub = new MultipleLinesText();
            textSub.initAttributes("", Color.White(), (float)FlxG.width * 0.5f, (float)FlxG.height * 0.98f, 1.0f, 1.0f, 1.2f);
            this.m_newsTextsCounter[i] = textSub;
            _layer.add(textSub);
            ++i;
        }
        this.m_tween = new TweenManager();
        this._initializeThreaded();
    }

    protected void _initializeThreaded() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                NewsFeedManager.this._buildInfoList();
                NewsFeedManager.this.m_bDoTextInit = true;
            }
        };
        this.m_phpInvoker = new Thread(r);
        this.m_phpInvoker.start();
    }

    protected void _initializeNextText() {
        if (this.m_news == null) {
            return;
        }
        int previousId = this.m_currentTextId++;
        if (this.m_currentTextId >= this.m_newsTexts.length) {
            this.m_currentTextId = 0;
        }
        if (m_currentNewsId >= this.m_news.size()) {
            m_currentNewsId = 0;
        }
        if (previousId != this.m_currentTextId) {
            this.m_tween.Clear();
            this.m_newsTexts[previousId].alpha(1.0f);
            this.m_newsTexts[this.m_currentTextId].alpha(0.0f);
            this.m_newsTexts[this.m_currentTextId].changeText(this.m_news.get(m_currentNewsId));
            this.m_tween.ToAlpha((Tweenable)this.m_newsTexts[previousId], 0.0f, this.FadeTime, TweenManager.EaseType.EASE_INSIN, 0.0f, (CallbackSimple)null);
            this.m_tween.ToAlpha((Tweenable)this.m_newsTexts[this.m_currentTextId], 1.0f, this.FadeTime, TweenManager.EaseType.EASE_INSIN, 0.0f, (CallbackSimple)null);
            this.m_newsTextsCounter[previousId].alpha(1.0f);
            this.m_newsTextsCounter[this.m_currentTextId].alpha(0.0f);
            this.m_newsTextsCounter[this.m_currentTextId].changeText("(" + (m_currentNewsId + 1) + "/" + this.m_news.size() + ")");
            this.m_tween.ToAlpha((Tweenable)this.m_newsTextsCounter[previousId], 0.0f, this.FadeTime, TweenManager.EaseType.EASE_INSIN, 0.0f, (CallbackSimple)null);
            this.m_tween.ToAlpha((Tweenable)this.m_newsTextsCounter[this.m_currentTextId], 1.0f, this.FadeTime, TweenManager.EaseType.EASE_INSIN, 0.0f, (CallbackSimple)null);
        }
        if (++m_currentNewsId >= this.m_news.size()) {
            m_currentNewsId = 0;
        }
    }

    protected void _buildInfoList() {
        String[] tweakAndInfos;
        String languageId = TextDataBase.Instance().LangageId();
        String phpRestult = FileManager.Instance().phpCall("getBTM_News", "?lang=" + languageId);
        this.m_news = null;
        if (phpRestult != null && phpRestult.length() > 0 && (tweakAndInfos = phpRestult.split("\\#")) != null && tweakAndInfos.length > 0) {
            String tweak = tweakAndInfos.length == 1 ? null : tweakAndInfos[0];
            String info = tweakAndInfos.length == 1 ? tweakAndInfos[0] : tweakAndInfos[1];
            String[] infos = info.split("\\|");
            if (infos != null && infos.length > 0) {
                this.m_news = new ArrayList(infos.length);
                int i = 0;
                while (i < infos.length) {
                    if (infos[i] != null && infos[i].length() > 0) {
                        this.m_news.add(infos[i]);
                    }
                    ++i;
                }
            }
            if (tweak != null && tweak.length() > 0) {
                try {
                    float delay = Float.parseFloat(tweak);
                    if (delay > 0.0f) {
                        this.m_delayBetweenNews = delay;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.m_news != null && this.m_news.size() == 0) {
            this.m_news = null;
        }
    }

    public void update() {
        if (this.m_bDoTextInit) {
            this._initializeNextText();
            this.m_bDoTextInit = false;
            this.m_bReadyToDisplay = true;
        } else if (this.m_bReadyToDisplay) {
            this.m_timeElapsed += FlxG.elapsed;
            if (this.m_timeElapsed > this.m_delayBetweenNews) {
                this.m_timeElapsed = 0.0f;
                this._initializeNextText();
            }
            this.m_tween.update();
        }
    }

    public void destroy() {
        if (this.m_phpInvoker != null) {
            this.m_phpInvoker.interrupt();
            this.m_phpInvoker = null;
        }
    }
}

