/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM.Particle;

import Microsoft.Xna.Framework.Color;
import SSS.Actor;
import SSS.Managers.BTM.Particle.ParticleManager;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.SssGroup;
import org.flixel.FlxSprite;

public class KaboomParticleEffect {
    public static Color _Orange = new Color(255, 255, 255);
    public static Color _Blue = new Color(34, 159, 255);
    public static Color _Dark = new Color(34, 34, 56, 128);
    ParticleManager m_manager;
    FlxSprite m_kaboomVisual;
    Actor m_kaboomEventReceiver = null;
    static final int m_kaboomFrame = 3;
    int m_animFrame;
    boolean m_bKaboomDone;
    float m_offsetx;
    float m_offsety;

    public static Color Orange() {
        return _Orange.clone();
    }

    public static Color Blue() {
        return _Blue.clone();
    }

    public static Color Dark() {
        return _Dark.clone();
    }

    public KaboomParticleEffect(ParticleManager _manager) {
        this.m_manager = _manager;
        this.m_kaboomVisual = ResourcesLibrary.Instance().InstanciateSprite("kaboom");
    }

    public void init(Actor _kaboomEventReceiver, float _centerx, float _centery, SssGroup _group, Color _color) {
        this.m_bKaboomDone = false;
        this.m_kaboomEventReceiver = _kaboomEventReceiver;
        this.m_offsetx = _centerx - _kaboomEventReceiver.x - this.m_kaboomVisual.width * 0.5f;
        this.m_offsety = _centery - _kaboomEventReceiver.y - this.m_kaboomVisual.height * 0.5f;
        this.m_kaboomVisual.x = this.m_offsetx + _kaboomEventReceiver.x;
        this.m_kaboomVisual.y = this.m_offsety + _kaboomEventReceiver.y;
        this.m_kaboomVisual.color(_color);
        this.m_kaboomVisual.play("kaboom", true);
        this.m_animFrame = this.m_kaboomVisual.CurFrame();
        _group.add(this.m_kaboomVisual);
    }

    public void deinit(SssGroup _group) {
        _group.remove(this.m_kaboomVisual);
    }

    public void update() {
        this.m_kaboomVisual.x = this.m_offsetx + this.m_kaboomEventReceiver.x;
        this.m_kaboomVisual.y = this.m_offsety + this.m_kaboomEventReceiver.y;
        this.m_kaboomVisual.update();
        if (this.m_animFrame <= 3 && this.m_kaboomVisual.CurFrame() >= 3) {
            this._kaboom();
        } else {
            this.m_animFrame = this.m_kaboomVisual.CurFrame();
        }
        if (this.m_kaboomVisual.finished) {
            this._kaboom();
            this.m_manager.stopKaboomEmitter(this);
        }
    }

    protected void _kaboom() {
        if (!this.m_bKaboomDone) {
            this.m_kaboomEventReceiver.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_Kaboom, null);
            this.m_bKaboomDone = true;
        }
    }
}

