/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM.Particle;

import Microsoft.Xna.Framework.Color;
import java.util.HashMap;
import org.flixel.FlxEmitter;
import org.flixel.FlxG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParticleEmitterFactory {
    protected static HashMap<String, eParamId> ParamIdByName = new HashMap<String, eParamId>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("area", eParamId.Area);
            this.put("img", eParamId.Img);
            this.put("rect", eParamId.Rect);
            this.put("color", eParamId.Color);
            this.put("scale", eParamId.Scale);
            this.put("rotation", eParamId.Rotation);
            this.put("speed", eParamId.Speed);
            this.put("gravity", eParamId.Gravity);
            this.put("life", eParamId.Life);
            this.put("drag", eParamId.Drag);
        }
    };
    protected static ParticleEmitterFactory m_Instance = null;

    public static ParticleEmitterFactory Instance() {
        if (m_Instance == null) {
            m_Instance = new ParticleEmitterFactory();
        }
        return m_Instance;
    }

    protected ParticleEmitterFactory() {
    }

    public FlxEmitter create(String _id) {
        FlxEmitter newEmitter = this.loadFromFile(_id);
        return newEmitter;
    }

    public void reset() {
    }

    protected FlxEmitter loadFromFile(String _filename) {
        Document doc = this._getParticleEmitterDocument(_filename);
        FlxEmitter emitter = new FlxEmitter();
        emitter.Id(_filename);
        this._initEmitterAttributes(emitter, doc);
        return emitter;
    }

    Document _getParticleEmitterDocument(String _filename) {
        Document doc = null;
        doc = FlxG.Content().LoadXDocument("sss/particles/" + _filename);
        return doc;
    }

    public void reinitEmitterParameter(FlxEmitter _emitter) {
        Document doc = this._getParticleEmitterDocument(_emitter.Id());
        this._initEmitterAttributes(_emitter, doc);
    }

    protected void _initEmitterAttributes(FlxEmitter _emitter, Document _doc) {
        Element elemParams = (Element)_doc.getElementsByTagName("Params").item(0);
        if (elemParams != null) {
            NodeList elemParamNodeList = elemParams.getElementsByTagName("Param");
            int elemParamId = 0;
            while (elemParamId < elemParamNodeList.getLength()) {
                Element elemParam = (Element)elemParamNodeList.item(elemParamId);
                this._initEmitterAttribute(_emitter, ParamIdByName.get(elemParam.getAttribute("id")), elemParam);
                ++elemParamId;
            }
        }
    }

    protected void _initEmitterAttribute(FlxEmitter _emitter, eParamId _paramId, Element _elemParam) {
        switch (_paramId) {
            case Img: {
                _emitter.createSprites(FlxG.Content().LoadTexture2D(_elemParam.getAttribute("value")), Integer.parseInt(_elemParam.getAttribute("quantity")), 0, 0);
                break;
            }
            case Rect: {
                _emitter.createSprites(null, Integer.parseInt(_elemParam.getAttribute("quantity")), Integer.parseInt(_elemParam.getAttribute("w")), Integer.parseInt(_elemParam.getAttribute("h")));
                break;
            }
            case Gravity: {
                _emitter.gravity = Float.parseFloat(_elemParam.getAttribute("value"));
                break;
            }
            case Rotation: {
                _emitter.setRotation(Float.parseFloat(_elemParam.getAttribute("min")), Float.parseFloat(_elemParam.getAttribute("max")));
                break;
            }
            case Scale: {
                _emitter.setScale(Float.parseFloat(_elemParam.getAttribute("min")), Float.parseFloat(_elemParam.getAttribute("max")));
                break;
            }
            case Speed: {
                _emitter.setXSpeed(Float.parseFloat(_elemParam.getAttribute("minx")), Float.parseFloat(_elemParam.getAttribute("maxx")));
                _emitter.setYSpeed(Float.parseFloat(_elemParam.getAttribute("miny")), Float.parseFloat(_elemParam.getAttribute("maxy")));
                break;
            }
            case Color: {
                _emitter.particuleColor(new Color(Integer.parseInt(_elemParam.getAttribute("r")), Integer.parseInt(_elemParam.getAttribute("g")), Integer.parseInt(_elemParam.getAttribute("b"))));
                break;
            }
            case Life: {
                _emitter.lifeTime(Float.parseFloat(_elemParam.getAttribute("min")), Float.parseFloat(_elemParam.getAttribute("max")));
                _emitter.alphaDisappearSpeed(Float.parseFloat(_elemParam.getAttribute("fadeOutSpeed")));
                _emitter.SpawnDelay(Float.parseFloat(_elemParam.getAttribute("delay")));
                _emitter.Explode(Integer.parseInt(_elemParam.getAttribute("explode")) > 0);
                break;
            }
            case Drag: {
                _emitter.particleDrag.X = Float.parseFloat(_elemParam.getAttribute("x"));
                _emitter.particleDrag.Y = Float.parseFloat(_elemParam.getAttribute("y"));
                break;
            }
            case Area: {
                _emitter.height = Float.parseFloat(_elemParam.getAttribute("h"));
                _emitter.width = Float.parseFloat(_elemParam.getAttribute("w"));
            }
        }
    }

    protected static enum eParamId {
        Area,
        Img,
        Rect,
        Color,
        Scale,
        Rotation,
        Speed,
        Gravity,
        Life,
        Drag;

    }
}

