/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM.Particle;

import Microsoft.Xna.Framework.Color;
import SSS.Actor;
import SSS.Behaviour;
import SSS.Level;
import SSS.Managers.BTM.Particle.KaboomParticleEffect;
import SSS.Managers.BTM.Particle.ParticleEmitterFactory;
import SSS.Managers.BTM.Particle.RetreiveMaterialParticleEffect;
import SSS.SssGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.flixel.FlxEmitter;

public class ParticleManager {
    ArrayList<RetreiveMaterialParticleEffect> m_activesMPart = new ArrayList(20);
    ArrayList<RetreiveMaterialParticleEffect> m_toAddMPart = new ArrayList(20);
    ArrayList<RetreiveMaterialParticleEffect> m_toRemoveMPart = new ArrayList(20);
    Stack<RetreiveMaterialParticleEffect> m_cachedMPart = new Stack();
    ArrayList<KaboomParticleEffect> m_activesKaboom = new ArrayList(20);
    ArrayList<KaboomParticleEffect> m_toAddKaboom = new ArrayList(20);
    ArrayList<KaboomParticleEffect> m_toRemoveKaboom = new ArrayList(20);
    Stack<KaboomParticleEffect> m_cachedKaboom = new Stack();
    HashMap<String, Stack<FlxEmitter>> m_poolEmitter = new HashMap(20);
    ArrayList<FlxEmitter> m_activeManualEmitter = new ArrayList(20);
    ArrayList<FlxEmitter> m_activeAutoEmitter = new ArrayList(20);
    ArrayList<FlxEmitter> m_activeAutoEmitterToRemove = new ArrayList(20);
    SssGroup m_renderingGroup;
    boolean m_bUpdating = false;
    Level m_level;

    public Level Level() {
        return this.m_level;
    }

    public ParticleManager(Level _level) {
        this.m_level = _level;
        this.m_renderingGroup = _level.LayerParticleEffects();
        this._initPools();
    }

    protected void _initPools() {
        int i = 0;
        while (i < 20) {
            this.m_cachedKaboom.push(new KaboomParticleEffect(this));
            ++i;
        }
    }

    public void startKaboomEmitter(float _cx, float _cy, Actor _kaboomEventReceiver, Color _color) {
        KaboomParticleEffect effet = null;
        if (this.m_cachedKaboom.size() == 0) {
            this.m_cachedKaboom.push(new KaboomParticleEffect(this));
        }
        effet = this.m_cachedKaboom.pop();
        effet.init(_kaboomEventReceiver, _cx, _cy, this.m_renderingGroup, _color);
        if (!this.m_bUpdating) {
            this.m_activesKaboom.add(effet);
        } else {
            this.m_toAddKaboom.add(effet);
        }
    }

    public void startFlyingMaterialEmitter(Behaviour _spawnerBehaviour, boolean _bClampNumMaterial) {
        RetreiveMaterialParticleEffect effet = null;
        if (this.m_cachedMPart.size() == 0) {
            this.m_cachedMPart.push(new RetreiveMaterialParticleEffect(this, _bClampNumMaterial));
        }
        effet = this.m_cachedMPart.pop();
        effet.init(_spawnerBehaviour, this.m_renderingGroup);
        if (!this.m_bUpdating) {
            this.m_activesMPart.add(effet);
        } else {
            this.m_toAddMPart.add(effet);
        }
    }

    public void update() {
        int i;
        this.m_bUpdating = true;
        this._updateKaboom();
        this._updateFlying();
        this.m_bUpdating = false;
        if (this.m_activeAutoEmitter.size() > 0) {
            i = 0;
            while (i < this.m_activeAutoEmitter.size()) {
                if (this.m_activeAutoEmitter.get(i).countLivingFast() <= 0) {
                    this.m_activeAutoEmitterToRemove.add(this.m_activeAutoEmitter.get(i));
                }
                ++i;
            }
        }
        if (this.m_activeAutoEmitterToRemove.size() > 0) {
            i = 0;
            while (i < this.m_activeAutoEmitterToRemove.size()) {
                this.m_activeAutoEmitter.remove(this.m_activeAutoEmitterToRemove.get(i));
                this.m_renderingGroup.remove(this.m_activeAutoEmitterToRemove.get(i));
                ++i;
            }
        }
    }

    protected void _reloadEmitterAttribs() {
        if (this.m_activeManualEmitter.size() > 0) {
            int i = 0;
            while (i < this.m_activeManualEmitter.size()) {
                FlxEmitter emitter = this.m_activeManualEmitter.get(i);
                ParticleEmitterFactory.Instance().reinitEmitterParameter(emitter);
                ++i;
            }
        }
    }

    protected void _updateKaboom() {
        if (this.m_toAddKaboom.size() > 0) {
            for (KaboomParticleEffect effect : this.m_toAddKaboom) {
                this.m_activesKaboom.add(effect);
            }
            this.m_toAddKaboom.clear();
        }
        if (this.m_activesKaboom.size() > 0) {
            for (KaboomParticleEffect effect : this.m_activesKaboom) {
                effect.update();
            }
        }
        if (this.m_toRemoveKaboom.size() > 0) {
            for (KaboomParticleEffect effect : this.m_toRemoveKaboom) {
                effect.deinit(this.m_renderingGroup);
                this.m_activesKaboom.remove(effect);
                this.m_cachedKaboom.push(effect);
            }
            this.m_toRemoveKaboom.clear();
        }
    }

    protected void _updateFlying() {
        if (this.m_toAddMPart.size() > 0) {
            for (RetreiveMaterialParticleEffect effect : this.m_toAddMPart) {
                this.m_activesMPart.add(effect);
            }
            this.m_toAddMPart.clear();
        }
        if (this.m_activesMPart.size() > 0) {
            for (RetreiveMaterialParticleEffect effect : this.m_activesMPart) {
                effect.update();
            }
        }
        if (this.m_toRemoveMPart.size() > 0) {
            for (RetreiveMaterialParticleEffect effect : this.m_toRemoveMPart) {
                effect.deinit(this.m_renderingGroup);
                this.m_activesMPart.remove(effect);
                this.m_cachedMPart.push(effect);
            }
            this.m_toRemoveMPart.clear();
        }
    }

    public FlxEmitter emitterUseBegin(String _id) {
        FlxEmitter result = null;
        result = this.m_poolEmitter.containsKey(_id) && this.m_poolEmitter.get(_id).size() > 0 ? this.m_poolEmitter.get(_id).pop() : ParticleEmitterFactory.Instance().create(_id);
        this.m_renderingGroup.add(result);
        this.m_activeManualEmitter.add(result);
        return result;
    }

    public void emitterUseEnd(FlxEmitter _emitter) {
        this.m_poolEmitter.get(_emitter.Id()).push(_emitter);
        this.m_renderingGroup.remove(_emitter);
        this.m_activeManualEmitter.remove(_emitter);
    }

    public void reserveEmitterTrigger(String _id) {
        if (!this.m_poolEmitter.containsKey(_id)) {
            this.m_poolEmitter.put(_id, new Stack());
        }
        this.m_poolEmitter.get(_id).push(ParticleEmitterFactory.Instance().create(_id));
    }

    public void emitterTrigger(String _id, float _centerx, float _centery) {
        this._emitterTrigger(_id, _centerx, _centery, Color.White());
    }

    public void emitterTrigger(String _id, float _centerx, float _centery, Color _particleColor) {
        this._emitterTrigger(_id, _centerx, _centery, _particleColor);
    }

    protected void _emitterTrigger(String _id, float _centerx, float _centery, Color _particleColor) {
        FlxEmitter emitter = null;
        if (this.m_poolEmitter.containsKey(_id) && this.m_poolEmitter.get(_id).size() > 0) {
            emitter = this.m_poolEmitter.get(_id).pop();
        }
        if (emitter == null) {
            emitter = ParticleEmitterFactory.Instance().create(_id);
        }
        emitter.particuleColor(_particleColor);
        this.m_activeAutoEmitter.add(emitter);
        this.m_renderingGroup.add(emitter);
        emitter.x = _centerx - emitter.width * 0.5f;
        emitter.y = _centery - emitter.height * 0.5f;
        emitter.start();
    }

    public void stopKaboomEmitter(KaboomParticleEffect _kaboom) {
        this.m_toRemoveKaboom.add(_kaboom);
    }

    public void stopMPartEmitter(RetreiveMaterialParticleEffect _mpart) {
        this.m_toRemoveMPart.add(_mpart);
    }

    public static enum eParticleEmitterType {
        eParticleEmitterType_TntKaboom;

    }
}

