/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM.Particle;

import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.BehaviourParameter;
import SSS.Managers.BTM.Particle.ParticleManager;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.SssGroup;
import java.util.Arrays;
import java.util.Map;
import org.flixel.FlxG;

public class RetreiveMaterialParticleEffect {
    ParticleManager m_manager;
    static Vector2[] InitPosOffsetsFactor = new Vector2[]{new Vector2(-1.0f, -1.0f), new Vector2(1.0f, -1.0f), new Vector2(-1.0f, 1.0f), new Vector2(1.0f, 1.0f)};
    static float TimeMoveMax = 0.25f;
    static final int MaxActors = 4;
    Actor[] m_actors = new Actor[4];
    boolean[] m_finished = new boolean[4];
    float[] m_elapsed = new float[4];
    float[] m_speed = new float[4];
    float[] m_initx = new float[4];
    float[] m_inity = new float[4];
    int m_numActor = 0;
    int[] m_hiddenActorMaterialExraCount = null;
    boolean m_bClampNumMaterial = true;

    public RetreiveMaterialParticleEffect(ParticleManager _manager, boolean _bClampNumMaterial) {
        this.m_manager = _manager;
        int i = 0;
        while (i < 4) {
            this.m_actors[i] = ResourcesLibrary.Instance().InstanciateActor("allblocks", this.m_manager.Level());
            this.m_actors[i].reinitValueBBoxTweakRelated();
            this.m_actors[i].scale(0.45f);
            this.m_actors[i].visible = false;
            ++i;
        }
        this.m_bClampNumMaterial = _bClampNumMaterial;
        if (GameVars.GameCommunityMode()) {
            this.m_hiddenActorMaterialExraCount = new int[Actor.NumCollectableMat()];
        } else {
            this.m_bClampNumMaterial = true;
        }
    }

    public void init(Behaviour _emitter, SssGroup _group) {
        this._init(_emitter, _group);
    }

    protected void _init(Behaviour _emitter, SssGroup _group) {
        Actor.eActorMaterial material = Actor.eActorMaterial.eActorMaterial_Unknown;
        Arrays.fill(this.m_finished, false);
        Arrays.fill(this.m_elapsed, 0.0f);
        Arrays.fill(this.m_speed, 0.0f);
        this.m_numActor = 0;
        int amount = 0;
        float cx = _emitter.Owner().getCenterX();
        float cy = _emitter.Owner().getCenterY();
        if (!this.m_bClampNumMaterial) {
            Arrays.fill(this.m_hiddenActorMaterialExraCount, 0);
        }
        for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : _emitter.IntParamsDictionary().entrySet()) {
            amount = matAmount.getValue().getValue();
            String matName = matAmount.getKey();
            material = matName != null && matName.length() > 0 && Actor.MaterialNameEnumDictionnary.containsKey(matName) ? Actor.MaterialNameEnumDictionnary.get(matName) : Actor.eActorMaterial.eActorMaterial_Unknown;
            if (amount <= 0 || material == Actor.eActorMaterial.eActorMaterial_Unknown) continue;
            int i = 0;
            while (i < amount) {
                if (this.m_numActor < 4) {
                    Actor act = this.m_actors[this.m_numActor];
                    act.Material(material);
                    act.play(matAmount.getKey());
                    act.x = cx + RetreiveMaterialParticleEffect.InitPosOffsetsFactor[this.m_numActor].X * act.width * act.scale() * 0.5f - act.width * 0.5f;
                    act.y = cy + RetreiveMaterialParticleEffect.InitPosOffsetsFactor[this.m_numActor].Y * act.height * act.scale() * 0.5f - act.height * 0.5f;
                    this.m_initx[this.m_numActor] = act.getCenterX();
                    this.m_inity[this.m_numActor] = act.getCenterY();
                    act.visible = true;
                    ++this.m_numActor;
                } else if (!this.m_bClampNumMaterial && material != Actor.eActorMaterial.eActorMaterial_Unknown) {
                    try {
                        int n = material.ordinal() - Actor.FirstCollectableMatIdHACK();
                        this.m_hiddenActorMaterialExraCount[n] = this.m_hiddenActorMaterialExraCount[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.m_numActor) {
            _group.add(this.m_actors[i]);
            ++i;
        }
    }

    public void deinit(SssGroup _group) {
        int i = 0;
        while (i < this.m_numActor) {
            _group.remove(this.m_actors[i]);
            ++i;
        }
    }

    void _updateSingleBloc(int _id) {
        if (!this.m_finished[_id]) {
            Actor act = this.m_actors[_id];
            float playerx = this.m_manager.Level().MainPlayer().getCenterX();
            float playery = this.m_manager.Level().MainPlayer().getCenterY();
            float elapsed = this.m_elapsed[_id];
            float cx = MathHelper.Lerp(this.m_initx[_id], playerx, elapsed / TimeMoveMax);
            float cy = MathHelper.Lerp(this.m_inity[_id], playery, elapsed / TimeMoveMax);
            act.x = cx - act.width * 0.5f;
            act.y = cy - act.height * 0.5f;
            if (elapsed > TimeMoveMax) {
                this.m_finished[_id] = true;
                act.visible = false;
                if (act.Material() != null && act.Material() != Actor.eActorMaterial.eActorMaterial_Unknown) {
                    this.m_manager.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_IncrementMaterialStock, act);
                }
            }
            this.m_elapsed[_id] = elapsed += FlxG.elapsed;
        }
    }

    protected boolean _allFinished() {
        int i = 0;
        while (i < this.m_numActor) {
            if (!this.m_finished[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void update() {
        block5: {
            block4: {
                if (this.m_manager.Level().PuzzleMode()) {
                    return;
                }
                if (!this._allFinished()) break block4;
                this.m_manager.stopMPartEmitter(this);
                if (!GameVars.GameCommunityMode()) break block5;
                int i = 0;
                while (i < this.m_hiddenActorMaterialExraCount.length) {
                    if (this.m_hiddenActorMaterialExraCount[i] > 0) {
                        this.m_manager.Level().MainPlayerBehaviour().increaseDecreaseCollectableIndex(i, true, this.m_hiddenActorMaterialExraCount[i]);
                        this.m_hiddenActorMaterialExraCount[i] = 0;
                    }
                    ++i;
                }
                break block5;
            }
            int i = 0;
            while (i < this.m_numActor) {
                this._updateSingleBloc(i);
                ++i;
            }
        }
    }
}

