/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import Microsoft.Xna.Framework.Vector4;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.BehaviourManager;
import SSS.Level;
import SSS.Managers.BTM.BlocksSoundsManager;
import SSS.Util.Debug;
import SSS.editor.Editor;
import java.util.ArrayList;
import java.util.HashMap;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class ResourcesLibrary {
    protected static ResourcesLibrary m_Instance = null;
    boolean m_bLoaded = false;
    HashMap<String, Integer> m_tabNameIndex;
    HashMap<String, FlxSprite> m_sprites;
    HashMap<String, Actor> m_actorsLib;
    ArrayList<ArrayList<Actor>> m_actors;
    ArrayList<Actor> m_displayedActors;
    protected ArrayList<TabInfo> m_tabs;
    HashMap<String, ArrayList<String>> m_levelSequences = null;
    ArrayList<String> m_levelSequencesName = new ArrayList();

    public ArrayList<TabInfo> Tabs() {
        return this.m_tabs;
    }

    public boolean hasLelevelSequences() {
        return this.m_levelSequences != null && this.m_levelSequences.size() > 0;
    }

    public ArrayList<String> getLevelsSequences() {
        return this.m_levelSequencesName;
    }

    public String getFirstLevelInSequence(String _sequenceName) {
        return this.m_levelSequences.get(_sequenceName).get(0);
    }

    public String getLevelNextToLevel(String _levelName, String _sequenceName, boolean _bPreviousLevel) {
        String res = null;
        ArrayList<String> refListLevel = this.m_levelSequences.get(_sequenceName);
        int i = 0;
        i = 0;
        while (i < refListLevel.size()) {
            if (refListLevel.get(i) == _levelName) break;
            ++i;
        }
        if (i < refListLevel.size()) {
            i = (i += _bPreviousLevel ? -1 : 1) < 0 ? refListLevel.size() + i : (i %= refListLevel.size());
            res = refListLevel.get(i);
        }
        return res;
    }

    public boolean hasLevelsSequence(String _sequenceName) {
        return this.m_levelSequences != null ? this.m_levelSequences.containsKey(_sequenceName) : false;
    }

    public static ResourcesLibrary Instance() {
        if (m_Instance == null) {
            m_Instance = new ResourcesLibrary();
        }
        return m_Instance;
    }

    protected ResourcesLibrary() {
    }

    public boolean DefferedLoadingDone() {
        return FlxG.Content().DefferedLoadingDone();
    }

    public void DefferedTextureLoadingActivate() {
        FlxG.Content().DefferedTextureLoadingActivate();
    }

    public void LoadResources() {
        if (!this.m_bLoaded) {
            this._loadResources();
            this.m_bLoaded = true;
        }
    }

    protected void _loadResources() {
        String resFile = "sss/resource/resources" + GameVars.TileStep();
        Document doc = null;
        try {
            doc = FlxG.Content().LoadXDocument(resFile);
        }
        catch (Exception e) {
            Debug.Assert(false, "Error Loading res file: \n{0}", e.getMessage());
        }
        this._loadGameVars(doc);
        this._loadBlocSounds(doc);
        this.m_levelSequences = new HashMap();
        this._loadLevelSequences(doc);
        this.m_tabNameIndex = new HashMap(10);
        this.m_tabs = new ArrayList(10);
        this._loadTabs(doc);
        this.m_sprites = new HashMap(100);
        this._loadSprites(doc);
        this.m_actorsLib = new HashMap(100);
        this.m_actors = new ArrayList(this.m_tabs.size());
        int i = 0;
        while (i < this.m_tabs.size()) {
            this.m_actors.add(new ArrayList(40));
            ++i;
        }
        this.m_displayedActors = new ArrayList(100);
        this._loadActors(doc);
    }

    protected void _loadBlocSounds(Document doc) {
        Element elemBlocSoundsParams;
        if (doc != null && (elemBlocSoundsParams = (Element)doc.getElementsByTagName("BlocSounds").item(0)) != null) {
            NodeList elemBlocSoundParamsNodeList = elemBlocSoundsParams.getElementsByTagName("BlocSound");
            int elemBlocSoundParamsId = 0;
            while (elemBlocSoundParamsId < elemBlocSoundParamsNodeList.getLength()) {
                Element elemBlocSoundParams = (Element)elemBlocSoundParamsNodeList.item(elemBlocSoundParamsId);
                BlocksSoundsManager.AddSoundToLibrary(elemBlocSoundParams.getAttribute("id"), elemBlocSoundParams.getAttribute("value"));
                ++elemBlocSoundParamsId;
            }
        }
    }

    protected void _loadGameVars(Document doc) {
        Element elemGameParams;
        if (doc != null && (elemGameParams = (Element)doc.getElementsByTagName("GameParams").item(0)) != null) {
            NodeList elemGameParamNodeList = elemGameParams.getElementsByTagName("GameParam");
            int elemGameParamId = 0;
            while (elemGameParamId < elemGameParamNodeList.getLength()) {
                String[] xy;
                String[] rgba;
                String[] rgb;
                Element elemGameParam = (Element)elemGameParamNodeList.item(elemGameParamId);
                String id = elemGameParam.getAttribute("id");
                if (id.equals("BlocManagerTick")) {
                    GameVars.BlocManagerTick(Integer.parseInt(elemGameParam.getAttribute("value")));
                    Debug.Assert(GameVars.BlocManagerTick() > 1);
                } else if (id.equals("TileStep")) {
                    GameVars.TileStep(Integer.parseInt(elemGameParam.getAttribute("value")));
                    Debug.Assert(GameVars.TileStep() > 0);
                } else if (id.equals("UseHologramZone")) {
                    GameVars.UseHologramZone(Integer.parseInt(elemGameParam.getAttribute("value")) > 0);
                } else if (id.equals("NumBlocToMakeAPiece")) {
                    GameVars.BlocCountToFormPiece(Integer.parseInt(elemGameParam.getAttribute("value")));
                    Debug.Assert(GameVars.BlocCountToFormPiece() > 0);
                } else if (id.equals("HologramZoneHeight")) {
                    GameVars.HologramBlocHeight(Integer.parseInt(elemGameParam.getAttribute("value")));
                    Debug.Assert(GameVars.HologramBlocHeight() >= 0);
                } else if (id.equals("PuzzleModeColorStainRGB")) {
                    rgb = elemGameParam.getAttribute("value").split(",");
                    GameVars.PuzzleColorStain(new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2])));
                } else if (id.equals("PuzzleModeColorLineRGB")) {
                    rgb = elemGameParam.getAttribute("value").split(",");
                    GameVars.PuzzleColorLine(new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2])));
                } else if (id.equals("PuzzleModeColorFullscreenGridRGBA")) {
                    rgba = elemGameParam.getAttribute("value").split(",");
                    GameVars.PuzzleModeColorFullscreenGrid(new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]), Integer.parseInt(rgba[3])));
                } else if (id.equals("PuzzleModeColorAroundCursorGridRGBA")) {
                    rgba = elemGameParam.getAttribute("value").split(",");
                    GameVars.PuzzleModeColorAroundCursorGrid(new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]), Integer.parseInt(rgba[3])));
                } else if (id.equals("HudAroundCursor")) {
                    GameVars.UseHudAroundCursor(Integer.parseInt(elemGameParam.getAttribute("value")) > 0);
                } else if (id.equals("HudAroundCursorDistFactorXY")) {
                    xy = elemGameParam.getAttribute("value").split(";");
                    GameVars.HudAroundCursorDistFactorXY(new Vector2(Float.parseFloat(xy[0]), Float.parseFloat(xy[1])));
                } else if (id.equals("CameraPercOffsetXY")) {
                    xy = elemGameParam.getAttribute("value").split(";");
                    GameVars.CameraPercOffsetXY(new Vector2(Float.parseFloat(xy[0]) / 200.0f, Float.parseFloat(xy[1]) / 200.0f));
                    GameVars.CameraPercOffsetXYinit(new Vector2(GameVars.CameraPercOffsetXY()));
                } else if (id.equals("CameraBoundMarginsTBLR")) {
                    String[] tblr = elemGameParam.getAttribute("value").split(";");
                    GameVars.CameraBoundMarginsTBLR(new Vector4(Float.parseFloat(tblr[0]), Float.parseFloat(tblr[1]), Float.parseFloat(tblr[2]), Float.parseFloat(tblr[3])));
                } else if (id.equals("GreenScanSpeed")) {
                    GameVars.GreenScanSpeed(Float.parseFloat(elemGameParam.getAttribute("value")));
                } else if (id.equals("BlueScanShakeAmplitudeDuration")) {
                    String[] ampliDuration = elemGameParam.getAttribute("value").split(";");
                    GameVars.BlueScanShakeAmplitudeDuration(new Vector2(Float.parseFloat(ampliDuration[0]), Float.parseFloat(ampliDuration[1])));
                } else if (id.equals("ChocolateBlockCanBeCollected")) {
                    GameVars.ChocolateBlockCanBeCollected(Integer.parseInt(elemGameParam.getAttribute("value")) > 0);
                } else if (id.equals("ChocolateBlockCanDoLines")) {
                    GameVars.ChocolateBlockCanDoLines(Integer.parseInt(elemGameParam.getAttribute("value")) > 0);
                } else if (id.equals("ChocolateDestroyDelay")) {
                    GameVars.ChocolateDestroyDelay(Float.parseFloat(elemGameParam.getAttribute("value")));
                } else if (id.equals("ChocolatePinkStick")) {
                    GameVars.ChocolatePinkStick(Integer.parseInt(elemGameParam.getAttribute("value")) > 0);
                }
                ++elemGameParamId;
            }
        }
    }

    protected void _loadLevelSequences(Document doc) {
        Element elemLevelSequences;
        if (doc != null && (elemLevelSequences = (Element)doc.getElementsByTagName("LevelSequences").item(0)) != null) {
            NodeList elemLevelSequenceNodeList = elemLevelSequences.getElementsByTagName("LevelSequence");
            int elemLevelSequenceId = 0;
            while (elemLevelSequenceId < elemLevelSequenceNodeList.getLength()) {
                Element elemLevelSequence = (Element)elemLevelSequenceNodeList.item(elemLevelSequenceId);
                String id = elemLevelSequence.getAttribute("id");
                this._loadLevelSequence(elemLevelSequence, id);
                ++elemLevelSequenceId;
            }
        }
    }

    protected void _loadLevelSequence(Element _elemLevelSequence, String _id) {
        if (_elemLevelSequence.hasChildNodes()) {
            ArrayList<String> levelSeq = new ArrayList<String>();
            Element elemLevel = null;
            NodeList elemLevelNodeList = _elemLevelSequence.getElementsByTagName("Level");
            int elemLevelId = 0;
            while (elemLevelId < elemLevelNodeList.getLength()) {
                elemLevel = (Element)elemLevelNodeList.item(elemLevelId);
                String id = elemLevel.getAttribute("id");
                levelSeq.add(id);
                ++elemLevelId;
            }
            if (levelSeq.size() > 0) {
                this.m_levelSequencesName.add(_id);
                this.m_levelSequences.put(_id, levelSeq);
            }
        }
    }

    protected void _loadTabs(Document doc) {
        Element elemEditorTabs;
        if (doc != null && (elemEditorTabs = (Element)doc.getElementsByTagName("EditorTabs").item(0)) != null) {
            int i = 0;
            String layer = "none";
            Element elemEditorTab = null;
            NodeList elemEditorTabNodeList = elemEditorTabs.getElementsByTagName("EditorTab");
            int elemEditorTabId = 0;
            while (elemEditorTabId < elemEditorTabNodeList.getLength()) {
                elemEditorTab = (Element)elemEditorTabNodeList.item(elemEditorTabId);
                String name = elemEditorTab.getAttribute("friendly");
                boolean visible = Boolean.parseBoolean(elemEditorTab.getAttribute("visible"));
                layer = elemEditorTab.getAttribute("linkedLayer");
                this.m_tabs.add(new TabInfo(name, visible, layer));
                this.m_tabNameIndex.put(name, i);
                ++i;
                ++elemEditorTabId;
            }
        }
    }

    protected void _loadSprites(Document doc) {
        if (doc != null) {
            Element elemSprites = (Element)doc.getElementsByTagName("Sprites").item(0);
            String texId = null;
            Element elemSprite = null;
            NodeList elemSpriteNodeList = elemSprites.getElementsByTagName("Sprite");
            int elemSpriteId = 0;
            while (elemSpriteId < elemSpriteNodeList.getLength()) {
                elemSprite = (Element)elemSpriteNodeList.item(elemSpriteId);
                String spriteId = elemSprite.getAttribute("friendly");
                FlxSprite sprite = new FlxSprite();
                texId = elemSprite.getAttribute("id");
                if (texId.length() > 0) {
                    sprite.loadGraphic(FlxG.Content().LoadTexture2D(texId), Boolean.parseBoolean(elemSprite.getAttribute("animated")), false, Integer.parseInt(elemSprite.getAttribute("width")), Integer.parseInt(elemSprite.getAttribute("height")));
                } else {
                    String[] rgb = elemSprite.getAttribute("color").split(",");
                    sprite.createGraphic(Integer.parseInt(elemSprite.getAttribute("width")), Integer.parseInt(elemSprite.getAttribute("height")), new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2])));
                }
                this._loadAnimList(sprite, elemSprite);
                this._loadAnchorList(sprite, elemSprite);
                sprite.scrollFactor = Vector2.Zero();
                this.m_sprites.put(spriteId, sprite);
                ++elemSpriteId;
            }
        }
    }

    protected void _loadActors(Document doc) {
        if (doc != null) {
            Element elemActors = (Element)doc.getElementsByTagName("Actors").item(0);
            Element elemActor = null;
            NodeList elemActorNodeList = elemActors.getElementsByTagName("Actor");
            boolean bPublicActor = true;
            int elemActorId = 0;
            while (elemActorId < elemActorNodeList.getLength()) {
                elemActor = (Element)elemActorNodeList.item(elemActorId);
                String friendly = elemActor.getAttribute("friendly");
                String tabFriendly = elemActor.getAttribute("friendlyEdittab");
                String[] tabsFriendlyList = tabFriendly.split("/");
                String friendlySprite = elemActor.getAttribute("friendlySprite");
                String publicAttrib = elemActor.getAttribute("public");
                Actor actor = new Actor(this.m_sprites.get(friendlySprite));
                this._loadActorInnerElements(actor, elemActor);
                actor.scrollFactor = Vector2.Zero();
                this._scaleActorToFeetLibTab(actor);
                actor.FriendlyName(friendly);
                this.m_actorsLib.put(friendly, actor);
                bPublicActor = publicAttrib != null && publicAttrib.length() > 0 ? Boolean.parseBoolean(publicAttrib) : true;
                if (bPublicActor || MACRO.DEBUG) {
                    String[] stringArray = tabsFriendlyList;
                    int n = tabsFriendlyList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tab = stringArray[n2];
                        this.m_actors.get(this.m_tabNameIndex.get(tab)).add(actor);
                        ++n2;
                    }
                }
                ++elemActorId;
            }
        }
    }

    protected void _scaleActorToFeetLibTab(Actor _actor) {
        float scalew = _actor.width / (float)GameVars.TileStep();
        float scaleh = _actor.height / (float)GameVars.TileStep();
        if (scalew > 1.0f || scaleh > 1.0f) {
            float maxScale = Math.max(scalew, scaleh);
            _actor.scale(1.0f / maxScale);
        }
    }

    protected void _loadActorInnerElements(Actor actor, Element _elemActor) {
        if (_elemActor.hasChildNodes()) {
            this._loadActorComponents(actor, _elemActor);
            this._loadActorBBoxTweak(actor, _elemActor);
            this._loadActorScaleTweak(actor, _elemActor);
        }
    }

    protected void _loadActorBBoxTweak(Actor actor, Element _elemActor) {
        NodeList elems = _elemActor.getElementsByTagName("BBoxTweak");
        if (elems.getLength() > 0) {
            Element elemBBoxTweak = (Element)elems.item(0);
            int width = Integer.parseInt(elemBBoxTweak.getAttribute("width"));
            int height = Integer.parseInt(elemBBoxTweak.getAttribute("height"));
            int offsetx = Integer.parseInt(elemBBoxTweak.getAttribute("offsetx"));
            int offsety = Integer.parseInt(elemBBoxTweak.getAttribute("offsety"));
            actor.tweakBoundingBox(width, height, offsetx, offsety);
        }
    }

    protected void _loadActorScaleTweak(Actor actor, Element _elemActor) {
        NodeList elems = _elemActor.getElementsByTagName("BBoxScale");
        if (elems.getLength() > 0) {
            Element elemBBoxTweak = (Element)elems.item(0);
            actor.tweakScale(Float.parseFloat(elemBBoxTweak.getAttribute("scale")));
        }
    }

    protected void _loadActorComponents(Actor actor, Element _elemActor) {
        NodeList elems = _elemActor.getElementsByTagName("Components");
        if (elems.getLength() > 0) {
            Element elemComponents = (Element)elems.item(0);
            Element elemComponent = null;
            NodeList elemComponentNodeList = elemComponents.getElementsByTagName("Component");
            int elemComponentId = 0;
            while (elemComponentId < elemComponentNodeList.getLength()) {
                elemComponent = (Element)elemComponentNodeList.item(elemComponentId);
                String value = elemComponent.getAttribute("value");
                Behaviour behaviour = BehaviourManager.InstanciateBehaviour(value, actor);
                this._loadBehaviourInnerElements(behaviour, elemComponent);
                ++elemComponentId;
            }
        }
    }

    protected void _loadBehaviourInnerElements(Behaviour _behaviour, Element _elemComponent) {
        NodeList elems = _elemComponent.getElementsByTagName("Params");
        if (elems.getLength() > 0) {
            Element elemParams = (Element)elems.item(0);
            String attribDesc = null;
            Element elemParam = null;
            NodeList elemParamsNodeList = elemParams.getElementsByTagName("Param");
            int elemParamId = 0;
            while (elemParamId < elemParamsNodeList.getLength()) {
                elemParam = (Element)elemParamsNodeList.item(elemParamId);
                String id = elemParam.getAttribute("id");
                String type = elemParam.getAttribute("type");
                String value = elemParam.getAttribute("value");
                attribDesc = elemParam.getAttribute("desc");
                String editableAttrib = elemParam.getAttribute("edit");
                boolean editable = editableAttrib.length() > 0 ? editableAttrib.equals("1") : true;
                _behaviour.addParameter(id, type, value, attribDesc != null ? attribDesc : null, editable);
                ++elemParamId;
            }
        }
    }

    protected void _loadAnchorList(FlxSprite _sprite, Element _elemSprite) {
        Element elemAnchors;
        NodeList elems = _elemSprite.getElementsByTagName("Anchors");
        if (elems.getLength() > 0 && (elemAnchors = (Element)elems.item(0)) != null) {
            Element elemAnchor = null;
            NodeList elemAnchorNodeList = elemAnchors.getElementsByTagName("Anchor");
            int elemAnchorId = 0;
            while (elemAnchorId < elemAnchorNodeList.getLength()) {
                elemAnchor = (Element)elemAnchorNodeList.item(elemAnchorId);
                Vector3[] anchorFrames = this._loadAnchorFramesArray(elemAnchor);
                _sprite.addAnchorAnimation(elemAnchor.getAttribute("id"), anchorFrames);
                ++elemAnchorId;
            }
        }
    }

    protected void _loadAnimList(FlxSprite _sprite, Element _elemSprite) {
        Element elemAnims;
        if (_elemSprite.hasChildNodes() && (elemAnims = (Element)_elemSprite.getElementsByTagName("Anims").item(0)) != null) {
            String defaultAnimId = elemAnims.getAttribute("default");
            Element elemAnim = null;
            NodeList elemAnimNodeList = elemAnims.getElementsByTagName("Anim");
            int elemAnimId = 0;
            while (elemAnimId < elemAnimNodeList.getLength()) {
                String attribFramerate;
                elemAnim = (Element)elemAnimNodeList.item(elemAnimId);
                int[] frames = this._loadFramesArray(elemAnim);
                int frameRate = frames.length > 1 ? Editor.FrameRate() : 0;
                boolean looped = frames.length > 1;
                String attribLoop = elemAnim.getAttribute("loop");
                if (attribLoop != null && attribLoop.length() > 0) {
                    looped = attribLoop.equals("1");
                }
                if ((attribFramerate = elemAnim.getAttribute("frate")) != null && attribFramerate.length() > 0) {
                    frameRate = Integer.parseInt(attribFramerate);
                }
                _sprite.addAnimation(elemAnim.getAttribute("id"), frames, frameRate, looped);
                ++elemAnimId;
            }
            _sprite.play(defaultAnimId);
        }
    }

    protected int[] _loadFramesArray(Element _elemAnim) {
        Element elemFrames;
        if (_elemAnim.hasChildNodes() && (elemFrames = (Element)_elemAnim.getElementsByTagName("Frames").item(0)) != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Element elemFrame = null;
            NodeList elemFrameNodeList = elemFrames.getElementsByTagName("Frame");
            int elemFrameId = 0;
            while (elemFrameId < elemFrameNodeList.getLength()) {
                elemFrame = (Element)elemFrameNodeList.item(elemFrameId);
                list.add(Integer.parseInt(elemFrame.getAttribute("id")));
                ++elemFrameId;
            }
            if (list.size() > 0) {
                return this.buildIntArray(list);
            }
        }
        return new int[1];
    }

    private int[] buildIntArray(ArrayList<Integer> integers) {
        int[] ints = new int[integers.size()];
        int i = 0;
        for (Integer n : integers) {
            ints[i++] = n;
        }
        return ints;
    }

    protected Vector3[] _loadAnchorFramesArray(Element _elemAnchor) {
        Element elemAnchorFrames;
        if (_elemAnchor.hasChildNodes() && (elemAnchorFrames = (Element)_elemAnchor.getElementsByTagName("AnchorFrames").item(0)) != null) {
            int cptErrorCheck = 0;
            Vector3 anchorProps = Vector3.Zero();
            ArrayList<Vector3> list = new ArrayList<Vector3>();
            Element elemFrame = null;
            NodeList elemFrameNodeList = elemAnchorFrames.getElementsByTagName("Frame");
            int elemFrameId = 0;
            while (elemFrameId < elemFrameNodeList.getLength()) {
                elemFrame = (Element)elemFrameNodeList.item(elemFrameId);
                int id = Integer.parseInt(elemFrame.getAttribute("id"));
                Debug.Assert(id == cptErrorCheck);
                ++cptErrorCheck;
                anchorProps.X = Float.parseFloat(elemFrame.getAttribute("xoff"));
                anchorProps.Y = Float.parseFloat(elemFrame.getAttribute("yoff"));
                anchorProps.Z = Float.parseFloat(elemFrame.getAttribute("rot"));
                list.add(anchorProps.clone());
                ++elemFrameId;
            }
            return this.buildVector3Array(list);
        }
        return new Vector3[]{Vector3.Zero()};
    }

    private Vector3[] buildVector3Array(ArrayList<Vector3> vectors) {
        Vector3[] vecs = new Vector3[vectors.size()];
        int i = 0;
        for (Vector3 n : vectors) {
            vecs[i++] = n;
        }
        return vecs;
    }

    public FlxSprite InstanciateSprite(String _friendly) {
        FlxSprite res = new FlxSprite(this.m_sprites.get(_friendly));
        res.scrollFactor = Vector2.One();
        return res;
    }

    public Actor InstanciateActor(String _friendly, Level _level) {
        Actor res = new Actor(this.m_actorsLib.get(_friendly), _level);
        res.scrollFactor = Vector2.One();
        res.FriendlyName(_friendly);
        return res;
    }

    public Actor InstanciateActorSafe(String _friendly, Level _level) {
        if (!this.m_actorsLib.containsKey(_friendly)) {
            return null;
        }
        return this.InstanciateActor(_friendly, _level);
    }

    public Actor GetLibraryActor(String _friendlyName) {
        return this.m_actorsLib.get(_friendlyName);
    }

    public Actor InstanciateLibActor(Level _level, int _indexTab, int _indexCursorPos) {
        Actor res = new Actor(this.m_actors.get(_indexTab).get(_indexCursorPos), _level);
        res.scrollFactor = Vector2.Zero();
        return res;
    }

    public Actor GetTabActor(int _indexTab, int _indexCursorPos) {
        Actor act = this.m_displayedActors.get(_indexCursorPos);
        if (act != null) {
            float offset = 0.0f;
            if (act.x < 0.0f) {
                offset = -act.x;
            } else if (act.x + act.width >= (float)FlxG.width) {
                offset = (float)FlxG.width - act.x - act.width;
            }
            if (offset != 0.0f) {
                for (Actor actor : this.m_displayedActors) {
                    actor.x += offset;
                }
            }
        }
        return act;
    }

    public void PopulateLayer(FlxGroup _group, int _tabIndex, float _startx, float _stepx, float _starty, float _stepy) {
        float x = _startx;
        float y = _starty;
        this.m_displayedActors.clear();
        float scaleCorrection = 1.0f;
        for (Actor actor : this.m_actors.get(_tabIndex)) {
            Actor copy = new Actor(actor, null);
            actor.x = x;
            copy.x = x - (actor.width * 0.5f - actor.width * actor.scale() * 0.5f);
            actor.y = y;
            copy.y = -(actor.height * 0.5f - actor.height * actor.scale() * 0.5f);
            copy.AlwaysVisible(true);
            copy.scale(actor.scale());
            copy.scrollFactor = Vector2.Zero();
            copy.reinitValueBBoxTweakRelated();
            _group.add(copy);
            this.m_displayedActors.add(copy);
            x += _stepx;
            y += _stepy;
        }
    }

    public int GetTabActorNum(int _tabIndex) {
        return this.m_actors.get(_tabIndex).size();
    }

    public class TabInfo {
        String m_name;
        boolean m_bVisible;
        String m_linkedLayer;

        public String Name() {
            return this.m_name;
        }

        public boolean Visible() {
            return this.m_bVisible;
        }

        public String LinkedLayer() {
            return this.m_linkedLayer;
        }

        public TabInfo(String _name, boolean _visible, String _linkedLayer) {
            this.m_name = _name;
            this.m_bVisible = _visible;
            this.m_linkedLayer = _linkedLayer;
        }
    }
}

