/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Content.XDocument;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.MusicManager;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class Save {
    Document m_saveDoc = null;

    public Save() {
        try {
            this.m_saveDoc = XDocument.Instance().createEmptyDocument();
            Element saveElem = this.m_saveDoc.createElement("Save");
            this.m_saveDoc.appendChild(saveElem);
            saveElem.appendChild(this.m_saveDoc.createElement("Player"));
            saveElem.appendChild(this.m_saveDoc.createElement("LevelsGroups"));
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    public void createFromData(String _data) {
        if (_data != null && _data.length() > 0) {
            this.m_saveDoc = XDocument.Parse(_data);
            this._applySaveToGame();
        }
    }

    protected void _applySaveToGame() {
        try {
            LevelDataBase.Instance().reloadLevelUniverse();
            Element root = this.m_saveDoc.getDocumentElement();
            String attrib = root.getAttribute("saveVersion");
            if (attrib != null && attrib.length() > 0) {
                GameVars.GameLoadSaveVersion(Integer.parseInt(attrib));
            }
            if ((attrib = root.getAttribute("saveCheated")) != null && attrib.length() > 0) {
                GameVars.CheatedSave(Integer.parseInt(attrib));
            }
            NodeList elemScreenSettingsNodeList = this.m_saveDoc.getElementsByTagName("ScreenSettings");
            int elemPlayerId = 0;
            while (elemPlayerId < elemScreenSettingsNodeList.getLength()) {
                Element elemScreenSettings = (Element)elemScreenSettingsNodeList.item(elemPlayerId);
                attrib = elemScreenSettings.getAttribute("saturation");
                if (attrib != null) {
                    FlxG.RenderingSaturation(Float.parseFloat(attrib));
                }
                if ((attrib = elemScreenSettings.getAttribute("brightness")) != null) {
                    FlxG.RenderingBrightness(Float.parseFloat(attrib));
                }
                if ((attrib = elemScreenSettings.getAttribute("contrast")) != null) {
                    FlxG.RenderingContrast(Float.parseFloat(attrib));
                }
                if ((attrib = elemScreenSettings.getAttribute("rBalance")) != null) {
                    FlxG.RenderingRedBalance(Float.parseFloat(attrib));
                }
                if ((attrib = elemScreenSettings.getAttribute("gBalance")) != null) {
                    FlxG.RenderingGreenBalance(Float.parseFloat(attrib));
                }
                if ((attrib = elemScreenSettings.getAttribute("bBalance")) != null) {
                    FlxG.RenderingBlueBalance(Float.parseFloat(attrib));
                }
                if ((attrib = elemScreenSettings.getAttribute("volume")) != null) {
                    MusicManager.Instance().setVolumeAutoClamped(Float.parseFloat(attrib));
                }
                ++elemPlayerId;
            }
            NodeList elemPlayerNodeList = this.m_saveDoc.getElementsByTagName("Player");
            int elemPlayerId2 = 0;
            while (elemPlayerId2 < elemPlayerNodeList.getLength()) {
                Element elemPlayer = (Element)elemPlayerNodeList.item(elemPlayerId2);
                attrib = elemPlayer.getAttribute("canDoPuzzle");
                if (attrib != null) {
                    GameVars.PlayerCanDoPuzzle(Integer.parseInt(attrib));
                }
                if ((attrib = elemPlayer.getAttribute("canDoLines")) != null) {
                    GameVars.PlayerCanDoLines(Integer.parseInt(attrib));
                }
                if ((attrib = elemPlayer.getAttribute("drillLevel")) != null) {
                    GameVars.MaxDrillableMatId(Integer.parseInt(attrib));
                }
                ++elemPlayerId2;
            }
            NodeList elemLevelsGroupsNodeList = this.m_saveDoc.getElementsByTagName("LevelsGroups");
            int elemLevelsGroupsId = 0;
            while (elemLevelsGroupsId < elemLevelsGroupsNodeList.getLength()) {
                Element elemLevelsGroups = (Element)elemLevelsGroupsNodeList.item(elemLevelsGroupsId);
                NodeList elemLevelsGroupNodeList = elemLevelsGroups.getElementsByTagName("LevelsGroup");
                int elemLevelsGroupId = 0;
                while (elemLevelsGroupId < elemLevelsGroupNodeList.getLength()) {
                    Element elemLevelsGroup = (Element)elemLevelsGroupNodeList.item(elemLevelsGroupId);
                    String groupId = elemLevelsGroup.getAttribute("id");
                    NodeList elemLevelNodeList = elemLevelsGroup.getElementsByTagName("Level");
                    int elemLevelId = 0;
                    while (elemLevelId < elemLevelNodeList.getLength()) {
                        Element elemLevel = (Element)elemLevelNodeList.item(elemLevelId);
                        attrib = elemLevel.getAttribute("opened");
                        boolean bOpened = attrib != null ? !attrib.equals("0") : false;
                        attrib = elemLevel.getAttribute("done");
                        boolean bDone = attrib != null ? !attrib.equals("0") : false;
                        int par = Integer.parseInt(elemLevel.getAttribute("par"));
                        if (GameVars.GameLoadSaveVersion() < 2) {
                            par = 0;
                        }
                        LevelDataBase.Instance().updateLevelStats(groupId, elemLevel.getAttribute("id"), !elemLevel.getAttribute("btm").equals("0"), par, bOpened, bDone);
                        ++elemLevelId;
                    }
                    ++elemLevelsGroupId;
                }
                ++elemLevelsGroupsId;
            }
            this._PathSaveFromErrors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void _PathSaveFromErrors() {
        LevelGroup lvlGroup = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_AVENTURE_NAME);
        if (lvlGroup != null) {
            int done = lvlGroup.getLevelDoneNumber();
            if (done >= 1) {
                if (GameVars.PlayerCanDoPuzzle() < 1) {
                    GameVars.PlayerCanDoPuzzle(1);
                }
                if (GameVars.MaxDrillableMatId() < Actor.UpdateDrillStep01.ordinal()) {
                    GameVars.MaxDrillableMatId(Actor.UpdateDrillStep01.ordinal());
                }
            }
            if (done >= 8 && GameVars.PlayerCanDoLines() < 1) {
                GameVars.PlayerCanDoLines(1);
            }
            if (done >= 19 && GameVars.MaxDrillableMatId() < Actor.UpdateDrillStep02.ordinal()) {
                GameVars.MaxDrillableMatId(Actor.UpdateDrillStep02.ordinal());
            }
            if (done >= 33 && GameVars.MaxDrillableMatId() < Actor.UpdateDrillStep03.ordinal()) {
                GameVars.MaxDrillableMatId(Actor.UpdateDrillStep03.ordinal());
            }
        }
    }

    public void createFromLevelDataBase() {
        this.m_saveDoc = XDocument.Instance().createEmptyDocument();
        Element screenSettingsElem = this.m_saveDoc.createElement("ScreenSettings");
        screenSettingsElem.setAttribute("screensize", Float.toString(FlxG.RenderingScale()));
        screenSettingsElem.setAttribute("saturation", Float.toString(FlxG.RenderingSaturation()));
        screenSettingsElem.setAttribute("brightness", Float.toString(FlxG.RenderingBrightness()));
        screenSettingsElem.setAttribute("contrast", Float.toString(FlxG.RenderingContrast()));
        screenSettingsElem.setAttribute("rBalance", Float.toString(FlxG.RenderingRedBalance()));
        screenSettingsElem.setAttribute("gBalance", Float.toString(FlxG.RenderingGreenBalance()));
        screenSettingsElem.setAttribute("bBalance", Float.toString(FlxG.RenderingBlueBalance()));
        screenSettingsElem.setAttribute("volume", Float.toString(MusicManager.Instance().GeneralVolume()));
        Element playerElem = this.m_saveDoc.createElement("Player");
        if (GameVars.AvoidSavePlayerProperties()) {
            playerElem.setAttribute("canDoPuzzle", Integer.toString(GameVars.PlayerCanDoPuzzleToSave()));
            playerElem.setAttribute("drillLevel", Integer.toString(GameVars.MaxDrillableMatIdToSave()));
            playerElem.setAttribute("canDoLines", Integer.toString(GameVars.PlayerCanDoLinesToSave()));
        } else {
            playerElem.setAttribute("canDoPuzzle", Integer.toString(GameVars.PlayerCanDoPuzzle()));
            playerElem.setAttribute("drillLevel", Integer.toString(GameVars.MaxDrillableMatId()));
            playerElem.setAttribute("canDoLines", Integer.toString(GameVars.PlayerCanDoLines()));
        }
        Element levelsGroupsElem = this.m_saveDoc.createElement("LevelsGroups");
        ArrayList<LevelGroup> levelsGroups = LevelDataBase.Instance().LevelsGroups();
        for (LevelGroup lg : levelsGroups) {
            Element elemLevelsGroup = this.m_saveDoc.createElement("LevelsGroup");
            elemLevelsGroup.setAttribute("id", lg.Id());
            ArrayList<LevelInfo> levelInfos = lg.LevelInfos();
            for (LevelInfo li : levelInfos) {
                if (!li.Unlocked()) continue;
                Element levelElem = this.m_saveDoc.createElement("Level");
                levelElem.setAttribute("id", li.TargetLevelFile());
                levelElem.setAttribute("par", Integer.toString(li.ParBestValue()));
                levelElem.setAttribute("btm", li.BTMFound() ? "1" : "0");
                levelElem.setAttribute("opened", li.Opened() ? "1" : "0");
                levelElem.setAttribute("done", li.Done() ? "1" : "0");
                elemLevelsGroup.appendChild(levelElem);
            }
            levelsGroupsElem.appendChild(elemLevelsGroup);
        }
        Element saveElem = this.m_saveDoc.createElement("Save");
        saveElem.setAttribute("saveVersion", Integer.toString(GameVars.GameSaveVersion()));
        saveElem.setAttribute("saveCheated", Integer.toString(GameVars.CheatedSave()));
        saveElem.appendChild(screenSettingsElem);
        saveElem.appendChild(playerElem);
        saveElem.appendChild(levelsGroupsElem);
        this.m_saveDoc.appendChild(saveElem);
    }

    public String getSaveContent() {
        return XDocument.Instance().getStringContentFromDoc(this.m_saveDoc);
    }
}

