/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Storage.StorageContainer;
import Microsoft.Xna.Framework.Storage.StorageDevice;
import SSS.API.GameAPIManager;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.Save;
import SSS.Managers.FileManager;
import SSS.Managers.LoginManager;
import SSS.Managers.MusicManager;
import SSS.Util.Utility;
import System.IAsyncResult;
import System.IO.FileMode;
import System.IO.Stream;
import org.flixel.FlxG;
import precompiler.MACRO;

public class SaveManager {
    StorageDevice m_storageDevice = null;
    boolean m_bSavingInProgress = false;
    Save m_save = new Save();
    Thread m_thread = null;
    IAsyncResult m_result = null;
    FileManager m_encryptMgr = null;
    CallbackSimple m_callBackSaveDone = null;
    CallbackSimple m_callBackLoadDone = null;
    boolean m_bSaveSession = false;
    protected static SaveManager m_Instance = null;
    static final float Gigabyte = 1.0E9f;

    public static SaveManager Instance() {
        if (m_Instance == null) {
            m_Instance = new SaveManager();
        }
        return m_Instance;
    }

    protected SaveManager() {
        if (MACRO.USE_ENCRYPTED_SAVE) {
            this.m_encryptMgr = FileManager.Instance();
        }
    }

    public void loadGameDataNotThreaded() {
        this._loadGameData();
    }

    public void loadGameDataThreaded(CallbackSimple loadComplete, boolean saveSession) {
        this.m_callBackLoadDone = loadComplete;
        this.m_bSaveSession = saveSession;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (SaveManager.this.m_bSaveSession) {
                    SaveManager.this.saveLastUserName();
                }
                SaveManager.this.loadGameDataNotThreaded();
                if (SaveManager.this.m_callBackLoadDone != null) {
                    CallbackSimple toCall = SaveManager.this.m_callBackLoadDone;
                    SaveManager.this.m_callBackLoadDone = null;
                    toCall.onCallback(this, null);
                }
            }
        };
        this.m_thread = new Thread(r);
        this.m_thread.start();
    }

    protected void _checkStorageDevice() {
        int maxTry = 3;
        if (this.m_storageDevice == null || !this.m_storageDevice.IsConnected()) {
            int i = 0;
            while (i < maxTry) {
                this.m_storageDevice = this._getStorageDevice();
                if (this.m_storageDevice != null) {
                    return;
                }
                ++i;
            }
        }
    }

    public void deleteGameData() {
        this._checkStorageDevice();
        if (this.m_storageDevice != null && this.m_storageDevice.IsConnected()) {
            this._deleteData("Blocks That Matter Save", this.m_storageDevice, "BTMsave");
        }
    }

    public boolean isStorageModeExists() {
        return this.m_storageDevice != null && this.m_storageDevice.IsConnected();
    }

    public boolean isStorageModeLookLikeHDD() {
        if (this.m_storageDevice != null && this.m_storageDevice.IsConnected()) {
            try {
                if (this.m_storageDevice.TotalSpace() > 1.0E9f) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void resetGameData() {
        if (!this.m_bSavingInProgress) {
            LevelDataBase.Instance().reloadLevelUniverse();
            GameVars.ResetPlayerGameVars();
            FlxG.ResetRenderingParams();
            MusicManager.Instance().defaultVolume();
            this.threadDelegateSave();
        }
    }

    public void saveGameDataThreaded(CallbackSimple saveComplete) {
        this.m_callBackSaveDone = saveComplete;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SaveManager.this.threadDelegateSave();
            }
        };
        this.m_thread = new Thread(r);
        this.m_thread.start();
    }

    protected void threadDelegateSave() {
        if (!this.m_bSavingInProgress) {
            this.m_bSavingInProgress = true;
            this._saveGameData();
            this.m_bSavingInProgress = false;
        }
        if (this.m_callBackSaveDone != null) {
            CallbackSimple toCall = this.m_callBackSaveDone;
            this.m_callBackSaveDone = null;
            toCall.onCallback(this, null);
        }
    }

    protected void _endsThread() {
        try {
            this.m_thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.m_thread = null;
    }

    protected void _loadGameData() {
        this._checkStorageDevice();
        if (this.m_storageDevice != null && this.m_storageDevice.IsConnected()) {
            String value = this._loadData("Blocks That Matter Save", this.m_storageDevice, "BTMsave", -1);
            if (value != null) {
                this.m_save.createFromData(value);
            } else {
                this.resetGameData();
            }
        } else if (this.m_storageDevice == null) {
            this._showNoLoadMessageBox();
        }
    }

    public String getSaveContent(int _slotOrNegForCurrentSlot) {
        return this._loadData("Blocks That Matter Save", this.m_storageDevice, "BTMsave", _slotOrNegForCurrentSlot);
    }

    public void recoverLastUserName() {
        this._checkStorageDevice();
        String content = this._loadDataRaw("Blocks That Matter Save", this.m_storageDevice, "LastSession");
        if (content != null) {
            LoginManager.Instance().setLastSessionInfos(content);
        }
    }

    public void saveLastUserName() {
        this._checkStorageDevice();
        this._saveDataRaw("Blocks That Matter Save", LoginManager.Instance().getLastSessionInfos(), this.m_storageDevice, "LastSession");
        GameAPIManager.GameAPI().CloudFileWrite("LastSession", LoginManager.Instance().getLastSessionInfos().getBytes());
    }

    protected void _showNoLoadMessageBox() {
    }

    protected void _showSignInGuide() {
        Utility.ShowSignInGuideIfneeded();
    }

    protected void _saveGameData() {
        if (!Utility.GuideIsVisible()) {
            this._checkStorageDevice();
            if (this.m_storageDevice != null && this.m_storageDevice.IsConnected()) {
                this.m_save.createFromLevelDataBase();
                String content = this.m_save.getSaveContent();
                this._saveData("Blocks That Matter Save", content, this.m_storageDevice, "BTMsave");
            }
        }
    }

    protected StorageDevice _getStorageDevice() {
        StorageDevice device = null;
        try {
            this.m_result = StorageDevice.BeginShowSelector(null, null);
            while (!this.m_result.IsCompleted()) {
            }
            device = StorageDevice.EndShowSelector(this.m_result);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return device;
    }

    protected void _saveData(String _friendlyName, String _saveContent, StorageDevice device, String _saveName) {
        StorageContainer container = this._getStorageContainer(_friendlyName, device);
        if (container == null) {
            return;
        }
        try {
            String filename = this._buildSavefileName(_saveName, container, -1);
            if (container.FileExists(filename)) {
                container.DeleteFile(filename);
            }
            Stream file = container.CreateFile(filename);
            byte[] byteArray = this.ConvertStringToBytes(_saveContent, MACRO.USE_ENCRYPTED_SAVE);
            file.Write(byteArray, 0, byteArray.length);
            file.Close();
            if (!GameAPIManager.GameAPI().CloudFileWrite(filename, byteArray)) {
                System.out.println("Cloud save writting failed");
                int availableInCloud = GameAPIManager.GameAPI().GetCloudAvailableSpace();
                int currentSaveLen = byteArray.length;
                if (availableInCloud < currentSaveLen) {
                    System.out.println("Not enough space available in Cloud! (available: " + availableInCloud + ", requested: " + currentSaveLen + ")");
                }
            }
            container.Dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void _saveDataRaw(String _friendlyName, String _saveContent, StorageDevice device, String _saveName) {
        StorageContainer container = this._getStorageContainer(_friendlyName, device);
        if (container == null) {
            return;
        }
        try {
            String filename = _saveName;
            if (container.FileExists(filename)) {
                container.DeleteFile(filename);
            }
            Stream file = container.CreateFile(filename);
            byte[] byteArray = this.ConvertStringToBytes(_saveContent, false);
            file.Write(byteArray, 0, byteArray.length);
            file.Close();
            container.Dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String _buildSavefileName(String _loadName, StorageContainer container, int _slotOrNegForCurrentSlot) {
        String filename = String.valueOf(_loadName) + ".sav";
        if (MACRO.USE_LOGIN_AND_SLOT) {
            String slotName = _slotOrNegForCurrentSlot < 0 ? LoginManager.Instance().currentSlotName() : LoginManager.Instance().getSlotName(_slotOrNegForCurrentSlot);
            container.CreateDirectory(slotName);
            filename = String.valueOf(slotName) + "/" + filename;
        }
        if (MACRO.USE_ENCRYPTED_SAVE) {
            filename = String.valueOf(filename) + ".dat";
        }
        return filename;
    }

    StorageContainer _getStorageContainer(String _friendlyName, StorageDevice device) {
        IAsyncResult result = null;
        try {
            result = device.BeginOpenContainer(_friendlyName, null, null);
        }
        catch (Exception e) {
            return null;
        }
        try {
            result.AsyncWaitHandle().WaitOne();
        }
        catch (Exception e) {
            // empty catch block
        }
        StorageContainer container = null;
        try {
            container = device.EndOpenContainer(result);
        }
        catch (Exception e) {
            return null;
        }
        if (result != null) {
            result.AsyncWaitHandle().Close();
        }
        return container;
    }

    String _loadDataRaw(String _friendlyName, StorageDevice device, String _loadName) {
        String loadContent = null;
        StorageContainer container = this._getStorageContainer(_friendlyName, device);
        if (container == null) {
            return null;
        }
        String filename = _loadName;
        if (container.FileExists(filename)) {
            Stream file = container.OpenFile(filename, FileMode.Open);
            byte[] byteArray = new byte[file.length()];
            file.Read(byteArray, 0, byteArray.length);
            file.Close();
            loadContent = this.ConvertBytesToString(byteArray, false);
        }
        container.Dispose();
        return loadContent;
    }

    String _loadData(String _friendlyName, StorageDevice device, String _loadName, int _slotOrNegForCurrentSlot) {
        String loadContent = null;
        StorageContainer container = this._getStorageContainer(_friendlyName, device);
        if (container == null) {
            return null;
        }
        String filename = this._buildSavefileName(_loadName, container, _slotOrNegForCurrentSlot);
        if (container.FileExists(filename)) {
            Stream file = container.OpenFile(filename, FileMode.Open);
            byte[] byteArray = new byte[file.length()];
            file.Read(byteArray, 0, byteArray.length);
            file.Close();
            loadContent = this.ConvertBytesToString(byteArray, MACRO.USE_ENCRYPTED_SAVE);
        }
        container.Dispose();
        return loadContent;
    }

    protected void _deleteData(String _friendlyName, StorageDevice device, String _loadName) {
        StorageContainer container = this._getStorageContainer(_friendlyName, device);
        if (container == null) {
            return;
        }
        String filename = this._buildSavefileName(_loadName, container, -1);
        if (container.FileExists(filename)) {
            container.DeleteFile(filename);
        }
    }

    protected byte[] ConvertStringToBytes(String input, boolean encrypt) {
        if (encrypt) {
            return this.m_encryptMgr.encrypt(input);
        }
        return input.getBytes();
    }

    protected String ConvertBytesToString(byte[] bytes, boolean decrypt) {
        if (decrypt) {
            return this.m_encryptMgr.decrypt(bytes);
        }
        return new String(bytes);
    }
}

