/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import SSS.Actor;
import SSS.Behaviours.BTM.BlocSwitchBehaviour;
import SSS.Behaviours.BTM.DoorBehaviour;
import SSS.Level;
import java.util.ArrayList;

public class SwitchObserver {
    Level m_level = null;
    protected ArrayList<BlocSwitchBehaviour> m_switches = null;
    protected ArrayList<DoorBehaviour> m_doors = null;

    public SwitchObserver(Level _level) {
        this.m_level = _level;
        this.m_doors = new ArrayList(20);
        this.m_switches = new ArrayList(30);
    }

    public void addSwitch(BlocSwitchBehaviour _switchBehaviour) {
        this.m_switches.add(_switchBehaviour);
    }

    public void addDoor(DoorBehaviour _switchBehaviour) {
        this.m_doors.add(_switchBehaviour);
    }

    public boolean allDoorOpen() {
        if (this.m_doors == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_doors.size()) {
            if (this.m_doors.get(i).State() != DoorBehaviour.eDoorState.eSwitchState_Open) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void propagateMessageToDoor(Actor _sender, String _doorId, Actor.eGenericMessage _message) {
        for (DoorBehaviour door : this.m_doors) {
            if (!door.DoorId().equals(_doorId)) continue;
            door.handleGenericMessage(_message, _sender);
        }
    }

    public void initializeDoorsAndSwitches() {
        if (this.m_switches.size() > 0) {
            for (BlocSwitchBehaviour sw : this.m_switches) {
                this.propagateMessageToDoor(sw.Owner(), sw.TargetDoorId(), Actor.eGenericMessage.eGenericMessage_SwitchCountIncrease);
            }
        }
        if (this.m_doors.size() > 0) {
            for (DoorBehaviour door : this.m_doors) {
                door.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DoorBaseInit, door.Owner());
            }
        }
    }
}

