/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers.BTM;

import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import SSS.BTM.GameVars;
import SSS.Managers.BTM.Text.TextDataBaseItem;
import SSS.Util.Debug;
import SSS.Util.InputManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.flixel.FlxG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class TextDataBase {
    static ArrayList<String> AcceptedLangageId = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("en");
            this.add("fr");
            this.add("de");
            this.add("es");
            this.add("it");
            this.add("ru");
            this.add("jp");
        }
    };
    String m_langageId = "en";
    String DefaultLanguage = "en";
    HashMap<String, TextDataBaseItem> m_textDataBase = new HashMap(200);
    boolean m_bLoaded = false;
    protected static TextDataBase m_Instance = null;

    public void LangageId(String value, boolean tryToGuess) {
        String guess;
        if (tryToGuess && AcceptedLangageId.contains(guess = this.guessLanguage())) {
            this.m_langageId = guess;
            return;
        }
        if (AcceptedLangageId.contains(value)) {
            this.m_langageId = value;
        } else {
            if (MACRO.DIALOG_VIEWER || MACRO.LOCALISATION_TESTER) {
                AcceptedLangageId.add(value);
            }
            this.m_langageId = this.DefaultLanguage;
        }
    }

    public String LangageId() {
        return this.m_langageId;
    }

    public static TextDataBase Instance() {
        if (m_Instance == null) {
            m_Instance = new TextDataBase();
        }
        return m_Instance;
    }

    protected TextDataBase() {
    }

    private String guessLanguage() {
        return System.getProperty("user.language");
    }

    public String getTextSafe(String _id) {
        if (this.m_textDataBase.containsKey(_id)) {
            return this.m_textDataBase.get(_id).getText();
        }
        return null;
    }

    public String getText(String _id) {
        if (GameVars.GameCommunityMode()) {
            if (this.m_textDataBase.containsKey(_id)) {
                return this.m_textDataBase.get(_id).getText();
            }
            return _id;
        }
        if ((MACRO.DIALOG_VIEWER || MACRO.LOCALISATION_TESTER) && !this.m_textDataBase.containsKey(_id)) {
            return "NO ID TEXT FOUND for: " + _id;
        }
        return this.m_textDataBase.get(_id).getText();
    }

    public void reload() {
        if (this.m_bLoaded) {
            this._unload();
        }
        this._load();
    }

    protected void _unload() {
        this.m_textDataBase.clear();
        this.m_bLoaded = false;
    }

    public void load() {
        if (!this.m_bLoaded) {
            this._load();
            this.m_bLoaded = true;
        }
    }

    protected void _load() {
        Document doc = null;
        try {
            doc = MACRO.DIALOG_VIEWER || MACRO.LOCALISATION_TESTER ? FlxG.Content().LoadXDocumentOutOfContent("DialogViewerData/Texts") : FlxG.Content().LoadXDocument("sss/metainfos/Texts");
        }
        catch (Exception e) {
            Debug.Assert(false, String.format("Error Loading textDatabase file: \n{0}", e.getMessage()));
        }
        if (doc != null) {
            this._populateDatabase(doc, this.LangageId());
        }
    }

    protected void _populateDatabase(Document _doc, String _languageId) {
        String defaultLanguageId = "en";
        String universalLanguageId = "univ";
        Element elemTxts = null;
        NodeList elemTxtsNodeList = null;
        Element elemTxt = null;
        NodeList elemTxtNodeList = null;
        NodeList langNodeList = null;
        Element elemLocalisedText = null;
        elemTxtsNodeList = _doc.getElementsByTagName("Texts");
        String buttonDefAttrib = null;
        int elemTxtsId = 0;
        while (elemTxtsId < elemTxtsNodeList.getLength()) {
            elemTxts = (Element)elemTxtsNodeList.item(elemTxtsId);
            elemTxtNodeList = elemTxts.getElementsByTagName("Text");
            int elemTxtId = 0;
            while (elemTxtId < elemTxtNodeList.getLength()) {
                elemTxt = (Element)elemTxtNodeList.item(elemTxtId);
                langNodeList = elemTxt.getElementsByTagName(_languageId);
                if (langNodeList == null || langNodeList.getLength() == 0) {
                    langNodeList = elemTxt.getElementsByTagName("univ");
                }
                if (langNodeList == null || langNodeList.getLength() == 0) {
                    langNodeList = elemTxt.getElementsByTagName("en");
                }
                elemLocalisedText = (Element)langNodeList.item(0);
                String id = elemTxt.getAttribute("id");
                buttonDefAttrib = elemTxt.getAttribute("buttonDef");
                this.m_textDataBase.put(id, new TextDataBaseItem(elemLocalisedText.getAttribute("value"), buttonDefAttrib != null && buttonDefAttrib.length() > 0 ? !buttonDefAttrib.equals("0") : false));
                ++elemTxtId;
            }
            ++elemTxtsId;
        }
    }

    public String getFriendlyButtonName(Buttons _button, boolean _bUseBracket) {
        return InputManager.GetFriendlyButtonName(_button, _bUseBracket);
    }

    public String getFriendlyKeyName(Keys _key, boolean _bUseBraket) {
        return InputManager.GetFriendlyKeyName(_key, _bUseBraket);
    }

    public boolean ChangeLangageId(String _newLanguageId) {
        if (this.m_langageId.equals(_newLanguageId)) {
            return false;
        }
        this.LangageId(_newLanguageId, false);
        try {
            Document doc = FlxG.Content().LoadXDocumentOutOfContent("config/DisplayOptions");
            NodeList langNodeList = doc.getElementsByTagName("language");
            if (langNodeList != null && langNodeList.getLength() > 0) {
                Element langElem = (Element)langNodeList.item(0);
                langElem.setAttribute("value", _newLanguageId);
                langElem.setAttribute("guess", "0");
                FlxG.Content().WriteXDocumentOutOfContent("config/DisplayOptions", doc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._load();
        return true;
    }
}

