/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers;

import SSS.Util.HTMLEncode;
import SSS.Util.LevelItem;
import SSS.Util.LevelItemAttribs;
import SSS.Util.LevelItemDateComparator;
import SSS.Util.LevelItemThumbs;
import SSS.Util.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import precompiler.MACRO;

public class FileManager {
    static FileManager m_Instance = null;
    String password = "save_password";
    byte[] salt = new byte[]{-55, -111, -8, -43, 40, 69, 6, -121};
    PBEKeySpec keySpec;
    SecretKeyFactory keyFactory;
    SecretKey passwordKey;
    Cipher cipherEncryptor;
    Cipher cipherDecryptor;
    boolean m_bInitialized = false;
    FTPClient m_ftpClient = null;
    String m_FTPFolder = MACRO.TECH_DEMO ? "" : (MACRO.DEBUG && MACRO.DEBUG_COMMUNITY ? "DBG/" : "Full/");
    Deflater m_compresser;
    byte[] m_tmpOutputCompress = null;
    Inflater m_decompresser;
    byte[] m_tmpOutputDecompress = null;
    File m_rootGameDir = null;
    File m_rootFile = new File(".");
    String m_rootFilePath = null;

    public String getRootHomePath() {
        return this.m_rootFilePath;
    }

    protected FileManager() {
        this.m_rootGameDir = new File(".");
        this.m_rootFilePath = String.valueOf(this.m_rootFile.getAbsolutePath()) + "/";
        this.m_compresser = new Deflater();
        this.m_tmpOutputCompress = new byte[2048];
        this.m_decompresser = new Inflater();
        this.m_tmpOutputDecompress = new byte[4046];
        if (!MACRO.TECH_DEMO) {
            this.password = "real_game_pswd";
        }
        try {
            this.keySpec = new PBEKeySpec(this.password.toCharArray());
            this.keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            this.passwordKey = this.keyFactory.generateSecret(this.keySpec);
            this.cipherEncryptor = Cipher.getInstance("PBEWithMD5AndDES");
            this.cipherDecryptor = Cipher.getInstance("PBEWithMD5AndDES");
            PBEParameterSpec parameterSpec = new PBEParameterSpec(this.salt, 1);
            this.cipherEncryptor.init(1, (Key)this.passwordKey, parameterSpec);
            this.cipherDecryptor.init(2, (Key)this.passwordKey, parameterSpec);
            this.m_bInitialized = true;
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            this.m_bInitialized = false;
        }
    }

    public void changeSaveFileFromLocalToHomeDir() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File homeDir = fsv.getDefaultDirectory();
        String home = null;
        if (homeDir.exists() && homeDir.isDirectory()) {
            try {
                home = homeDir.getCanonicalPath();
            }
            catch (IOException e) {
                home = homeDir.getAbsolutePath();
            }
            home = String.valueOf(home) + "/" + MACRO.ROOT_DATA_GAME_DIR_NAME;
            this.m_rootFile = new File(home);
            if (!this.m_rootFile.exists()) {
                this.m_rootFile.mkdir();
            }
        }
        this.m_rootGameDir = new File(".");
        this.m_rootFilePath = String.valueOf(this.m_rootFile.getAbsolutePath()) + "/";
        System.out.println("Game will save your datas in: " + this.m_rootFilePath);
    }

    public void openUrl(String _url) {
        Runtime runtime = Runtime.getRuntime();
        try {
            switch (Utility.GetOsType()) {
                case Linux: {
                    String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String browser = null;
                    int count = 0;
                    while (count < browsers.length && browser == null) {
                        if (runtime.exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                            browser = browsers[count];
                        }
                        ++count;
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    runtime.exec(new String[]{browser, _url});
                    break;
                }
                case Windows: {
                    String cmd = "rundll32 url.dll,FileProtocolHandler " + _url;
                    runtime.exec(cmd);
                    break;
                }
                case OSX: {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, _url);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error while invoking Browser!");
            e.printStackTrace();
        }
    }

    public static FileManager Instance() {
        if (m_Instance == null) {
            m_Instance = new FileManager();
        }
        return m_Instance;
    }

    public void checkHomeFolderPresence(String _folder) {
        File dest;
        if (MACRO.USE_EXTERNAL_GAMEDATA_FOLDER && !(dest = new File(this.m_rootFile, _folder)).exists()) {
            dest.mkdir();
            File source = new File(this.m_rootGameDir, _folder);
            if (source.exists()) {
                try {
                    this.copyDirectory(source, dest);
                }
                catch (Exception e) {
                    System.out.println("ERROR trying to build home folder files");
                }
            }
        }
    }

    public boolean duplicateDirectory(String srcLocalPath, String dstLocalPath, boolean _bOnlyDuplicateIfDstNotExists) {
        File dstPath = new File(this.m_rootFile, dstLocalPath);
        if (_bOnlyDuplicateIfDstNotExists && dstPath.exists()) {
            return false;
        }
        File srcPath = new File(this.m_rootFile, srcLocalPath);
        try {
            this.copyDirectory(srcPath, dstPath);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean renameFileOrFolder(String oldName, String newName) {
        File file = new File(this.m_rootFile, oldName);
        File file2 = new File(this.m_rootFile, newName);
        boolean success = file.renameTo(file2);
        return success;
    }

    public boolean renameHome(String oldName, String newName) {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File homeDir = fsv.getDefaultDirectory();
        String homeNew = null;
        String homeOld = null;
        if (homeDir.exists() && homeDir.isDirectory()) {
            try {
                homeNew = homeOld = homeDir.getCanonicalPath();
            }
            catch (IOException e) {
                homeNew = homeOld = homeDir.getAbsolutePath();
            }
            homeNew = String.valueOf(homeNew) + "/" + MACRO.ROOT_DATA_GAME_DIR_NAME;
            homeOld = String.valueOf(homeOld) + "/" + MACRO.ROOT_DATA_GAME_DIR_NAME_OLD;
            File homeOldFile = new File(homeOld);
            if (homeOldFile.exists() && homeOldFile.isDirectory()) {
                File homeNewFile = new File(homeNew);
                return homeOldFile.renameTo(homeNewFile);
            }
        }
        return false;
    }

    public void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            int i = 0;
            while (i < files.length) {
                this.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                ++i;
            }
        } else if (srcPath.exists()) {
            int len;
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(dstPath);
            while ((len = ((InputStream)in).read(this.m_tmpOutputDecompress)) > 0) {
                ((OutputStream)out).write(this.m_tmpOutputDecompress, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public byte[] encrypt(String input) {
        try {
            return this.cipherEncryptor.doFinal(input.getBytes());
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public byte[] encryptByte(byte[] input) {
        try {
            return this.cipherEncryptor.doFinal(input);
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String decrypt(byte[] bytes) {
        try {
            return new String(this.cipherDecryptor.doFinal(bytes));
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public byte[] decryptByte(byte[] bytes) {
        try {
            return this.cipherDecryptor.doFinal(bytes);
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String getTextFileContent(String _filename, boolean _bDecrypt) {
        byte[] res = this.getTextFileContentByte(_filename, _bDecrypt);
        if (res != null) {
            return new String(res);
        }
        return null;
    }

    public byte[] getTextFileContentByte(String _filename, boolean _bDecrypt) {
        File file = new File(this.m_rootFile, _filename);
        return this.getFileContentByte(file, _bDecrypt);
    }

    public byte[] getFileContentByte(File file, boolean _bDecrypt) {
        if (file.exists() && file.length() > 0L) {
            int len = (int)file.length();
            byte[] data = new byte[len];
            int offset = 0;
            try {
                int read;
                FileInputStream is = new FileInputStream(file);
                do {
                    read = ((InputStream)is).read(data, offset, len);
                    len -= read;
                    offset += read;
                } while (read > 0);
                if (_bDecrypt) {
                    data = this.decryptByte(data);
                }
                ((InputStream)is).close();
            }
            catch (Exception e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
            return data;
        }
        return null;
    }

    public void writeTextFileContent(String _filename, boolean _bEncrypt, String _content) {
        this.writeTextFileContentByte(_filename, _bEncrypt, _content.getBytes());
    }

    public void writeTextFileContentByte(String _filename, boolean _bEncrypt, byte[] _content) {
        File file = new File(this.m_rootFile, _filename);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                return;
            }
        }
        try {
            FileOutputStream os = null;
            os = new FileOutputStream(file);
            byte[] content = null;
            content = _bEncrypt ? this.encryptByte(_content) : _content;
            os.write(content);
            os.close();
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
    }

    public ArrayList<LevelItem> listDirectories(String _dirPath, String _includeStringOrNil) {
        File[] child;
        File scanDir = new File(this.m_rootFile, _dirPath);
        if (scanDir.exists() && scanDir.isDirectory() && (child = scanDir.listFiles()) != null && child.length > 0) {
            ArrayList<LevelItem> res = new ArrayList<LevelItem>(child.length);
            File[] fileArray = child;
            int n = child.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && f.getName().contains("#")) {
                    res.add(new LevelItem(f.getName(), f.lastModified()));
                }
                ++n2;
            }
            return res;
        }
        return null;
    }

    public ArrayList<LevelItem> listFiles(String _dirPath, String _includeStringOrNil, String _extension) {
        File[] child;
        File scanDir = new File(this.m_rootFile, _dirPath);
        if (scanDir.exists() && scanDir.isDirectory() && (child = scanDir.listFiles()) != null && child.length > 0) {
            ArrayList<LevelItem> res = new ArrayList<LevelItem>(child.length);
            File[] fileArray = child;
            int n = child.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().contains("#") && f.getName().endsWith(_extension)) {
                    res.add(new LevelItem(f.getName(), f.lastModified()));
                }
                ++n2;
            }
            return res;
        }
        return null;
    }

    public boolean reportLevelByMail(String _userId, String _friendlyUserId, String _levelName, String _body) {
        try {
            String inputLine;
            String level_name = _levelName.replace("@", "_at_");
            level_name = _levelName.replace("#", "-KEY");
            level_name = HTMLEncode.encode(level_name);
            String _url = "http://www.swingswingsubmarine.com/phpbtmrequest/";
            String _args = "?user_id=" + _userId + "&user_id_friendly=" + HTMLEncode.encode(_friendlyUserId) + "&message=" + HTMLEncode.encode(_body) + "&level_name=" + level_name;
            URL url = new URL(String.valueOf(_url) + "report_A_Level.php" + _args);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean listPHPLevelAttribs(ArrayList<LevelItem> _levelNames, String _databaseLocalFileOrNil, boolean bForceUsingLocalFileDB) {
        boolean bDone = false;
        if (_levelNames != null && _levelNames.size() > 0) {
            String content;
            HashMap<String, LevelItemAttribs> localAttribs;
            block11: {
                localAttribs = new HashMap<String, LevelItemAttribs>(_levelNames.size());
                content = "";
                try {
                    if (!bForceUsingLocalFileDB) {
                        String inputLine;
                        String _url = "http://www.swingswingsubmarine.com/phpbtmrequest/";
                        URL url = new URL(String.valueOf(_url) + "getBTM_Community_LevelAttribList_SQL.php");
                        URLConnection yc = url.openConnection();
                        BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                        while ((inputLine = in.readLine()) != null) {
                            content = String.valueOf(content) + inputLine;
                        }
                        this._fillAttribItems(content, localAttribs);
                        this._syncLevelItemWithAttribs(_levelNames, localAttribs);
                        bDone = true;
                    } else {
                        bDone = false;
                    }
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block11;
                    e.printStackTrace();
                    bDone = false;
                }
            }
            if (_databaseLocalFileOrNil != null && localAttribs != null) {
                if (bDone) {
                    if (content != null && content.length() > 0) {
                        this.writeTextFileContent(_databaseLocalFileOrNil, true, content);
                    }
                } else {
                    content = this.getTextFileContent(_databaseLocalFileOrNil, true);
                    if (content != null && content.length() > 0) {
                        localAttribs.clear();
                        this._fillAttribItems(content, localAttribs);
                        this._syncLevelItemWithAttribs(_levelNames, localAttribs);
                    }
                    bDone = true;
                }
            }
        }
        return bDone;
    }

    protected void _fillAttribItems(String content, HashMap<String, LevelItemAttribs> localAttribs) {
        String[] items;
        String[] stringArray = items = content.split(";");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String[] levelName_chest_par;
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && (levelName_chest_par = item.split("\\|")) != null && levelName_chest_par.length >= 3) {
                localAttribs.put(String.valueOf(levelName_chest_par[0]) + ".btm", new LevelItemAttribs(Integer.parseInt(levelName_chest_par[2]), Integer.parseInt(levelName_chest_par[1]) > 0));
            }
            ++n2;
        }
    }

    protected void _syncLevelItemWithAttribs(ArrayList<LevelItem> _levelNames, HashMap<String, LevelItemAttribs> localAttribs) {
        for (LevelItem levelItem : _levelNames) {
            String levelName = levelItem.LevelFileName();
            if (!localAttribs.containsKey(levelName)) continue;
            LevelItemAttribs attribs = localAttribs.get(levelName);
            levelItem.par(attribs.par());
            levelItem.hasCustomChest(attribs.customChest());
        }
    }

    public boolean listPHPThumbs(ArrayList<LevelItem> _levelNames) {
        block7: {
            if (_levelNames != null && _levelNames.size() > 0) {
                try {
                    String inputLine;
                    HashMap<String, LevelItemThumbs> localThumbs = new HashMap<String, LevelItemThumbs>(_levelNames.size());
                    String _url = "http://www.swingswingsubmarine.com/phpbtmrequest/";
                    URL url = new URL(String.valueOf(_url) + "getBTM_Community_LevelRatingList_SQL.php");
                    URLConnection yc = url.openConnection();
                    BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                    String content = "";
                    while ((inputLine = in.readLine()) != null) {
                        content = String.valueOf(content) + inputLine;
                    }
                    String[] items = content.split(";");
                    String[] stringArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] levelName_up_down;
                        String item = stringArray[n2];
                        if (item != null && item.length() > 0 && (levelName_up_down = item.split("\\|")) != null && levelName_up_down.length == 3) {
                            localThumbs.put(String.valueOf(levelName_up_down[0]) + ".btm", new LevelItemThumbs(Integer.parseInt(levelName_up_down[1]), Integer.parseInt(levelName_up_down[2])));
                        }
                        ++n2;
                    }
                    for (LevelItem levelItem : _levelNames) {
                        String levelName = levelItem.LevelFileName();
                        if (!localThumbs.containsKey(levelName)) continue;
                        LevelItemThumbs thumbs = (LevelItemThumbs)localThumbs.get(levelName);
                        levelItem.thumbUp(thumbs.upCount());
                        levelItem.thumbDown(thumbs.downCount());
                    }
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public String phpCall(String _phpFunction, String _args) {
        try {
            String inputLine;
            String _url = "http://www.swingswingsubmarine.com/phpbtmrequest/" + _phpFunction + ".php";
            if (_args != null) {
                _url = String.valueOf(_url) + _args;
            }
            URL url = new URL(_url);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            return content;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean listPHPFiles(String _phpFunction, String _keyDelimiter, String _extension, ArrayList<LevelItem> _levelNames, ArrayList<LevelItem> _avoidListOrNil, boolean _bSort, boolean _bFlagAvoidNotUpToDate) {
        try {
            String inputLine;
            String _url = "http://www.swingswingsubmarine.com/phpbtmrequest/";
            URL url = new URL(String.valueOf(_url) + _phpFunction + ".php");
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            String[] items = content.split(";");
            LevelItem levelItem = null;
            LevelItem levelItemToFlag = null;
            String extensionPipe = String.valueOf(_extension) + "|";
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null && item.length() > 0 && item.contains(_keyDelimiter) && item.contains(extensionPipe)) {
                    String[] nameDate = item.split("\\|");
                    levelItem = new LevelItem(nameDate[0], this.PHPdateToJavaDate(Long.parseLong(nameDate[1])));
                    levelItem.online(true);
                    if (_avoidListOrNil == null || !_avoidListOrNil.contains(levelItem)) {
                        _levelNames.add(levelItem);
                    } else {
                        int index = Collections.binarySearch(_avoidListOrNil, levelItem);
                        if (index >= 0) {
                            levelItemToFlag = _avoidListOrNil.get(index);
                            levelItemToFlag.online(true);
                            if (_bFlagAvoidNotUpToDate && levelItemToFlag.Date() < levelItem.Date()) {
                                levelItemToFlag.upToDate(false);
                            }
                            levelItemToFlag.Date(levelItem.Date());
                        }
                    }
                }
                ++n2;
            }
            in.close();
            if (_bSort && _levelNames.size() > 0) {
                Collections.sort(_levelNames, new LevelItemDateComparator());
            }
            return true;
        }
        catch (Exception e) {
            if (MACRO.DEBUG && MACRO.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    long PHPdateToJavaDate(long phpDate) {
        return phpDate * 1000L;
    }

    public void createLevelEditDir(String levelDir) {
        block3: {
            File newDir = new File(this.m_rootFile, levelDir);
            if (!newDir.exists()) {
                try {
                    newDir.mkdir();
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public void createFolder(String folderName) {
        block3: {
            File newDir = new File(this.m_rootFile, folderName);
            if (!newDir.exists()) {
                try {
                    newDir.mkdir();
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public void deleteFolder(String folderName) {
        block7: {
            File deleteDir = new File(this.m_rootFile, folderName);
            if (deleteDir.exists() && deleteDir.isDirectory()) {
                try {
                    File[] children = deleteDir.listFiles();
                    if (children != null && children.length > 0) {
                        File[] fileArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File childFile = fileArray[n2];
                            if (childFile.isDirectory()) {
                                this.deleteFolder(childFile.getName());
                            } else {
                                childFile.delete();
                            }
                            ++n2;
                        }
                    }
                    deleteDir.delete();
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean deleteFile(String filePath) {
        File deleteFile = new File(this.m_rootFile, filePath);
        if (deleteFile.exists() && deleteFile.isFile()) {
            return deleteFile.delete();
        }
        return false;
    }

    public boolean copyFile(String filename, String folderSource, String folderDest, boolean _bCompress) {
        boolean bDone = false;
        File source = new File(this.m_rootFile, String.valueOf(folderSource) + "/" + filename);
        File dest = new File(this.m_rootFile, String.valueOf(folderDest) + "/" + filename + (_bCompress ? ".dat" : ""));
        if (dest.exists()) {
            dest.delete();
        }
        if (source.exists() && source.length() > 0L) {
            byte[] data = new byte[(int)source.length()];
            try {
                int read;
                FileInputStream in = new FileInputStream(source);
                FileOutputStream out = new FileOutputStream(dest);
                int len = (int)source.length();
                int offset = 0;
                do {
                    read = ((InputStream)in).read(data, offset, len);
                    offset += read;
                    len -= read;
                } while (read > 0);
                if (_bCompress) {
                    byte[] output = new byte[data.length];
                    Deflater compresser = new Deflater();
                    compresser.setInput(data);
                    compresser.finish();
                    int compressedDataLength = compresser.deflate(output);
                    ((OutputStream)out).write(output, 0, compressedDataLength);
                } else {
                    ((OutputStream)out).write(data);
                }
                bDone = true;
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                bDone = false;
            }
        }
        return bDone;
    }

    public boolean zipFolder(String folderNamePackage) {
        boolean bDone = false;
        File folderToZip = new File(this.m_rootFile, folderNamePackage);
        File zipArchive = new File(this.m_rootFile, String.valueOf(folderNamePackage) + ".btm");
        if (zipArchive.exists()) {
            zipArchive.delete();
        }
        if (folderToZip.exists() && folderToZip.isDirectory()) {
            try {
                File[] children = folderToZip.listFiles();
                byte[] buf = new byte[4096];
                if (children != null && children.length > 0) {
                    ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(zipArchive));
                    int numFileArchived = 0;
                    File[] fileArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File fileToZip = fileArray[n2];
                        if (fileToZip.isFile()) {
                            int len;
                            FileInputStream in = new FileInputStream(fileToZip);
                            zipStream.putNextEntry(new ZipEntry(fileToZip.getName()));
                            while ((len = in.read(buf)) > 0) {
                                zipStream.write(buf, 0, len);
                            }
                            zipStream.closeEntry();
                            in.close();
                            ++numFileArchived;
                        }
                        ++n2;
                    }
                    zipStream.close();
                    if (numFileArchived > 0) {
                        bDone = true;
                    }
                }
            }
            catch (Exception e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                bDone = false;
            }
        }
        return bDone;
    }

    public boolean uploadFileToFTP(String file, boolean bWaitingApproval) {
        boolean bUploded;
        block9: {
            File toUpload;
            bUploded = false;
            if (this.m_ftpClient == null) {
                this.m_ftpClient = new FTPClient();
            }
            if ((toUpload = new File(this.m_rootFile, file)).exists() && toUpload.isFile()) {
                FileInputStream fis;
                block8: {
                    fis = null;
                    try {
                        fis = new FileInputStream(toUpload);
                    }
                    catch (FileNotFoundException e1) {
                        fis = null;
                        if (!MACRO.DEBUG) break block8;
                        e1.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        this.m_ftpClient.connect("ftp.swingswingsubmarine.com");
                        this.m_ftpClient.login("swingswi-btm", "btmcommunity");
                        this.m_ftpClient.setFileTransferMode(2);
                        this.m_ftpClient.setFileType(2);
                        int reply = this.m_ftpClient.getReplyCode();
                        if (FTPReply.isPositiveCompletion((int)reply)) {
                            String name = toUpload.getName();
                            bUploded = bWaitingApproval ? this.m_ftpClient.storeFile(String.valueOf(this.m_FTPFolder) + "approval/" + name, (InputStream)fis) : this.m_ftpClient.storeFile(String.valueOf(this.m_FTPFolder) + name, (InputStream)fis);
                        }
                        this.m_ftpClient.logout();
                        fis.close();
                    }
                    catch (Exception e) {
                        if (!MACRO.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
            }
        }
        return bUploded;
    }

    public boolean downloadFileFromFTP(String filename, String destFolder) {
        boolean bDownloaded = false;
        if (this.m_ftpClient == null) {
            this.m_ftpClient = new FTPClient();
        }
        File fileDest = new File(this.m_rootFile, String.valueOf(destFolder) + "/" + filename);
        DeflaterOutputStream fos = null;
        try {
            try {
                this.m_ftpClient.connect("ftp.swingswingsubmarine.com");
                this.m_ftpClient.login("swingswi-btm", "btmcommunity");
                fos = new ZipOutputStream(new FileOutputStream(fileDest));
                this.m_ftpClient.retrieveFile("/" + filename, (OutputStream)fos);
                this.m_ftpClient.disconnect();
                bDownloaded = true;
            }
            catch (Exception e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                try {
                    if (fos != null) {
                        fos.flush();
                        ((ZipOutputStream)fos).close();
                    }
                }
                catch (Exception e2) {
                    if (MACRO.DEBUG) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        finally {
            block17: {
                try {
                    if (fos != null) {
                        fos.flush();
                        ((ZipOutputStream)fos).close();
                    }
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block17;
                    e.printStackTrace();
                }
            }
        }
        return bDownloaded;
    }

    public boolean downloadFileFromURL(String filename, String destFolder, boolean bWaitingApproval) {
        boolean bLoaded;
        block24: {
            bLoaded = false;
            BufferedOutputStream bos = null;
            BufferedInputStream bis = null;
            try {
                try {
                    int count;
                    String _url = null;
                    _url = MACRO.TECH_DEMO ? "http://www.swingswingsubmarine.com/BTM_Community/" : (MACRO.DEBUG && MACRO.DEBUG_COMMUNITY ? (bWaitingApproval ? "http://www.swingswingsubmarine.com/BTM_Community/DBG/approval/" : "http://www.swingswingsubmarine.com/BTM_Community/DBG/") : (bWaitingApproval ? "http://www.swingswingsubmarine.com/BTM_Community/Full/approval/" : "http://www.swingswingsubmarine.com/BTM_Community/Full/"));
                    String encodedFilename = filename.replace(" ", "%20");
                    encodedFilename = encodedFilename.replace("#", "%23");
                    URL url = new URL(String.valueOf(_url) + encodedFilename);
                    bis = new BufferedInputStream(url.openStream());
                    File destFile = new File(this.m_rootFile, String.valueOf(destFolder) + "/" + filename);
                    bos = new BufferedOutputStream(new FileOutputStream(destFile), 4096);
                    byte[] data = new byte[4096];
                    while ((count = bis.read(data, 0, 4096)) != -1) {
                        bos.write(data, 0, count);
                    }
                    bLoaded = true;
                }
                catch (Exception e) {
                    block23: {
                        if (MACRO.DEBUG) {
                            e.printStackTrace();
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Exception e2) {
                                if (!MACRO.DEBUG) break block23;
                                e2.printStackTrace();
                            }
                        }
                    }
                    if (bos == null) break block24;
                    try {
                        bos.flush();
                        bos.close();
                    }
                    catch (Exception e3) {
                        if (MACRO.DEBUG) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            finally {
                block26: {
                    block25: {
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Exception e) {
                                if (!MACRO.DEBUG) break block25;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.flush();
                            bos.close();
                        }
                        catch (Exception e) {
                            if (!MACRO.DEBUG) break block26;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return bLoaded;
    }

    public boolean checkArchiveOpens(String _path, String archiveFilename) {
        boolean bRes = false;
        File archiveFile = new File(this.m_rootFile, String.valueOf(_path) + "/" + archiveFilename);
        if (archiveFile.exists() && archiveFile.isFile()) {
            FileInputStream fis = null;
            ByteArrayOutputStream bos = null;
            ZipInputStream zis = null;
            ZipEntry ze = null;
            try {
                try {
                    fis = new FileInputStream(archiveFile);
                    bos = new ByteArrayOutputStream();
                    zis = new ZipInputStream(fis);
                    ze = zis.getNextEntry();
                    if (ze != null) {
                        zis.closeEntry();
                        bRes = true;
                    }
                }
                catch (Exception e) {
                    bRes = false;
                    if (MACRO.DEBUG) {
                        e.printStackTrace();
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (bos != null) {
                            bos.close();
                        }
                        if (zis != null) {
                            zis.close();
                        }
                    }
                    catch (Exception e2) {
                        if (MACRO.DEBUG) {
                            e2.printStackTrace();
                        }
                    }
                }
            }
            finally {
                block22: {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (bos != null) {
                            bos.close();
                        }
                        if (zis != null) {
                            zis.close();
                        }
                    }
                    catch (Exception e) {
                        if (!MACRO.DEBUG) break block22;
                        e.printStackTrace();
                    }
                }
            }
        }
        return bRes;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteArrayInputStream getZipArchiveStreamItem(String archiveFilename, String filename, String filenameEncryptedOrNil) {
        fis = null;
        res = null;
        out = null;
        zis = null;
        archiveFile = new File(this.m_rootFile, archiveFilename);
        bNeedDecrypt = false;
        if (archiveFile.exists() == false) return res;
        if (!archiveFile.isFile()) return res;
        try {
            try {
                fis = new FileInputStream(archiveFile);
                out = new ByteArrayOutputStream();
                zis = new ZipInputStream(fis);
                if (true) ** GOTO lbl49
                do {
                    bFilenameMatch = ze.getName().endsWith(filename);
                    v0 = bFilenameEncryptedMatch = filenameEncryptedOrNil == null || bFilenameMatch != false ? false : ze.getName().endsWith(filenameEncryptedOrNil);
                    if (bFilenameMatch || bFilenameEncryptedMatch) {
                        data = new byte[4096];
                        while ((count = zis.read(data, 0, 4096)) != -1) {
                            out.write(data, 0, count);
                        }
                        if (bFilenameEncryptedMatch) {
                            block47: {
                                output = out.toByteArray();
                                decompressor = new Inflater();
                                decompressor.setInput(output);
                                bos = new ByteArrayOutputStream(output.length);
                                buf = new byte[4096];
                                while (!decompressor.finished()) {
                                    try {
                                        count = decompressor.inflate(buf);
                                        bos.write(buf, 0, count);
                                    }
                                    catch (DataFormatException e) {
                                        if (!MACRO.DEBUG) continue;
                                        e.printStackTrace();
                                    }
                                }
                                try {
                                    bos.close();
                                }
                                catch (IOException e) {
                                    if (!MACRO.DEBUG) break block47;
                                    e.printStackTrace();
                                }
                            }
                            res = new ByteArrayInputStream(bos.toByteArray());
                        } else {
                            res = new ByteArrayInputStream(out.toByteArray());
                        }
                    }
                    zis.closeEntry();
lbl49:
                    // 2 sources

                    if (res != null) return res;
                } while ((ze = zis.getNextEntry()) != null);
                return res;
            }
            catch (Exception e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception var21_23) {
                        // empty catch block
                    }
                }
                if (res != null) {
                    try {
                        res.close();
                    }
                    catch (Exception var21_24) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception var21_25) {
                        // empty catch block
                    }
                }
                if (zis == null) return res;
                try {
                    zis.close();
                    return res;
                }
                catch (Exception var21_26) {}
            }
            return res;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception var21_31) {}
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception var21_32) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception var21_33) {}
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception var21_34) {}
            }
        }
    }

    public ByteArrayInputStream getStreamItem(String filename) {
        ByteArrayInputStream res = null;
        byte[] datas = this.getTextFileContentByte(filename, false);
        if (datas != null) {
            res = new ByteArrayInputStream(datas);
        }
        return res;
    }

    public boolean fileExists(String _path, String _filename) {
        File file = new File(this.m_rootFile, String.valueOf(_path) + "/" + _filename);
        return file.exists();
    }

    public boolean fileExists(String _fullPath) {
        File file = new File(this.m_rootFile, _fullPath);
        return file.exists();
    }

    public boolean updateAttribsPHPLevel(String _levelNameWithoutExt, boolean _bCustomChest, int _customPar) {
        String url = "http://www.swingswingsubmarine.com/phpbtmrequest/updateBTM_Community_LevelAttribs_SQL.php";
        String args = "?chest=" + (_bCustomChest ? "1" : "0") + "&par=" + _customPar + "&level_name=" + HTMLEncode.encode(_levelNameWithoutExt);
        return this._makeURL_PHP_Request(url, args);
    }

    protected boolean _makeURL_PHP_Request(String _url, String _args) {
        try {
            String inputLine;
            URL urlFull = new URL(String.valueOf(_url) + (_args != null ? _args : ""));
            URLConnection yc = urlFull.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            return !content.contains("ERROR");
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean thumbsPHPLevel(String _levelNameWithoutExt, boolean _bThumbsUp) {
        String url = "http://www.swingswingsubmarine.com/phpbtmrequest/";
        String args = "?increment=" + (_bThumbsUp ? "1" : "0") + "&level_name=" + HTMLEncode.encode(_levelNameWithoutExt);
        try {
            String inputLine;
            URL urlFull = new URL(String.valueOf(url) + "incrementBTM_Community_LevelThumbUpOrDown_SQL.php" + args);
            URLConnection yc = urlFull.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            return !content.contains("ERROR");
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean deletePHPLevel(String _levelName) {
        String url = "http://www.swingswingsubmarine.com/phpbtmrequest/";
        String args = "?fooooooo=123&level_name=" + HTMLEncode.encode(_levelName);
        try {
            String inputLine;
            URL urlFull = null;
            urlFull = MACRO.DEBUG && MACRO.DEBUG_COMMUNITY ? new URL(String.valueOf(url) + "BTM_Community_DeleteLevelFromBaseDBG.php" + args) : new URL(String.valueOf(url) + "BTM_Community_DeleteLevelFromBaseFull.php" + args);
            URLConnection yc = urlFull.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            return !content.contains("ERROR");
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public long fileTimestampOrZero(String filename) {
        File file = new File(this.m_rootFile, filename);
        if (file.exists() && file.isFile()) {
            long value = file.lastModified() / 1000L;
            return value;
        }
        return 0L;
    }

    public void readCommaSeparatedValue(String _filename, ArrayList<String> _finishedLevels, boolean _clearExitingList) {
        String[] values;
        String content;
        if (_clearExitingList) {
            _finishedLevels.clear();
        }
        if ((content = this.getTextFileContent(_filename, true)) != null && (values = content.split(";")) != null && values.length > 0) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                _finishedLevels.add(value);
                ++n2;
            }
        }
    }

    public void writeCommaSeparatedValue(String _filename, ArrayList<String> _finishedLevels) {
        if (_finishedLevels != null && _finishedLevels.size() > 0) {
            String content = "";
            for (String value : _finishedLevels) {
                content = String.valueOf(content) + value + ";";
            }
            this.writeTextFileContent(_filename, true, content);
        }
    }

    public String listGroupMember(String groupUrl) {
        try {
            String inputLine;
            URL urlFull = new URL(groupUrl);
            URLConnection yc = urlFull.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String content = "";
            while ((inputLine = in.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            return content;
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public byte[] compressData(byte[] data) {
        if (this.m_tmpOutputCompress.length < data.length) {
            this.m_tmpOutputCompress = new byte[data.length];
        }
        this.m_compresser.reset();
        this.m_compresser.setInput(data);
        this.m_compresser.finish();
        int compressedDataLength = this.m_compresser.deflate(this.m_tmpOutputCompress);
        return Arrays.copyOfRange(this.m_tmpOutputCompress, 0, compressedDataLength);
    }

    public byte[] decompressData(byte[] data) {
        this.m_decompresser.reset();
        this.m_decompresser.setInput(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        while (!this.m_decompresser.finished()) {
            try {
                int count = this.m_decompresser.inflate(this.m_tmpOutputDecompress);
                if (count == 0) break;
                bos.write(this.m_tmpOutputDecompress, 0, count);
            }
            catch (DataFormatException e) {
                if (MACRO.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        try {
            bos.close();
        }
        catch (Exception e) {
            if (MACRO.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        return bos.toByteArray();
    }

    public boolean isImageSizeValid(String _filename, int _maxHeight, int _maxWidth) {
        boolean bRes;
        block18: {
            bRes = false;
            File file = new File(this.m_rootFile, _filename);
            if (file.exists() && !file.isDirectory()) {
                ImageInputStream in = null;
                try {
                    try {
                        in = ImageIO.createImageInputStream(file);
                        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                        if (!readers.hasNext()) break block18;
                        ImageReader reader = readers.next();
                        try {
                            try {
                                reader.setInput(in);
                                bRes = reader.getWidth(0) <= _maxWidth && reader.getHeight(0) <= _maxHeight;
                            }
                            catch (Exception e) {
                                bRes = false;
                                reader.dispose();
                            }
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                    catch (Exception e) {
                        bRes = false;
                        if (in == null) break block18;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return bRes;
    }
}

