/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers;

import Microsoft.Xna.Framework.Content.XDocument;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.BTM.SaveManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class LoginManager {
    static LoginManager m_Instance = null;
    protected static String _DefaultUserName = "Anonymous Sailor";
    protected int m_slotId = 0;
    protected int m_slotIdNext = 0;
    CallbackSimple m_changeSlotDone = null;
    protected static String[] m_slotsNames = new String[]{"Slot01", "Slot02", "Slot03", "Slot04"};
    protected static String[] m_usersNames = new String[]{_DefaultUserName, _DefaultUserName, _DefaultUserName, _DefaultUserName};
    CallbackSimple m_saveComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LoginManager.this._saveComplete(_sender, _args);
        }
    };
    CallbackSimple m_loadComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LoginManager.this._loadComplete(_sender, _args);
        }
    };
    private float[] m_mainCompletion = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float[] m_bonusCompletion = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float[] m_soundCompletion = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private String[] m_completionString = new String[]{"", "", "", ""};

    public int currentSlotId() {
        return this.m_slotId;
    }

    public String currentSlotName() {
        return m_slotsNames[this.m_slotId];
    }

    public void currentSlotName(String name) {
        this.m_slotId = 0;
        int i = 0;
        while (i < m_slotsNames.length) {
            if (m_slotsNames[i].equals(name)) {
                this.m_slotId = i;
                break;
            }
            ++i;
        }
    }

    public String getSlotName(int slotId) {
        if (slotId > -1 && slotId < m_slotsNames.length) {
            return m_slotsNames[slotId];
        }
        return m_slotsNames[0];
    }

    public String DefaultUserName() {
        return _DefaultUserName;
    }

    public String currentUserName() {
        return m_usersNames[this.m_slotId];
    }

    public void currentUserName(String userName, boolean _bSaveChange) {
        if (!userName.equals(m_usersNames[this.m_slotId])) {
            LoginManager.m_usersNames[this.m_slotId] = userName;
            if (_bSaveChange) {
                SaveManager.Instance().saveLastUserName();
            }
        }
    }

    public static LoginManager Instance() {
        if (m_Instance == null) {
            m_Instance = new LoginManager();
        }
        return m_Instance;
    }

    protected LoginManager() {
    }

    public boolean isDefaultUserName() {
        return _DefaultUserName.equals(this.currentUserName());
    }

    public void setLastSessionInfos(String content) {
        String[] curSlotAndUserSlots;
        if ((content = content.trim()).length() > 0 && content.contains("#") && content.contains("@") && content.contains("$") && (curSlotAndUserSlots = content.split("\\$")) != null && curSlotAndUserSlots.length > 1) {
            this.m_slotId = Integer.parseInt(curSlotAndUserSlots[0]);
            String[] usersSlots = curSlotAndUserSlots[1].split("\\#");
            if (usersSlots != null && usersSlots.length > 0) {
                int i = 0;
                while (i < usersSlots.length) {
                    String[] userAndSlot = usersSlots[i].split("@");
                    if (userAndSlot != null && userAndSlot.length > 1 && i < m_slotsNames.length) {
                        LoginManager.m_usersNames[i] = userAndSlot[0];
                        LoginManager.m_slotsNames[i] = userAndSlot[1];
                    }
                    ++i;
                }
            }
        }
    }

    public String getLastSessionInfos() {
        String content = String.valueOf(this.m_slotId) + "$";
        int i = 0;
        while (i < m_usersNames.length) {
            content = String.valueOf(content) + m_usersNames[i] + "@" + m_slotsNames[i];
            if (i < m_usersNames.length - 1) {
                content = String.valueOf(content) + "#";
            }
            ++i;
        }
        return content;
    }

    protected void _saveComplete(Object sender, Object e) {
        this.m_slotId = this.m_slotIdNext;
        SaveManager.Instance().loadGameDataThreaded(this.m_loadComplete, true);
    }

    protected void _loadComplete(Object sender, Object e) {
        this.m_changeSlotDone.onCallback(this, null);
    }

    public void changeSlot(int _nextSlot, CallbackSimple _done) {
        if (this.m_slotId != _nextSlot) {
            this.m_slotIdNext = _nextSlot;
            this.m_changeSlotDone = _done;
            SaveManager.Instance().saveGameDataThreaded(this.m_saveComplete);
        } else {
            _done.onCallback(this, null);
        }
    }

    public void computeCompletions() {
        int slotId = 0;
        while (slotId < m_slotsNames.length) {
            if (this.m_slotId == slotId) {
                this._computeCompletionFromCurrentLevelGroups(slotId);
            } else {
                this._computeCompletionFromSaveFile(slotId);
            }
            ++slotId;
        }
    }

    public void computeCurrentCompletion() {
        this._computeCompletionFromCurrentLevelGroups(this.m_slotId);
    }

    public void computeCurrentMainCompletion() {
        this._computeCompletionFromCurrentLevelGroups(this.m_slotId);
    }

    public String getCompletionString(int slot) {
        return this.m_completionString[slot];
    }

    public float getCurrentSlotMainCompletionValue() {
        return this.m_mainCompletion[this.m_slotId];
    }

    public float getCurrentSlotBonusCompletionValue() {
        return this.m_bonusCompletion[this.m_slotId];
    }

    public float getCurrentSlotTrackCompletionValue() {
        return this.m_soundCompletion[this.m_slotId];
    }

    private void _computeCompletionFromCurrentLevelGroups(int _idSlot) {
        float mainCompletion = 0.0f;
        float bonusCompletion = 0.0f;
        float soundCompletion = 0.0f;
        mainCompletion = this._mainCompletion();
        bonusCompletion = this._bonusCompletion();
        soundCompletion = this._tracksCompletion();
        this.m_mainCompletion[_idSlot] = mainCompletion;
        this.m_bonusCompletion[_idSlot] = bonusCompletion;
        this.m_soundCompletion[_idSlot] = soundCompletion;
        this.m_completionString[_idSlot] = String.valueOf((int)mainCompletion) + "%|" + (int)bonusCompletion + "%|" + (int)soundCompletion + "%";
    }

    protected float _mainCompletion() {
        LevelGroup mainGroup = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_AVENTURE_NAME);
        LevelInfo lvlInfo = null;
        int numLevelFinished = 0;
        int numPARDone = 0;
        int numBTMFound = 0;
        int numLevel = 0;
        if (mainGroup != null) {
            int i = 0;
            while (i < mainGroup.LevelInfos().size()) {
                lvlInfo = mainGroup.LevelInfos().get(i);
                if (lvlInfo != null && !lvlInfo.Cinematic()) {
                    ++numLevel;
                    if (lvlInfo.Done()) {
                        ++numLevelFinished;
                    }
                    if (lvlInfo.BTMFound()) {
                        ++numBTMFound;
                    }
                    if (lvlInfo.ParDone()) {
                        ++numPARDone;
                    }
                }
                ++i;
            }
        }
        return (1.0f * (float)numBTMFound / (1.0f * (float)numLevel) + 1.0f * (float)numPARDone / (1.0f * (float)numLevel) + 1.0f * (float)numLevelFinished / (1.0f * (float)numLevel)) * 100.0f / 3.0f;
    }

    protected float _bonusCompletion() {
        int numLevelFinished = 0;
        int numLevel = 0;
        LevelInfo lvlInfo = null;
        LevelGroup bonuses01Group = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_BONUS_CHAPTER_NAME);
        if (bonuses01Group != null) {
            int i = 0;
            while (i < bonuses01Group.LevelInfos().size()) {
                lvlInfo = bonuses01Group.LevelInfos().get(i);
                if (lvlInfo != null && !lvlInfo.Cinematic()) {
                    ++numLevel;
                    if (lvlInfo.Done()) {
                        ++numLevelFinished;
                    }
                }
                ++i;
            }
        }
        return 1.0f * (float)numLevelFinished / (1.0f * (float)numLevel) * 100.0f;
    }

    protected float _tracksCompletion() {
        int numLevelFinished = 0;
        int numLevel = 0;
        LevelInfo lvlInfo = null;
        LevelGroup tracksGroup = LevelDataBase.Instance().getLevelGroup("Tracks");
        if (tracksGroup != null) {
            int i = 0;
            while (i < tracksGroup.LevelInfos().size()) {
                lvlInfo = tracksGroup.LevelInfos().get(i);
                if (lvlInfo != null && !lvlInfo.Cinematic()) {
                    ++numLevel;
                    if (lvlInfo.Unlocked()) {
                        ++numLevelFinished;
                    }
                }
                ++i;
            }
        }
        return 1.0f * (float)numLevelFinished / (1.0f * (float)numLevel) * 100.0f;
    }

    private void _computeCompletionFromSaveFile(int _idSlot) {
        Document doc;
        String saveContent = SaveManager.Instance().getSaveContent(_idSlot);
        float mainCompletion = 0.0f;
        float bonusCompletion = 0.0f;
        float soundCompletion = 0.0f;
        if (saveContent != null && (doc = XDocument.Parse(saveContent)) != null) {
            NodeList levelGroupsList = doc.getElementsByTagName("LevelsGroup");
            Element levelElem = null;
            Element groupElem = null;
            LevelGroup levelGroup = null;
            LevelInfo lvlInfo = null;
            LevelDataBase lvlDB = LevelDataBase.Instance();
            int group = 0;
            while (group < levelGroupsList.getLength()) {
                int numLevelFinished = 0;
                int numBTMFound = 0;
                int numPARDone = 0;
                int numLevel = 0;
                groupElem = (Element)levelGroupsList.item(group);
                String groupId = groupElem.getAttribute("id");
                if (groupId != null) {
                    int lvl;
                    NodeList levelList;
                    if (groupId.equals(MACRO.MAIN_AVENTURE_NAME)) {
                        levelGroup = lvlDB.getLevelGroup(MACRO.MAIN_AVENTURE_NAME);
                        levelList = groupElem.getElementsByTagName("Level");
                        lvl = 0;
                        while (lvl < levelList.getLength()) {
                            levelElem = (Element)levelList.item(lvl);
                            lvlInfo = levelGroup.getLevelInfoOrNil(levelElem.getAttribute("id"));
                            if (lvlInfo != null && !lvlInfo.Cinematic()) {
                                int par;
                                String parStr;
                                if (levelElem.getAttribute("done").equals("1")) {
                                    ++numLevelFinished;
                                }
                                if (levelElem.getAttribute("btm").equals("1")) {
                                    ++numBTMFound;
                                }
                                if ((parStr = levelElem.getAttribute("par")) != null && parStr.length() > 0 && (par = Integer.parseInt(parStr)) >= lvlInfo.ParToReachValue()) {
                                    ++numPARDone;
                                }
                            }
                            ++lvl;
                        }
                        numLevel = levelGroup.getLevelNumber(false);
                        mainCompletion = (1.0f * (float)numBTMFound / (1.0f * (float)numLevel) + 1.0f * (float)numPARDone / (1.0f * (float)numLevel) + 1.0f * (float)numLevelFinished / (1.0f * (float)numLevel)) * 100.0f / 3.0f;
                    } else if (groupId.equals(MACRO.MAIN_BONUS_CHAPTER_NAME)) {
                        levelGroup = lvlDB.getLevelGroup(MACRO.MAIN_BONUS_CHAPTER_NAME);
                        levelList = groupElem.getElementsByTagName("Level");
                        lvl = 0;
                        while (lvl < levelList.getLength()) {
                            levelElem = (Element)levelList.item(lvl);
                            lvlInfo = levelGroup.getLevelInfoOrNil(levelElem.getAttribute("id"));
                            if (lvlInfo != null && !lvlInfo.Cinematic() && levelElem.getAttribute("done").equals("1")) {
                                ++numLevelFinished;
                            }
                            ++lvl;
                        }
                        numLevel = levelGroup.getLevelNumber(false);
                        bonusCompletion = 1.0f * (float)numLevelFinished / (1.0f * (float)numLevel) * 100.0f;
                    } else if (groupId.equals("Tracks")) {
                        levelGroup = LevelDataBase.Instance().getLevelGroup("Tracks");
                        levelList = groupElem.getElementsByTagName("Level");
                        lvl = 0;
                        while (lvl < levelList.getLength()) {
                            levelElem = (Element)levelList.item(lvl);
                            ++numLevelFinished;
                            ++lvl;
                        }
                        numLevel = levelGroup.getLevelNumber(false);
                        soundCompletion = 1.0f * (float)numLevelFinished / (1.0f * (float)numLevel) * 100.0f;
                    }
                }
                ++group;
            }
        }
        this.m_mainCompletion[_idSlot] = mainCompletion;
        this.m_bonusCompletion[_idSlot] = bonusCompletion;
        this.m_soundCompletion[_idSlot] = soundCompletion;
        this.m_completionString[_idSlot] = String.valueOf((int)mainCompletion) + "%|" + (int)bonusCompletion + "%|" + (int)soundCompletion + "%";
    }
}

