/*
 * Decompiled with CFR 0.152.
 */
package SSS.Managers;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.MathHelper;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Tween.VolumeTweener;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.FlxSoundManager;

public class MusicManager {
    float m_defaultVolume = 1.0f;
    float m_generalVolume = 1.0f;
    float m_generalVolumeMin = 0.0f;
    float m_generalVolumeMax = 1.0f;
    FlxSound m_baseTrack = null;
    FlxSound m_addTrack = null;
    ref<FlxSound> m_baseTrackRef = new ref<Object>(null);
    ref<FlxSound> m_addTrackRef = new ref<Object>(null);
    TweenManager m_tweenManager = null;
    protected static MusicManager m_Instance = null;
    ref<FlxSound> m_refSoundHelper = new ref<Object>(null);
    CallbackSimple m_onFadeOutDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MusicManager.this._onFadeOutDone(_sender, _args);
        }
    };

    public float DefaultlVolume() {
        return this.m_defaultVolume;
    }

    public float GeneralVolume() {
        return this.m_generalVolume;
    }

    public float GeneralVolumeMin() {
        return this.m_generalVolumeMin;
    }

    public float GeneralVolumeMax() {
        return this.m_generalVolumeMax;
    }

    public static MusicManager Instance() {
        if (m_Instance == null) {
            m_Instance = new MusicManager();
        }
        return m_Instance;
    }

    protected MusicManager() {
        this.m_tweenManager = new TweenManager();
    }

    public void update() {
        if (FlxSoundManager.Muted()) {
            if (FlxG.hasFocus()) {
                FlxSoundManager.Mute();
            }
        } else if (!FlxG.hasFocus()) {
            FlxSoundManager.Mute();
        }
        this.m_tweenManager.update();
    }

    public void fade(eTrack _track, eFade _fade, float _duration) {
        boolean bFadeOut;
        FlxSound snd = _track == eTrack.TrackMain ? this.m_baseTrack : this.m_addTrack;
        boolean bl = bFadeOut = _fade == eFade.FadeOut;
        if (snd != null) {
            if (bFadeOut) {
                this._fadeOutSndTween(snd, _duration, false);
            } else {
                this._fadeInSndTween(snd, _duration);
            }
        }
    }

    public void increaseGeneralVolumeAutoClamped(float _deltaVolume) {
        this.setVolumeAutoClamped(this.m_generalVolume + _deltaVolume);
    }

    public void setVolumeAutoClamped(float _volume) {
        this.m_generalVolume = MathHelper.Clamp(_volume, this.m_generalVolumeMin, this.m_generalVolumeMax);
        FlxSoundManager.SetGeneralVolume(this.m_generalVolume);
    }

    public void defaultVolume() {
        this.setVolumeAutoClamped(this.m_defaultVolume);
    }

    public void playTracks(String _trackBaseOrNil, String _trackAddOrNil, float _fadeDurationOfZero, boolean _bForce) {
        if (_trackBaseOrNil != null && this.m_baseTrack != null && !this.m_baseTrack.CueSoundId().equals(_trackBaseOrNil)) {
            LevelDataBase.Instance().markTracksAsUnlocked(_trackBaseOrNil);
        }
        this.m_baseTrackRef.set(this.m_baseTrack);
        this._handleTween(_trackBaseOrNil, this.m_baseTrackRef, _fadeDurationOfZero, _bForce);
        this.m_baseTrack = this.m_baseTrackRef.get();
        this.m_addTrackRef.set(this.m_addTrack);
        this._handleTween(_trackAddOrNil, this.m_addTrackRef, _fadeDurationOfZero, _bForce);
        this.m_addTrack = this.m_addTrackRef.get();
    }

    protected void _handleTween(String _trackId, ref<FlxSound> _sndRef, float _fadeDurationOfZero, boolean _bForce) {
        FlxSound _snd = _sndRef.get();
        FlxSound oldSnd = null;
        FlxSound newSnd = null;
        if (_trackId != null && _trackId.length() == 0) {
            _trackId = null;
        }
        if (_trackId == null) {
            if (_snd != null) {
                oldSnd = _snd;
            }
        } else if (_snd == null || !_snd.CueSoundId().equals(_trackId)) {
            newSnd = new FlxSound();
            newSnd.loadEmbedded(_trackId, true, true, false);
            newSnd.volume(0.0f);
            if (_snd != null) {
                oldSnd = _snd;
            }
        } else if (_snd.volume() < 1.0f || !_snd.playing()) {
            this.m_tweenManager.RemoveTweenable(_snd);
            if (_fadeDurationOfZero > 0.0f) {
                this.m_tweenManager.ToVolume((Tweenable)_snd, 1.0f, _fadeDurationOfZero, TweenManager.EaseType.EASE_LINEAR, 0.0f, (CallbackSimple)null);
            } else {
                _snd.volume(1.0f);
            }
            this._playSnd(_snd);
        }
        if (oldSnd != null) {
            if (_fadeDurationOfZero > 0.0f) {
                this._fadeOutSndTween(oldSnd, _fadeDurationOfZero, true);
            } else {
                this.m_tweenManager.RemoveTweenable(oldSnd);
                this.m_refSoundHelper.set(oldSnd);
                this._stopSnd(this.m_refSoundHelper);
                oldSnd = this.m_refSoundHelper.get();
            }
        }
        if (newSnd != null) {
            _snd = newSnd;
            if (_fadeDurationOfZero > 0.0f) {
                this._fadeInSndTween(newSnd, _fadeDurationOfZero);
            } else {
                this.m_tweenManager.RemoveTweenable(newSnd);
                newSnd.volume(1.0f);
                this._playSnd(newSnd);
            }
        }
        _sndRef.set(_snd);
    }

    protected void _playSnd(FlxSound _snd) {
        if (_snd != null && !_snd.playing()) {
            _snd.play();
        }
    }

    protected void _stopSnd(ref<FlxSound> _sndRef) {
        FlxSound _snd = _sndRef.get();
        if (_snd != null) {
            this.m_tweenManager.RemoveTweenable(_snd);
            _snd.stop(true);
            _snd = null;
        }
        _sndRef.set(_snd);
    }

    protected void _fadeOutSndTween(FlxSound _snd, float _fadeDuration, boolean _bCallBackStopSound) {
        this.m_tweenManager.RemoveTweenable(_snd);
        if (_snd.volume() != 0.0f) {
            if (_bCallBackStopSound) {
                this.m_tweenManager.ToVolume((Tweenable)_snd, 0.0f, _fadeDuration, TweenManager.EaseType.EASE_LINEAR, 0.0f, this.m_onFadeOutDone);
            } else {
                this.m_tweenManager.ToVolume((Tweenable)_snd, 0.0f, _fadeDuration, TweenManager.EaseType.EASE_LINEAR, 0.0f, (CallbackSimple)null);
            }
        }
    }

    protected void _fadeInSndTween(FlxSound _snd, float _fadeDuration) {
        this.m_tweenManager.RemoveTweenable(_snd);
        if (_snd.volume() != 1.0f) {
            this.m_tweenManager.ToVolume((Tweenable)_snd, 1.0f, _fadeDuration, TweenManager.EaseType.EASE_LINEAR, 0.0f, (CallbackSimple)null);
        }
        this._playSnd(_snd);
    }

    protected void _onFadeOutDone(Object _sender, Object _e) {
        VolumeTweener vt = (VolumeTweener)_sender;
        FlxSound snd = (FlxSound)vt.Tweenable();
        this.m_tweenManager.RemoveTweenable(snd);
        snd.stop(true);
    }

    protected void _onFadeInDone(Object _sender, Object _e) {
        VolumeTweener vt = (VolumeTweener)_sender;
        FlxSound snd = (FlxSound)vt.Tweenable();
    }

    public static enum eFade {
        FadeIn,
        FadeOut;

    }

    public static enum eTrack {
        TrackMain,
        TrackAdditionnal;

    }
}

