/*
 * Decompiled with CFR 0.152.
 */
package SSS;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Util.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SssGroup
extends FlxGroup {
    FlxSprite m_fullScreenAlignedQuad = null;
    float m_fullscreenQuadMargin = (float)GameVars.TileStep() * 0.5f;
    ArrayList<Actor> m_renderingOverAllList = null;
    int m_idColResBeg;
    int m_idColResEnd;
    int m_idLineResBeg;
    int m_idLineResEnd;
    Actor[][][] m_renderingGrid = null;
    int[][] m_renderingGridLayerCount = null;
    int m_renderingGridColNum;
    int m_renderingGridLineNum;
    int m_renderingGridLayerNum;
    int m_topMargin;
    int m_leftMargin;
    int m_numActorToRender;
    int m_numActorRendered;
    SSSLayerType m_sssLayerType = SSSLayerType.SSSLayerType_None;
    protected boolean m_bSpecialSortedRendering = false;

    public SSSLayerType LayerType() {
        return this.m_sssLayerType;
    }

    public void LayerType(SSSLayerType value) {
        this.m_sssLayerType = value;
    }

    public void SpecialSortRendering(boolean value) {
        this.m_bSpecialSortedRendering = value;
        if (this.m_bSpecialSortedRendering) {
            this.m_fullScreenAlignedQuad = new FlxSprite();
            int margin = GameVars.TileStep();
            this.m_fullScreenAlignedQuad.createGraphic(FlxG.width + margin, FlxG.height + margin, Color.Yellow());
            this.m_fullScreenAlignedQuad.alpha(0.5f);
            this.m_renderingOverAllList = new ArrayList(20);
            this.m_renderingGridColNum = (int)((float)FlxG.width * GameVars.OneOverTileStep()) + 8;
            this.m_renderingGridLineNum = (int)((float)FlxG.height * GameVars.OneOverTileStep()) + 8;
            this.m_renderingGridLayerNum = 5;
            this.m_renderingGrid = new Actor[this.m_renderingGridLineNum][this.m_renderingGridColNum][this.m_renderingGridLayerNum];
            this.m_renderingGridLayerCount = new int[this.m_renderingGridLineNum][this.m_renderingGridColNum];
        }
    }

    public boolean SpecialSortRendering() {
        return this.m_bSpecialSortedRendering;
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (this.m_bSpecialSortedRendering) {
            this.m_numActorToRender = 0;
            this.m_numActorRendered = 0;
            int li = 0;
            while (li < this.m_renderingGridLineNum) {
                int co = 0;
                while (co < this.m_renderingGridColNum) {
                    Arrays.fill(this.m_renderingGrid[li][co], null);
                    ++co;
                }
                ++li;
            }
            li = 0;
            while (li < this.m_renderingGridLineNum) {
                Arrays.fill(this.m_renderingGridLayerCount[li], 0);
                ++li;
            }
            this._computeRenderingList();
            this._renderRenderingList(spriteBatch);
        } else {
            super.render(spriteBatch);
        }
    }

    protected void _computeRenderingList() {
        this.m_fullScreenAlignedQuad.x = -FlxG.scroll.X - this.m_fullscreenQuadMargin;
        this.m_fullScreenAlignedQuad.y = -FlxG.scroll.Y - this.m_fullscreenQuadMargin;
        this.m_renderingOverAllList.clear();
        this.m_topMargin = (int)(-FlxG.scroll.Y * GameVars.OneOverTileStep()) - 4;
        this.m_topMargin *= GameVars.TileStep();
        this.m_leftMargin = (int)(-FlxG.scroll.X * GameVars.OneOverTileStep()) - 4;
        this.m_leftMargin *= GameVars.TileStep();
        this._myOverlapOldSchool();
    }

    protected boolean _addRenderingElement(Object _object, FlxSpriteCollisionEvent _sce) {
        this._addRenderingElement((Actor)_sce.Object1());
        return false;
    }

    protected void _myOverlapOldSchool() {
        Actor a = null;
        int i = 0;
        while (i < this.members.size()) {
            a = (Actor)this.members.get(i);
            if (a != null && a.exists && a.visible && (a.AlwaysVisible() || Utility.IsActorsVisualOverlappingFast(a, this.m_fullScreenAlignedQuad))) {
                this._addRenderingElement(a);
            }
            ++i;
        }
    }

    protected void _addRenderingElement(Actor a) {
        float approx = 0.5f;
        if (a != null && a.exists && a.visible) {
            a.addFlag(Actor.eSpecialFlag.eSpecialFlag_NotRenderedYet);
            if (a.hasFlag(Actor.eSpecialFlag.eSpecialFlag_RenderOverall)) {
                this.m_renderingOverAllList.add(a);
            } else {
                this.m_idLineResBeg = (int)((a.y + 0.5f - (float)this.m_topMargin) * GameVars.OneOverTileStep());
                this.m_idLineResEnd = (int)((a.y + a.height - 0.5f - (float)this.m_topMargin) * GameVars.OneOverTileStep());
                this.m_idColResBeg = (int)((a.x + 0.5f - (float)this.m_leftMargin) * GameVars.OneOverTileStep());
                this.m_idColResEnd = (int)((a.x + a.width - 0.5f - (float)this.m_leftMargin) * GameVars.OneOverTileStep());
                if (this.m_idLineResBeg == this.m_idLineResEnd) {
                    a.addFlag(Actor.eSpecialFlag.eSpecialFlag_AlignedWithGrid);
                } else {
                    a.removeFlag(Actor.eSpecialFlag.eSpecialFlag_AlignedWithGrid);
                }
                boolean inc = false;
                int li = this.m_idLineResBeg;
                while (li <= this.m_idLineResEnd) {
                    int co = this.m_idColResBeg;
                    while (co <= this.m_idColResEnd) {
                        int count;
                        if (li >= 0 && li < this.m_renderingGridLineNum && co >= 0 && co < this.m_renderingGridColNum && (count = this.m_renderingGridLayerCount[li][co]) < this.m_renderingGridLayerNum) {
                            this.m_renderingGrid[li][co][count] = a;
                            inc = true;
                            this.m_renderingGridLayerCount[li][co] = ++count;
                        }
                        ++co;
                    }
                    ++li;
                }
                if (inc) {
                    ++this.m_numActorToRender;
                }
            }
        }
    }

    protected boolean _isAlignedWithGrid(Actor _actor) {
        return (_actor.y + _actor.height) % GameVars.OneOverTileStep() == 0.0f;
    }

    protected boolean _isNotAlignedActorPresentOnTopOfCell(Actor _actor, int _cellLi, int _cellCo) {
        if (--_cellLi >= 0) {
            int layCount = this.m_renderingGridLayerCount[_cellLi][_cellCo];
            int lay = 0;
            while (lay < layCount) {
                Actor a = this.m_renderingGrid[_cellLi][_cellCo][lay];
                if (a != null && a.equals(_actor)) {
                    return true;
                }
                ++lay;
            }
        }
        return false;
    }

    protected void _renderRenderingList(SpriteBatch spriteBatch) {
        int lastLi = this.m_renderingGridLineNum - 1;
        int lastCo = this.m_renderingGridColNum - 1;
        int li = lastLi;
        int co = lastCo;
        boolean bInterupt = false;
        boolean bLineIterupt = false;
        boolean bResetGridRendering = false;
        li = lastLi;
        co = lastCo;
        while (li >= 0) {
            co = lastCo;
            bInterupt = false;
            bLineIterupt = false;
            bResetGridRendering = false;
            while (!bInterupt && co >= 0) {
                int layCount = this.m_renderingGridLayerCount[li][co];
                if (layCount > 0) {
                    int lay = 0;
                    while (lay < layCount) {
                        Actor a = this.m_renderingGrid[li][co][lay];
                        if (a.hasFlag(Actor.eSpecialFlag.eSpecialFlag_AlignedWithGrid)) {
                            this._renderActor(a, spriteBatch);
                        } else if (a.hasFlag(Actor.eSpecialFlag.eSpecialFlag_NotRenderedYet)) {
                            if (this._isNotAlignedActorPresentOnTopOfCell(a, li, co)) {
                                bLineIterupt = true;
                                bInterupt = true;
                            } else if (this._renderActor(a, spriteBatch)) {
                                bResetGridRendering = true;
                                bInterupt = true;
                            }
                        }
                        ++lay;
                    }
                }
                --co;
            }
            if (bLineIterupt) {
                co = lastCo;
                --li;
                continue;
            }
            if (bResetGridRendering) {
                li = lastLi;
                co = lastCo;
                continue;
            }
            --li;
        }
        if (this.m_renderingOverAllList.size() > 0) {
            for (Actor oa : this.m_renderingOverAllList) {
                if (!oa.hasFlag(Actor.eSpecialFlag.eSpecialFlag_NotRenderedYet)) continue;
                oa.render(spriteBatch);
                oa.removeFlag(Actor.eSpecialFlag.eSpecialFlag_NotRenderedYet);
            }
        }
    }

    protected boolean _renderActor(Actor _actor, SpriteBatch spriteBatch) {
        if (_actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_NotRenderedYet)) {
            _actor.render(spriteBatch);
            _actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_NotRenderedYet);
            ++this.m_numActorRendered;
            return true;
        }
        return false;
    }

    public static enum SSSLayerType {
        SSSLayerType_None,
        SSSLayerType_Portal,
        SSSLayerType_Player,
        SSSLayerType_Background,
        SSSLayerType_Foreground,
        SSSLayerType_PieceProjection,
        SSSLayerType_BlocDelimiter,
        SSSLayerType_PassiveIsoRendering,
        SSSLayerType_ActiveIsoRendering,
        SSSLayerType_Physics,
        SSSLayerType_ParticleEffects,
        SSSLayerType_PostProcess,
        SSSLayerType_Vignettage,
        SSSLayerType_Hud,
        SSSLayerType_TiledBackground;

    }
}

