/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import SSS.API.GameAPIManager;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.TextDataBase;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.CheatSequence;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxText;

public class CheatCodeState
extends TemplateGameMenu {
    static float TxtCheatPercY = 0.2f;
    static float TxtCheatScale = 3.0f;
    FlxText m_txtCheat;
    int m_numCheatDisplayed = 0;
    boolean m_bReturnToMainRequest = false;
    ArrayList<CheatSequence> m_cheatSequences = new ArrayList(10);
    CallbackSimple m_onGoToMain = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            CheatCodeState.this._onGoToMain(_sender, _args);
        }
    };

    @Override
    public void create() {
        super.create();
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Quit, TemplateGameMenu.eButtonAction.NoAction, TemplateGameMenu.eButtonAction.NoAction);
        TextDataBase tdb = TextDataBase.Instance();
        this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), "", "");
        this.m_txtCheat = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtCheat.alignment = FlxText.FlxJustification.Center;
        this.m_txtCheat.scale(TxtCheatScale);
        this.m_txtCheat.text("Cheat");
        this.m_txtCheat.color(Color.Black());
        this.m_txtCheat.UseRounding(false);
        this.m_txtCheat.x = 0.0f;
        this.m_txtCheat.y = (float)FlxG.height * TxtCheatPercY - this.m_txtCheat.height * 0.5f;
        this.m_txtCheat.alpha(0.2f);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_txtCheat, 1.0f, 1.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this.add(this.m_txtCheat);
        this._buildCheatSequences();
    }

    protected void _buildCheatSequences() {
        CheatSequence flyMode = new CheatSequence("Right stick button fly Mode unlocked!", CheatSequence.eCheatId.CanUseFlyMode);
        flyMode.addButtonToSequence(Buttons.DPadUp);
        flyMode.addButtonToSequence(Buttons.Y);
        flyMode.addButtonToSequence(Buttons.DPadDown);
        flyMode.addButtonToSequence(Buttons.A);
        flyMode.addButtonToSequence(Buttons.DPadLeft);
        flyMode.addButtonToSequence(Buttons.X);
        flyMode.addButtonToSequence(Buttons.DPadRight);
        flyMode.addButtonToSequence(Buttons.B);
        this.m_cheatSequences.add(flyMode);
        CheatSequence unlockAll = new CheatSequence("All levels unlocked!", CheatSequence.eCheatId.UnlockAllLevel);
        unlockAll.addButtonToSequence(Buttons.Y);
        unlockAll.addButtonToSequence(Buttons.A);
        unlockAll.addButtonToSequence(Buttons.X);
        unlockAll.addButtonToSequence(Buttons.B);
        unlockAll.addButtonToSequence(Buttons.Y);
        unlockAll.addButtonToSequence(Buttons.A);
        unlockAll.addButtonToSequence(Buttons.X);
        unlockAll.addButtonToSequence(Buttons.B);
        this.m_cheatSequences.add(unlockAll);
        CheatSequence selectTheUnlockable = new CheatSequence("All BTMs unlocked!", CheatSequence.eCheatId.UnlockAllMainBTM);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadUp);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadDown);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadLeft);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadRight);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadUp);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadDown);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadLeft);
        selectTheUnlockable.addButtonToSequence(Buttons.DPadRight);
        this.m_cheatSequences.add(selectTheUnlockable);
        CheatSequence allStars = new CheatSequence("All Stars!", CheatSequence.eCheatId.UnlockAllMainPar);
        allStars.addButtonToSequence(Buttons.Y);
        allStars.addButtonToSequence(Buttons.A);
        allStars.addButtonToSequence(Buttons.X);
        allStars.addButtonToSequence(Buttons.B);
        allStars.addButtonToSequence(Buttons.B);
        allStars.addButtonToSequence(Buttons.A);
        allStars.addButtonToSequence(Buttons.X);
        allStars.addButtonToSequence(Buttons.Y);
        allStars.addButtonToSequence(Buttons.LeftShoulder);
        allStars.addButtonToSequence(Buttons.RightShoulder);
        this.m_cheatSequences.add(allStars);
        CheatSequence allTetrobotsUpdates = new CheatSequence("All Tetrobots updates!", CheatSequence.eCheatId.AllTetrobotUpdgrade);
        allTetrobotsUpdates.addButtonToSequence(Buttons.A);
        allTetrobotsUpdates.addButtonToSequence(Buttons.B);
        allTetrobotsUpdates.addButtonToSequence(Buttons.X);
        allTetrobotsUpdates.addButtonToSequence(Buttons.Y);
        allTetrobotsUpdates.addButtonToSequence(Buttons.A);
        allTetrobotsUpdates.addButtonToSequence(Buttons.B);
        allTetrobotsUpdates.addButtonToSequence(Buttons.X);
        allTetrobotsUpdates.addButtonToSequence(Buttons.Y);
        this.m_cheatSequences.add(allTetrobotsUpdates);
        CheatSequence resetGAmeAPI = new CheatSequence("Game API reset!", CheatSequence.eCheatId.GameAPIReset);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.A);
        resetGAmeAPI.addButtonToSequence(Buttons.RightShoulder);
        this.m_cheatSequences.add(resetGAmeAPI);
    }

    @Override
    public void update() {
        super.update();
        CheatSequence cs = null;
        int i = 0;
        while (i < this.m_cheatSequences.size()) {
            cs = this.m_cheatSequences.get(i);
            cs.update();
            if (cs.JustValidated()) {
                GameVars.CheatedSave(1);
                FlxG.flash.start(Color.Green(), 0.25f, null, true);
                FlxG.quake.start(0.01f, 0.25f);
                this._unlockDependingType(cs.CheatId());
                ++this.m_numCheatDisplayed;
                FlxText text = new FlxText(0.0f, 0.0f, FlxG.width);
                text.text(cs.ValidationText());
                text.alignment = FlxText.FlxJustification.Center;
                text.scale(2.0f);
                text.y = (float)this.m_numCheatDisplayed * (text.height + 20.0f) + this.m_txtCheat.y + this.m_txtCheat.height;
                this.add(text);
            }
            ++i;
        }
    }

    protected void _unlockDependingType(CheatSequence.eCheatId _cheatId) {
        switch (_cheatId) {
            case CanUseFlyMode: {
                GameVars.CheatCanFly(true);
                break;
            }
            case UnlockAllMainBTM: {
                LevelDataBase.Instance().cheatUnlockAllBtm("Main");
                break;
            }
            case UnlockAllMainPar: {
                LevelDataBase.Instance().cheatUnlockAllPar("Main");
                break;
            }
            case UnlockAllLevel: {
                LevelDataBase.Instance().cheatUnlockAllLevel("Main");
                LevelDataBase.Instance().cheatUnlockAllLevel("Bonus01");
                LevelDataBase.Instance().cheatUnlockAllLevel("Tracks");
                LevelDataBase.Instance().cheatUnlockAllLevel("Chocolate");
                break;
            }
            case AllTetrobotUpdgrade: {
                GameVars.PlayerCanDoLines(1);
                GameVars.PlayerCanDoPuzzle(1);
                Actor.SetCanBeDrilled(Actor.UpdateDrillStep03, !Actor.CanBeDrilled(Actor.UpdateDrillStep03));
                break;
            }
            case GameAPIReset: {
                GameAPIManager.GameAPI().ResetAllStats(true);
            }
        }
    }

    @Override
    protected void _onThanks() {
    }

    @Override
    protected void _onReturnPressed() {
        this.m_bLastEventProcessed = false;
        if (!this.m_bReturnToMainRequest) {
            this.m_bReturnToMainRequest = true;
            FlxG.flash.start(Color.White(), 0.5f, this.m_onGoToMain, true);
        }
    }

    @Override
    protected void _onSelectPressed() {
    }

    protected void _onGoToMain(Object _sender, Object _e) {
        FlxG.state(new MenuMainState(false, false));
    }
}

