/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import SSS.BTM.PlayState;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.SssGroup;
import SSS.States.BTM.LauncherState;
import SSS.States.BTM.LevelSelectionState;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.PauseFakeState;
import SSS.Tween.AnimationStage;
import SSS.Util.InputManager;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxState;

public class CinematicReplayState
extends FlxState {
    eSpecialFlag m_specialFlag = eSpecialFlag.None;
    AnimationStage m_cinematic = null;
    PauseFakeState m_pauseMenu;
    String m_cinematicId = null;
    String m_levelToLaunchAfterOrNil = null;
    LevelGroup m_group = null;
    SssGroup m_layerCinematic;
    SssGroup m_layerHud;
    boolean m_bPaused = false;
    boolean m_bSkip = false;
    boolean m_bSkipDone = false;
    FlxFadeListener m_skipFadeComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            CinematicReplayState.this._skipFadeComplete(_sender, _e);
        }
    };

    public CinematicReplayState(String _cinematicId, String _levelToLaunchAfterOrNil, eSpecialFlag _specialFlag, String _groupId) {
        LevelGroup lg = LevelDataBase.Instance().getLevelGroup(_groupId);
        this._construct(_cinematicId, _levelToLaunchAfterOrNil, _specialFlag, lg);
    }

    public CinematicReplayState(String _cinematicId, String _levelToLaunchAfterOrNil, eSpecialFlag _specialFlag, LevelGroup _group) {
        this._construct(_cinematicId, _levelToLaunchAfterOrNil, _specialFlag, _group);
    }

    protected void _construct(String _cinematicId, String _levelToLaunchAfterOrNil, eSpecialFlag _specialFlag, LevelGroup _group) {
        this.m_cinematicId = _cinematicId;
        this.m_levelToLaunchAfterOrNil = _levelToLaunchAfterOrNil;
        this.m_specialFlag = _specialFlag;
        this.m_group = _group;
    }

    @Override
    public void create() {
        this.m_layerCinematic = new SssGroup();
        this.add(this.m_layerCinematic);
        this.m_cinematic = new AnimationStage(this.m_layerCinematic);
        this.m_cinematic.load(this.m_cinematicId);
        this.m_layerHud = new SssGroup();
        this.add(this.m_layerHud);
        this.m_pauseMenu = new PauseFakeState(null, this);
        this.m_pauseMenu.create();
        this.m_pauseMenu.registerLayer();
        LevelInfo lvlInfo = LevelDataBase.Instance().getLevelInfo(this.m_cinematicId, this.m_group);
        if (lvlInfo != null) {
            lvlInfo.Unlocked(true);
            lvlInfo.BTMFound(true);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        this._checkPaused();
        this.m_pauseMenu.update();
        if (!this.m_bPaused) {
            this.m_cinematic.update();
        }
        if (this.m_cinematic.finished() || this.m_bSkipDone) {
            if (this.m_specialFlag == eSpecialFlag.ReturnToMainMenuOnFinish) {
                FlxG.state(new MenuMainState(true, false));
            } else if (this.m_levelToLaunchAfterOrNil != null) {
                LevelInfo lvlInfo = LevelDataBase.Instance().getLevelInfo(this.m_levelToLaunchAfterOrNil, this.m_group);
                if (lvlInfo.Cinematic()) {
                    LevelInfo lvlInfoNextLevel = LevelDataBase.Instance().getNextLevelInfoOrNil(lvlInfo.TargetLevelFile(), this.m_group);
                    FlxG.state(new CinematicReplayState(lvlInfo.TargetLevelFile(), lvlInfoNextLevel != null ? lvlInfoNextLevel.TargetLevelFile() : null, this.m_specialFlag, this.m_group));
                } else {
                    FlxG.state(new PlayState(LauncherState.PlayOnStart(), LauncherState.AllowEdit(), this.m_levelToLaunchAfterOrNil, this.m_group));
                }
            } else {
                FlxG.state(new LevelSelectionState(true, null, this.m_cinematicId));
            }
            if (this.m_cinematic.finished() && this.m_cinematicId.equals("CREDITS")) {
                AchievementManager.Instance().unlockAchievement("ACH_CREDITS");
            }
        }
    }

    protected void _checkPaused() {
        if (!this.m_bSkip && (InputManager.IsNewButtonPress(Buttons.Start) || !this.m_bPaused && InputManager.IsNewGuidePress() || InputManager.IsNewButtonPress(Buttons.A) || !this.m_bPaused && FlxG.justLostFocus() || this.m_bPaused && FlxG.justGainedFocus() || InputManager.IsLeftMouseButtonPress() || InputManager.IsNewKeyPress(Keys.Enter))) {
            this.m_pauseMenu.togglePause();
            this.m_bPaused = this.m_pauseMenu.Pause();
        }
    }

    public void onReturnPressed() {
        this._onReturnPressed();
    }

    protected void _onReturnPressed() {
        if (this.m_bPaused && !this.m_bSkip) {
            this.m_bSkip = true;
            FlxG.fade.start(Color.Black(), 0.5f, this.m_skipFadeComplete, true, true);
        }
    }

    protected void _skipFadeComplete(Object sender, Object e) {
        this.m_bSkipDone = true;
    }

    public static enum eSpecialFlag {
        None,
        ReturnToMainMenuOnFinish;

    }
}

