/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.GamePad;
import Microsoft.Xna.Framework.Input.GamePadItemState;
import Microsoft.Xna.Framework.Input.GamePadMapper;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.States.BTM.SettingsState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import org.flixel.data.FlxGamepad;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigureGamepadState
extends TemplateGameMenu {
    boolean[] m_buttonDownOld;
    boolean[] m_buttonDown;
    float[] m_povOld;
    float[] m_pov;
    float[] m_axisOld;
    float[] m_axis;
    boolean m_bFirstAxisEventToDiscard = true;
    boolean m_bDone = false;
    float m_timeBetweenChange = 0.0f;
    float m_minTimeBetweenChange = 0.26f;
    boolean m_bChangeMade = false;
    float InfoTxtPercY = 0.1f;
    FlxText m_infoTxt;
    FlxText m_subInfoTxt;
    float SubInfoTxtPercY = 0.15f;
    FlxText m_subInfoCurrentBindingTxt;
    float SubInfoCurrentBindingPercY = 0.77f;
    FlxText m_shortCutInfoTxt;
    float ShortCutInfoTxtPercY = 0.85f;
    Controller m_controllerToConfigure = null;
    int m_forceIndex = -1;
    Buttons m_currentButton;
    int m_curIdButtons = 0;
    int m_numButtons;
    FlxSprite m_gamepadSprite = null;
    FlxSprite m_gamepadCircleSprite = null;
    static Buttons[] XmlConfigButtonsOrder = new Buttons[]{Buttons.LeftThumbstickUp, Buttons.LeftThumbstickDown, Buttons.LeftThumbstickLeft, Buttons.LeftThumbstickRight, Buttons.RightThumbstickUp, Buttons.RightThumbstickDown, Buttons.RightThumbstickLeft, Buttons.RightThumbstickRight, Buttons.LeftTrigger, Buttons.RightTrigger, Buttons.DPadUp, Buttons.DPadDown, Buttons.DPadLeft, Buttons.DPadRight, Buttons.Start, Buttons.Back, Buttons.LeftStick, Buttons.RightStick, Buttons.LeftShoulder, Buttons.RightShoulder, Buttons.A, Buttons.B, Buttons.X, Buttons.Y};
    static Buttons[] ConfigButtonsOrder = new Buttons[]{Buttons.A, Buttons.B, Buttons.X, Buttons.Y, Buttons.Start, Buttons.Back, Buttons.DPadUp, Buttons.DPadDown, Buttons.DPadLeft, Buttons.DPadRight, Buttons.LeftThumbstickUp, Buttons.LeftThumbstickDown, Buttons.LeftThumbstickLeft, Buttons.LeftThumbstickRight, Buttons.RightThumbstickUp, Buttons.RightThumbstickDown, Buttons.RightThumbstickLeft, Buttons.RightThumbstickRight, Buttons.LeftShoulder, Buttons.RightShoulder, Buttons.LeftTrigger, Buttons.RightTrigger, Buttons.LeftStick, Buttons.RightStick};
    static boolean DefaultGamepadButtonsLoaded = false;
    static HashMap<Buttons, GamePadItemState.GamePadItemType> DefaultGamepadButtons = new HashMap<Buttons, GamePadItemState.GamePadItemType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Buttons.A, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.B, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.X, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.Y, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.Start, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.Back, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.DPadUp, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.DPadDown, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.DPadLeft, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.DPadRight, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftThumbstickUp, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftThumbstickDown, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftThumbstickLeft, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftThumbstickRight, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightThumbstickUp, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightThumbstickDown, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightThumbstickLeft, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightThumbstickRight, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftShoulder, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightShoulder, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftTrigger, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightTrigger, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.LeftStick, GamePadItemState.GamePadItemType.Button01);
            this.put(Buttons.RightStick, GamePadItemState.GamePadItemType.Button01);
        }
    };
    static Vector2[] HilightConfigButtonsOrderOffset = new Vector2[]{new Vector2(650.0f, 188.0f), new Vector2(694.0f, 149.0f), new Vector2(610.0f, 149.0f), new Vector2(650.0f, 107.0f), new Vector2(530.0f, 146.0f), new Vector2(448.0f, 146.0f), new Vector2(412.0f, 222.0f), new Vector2(412.0f, 319.0f), new Vector2(361.0f, 269.0f), new Vector2(462.0f, 269.0f), new Vector2(330.0f, 101.0f), new Vector2(330.0f, 194.0f), new Vector2(282.0f, 146.0f), new Vector2(377.0f, 145.0f), new Vector2(571.0f, 218.0f), new Vector2(571.0f, 314.0f), new Vector2(520.0f, 265.0f), new Vector2(619.0f, 265.0f), new Vector2(335.0f, 38.0f), new Vector2(641.0f, 38.0f), new Vector2(217.0f, 56.0f), new Vector2(764.0f, 54.0f), new Vector2(331.0f, 149.0f), new Vector2(572.0f, 267.0f)};

    @Override
    public void create() {
        FlxG.backColor = Color.Black();
        this._build();
    }

    protected void _build() {
        super.create();
        FlxGamepad.GamepadConnectedFlagMask(false);
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this._templateDefineKeysOverride(Keys.Tab);
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.ResetDefault, TemplateGameMenu.eButtonAction.NoAction);
        TextDataBase tdb = TextDataBase.Instance();
        this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_RESET"), "");
        this._loadDefaultControls();
        this.m_infoTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_infoTxt.alignment = FlxText.FlxJustification.Center;
        this.m_infoTxt.y = (float)FlxG.height * this.InfoTxtPercY;
        this.m_infoTxt.scale(2.0f);
        this.m_infoTxt.color(Color.Black());
        this.m_subInfoTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_subInfoTxt.alignment = FlxText.FlxJustification.Center;
        this.m_subInfoTxt.y = (float)FlxG.height * this.SubInfoTxtPercY;
        this.m_subInfoTxt.scale(2.0f);
        this.m_subInfoTxt.color(Color.Black());
        this.m_subInfoCurrentBindingTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_subInfoCurrentBindingTxt.alignment = FlxText.FlxJustification.Center;
        this.m_subInfoCurrentBindingTxt.y = (float)FlxG.height * this.SubInfoCurrentBindingPercY;
        this.m_subInfoCurrentBindingTxt.scale(1.5f);
        this.m_shortCutInfoTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_shortCutInfoTxt.alignment = FlxText.FlxJustification.Center;
        this.m_shortCutInfoTxt.y = (float)FlxG.height * this.ShortCutInfoTxtPercY;
        this.m_shortCutInfoTxt.scale(1.5f);
        this.m_infoTxt.text(tdb.getText("TXT_GAMEPAD_WIZ_PUSH_ANY"));
        this.m_tweenManager.ToAlpha((Tweenable)this.m_infoTxt, 0.2f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this.m_shortCutInfoTxt.text(tdb.getText("TXT_GAMEPAD_WIZ_INSTRUCTION"));
        this.m_shortCutInfoTxt.color(Color.YellowSub());
        this.m_tweenManager.ToAlpha((Tweenable)this.m_subInfoTxt, 0.2f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this.m_gamepadSprite = new FlxSprite();
        this.m_gamepadSprite.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Gamepad"));
        this.m_gamepadSprite.scrollFactor = Vector2.Zero();
        this.m_gamepadSprite.x = (float)FlxG.width * 0.5f - this.m_gamepadSprite.width * 0.5f;
        this.m_gamepadSprite.y = (float)FlxG.height * 0.5f - this.m_gamepadSprite.height * 0.5f;
        this.m_gamepadCircleSprite = new FlxSprite();
        this.m_gamepadCircleSprite.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Gamepad_highlight"));
        this.m_gamepadCircleSprite.scrollFactor = Vector2.Zero();
        this.m_gamepadCircleSprite.visible = false;
        this.add(this.m_gamepadSprite);
        this.add(this.m_gamepadCircleSprite);
        this.add(this.m_infoTxt);
        this.add(this.m_subInfoTxt);
        this.add(this.m_subInfoCurrentBindingTxt);
        this.add(this.m_shortCutInfoTxt);
    }

    protected void _loadDefaultControls() {
        if (!DefaultGamepadButtonsLoaded) {
            Element customGamepadMappingsElem;
            DefaultGamepadButtonsLoaded = true;
            Document doc = FlxG.Content().LoadXDocumentOutOfContent("config/KeyMapping");
            if (doc == null) {
                return;
            }
            NodeList customList = doc.getElementsByTagName("DefaultGamepadMappings");
            if (customList.getLength() > 0 && (customList = (customGamepadMappingsElem = (Element)customList.item(0)).getElementsByTagName("GamepadMappings")) != null && customList.getLength() > 0) {
                int os = 0;
                while (os < customList.getLength()) {
                    customGamepadMappingsElem = (Element)customList.item(os);
                    String osStr = customGamepadMappingsElem.getAttribute("os");
                    if (Utility.IsOs(osStr)) {
                        NodeList mappingElemNodeList = customGamepadMappingsElem.getElementsByTagName("GamepadMapping");
                        int i = 0;
                        while (i < mappingElemNodeList.getLength()) {
                            Element elemMapping = (Element)mappingElemNodeList.item(i);
                            String id = elemMapping.getAttribute("id");
                            Buttons btn = Buttons.valueOf(id);
                            String value = elemMapping.getAttribute("value");
                            GamePadItemState.GamePadItemType gamepadItemType = GamePadItemState.GamePadItemType.valueOf(value);
                            DefaultGamepadButtons.put(btn, gamepadItemType);
                            ++i;
                        }
                        break;
                    }
                    ++os;
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        this.m_timeBetweenChange -= FlxG.elapsed;
        if (!this.m_bDone) {
            if (this.m_controllerToConfigure == null) {
                this.m_forceIndex = -1;
                int cptValid = 0;
                int controllerToUse = -1;
                int i = 0;
                while (i < Controllers.getControllerCount()) {
                    Controller ctrl = Controllers.getController((int)i);
                    String name = ctrl.getName();
                    if (GamePad.Instance().isValidPartialGamepadName(name)) {
                        ++cptValid;
                        int btn = 0;
                        while (btn < ctrl.getButtonCount()) {
                            if (ctrl.isButtonPressed(btn) && GamePad.Instance().isValidPartialGamepadName(name)) {
                                controllerToUse = i;
                            }
                            ++btn;
                        }
                    }
                    ++i;
                }
                if (controllerToUse > -1) {
                    this.m_forceIndex = cptValid - 1;
                    this.m_controllerToConfigure = Controllers.getController((int)controllerToUse);
                    this.m_buttonDownOld = new boolean[this.m_controllerToConfigure.getButtonCount()];
                    Arrays.fill(this.m_buttonDownOld, false);
                    this.m_buttonDown = Arrays.copyOf(this.m_buttonDownOld, this.m_buttonDownOld.length);
                    this.m_povOld = new float[2];
                    Arrays.fill(this.m_povOld, 0.0f);
                    this.m_pov = Arrays.copyOf(this.m_povOld, this.m_povOld.length);
                    this.m_axisOld = new float[this.m_controllerToConfigure.getAxisCount()];
                    this.m_axis = Arrays.copyOf(this.m_axisOld, this.m_axisOld.length);
                    this.m_curIdButtons = 0;
                    this.m_numButtons = ConfigButtonsOrder.length;
                    this.m_currentButton = ConfigButtonsOrder[this.m_curIdButtons];
                    this.m_tweenManager.RemoveTweenable(this.m_infoTxt);
                    this.m_infoTxt.alpha(1.0f);
                    this._updateTexts();
                    this._updateButtonsState();
                    this._positionateHiligh();
                }
            } else {
                this._updateButtonsState();
                boolean nextStep = false;
                boolean nextStepPositive = true;
                boolean allowWrap = false;
                if (InputManager.IsNewKeyPress(Keys.Space) || this.m_currentButton == Buttons.BigButton) {
                    if (this._changeMapping(this.m_currentButton, GamePadItemState.GamePadItemType.None)) {
                        nextStep = true;
                    }
                } else if (InputManager.IsNewKeyPress(Keys.Right)) {
                    nextStep = true;
                    allowWrap = true;
                } else if (InputManager.IsNewKeyPress(Keys.Left)) {
                    nextStep = true;
                    nextStepPositive = false;
                    allowWrap = true;
                } else {
                    int idBtn = 0;
                    while (idBtn < this.m_controllerToConfigure.getButtonCount()) {
                        if (this._isNewButtonDown(idBtn) && this._changeMapping(this.m_currentButton, GamePadItemState.IdButtonToGamePadItemTypeButton.get(idBtn))) {
                            nextStep = true;
                            break;
                        }
                        ++idBtn;
                    }
                    this._updatePov();
                    int idPov = 0;
                    while (idPov < this.m_pov.length) {
                        if (this.m_pov[idPov] * this.m_pov[idPov] > 0.80999994f && this.m_povOld[idPov] != this.m_pov[idPov] && this._changeMapping(this.m_currentButton, this._determinePov(idPov, this.m_pov[idPov]))) {
                            nextStep = true;
                        }
                        ++idPov;
                    }
                    this._updateAxis();
                    if (this.m_bFirstAxisEventToDiscard) {
                        this.m_bFirstAxisEventToDiscard = false;
                    } else {
                        int axis = 0;
                        while (axis < this.m_controllerToConfigure.getAxisCount()) {
                            float threashValue = 0.64000005f;
                            float axisSquare = this.m_axis[axis] * this.m_axis[axis];
                            float axisOldSquare = this.m_axisOld[axis] * this.m_axisOld[axis];
                            if (axisSquare >= threashValue && this.m_axisOld[axis] != this.m_axis[axis] && this.m_axisOld[axis] != this.m_axis[axis] && axisOldSquare < threashValue && this._changeMapping(this.m_currentButton, this._determineAxis(axis, this.m_axis[axis], this.m_currentButton))) {
                                nextStep = true;
                            }
                            ++axis;
                        }
                    }
                }
                if (nextStep) {
                    int n = this.m_curIdButtons = nextStepPositive ? this.m_curIdButtons + 1 : this.m_curIdButtons - 1;
                    if (allowWrap) {
                        if (this.m_curIdButtons < 0) {
                            this.m_curIdButtons = ConfigButtonsOrder.length - 1;
                        } else if (this.m_curIdButtons >= ConfigButtonsOrder.length) {
                            this.m_curIdButtons = 0;
                        }
                    }
                    if (this.m_curIdButtons < 0) {
                        this.m_curIdButtons = 0;
                    } else if (this.m_curIdButtons < this.m_numButtons) {
                        this.m_currentButton = ConfigButtonsOrder[this.m_curIdButtons];
                        if (this.m_currentButton != Buttons.BigButton) {
                            this._updateTexts();
                            this._positionateHiligh();
                        }
                    } else {
                        this.m_bDone = true;
                    }
                }
            }
        }
        this.m_tweenManager.update();
        if (this.m_bDone) {
            if (this.m_bChangeMade) {
                this._writeConfigFile();
            }
            FlxGamepad.GamepadConnectedFlagMask(true);
            FlxG.state(new SettingsState());
            this.m_bDone = false;
        } else {
            FlxGamepad.GamepadConnectedFlagMask(false);
        }
    }

    protected void _positionateHiligh() {
        if (this.m_curIdButtons >= 0 && this.m_curIdButtons < HilightConfigButtonsOrderOffset.length) {
            this.m_gamepadCircleSprite.visible = true;
            this.m_tweenManager.RemoveTweenable(this.m_gamepadCircleSprite);
            this.m_gamepadCircleSprite.alpha(0.0f);
            this.m_gamepadCircleSprite.scale(2.0f);
            Vector2 offset = HilightConfigButtonsOrderOffset[this.m_curIdButtons];
            this.m_gamepadCircleSprite.x = offset.X + this.m_gamepadSprite.x - 5.0f;
            this.m_gamepadCircleSprite.y = offset.Y + this.m_gamepadSprite.y - 5.0f;
            float time = 0.5f;
            this.m_tweenManager.ToAlpha((Tweenable)this.m_gamepadCircleSprite, 1.0f, time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToScale((Tweenable)this.m_gamepadCircleSprite, Vector2.One(), time, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToScale((Tweenable)this.m_gamepadCircleSprite, new Vector2(1.1f), 1.0f, TweenManager.EaseType.EASE_INOUTSIN, time, TweenManager.LoopType.PingPong);
        } else {
            this.m_gamepadCircleSprite.visible = false;
        }
    }

    @Override
    protected void _onThanks() {
    }

    @Override
    protected void _onReturnPressed() {
        if (!InputManager.IsAnyGamepadButtonPressed()) {
            this.m_bDone = true;
        }
    }

    @Override
    protected void _onSelectPressed() {
        if (!InputManager.IsAnyGamepadButtonPressed()) {
            FlxG.flash.start(Color.White());
            for (Map.Entry<Buttons, GamePadItemState.GamePadItemType> mapping : DefaultGamepadButtons.entrySet()) {
                this._changeMapping(mapping.getKey(), mapping.getValue());
            }
            this._updateTexts();
        }
    }

    protected void _updateTexts() {
        TextDataBase tdb = TextDataBase.Instance();
        if (this.m_controllerToConfigure != null) {
            this.m_infoTxt.text(String.valueOf(tdb.getText("TXT_CONFIGURING")) + " " + this.m_controllerToConfigure.getName() + " (" + (this.m_curIdButtons + 1) + "/" + this.m_numButtons + ")");
        }
        if (this.m_currentButton != null) {
            this.m_subInfoTxt.text(String.valueOf(tdb.getText("TXT_PRESS_BTN_FOR")) + " " + (Object)((Object)this.m_currentButton));
            this.m_subInfoCurrentBindingTxt.text("(" + tdb.getText("TXT_ACTUAL_BINDING") + ": " + GamePadMapper.Instance().getGamePadItemState(this.m_currentButton).itemType().toString() + ")");
        }
    }

    protected void _updateButtonsState() {
        int i = 0;
        while (i < this.m_buttonDown.length) {
            this.m_buttonDownOld[i] = this.m_buttonDown[i];
            ++i;
        }
        int btn = 0;
        while (btn < this.m_controllerToConfigure.getButtonCount()) {
            this.m_buttonDown[btn] = this.m_controllerToConfigure.isButtonPressed(btn);
            ++btn;
        }
    }

    protected boolean _isNewButtonDown(int btnId) {
        return this.m_buttonDown[btnId] && !this.m_buttonDownOld[btnId];
    }

    protected void _updatePov() {
        int i = 0;
        while (i < this.m_povOld.length) {
            this.m_povOld[i] = this.m_pov[i];
            ++i;
        }
        this.m_pov[0] = this.m_controllerToConfigure.getPovX();
        this.m_pov[1] = this.m_controllerToConfigure.getPovY();
    }

    protected void _updateAxis() {
        int i = 0;
        while (i < this.m_axis.length) {
            this.m_axisOld[i] = this.m_axis[i];
            ++i;
        }
        int axis = 0;
        axis = 0;
        while (axis < this.m_controllerToConfigure.getAxisCount()) {
            this.m_axis[axis] = this.m_controllerToConfigure.getAxisValue(axis);
            ++axis;
        }
    }

    protected GamePadItemState.GamePadItemType _determinePov(int idPov, float value) {
        if (idPov == 0) {
            if (value < 0.0f) {
                return GamePadItemState.GamePadItemType.PovX_neg;
            }
            return GamePadItemState.GamePadItemType.PovX_pos;
        }
        if (value < 0.0f) {
            return GamePadItemState.GamePadItemType.PovY_neg;
        }
        return GamePadItemState.GamePadItemType.PovY_pos;
    }

    protected GamePadItemState.GamePadItemType _determineAxis(int idAxis, float axisValue, Buttons associatedButton) {
        GamePadItemState.GamePadItemType res = GamePadItemState.GamePadItemType.None;
        switch (idAxis) {
            case 0: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_01_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_01_neg;
                break;
            }
            case 1: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_02_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_02_neg;
                break;
            }
            case 2: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_03_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_03_neg;
                break;
            }
            case 3: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_04_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_04_neg;
                break;
            }
            case 4: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_05_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_05_neg;
                break;
            }
            case 5: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_06_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_06_neg;
                break;
            }
            case 6: {
                if (axisValue > 0.0f) {
                    res = GamePadItemState.GamePadItemType.Axis_07_pos;
                    break;
                }
                res = GamePadItemState.GamePadItemType.Axis_07_neg;
                break;
            }
            case 7: {
                res = axisValue > 0.0f ? GamePadItemState.GamePadItemType.Axis_08_pos : GamePadItemState.GamePadItemType.Axis_08_neg;
            }
        }
        return res;
    }

    protected void _writeConfigFile() {
        String gamepadName;
        Document doc = FlxG.Content().LoadXDocumentOutOfContent("config/KeyMapping");
        if (doc == null) {
            return;
        }
        NodeList customList = doc.getElementsByTagName("CustomGamepadMappings");
        Element customGamepadMappingsElem = null;
        if (customList != null && customList.getLength() > 0) {
            customGamepadMappingsElem = (Element)customList.item(0);
        } else {
            customGamepadMappingsElem = doc.createElement("CustomGamepadMappings");
            doc.appendChild(customGamepadMappingsElem);
        }
        NodeList allCustomMappingsList = customGamepadMappingsElem.getElementsByTagName("GamepadMappings");
        Element toUpdate = null;
        if (allCustomMappingsList != null && allCustomMappingsList.getLength() > 0) {
            int i = 0;
            while (i < allCustomMappingsList.getLength()) {
                Element temp = (Element)allCustomMappingsList.item(i);
                String configName = temp.getAttribute("name");
                if (configName != null && configName.equals(this.m_controllerToConfigure.getName())) {
                    toUpdate = temp;
                    break;
                }
                ++i;
            }
        }
        if (toUpdate != null) {
            customGamepadMappingsElem.removeChild(toUpdate);
        }
        Element newCustomGameMappings = doc.createElement("GamepadMappings");
        newCustomGameMappings.setAttribute("force", "0");
        newCustomGameMappings.setAttribute("name", this.m_controllerToConfigure.getName());
        newCustomGameMappings.setAttribute("os", Utility.GetOsType().toString());
        if (this.m_forceIndex > 0) {
            newCustomGameMappings.setAttribute("forceIndex", Integer.toString(this.m_forceIndex));
        }
        int i = 0;
        while (i < XmlConfigButtonsOrder.length) {
            Buttons btn = XmlConfigButtonsOrder[i];
            this._addMappingBinding(doc, newCustomGameMappings, btn.toString(), GamePadMapper.Instance().getGamePadItemState(btn).itemType().toString());
            ++i;
        }
        customGamepadMappingsElem.appendChild(newCustomGameMappings);
        if (this.m_controllerToConfigure != null && !(gamepadName = this.m_controllerToConfigure.getName().toLowerCase()).contains("virtual")) {
            NodeList elemValidsNamesList;
            NodeList gamepadValidNamesList = doc.getElementsByTagName("GamepadValidNames");
            Element gamepadValidNamesElem = null;
            if (gamepadValidNamesList != null && gamepadValidNamesList.getLength() > 0 && (elemValidsNamesList = (gamepadValidNamesElem = (Element)gamepadValidNamesList.item(0)).getElementsByTagName("Name")) != null && elemValidsNamesList.getLength() > 0) {
                boolean bfound = false;
                int i2 = 0;
                while (i2 < elemValidsNamesList.getLength()) {
                    Element temp = (Element)elemValidsNamesList.item(i2);
                    String validName = temp.getAttribute("value");
                    if (validName != null && validName.equals(gamepadName)) {
                        bfound = true;
                        break;
                    }
                    ++i2;
                }
                if (!bfound && gamepadValidNamesElem != null) {
                    Element newValidGamePadName = doc.createElement("Name");
                    newValidGamePadName.setAttribute("value", gamepadName);
                    gamepadValidNamesElem.appendChild(newValidGamePadName);
                }
            }
        }
        FlxG.Content().WriteXDocumentOutOfContent("config/KeyMapping", doc, true);
    }

    protected boolean _changeMapping(Buttons _button, GamePadItemState.GamePadItemType _item) {
        if (this.m_timeBetweenChange <= 0.0f) {
            GamePadItemState.GamePadItemType oldItem;
            this.m_timeBetweenChange = this.m_minTimeBetweenChange;
            if (!this.m_bChangeMade && (oldItem = GamePadMapper.Instance().getGamePadItemState(_button).itemType()) != _item) {
                this.m_bChangeMade = true;
            }
            GamePadMapper.Instance().changeMapping(_button, _item);
            return true;
        }
        return false;
    }

    protected void _addMappingBinding(Document doc, Element parent, String id, String value) {
        Element elemGamepadMapping = doc.createElement("GamepadMapping");
        elemGamepadMapping.setAttribute("id", id);
        elemGamepadMapping.setAttribute("value", value);
        parent.appendChild(elemGamepadMapping);
    }
}

