/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.States.BTM.SettingsState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import SSS.Util.MultipleLinesText;
import SSS.Util.Utility;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import org.flixel.data.FlxGamepad;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigureKeyboardState
extends TemplateGameMenu {
    boolean m_bDone = false;
    boolean m_bChangeMade = false;
    FlxText m_infoTxt;
    FlxText m_subInfoTxt;
    MultipleLinesText m_subInfoDetailTxt;
    FlxText m_subInfoCurrentBindingTxt;
    FlxText m_shortCutInfoTxt;
    Buttons m_currentButton;
    int m_curIdButtons = 0;
    int m_numButtons;
    boolean m_bWaitingForKey = false;
    Keys[] m_allKeys;
    float ScaleIconKey = 1.5f;
    FlxSprite m_iconKeyCurrent = null;
    FlxSprite m_iconKeyAsk = null;
    FlxText m_iconKeyCurrentTxt = null;
    FlxText m_iconKeyAskTxt = null;
    FlxText m_iconChevronTxt = null;
    FlxSprite m_cursorLeft;
    FlxSprite m_cursorRight;
    static Buttons[] XmlConfigButtonsOrder = new Buttons[]{Buttons.DPadUp, Buttons.DPadDown, Buttons.DPadLeft, Buttons.DPadRight, Buttons.Start, Buttons.Back, Buttons.LeftStick, Buttons.RightStick, Buttons.LeftShoulder, Buttons.RightShoulder, Buttons.A, Buttons.B, Buttons.X, Buttons.Y, Buttons.LeftTrigger, Buttons.RightTrigger, Buttons.RightThumbstickUp, Buttons.RightThumbstickDown, Buttons.RightThumbstickLeft, Buttons.RightThumbstickRight, Buttons.LeftThumbstickUp, Buttons.LeftThumbstickDown, Buttons.LeftThumbstickLeft, Buttons.LeftThumbstickRight};
    static Buttons[] ConfigButtonsOrder = new Buttons[]{Buttons.A, Buttons.B, Buttons.X, Buttons.Y, Buttons.Start, Buttons.Back, Buttons.DPadUp, Buttons.DPadDown, Buttons.DPadLeft, Buttons.DPadRight, Buttons.LeftThumbstickUp, Buttons.LeftThumbstickDown, Buttons.LeftThumbstickLeft, Buttons.LeftThumbstickRight, Buttons.RightThumbstickUp, Buttons.RightThumbstickDown, Buttons.RightThumbstickLeft, Buttons.RightThumbstickRight, Buttons.LeftShoulder, Buttons.RightShoulder, Buttons.LeftTrigger, Buttons.RightTrigger, Buttons.RightStick};
    static boolean DefaultKeysLoaded = false;
    static HashMap<Buttons, Keys> DefaultKeys = new HashMap<Buttons, Keys>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Buttons.A, Keys.Space);
            this.put(Buttons.B, Keys.W);
            this.put(Buttons.X, Keys.F);
            this.put(Buttons.Y, Keys.E);
            this.put(Buttons.Start, Keys.Escape);
            this.put(Buttons.Back, Keys.F1);
            this.put(Buttons.DPadUp, Keys.NumPad8);
            this.put(Buttons.DPadDown, Keys.NumPad2);
            this.put(Buttons.DPadLeft, Keys.NumPad4);
            this.put(Buttons.DPadRight, Keys.NumPad6);
            this.put(Buttons.LeftThumbstickUp, Keys.Up);
            this.put(Buttons.LeftThumbstickDown, Keys.Down);
            this.put(Buttons.LeftThumbstickLeft, Keys.Left);
            this.put(Buttons.LeftThumbstickRight, Keys.Right);
            this.put(Buttons.RightThumbstickUp, Keys.I);
            this.put(Buttons.RightThumbstickDown, Keys.K);
            this.put(Buttons.RightThumbstickLeft, Keys.L);
            this.put(Buttons.RightThumbstickRight, Keys.J);
            this.put(Buttons.LeftShoulder, Keys.R);
            this.put(Buttons.RightShoulder, Keys.T);
            this.put(Buttons.LeftTrigger, Keys.C);
            this.put(Buttons.RightTrigger, Keys.D);
            this.put(Buttons.LeftStick, Keys.LeftControl);
            this.put(Buttons.RightStick, Keys.RightControl);
        }
    };
    static String[] ConfigButtonDesc = new String[]{"TXT_FRIENDLY_A", "TXT_FRIENDLY_B", "TXT_FRIENDLY_X", "TXT_FRIENDLY_Y", "TXT_FRIENDLY_START", "TXT_FRIENDLY_BACK", "TXT_FRIENDLY_DPAD_UP", "TXT_FRIENDLY_DPAD_DOWN", "TXT_FRIENDLY_DPAD_LEFT", "TXT_FRIENDLY_DPAD_RIGHT", "TXT_FRIENDLY_LSTICK_UP", "TXT_FRIENDLY_LSTICK_DOWN", "TXT_FRIENDLY_LSTICK_LEFT", "TXT_FRIENDLY_LSTICK_RIGHT", "TXT_FRIENDLY_RSTICK_UP", "TXT_FRIENDLY_RSTICK_DOWN", "TXT_FRIENDLY_RSTICK_LEFT", "TXT_FRIENDLY_RSTICK_RIGHT", "TXT_FRIENDLY_LB", "TXT_FRIENDLY_RB", "TXT_FRIENDLY_LT", "TXT_FRIENDLY_RT", "TXT_FRIENDLY_RSTICK"};

    @Override
    public void create() {
        FlxG.backColor = Color.Black();
        this._build();
    }

    protected void _build() {
        super.create();
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this._templateDefineKeysOverride(Keys.Tab);
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.ResetDefault, TemplateGameMenu.eButtonAction.NoAction);
        TextDataBase tdb = TextDataBase.Instance();
        this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_RESET"), "");
        this._loadDefaultControls();
        this.m_infoTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_infoTxt.alignment = FlxText.FlxJustification.Center;
        this.m_infoTxt.y = (float)FlxG.height * 0.1f;
        this.m_infoTxt.scale(2.0f);
        this.m_infoTxt.color(Color.Black());
        this.m_subInfoTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_subInfoTxt.alignment = FlxText.FlxJustification.Center;
        this.m_subInfoTxt.y = (float)FlxG.height * 0.25f;
        this.m_subInfoTxt.scale(2.0f);
        this.m_subInfoDetailTxt = new MultipleLinesText();
        this.m_subInfoDetailTxt.Justification(FlxText.FlxJustification.Center);
        this.m_subInfoDetailTxt.x = (float)FlxG.width * 0.5f;
        this.m_subInfoDetailTxt.y = (float)FlxG.height * 0.35f;
        this.m_subInfoDetailTxt.scale(2.0f);
        this.m_subInfoCurrentBindingTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_subInfoCurrentBindingTxt.alignment = FlxText.FlxJustification.Center;
        this.m_subInfoCurrentBindingTxt.y = (float)FlxG.height * 0.6f;
        this.m_subInfoCurrentBindingTxt.scale(1.5f);
        this.m_shortCutInfoTxt = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_shortCutInfoTxt.alignment = FlxText.FlxJustification.Center;
        this.m_shortCutInfoTxt.y = (float)FlxG.height * 0.75f;
        this.m_shortCutInfoTxt.scale(1.5f);
        this.m_infoTxt.text(tdb.getText("TXT_KEYBOARD_CONFIG"));
        this.m_shortCutInfoTxt.text(tdb.getText("TXT_KEYBOARD_INSTRUCTIONS"));
        this.m_curIdButtons = 0;
        this.m_currentButton = ConfigButtonsOrder[this.m_curIdButtons];
        this.m_numButtons = ConfigButtonsOrder.length;
        this.m_allKeys = Keys.values();
        this.m_tweenManager.ToAlpha((Tweenable)this.m_subInfoTxt, 0.2f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this.m_iconKeyCurrent = new FlxSprite();
        this.m_iconKeyCurrent.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/keyboard_key"));
        this.m_iconKeyCurrent.scrollFactor = Vector2.Zero();
        this.m_iconKeyCurrent.scale(this.ScaleIconKey);
        this.m_iconKeyAsk = new FlxSprite();
        this.m_iconKeyAsk.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/keyboard_key"));
        this.m_iconKeyAsk.scrollFactor = Vector2.Zero();
        this.m_iconKeyAsk.scale(this.ScaleIconKey);
        this.m_iconKeyCurrentTxt = new FlxText(0.0f, 0.0f, 150.0f);
        this.m_iconKeyCurrentTxt.alignment = FlxText.FlxJustification.Center;
        this.m_iconKeyCurrentTxt.color(Color.Black());
        this.m_iconKeyAskTxt = new FlxText(0.0f, 0.0f, 150.0f);
        this.m_iconKeyAskTxt.alignment = FlxText.FlxJustification.Center;
        this.m_iconKeyAskTxt.text("?");
        this.m_iconKeyAskTxt.scale(Utility.GetTextButtonScale(this.m_iconKeyAsk, this.m_iconKeyAskTxt));
        this.m_iconKeyAskTxt.color(Color.Black());
        this.m_iconChevronTxt = new FlxText(0.0f, 0.0f, 150.0f);
        this.m_iconChevronTxt.alignment = FlxText.FlxJustification.Center;
        this.m_iconChevronTxt.text(">>");
        this.m_iconChevronTxt.scale(2.0f);
        this.m_iconChevronTxt.color(Color.Black());
        this.m_iconChevronTxt.x = (float)FlxG.width * 0.5f - this.m_iconChevronTxt.width * 0.5f;
        this.m_iconChevronTxt.y = (float)FlxG.height * 0.5f - this.m_iconChevronTxt.height * 0.5f;
        this.m_cursorLeft = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorLeft.play("pointLeft");
        this.add(this.m_cursorLeft);
        this.m_cursorRight = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorRight.play("pointRight");
        this.add(this.m_cursorRight);
        this.m_tweenManager.ToScale((Tweenable)this.m_cursorLeft, new Vector2(1.1f), 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this.m_tweenManager.ToScale((Tweenable)this.m_cursorRight, new Vector2(1.1f), 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this._updateTexts();
        this.add(this.m_iconChevronTxt);
        this.add(this.m_iconKeyCurrent);
        this.add(this.m_iconKeyAsk);
        this.add(this.m_iconKeyCurrentTxt);
        this.add(this.m_iconKeyAskTxt);
        this.add(this.m_infoTxt);
        this.add(this.m_subInfoTxt);
        this.add(this.m_subInfoDetailTxt);
        this.add(this.m_subInfoCurrentBindingTxt);
        this.add(this.m_shortCutInfoTxt);
    }

    protected void _loadDefaultControls() {
        if (!DefaultKeysLoaded) {
            DefaultKeysLoaded = true;
            Document doc = FlxG.Content().LoadXDocumentOutOfContent("config/KeyMapping");
            if (doc == null) {
                return;
            }
            NodeList customList = doc.getElementsByTagName("DefaultKeyboardMappings");
            Element customGamepadMappingsElem = null;
            if (customList != null && customList.getLength() > 0) {
                customGamepadMappingsElem = (Element)customList.item(0);
                NodeList mappingElemNodeList = customGamepadMappingsElem.getElementsByTagName("Mapping");
                int i = 0;
                while (i < mappingElemNodeList.getLength()) {
                    Element elemMapping = (Element)mappingElemNodeList.item(i);
                    String id = elemMapping.getAttribute("id");
                    Buttons btn = Buttons.valueOf(id);
                    String value = elemMapping.getAttribute("value");
                    Keys key = Keys.valueOf(value);
                    DefaultKeys.put(btn, key);
                    ++i;
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        if (!this.m_bDone) {
            boolean nextStep = false;
            boolean nextStepPositive = true;
            if (this.m_bWaitingForKey) {
                int i = 0;
                while (i < this.m_allKeys.length) {
                    Keys key = this.m_allKeys[i];
                    if (InputManager.IsNewKeyPress(key)) {
                        this._changeMapping(this.m_currentButton, key);
                        this.m_bWaitingForKey = false;
                        this._updateTexts();
                    }
                    ++i;
                }
            } else if (InputManager.IsNewKeyPress(Keys.Space)) {
                this._changeMapping(this.m_currentButton, Keys.None);
                this._updateTexts();
            } else if (InputManager.IsNewKeyPress(Keys.Enter)) {
                this.m_bWaitingForKey = true;
                this._updateTexts();
            } else if (InputManager.IsNewKeyPress(Keys.Right)) {
                nextStep = true;
            } else if (InputManager.IsNewKeyPress(Keys.Left)) {
                nextStep = true;
                nextStepPositive = false;
            }
            if (nextStep) {
                int n = this.m_curIdButtons = nextStepPositive ? this.m_curIdButtons + 1 : this.m_curIdButtons - 1;
                if (this.m_curIdButtons < 0) {
                    this.m_curIdButtons = ConfigButtonsOrder.length - 1;
                } else if (this.m_curIdButtons >= ConfigButtonsOrder.length) {
                    this.m_curIdButtons = 0;
                }
                if (this.m_curIdButtons < this.m_numButtons) {
                    this.m_currentButton = ConfigButtonsOrder[this.m_curIdButtons];
                    if (this.m_currentButton != Buttons.BigButton) {
                        this._updateTexts();
                    }
                } else {
                    this.m_bDone = true;
                }
            }
        }
        this.m_tweenManager.update();
        if (this.m_bDone) {
            if (this.m_bChangeMade) {
                this._writeConfigFile();
            }
            FlxGamepad.GamepadConnectedFlagMask(false);
            FlxG.state(new SettingsState());
            this.m_bDone = false;
        }
    }

    @Override
    protected void _onThanks() {
    }

    @Override
    protected void _onReturnPressed() {
        if (!this.m_bWaitingForKey) {
            this.m_bDone = true;
        }
    }

    @Override
    protected void _onSelectPressed() {
        if (!this.m_bWaitingForKey && !InputManager.IsKeyDown(Keys.Enter)) {
            FlxG.flash.start(Color.White());
            for (Map.Entry<Buttons, Keys> keys : DefaultKeys.entrySet()) {
                InputManager.ChangeMappingKey(keys.getKey(), keys.getValue());
            }
            this._updateTexts();
        }
    }

    protected void _updateTexts() {
        TextDataBase tdb = TextDataBase.Instance();
        this.m_infoTxt.text(String.valueOf(tdb.getText("TXT_KEYBOARD_CONFIGURING")) + " (" + (this.m_curIdButtons + 1) + "/" + this.m_numButtons + ")");
        if (this.m_bWaitingForKey) {
            this.m_subInfoTxt.text(String.valueOf(tdb.getText("TXT_PRESS_KEY_FOR")) + " ");
            this.m_subInfoDetailTxt.changeText(TextDataBase.Instance().getText(ConfigButtonDesc[this.m_curIdButtons]));
        } else {
            this.m_subInfoTxt.text(String.valueOf(tdb.getText("TXT_PRESS_ENTER_TO_RECONFIGURE")) + " ");
            this.m_subInfoDetailTxt.changeText(TextDataBase.Instance().getText(ConfigButtonDesc[this.m_curIdButtons]));
        }
        this.m_subInfoCurrentBindingTxt.text("(" + tdb.getText("TXT_DEFAULT_BINDING") + ": " + DefaultKeys.get((Object)this.m_currentButton).toString() + ")");
        this.m_shortCutInfoTxt.visible = !this.m_bWaitingForKey;
        this._updateIconKey();
    }

    protected void _positionnateIconKey() {
        if (this.m_bWaitingForKey) {
            if (!this.m_iconKeyAsk.visible) {
                this.m_iconKeyAsk.visible = true;
                this.m_iconKeyAsk.scale(this.ScaleIconKey);
                this.m_tweenManager.ToScale((Tweenable)this.m_iconKeyAsk, new Vector2(this.ScaleIconKey * 1.05f), 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
            }
            this.m_iconKeyAskTxt.visible = true;
            this.m_iconChevronTxt.visible = true;
            this.m_iconKeyCurrent.x = (float)FlxG.width * 0.4f - this.m_iconKeyCurrent.width * 0.5f;
            this.m_iconKeyCurrent.y = (float)FlxG.height * 0.5f - this.m_iconKeyCurrent.height * 0.5f;
            this.m_iconKeyCurrentTxt.x = this.m_iconKeyCurrent.x + this.m_iconKeyCurrent.width * 0.5f - this.m_iconKeyCurrentTxt.width * 0.5f;
            this.m_iconKeyCurrentTxt.y = this.m_iconKeyCurrent.y + this.m_iconKeyCurrent.height * 0.5f - this.m_iconKeyCurrentTxt.height * 0.5f;
            this.m_iconKeyCurrentTxt.y -= 28.0f * this.m_iconKeyCurrentTxt.scale();
            this.m_iconKeyAsk.x = (float)FlxG.width * 0.6f - this.m_iconKeyAsk.width * 0.5f;
            this.m_iconKeyAsk.y = (float)FlxG.height * 0.5f - this.m_iconKeyAsk.height * 0.5f;
            this.m_iconKeyAskTxt.x = this.m_iconKeyAsk.x + this.m_iconKeyAsk.width * 0.5f - this.m_iconKeyAskTxt.width * 0.5f;
            this.m_iconKeyAskTxt.y = this.m_iconKeyAsk.y + this.m_iconKeyAsk.height * 0.5f - this.m_iconKeyAskTxt.height * 0.5f;
            this.m_iconKeyAskTxt.y -= 28.0f * this.m_iconKeyAskTxt.scale();
            this.m_cursorLeft.visible = false;
            this.m_cursorRight.visible = false;
        } else {
            if (this.m_iconKeyAsk.visible) {
                this.m_iconKeyAsk.visible = false;
                this.m_iconKeyAsk.scale(this.ScaleIconKey);
                this.m_tweenManager.RemoveTweenable(this.m_iconKeyAsk);
            }
            this.m_iconKeyAskTxt.visible = false;
            this.m_iconChevronTxt.visible = false;
            this.m_iconKeyCurrent.x = (float)FlxG.width * 0.5f - this.m_iconKeyCurrent.width * 0.5f;
            this.m_iconKeyCurrent.y = (float)FlxG.height * 0.5f - this.m_iconKeyCurrent.height * 0.5f;
            this.m_iconKeyCurrentTxt.x = this.m_iconKeyCurrent.x + this.m_iconKeyCurrent.width * 0.5f - this.m_iconKeyCurrentTxt.width * 0.5f;
            this.m_iconKeyCurrentTxt.y = this.m_iconKeyCurrent.y + this.m_iconKeyCurrent.height * 0.5f - this.m_iconKeyCurrentTxt.height * 0.5f;
            this.m_iconKeyCurrentTxt.y -= 28.0f * this.m_iconKeyCurrentTxt.scale();
            this.m_cursorLeft.x = this.m_iconKeyCurrent.x - this.m_cursorLeft.width;
            this.m_cursorLeft.y = this.m_iconKeyCurrent.y + this.m_iconKeyCurrent.height * 0.5f - this.m_cursorLeft.height * 0.5f;
            this.m_cursorLeft.visible = true;
            this.m_cursorRight.x = this.m_iconKeyCurrent.x + this.m_iconKeyCurrent.width;
            this.m_cursorRight.y = this.m_cursorLeft.y;
            this.m_cursorRight.visible = true;
        }
    }

    protected void _updateIconKey() {
        if (this.m_iconKeyCurrentTxt.scale() != 1.0f) {
            this.m_iconKeyCurrentTxt.scale(1.0f);
        }
        this.m_iconKeyCurrentTxt.text(InputManager.GetMappingKeyForButton(this.m_currentButton).toString());
        float scale = Utility.GetTextButtonScale(this.m_iconKeyCurrent, this.m_iconKeyCurrentTxt);
        this.m_iconKeyCurrentTxt.scale(scale);
        this._positionnateIconKey();
    }

    protected void _writeConfigFile() {
        Document doc = FlxG.Content().LoadXDocumentOutOfContent("config/KeyMapping");
        if (doc == null) {
            return;
        }
        NodeList customList = doc.getElementsByTagName("CustomKeyboardMappings");
        Element customGamepadMappingsElem = null;
        if (customList != null && customList.getLength() > 0) {
            customGamepadMappingsElem = (Element)customList.item(0);
            NodeList mappingElemNodeList = customGamepadMappingsElem.getElementsByTagName("Mapping");
            int i = 0;
            while (i < mappingElemNodeList.getLength()) {
                Element elemMapping = (Element)mappingElemNodeList.item(i);
                String id = elemMapping.getAttribute("id");
                Buttons btn = Buttons.valueOf(id);
                String attrib = InputManager.GetMappingKeyForButton(btn).toString();
                elemMapping.setAttribute("value", attrib);
                ++i;
            }
        } else {
            customGamepadMappingsElem = doc.createElement("CustomKeyboardMappings");
            doc.appendChild(customGamepadMappingsElem);
        }
        FlxG.Content().WriteXDocumentOutOfContent("config/KeyMapping", doc, true);
    }

    protected void _changeMapping(Buttons _button, Keys key) {
        Keys oldKey;
        if (!this.m_bChangeMade && (oldKey = InputManager.GetMappingKeyForButton(_button)) != key) {
            this.m_bChangeMade = true;
        }
        InputManager.ChangeMappingKey(_button, key);
    }

    protected void _addMappingBinding(Document doc, Element parent, String id, String value) {
        Element elemGamepadMapping = doc.createElement("Mapping");
        elemGamepadMapping.setAttribute("id", id);
        elemGamepadMapping.setAttribute("value", value);
        parent.appendChild(elemGamepadMapping);
    }
}

