/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Keys;
import SSS.Level;
import SSS.Managers.BTM.Dialog.Dialog;
import SSS.Managers.BTM.DialogDataBase;
import SSS.Managers.BTM.DialogManager;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.States.BTM.LauncherState;
import SSS.Util.InputManager;
import SSS.Util.MultipleLinesText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.flixel.FlxText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class DialogViewerState
extends FlxState {
    protected static int STEP_SKIP = 10;
    protected static int STEP_NEXT = 1;
    DialogManager m_dialogManager;
    HashMap<String, Dialog> m_allDialogs;
    ArrayList<String> m_allDialogsID;
    int m_currentDialog = 0;
    int m_currentStepText = -1;
    boolean m_bFirstUpdate = true;
    MultipleLinesText m_info;
    MultipleLinesText m_infoTextID;
    boolean m_bNeedRefreshInfo = false;
    boolean m_bDirectSkipToGame = false;
    String m_langageID = "";
    FlxSprite m_background;
    FlxText m_F1Txt;
    FlxText m_helpTxt;
    boolean m_bLastManagerInactiveFlag = true;

    @Override
    public void create() {
        FlxG.backColor = Color.Black();
        this._build();
    }

    protected void _build() {
        MusicManager.Instance().playTracks(null, null, 1.0f, true);
        this._determineLangageID();
        Level fakeLevel = new Level(true);
        this.m_dialogManager = new DialogManager(fakeLevel);
        this.m_allDialogs = DialogDataBase.Instance().DialogDataBaseValues();
        this.m_allDialogsID = new ArrayList();
        for (Map.Entry<String, Dialog> dialog : this.m_allDialogs.entrySet()) {
            this.m_allDialogsID.add(dialog.getKey());
        }
        this.add(fakeLevel.LayerHud());
        this.m_info = new MultipleLinesText();
        this.m_info.initAttributes("", Color.White(), (float)FlxG.width * 0.5f, FlxG.height - 150, 2.5f, 1.0f, 1.0f);
        this.m_info.Justification(FlxText.FlxJustification.Center);
        this.add(this.m_info);
        this.m_infoTextID = new MultipleLinesText();
        this.m_infoTextID.initAttributes("", Color.White(), (float)FlxG.width * 0.5f, FlxG.height - 50, 2.5f, 1.0f, 1.0f);
        this.m_infoTextID.Justification(FlxText.FlxJustification.Center);
        this.add(this.m_infoTextID);
        this.m_background = new FlxSprite();
        this.m_background.createGraphic(FlxG.width, FlxG.height, Color.Gray());
        this.m_background.alpha(0.8f);
        this.m_background.visible = false;
        this.add(this.m_background);
        this.m_F1Txt = new FlxText(20.0f, 20.0f, 200.0f, "F1: Help");
        this.m_F1Txt.alignment = FlxText.FlxJustification.Left;
        this.m_F1Txt.scale(1.5f);
        this.m_F1Txt.visible = true;
        this.add(this.m_F1Txt);
        String helpContent = "HELP\nF1: Toggle this help\nEnter: Restart the current dialog\nSpace: Next step into not automatic dialog\nLeft/Right Arrows: Previous/Next dialog\nUp/Down Arrows: Skip +10/-10 dialogs\nControl+R: Reload (text content, language switch), ALSO works in game menus\nChange language: edit the 'TestLanguage.xml' file and Reload\nChange texts: edit the 'Texts.xml' file and Reload\nControl+Enter: Launch the game with the current language (and use Reload shortcut in menus)\nESC: Exit the editor";
        this.m_helpTxt = new FlxText(20.0f, 20.0f, (float)FlxG.width - 40.0f, helpContent);
        this.m_helpTxt.scale(1.5f);
        this.m_helpTxt.alignment = FlxText.FlxJustification.Left;
        this.m_helpTxt.visible = false;
        this.add(this.m_helpTxt);
        this._updateInfo();
    }

    protected void _determineLangageID() {
        Document doc = FlxG.Content().LoadXDocumentOutOfContent("DialogViewerData/TestLanguage");
        if (doc != null) {
            NodeList directlySkipToGame;
            NodeList languages = doc.getElementsByTagName("language");
            if (languages != null && languages.getLength() > 0) {
                Element langElem = (Element)languages.item(0);
                this.m_langageID = langElem.getAttribute("value");
                if (!this.m_langageID.equals(TextDataBase.Instance().LangageId())) {
                    TextDataBase.Instance().LangageId(this.m_langageID, false);
                }
            }
            if ((directlySkipToGame = doc.getElementsByTagName("directlySkipToGame")) != null && directlySkipToGame.getLength() > 0) {
                Element directlySkipToGameElem = (Element)directlySkipToGame.item(0);
                String directlySkipToGameStr = directlySkipToGameElem.getAttribute("value");
                this.m_bDirectSkipToGame = directlySkipToGameStr != null && !directlySkipToGameStr.equals("0");
            }
        }
    }

    protected void _updateInfo() {
        String currentID = this.m_allDialogsID.get(this.m_currentDialog);
        if (this.m_allDialogs.containsKey(currentID)) {
            Dialog dialog = DialogDataBase.Instance().getDialog(currentID);
            boolean needValidation = dialog.NeedValidation();
            int steps = dialog.DialogSteps().size();
            if (this.m_dialogManager.isManagerInactive()) {
                this.m_info.changeText("Just played dialog \"" + dialog.Id() + "\" (" + (this.m_currentDialog + 1) + "/" + this.m_allDialogsID.size() + ")" + "[r]" + (needValidation ? "dialog requiring validation" : "dialog auto") + " with " + steps + " steps" + "[r](Press Enter to restart)");
            } else {
                this.m_info.changeText("Playing dialog \"" + dialog.Id() + "\" (" + (this.m_currentDialog + 1) + "/" + this.m_allDialogsID.size() + ")" + "[r]" + (needValidation ? "dialog requiring validation" : "dialog auto") + " with " + steps + " steps");
            }
            this._updateInfoTextID();
        }
    }

    protected void _updateInfoTextID() {
        Dialog dialog;
        String currentID = this.m_allDialogsID.get(this.m_currentDialog);
        if (this.m_allDialogs.containsKey(currentID) && (dialog = DialogDataBase.Instance().getDialog(currentID)) != null) {
            this.m_currentStepText = this.m_dialogManager.getDialogStep();
            int numDialogStep = this.m_dialogManager.getNumDialogStep();
            if (this.m_currentStepText < numDialogStep) {
                String textID = dialog.DialogSteps().get(this.m_currentStepText).TextId();
                this.m_infoTextID.changeText("current text: " + textID + " (" + (this.m_currentStepText + 1) + "/" + numDialogStep + ")");
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        if (this.m_bDirectSkipToGame) {
            this._switchToGame();
            return;
        }
        if (this.m_bFirstUpdate) {
            this.m_bFirstUpdate = false;
            this._reload();
            this._forcePlayCurrentDialog();
        }
        if (!this._isHelpVisible()) {
            this.m_dialogManager.update();
        }
        this._updateInputs();
        this._updateInfoTextID();
    }

    protected void _updateInputs() {
        if (InputManager.IsNewKeyPress(Keys.F1)) {
            this._toggleHelpVisibility();
        }
        if (InputManager.IsNewKeyPress(Keys.R) && (InputManager.IsKeyDown(Keys.LeftControl) || InputManager.IsKeyDown(Keys.RightControl))) {
            this._reload();
        } else if (InputManager.IsNewKeyPress(Keys.Up)) {
            this._stepDialog(STEP_SKIP);
        } else if (InputManager.IsNewKeyPress(Keys.Down)) {
            this._stepDialog(-STEP_SKIP);
        } else if (InputManager.IsNewKeyPress(Keys.Left)) {
            this._stepDialog(-STEP_NEXT);
        } else if (InputManager.IsNewKeyPress(Keys.Right)) {
            this._stepDialog(STEP_NEXT);
        } else if (InputManager.IsNewKeyPress(Keys.Enter)) {
            this._forcePlayCurrentDialog();
        } else if (InputManager.IsNewKeyPress(Keys.Escape)) {
            FlxG.Game.Exit();
        }
        if (this.m_bLastManagerInactiveFlag != this.m_dialogManager.isManagerInactive()) {
            this._updateInfo();
        }
        this.m_bLastManagerInactiveFlag = this.m_dialogManager.isManagerInactive();
        if (this.m_bNeedRefreshInfo) {
            this._forcePlayCurrentDialog();
            this._updateInfo();
            this.m_bNeedRefreshInfo = false;
        }
        if (InputManager.IsNewKeyPress(Keys.Enter) && (InputManager.IsKeyDown(Keys.LeftControl) || InputManager.IsKeyDown(Keys.RightControl))) {
            this._switchToGame();
        }
    }

    protected void _switchToGame() {
        MACRO.DIALOG_VIEWER = false;
        MACRO.LOCALISATION_TESTER = true;
        FlxG.state(new LauncherState(true));
    }

    protected void _toggleHelpVisibility() {
        boolean bNextVisible;
        this.m_background.visible = bNextVisible = !this.m_background.visible;
        this.m_helpTxt.visible = bNextVisible;
        this.m_F1Txt.visible = !bNextVisible;
    }

    protected boolean _isHelpVisible() {
        return this.m_background.visible;
    }

    protected void _reload() {
        this._determineLangageID();
        TextDataBase.Instance().reload();
        this.m_dialogManager.forceRefresh();
    }

    protected void _stepDialog(int step) {
        this.m_bNeedRefreshInfo = true;
        this.m_currentDialog += step;
        if (this.m_currentDialog < 0) {
            this.m_currentDialog = (this.m_allDialogsID.size() + this.m_currentDialog) % this.m_allDialogsID.size();
        } else if (this.m_currentDialog >= this.m_allDialogsID.size()) {
            this.m_currentDialog %= this.m_allDialogsID.size();
        }
    }

    protected void _forcePlayCurrentDialog() {
        this.m_dialogManager.stopDialog();
        this.m_dialogManager.startDialog(this.m_allDialogsID.get(this.m_currentDialog), null, null, null);
    }
}

