/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.API.GameAPIManager;
import SSS.BTM.GameVars;
import SSS.BTM.PlayState;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.DialogDataBase;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.SaveManager;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.FileManager;
import SSS.Managers.MusicManager;
import SSS.States.BTM.CameraTestState;
import SSS.States.BTM.DialogViewerState;
import SSS.States.BTM.MenuMainState;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import SSS.Util.MultipleLinesText;
import SSS.Util.Utility;
import java.util.HashMap;
import java.util.UUID;
import org.flixel.FlxG;
import org.flixel.FlxSoundManager;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.flixel.FlxText;
import org.flixel.data.FlxGamepad;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import precompiler.MACRO;

public class LauncherState
extends FlxState {
    HashMap<String, String> Keys = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("22b5976a-f76e-4789-9ccf-bc6566680b1a", "Swing Swing Submarine - Internal use only");
            this.put("8162d777-ab8d-44e6-b26b-772e4e403138", "Swing Swing Submarine - Nolife version - For evaluation purpose only");
            this.put("e2a48c3a-6dbe-4faa-a7de-9a2b4c86afd2", "Swing Swing Submarine - Une version pour Simon, tiens, oh! une rime!");
            this.put("ad3cdfc2-7524-4b74-b9c9-90e67ccd2527", "Swing Swing Submarine - Playtest version 1.0");
        }
    };
    String m_launcherFilename = "sss/editor/launcher";
    boolean m_bWaitForInputKey = false;
    static boolean m_bPlayOnStart = true;
    static boolean m_bAllowEdit = false;
    boolean m_bValidDone = false;
    boolean m_bLoadSaveGameTriggered = false;
    boolean m_bLoadSaveGameDone = false;
    boolean m_bValidKey = false;
    boolean m_bUseHudMenu = false;
    String m_sequence = "";
    FlxText m_bottomText;
    FlxText m_pressAny;
    FlxText m_loadingText;
    FlxSprite m_background;
    FlxSprite m_frame;
    static float FrameInitScale = 1.2f;
    static float FrameFinalScale = 1.0f;
    FlxSprite m_logo = null;
    FlxSprite m_logoLoading = null;
    static float MediumLogoScaleBeginTween = 0.2f;
    static float MediumLogoPosPercX = 0.5f;
    static float MediumLogoPosPercY = 0.2f;
    boolean m_bSndTrackLaunched = false;
    TweenManager m_tweenManager;
    Thread m_thread = null;
    boolean m_bLoadingDone = false;
    boolean m_bSkipLoading = false;

    public static boolean PlayOnStart() {
        return m_bPlayOnStart;
    }

    public static boolean AllowEdit() {
        return m_bAllowEdit || MACRO.ALLOW_EDIT_FORCE;
    }

    public LauncherState() {
    }

    public LauncherState(boolean _bSkipLoading) {
        this.m_bSkipLoading = _bSkipLoading;
    }

    protected void _build() {
        Utility.DetermineOsName();
        this.m_background = new FlxSprite();
        this.m_background.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/cinematics/bg3"), false);
        this.m_background.x = (float)FlxG.width * 0.5f - this.m_background.width * 0.5f;
        this.m_background.y = (float)FlxG.height * 0.5f - this.m_background.height * 0.5f;
        this.add(this.m_background);
        this.m_frame = new FlxSprite();
        this.m_frame.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_cadre"), false);
        this.m_frame.x = (float)FlxG.width * 0.5f - this.m_frame.width * 0.5f;
        this.m_frame.y = (float)FlxG.height * 0.5f - this.m_frame.height * 0.5f;
        this.m_frame.alpha(0.0f);
        this.add(this.m_frame);
        this.m_bottomText = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_bottomText.text("");
        this.m_bottomText.scale(2.0f);
        this.m_bottomText.y = (float)FlxG.height - this.m_bottomText.height * 3.0f;
        this.m_pressAny = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_pressAny.scale(3.0f);
        this.m_pressAny.y = (float)FlxG.height * 0.5f - this.m_pressAny.height * 2.0f;
        this.m_pressAny.visible = false;
        this.m_loadingText = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_loadingText.scale(2.0f);
        this.m_loadingText.text("Loading... please wait!");
        this.m_loadingText.y = (float)FlxG.height * 0.75f - this.m_bottomText.height * 2.0f;
        this.m_loadingText.visible = true;
        this.m_logoLoading = new FlxSprite();
        this.m_logoLoading.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_logo"), false);
        this.m_logoLoading.x = (float)FlxG.width * 0.5f - this.m_logoLoading.width * 0.5f;
        this.m_logoLoading.y = (float)FlxG.height * 0.5f - this.m_logoLoading.height * 0.5f;
        this.m_logo = new FlxSprite();
        this.m_logo.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_logo"), false);
        this.m_logo.alpha(0.0f);
        this.m_logo.x = (float)FlxG.width * MediumLogoPosPercX - this.m_logo.width * 0.5f;
        this.m_logo.y = (float)FlxG.height * MediumLogoPosPercY - this.m_logo.height * 0.5f;
        this.m_logo.scale(MediumLogoScaleBeginTween);
        this.add(this.m_logoLoading);
        this.add(this.m_pressAny);
        this.add(this.m_loadingText);
        this.add(this.m_bottomText);
        this.add(this.m_logo);
        this.m_tweenManager = new TweenManager();
        this.m_logoLoading.alpha(0.0f);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_logoLoading, 1.0f, 0.2f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        this.m_tweenManager.ToScale((Tweenable)this.m_logoLoading, new Vector2(1.2f), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, TweenManager.LoopType.PingPong);
        FlxG.fade.start(Color.Black(), 1.0f, null, true, false);
    }

    protected void _load() {
        Element elem;
        Document doc = FlxG.Content().LoadXDocument(this.m_launcherFilename);
        if (doc != null && (elem = (Element)doc.getElementsByTagName("Launcher").item(0)) != null) {
            this.m_bWaitForInputKey = true;
            m_bPlayOnStart = true;
            m_bAllowEdit = false;
            this.m_sequence = "FRIDAY";
            this.m_bUseHudMenu = true;
            this.m_bValidKey = true;
        }
    }

    @Override
    public void create() {
        this._build();
        if (this.m_bSkipLoading) {
            this._minimalLoading();
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LauncherState.this._loading();
            }
        };
        this.m_thread = new Thread(r);
        this.m_thread.start();
    }

    protected void _minimalLoading() {
        if (this.m_bSkipLoading) {
            this._load();
            if (InputManager.IsAnyGamepadConnected()) {
                this.m_pressAny.text(TextDataBase.Instance().getText("TXT_ANY_KEY"));
            } else {
                this.m_pressAny.text(TextDataBase.Instance().getText("TXT_ANY_KEY"));
            }
            this.m_bLoadingDone = true;
        }
    }

    protected void _loading() {
        this._load();
        if (MACRO.LOAD_SOUND_ASYNC && !MACRO.DEBUG_DONT_LOAD_SOUND) {
            FlxSoundManager.Initialize("Content/sss/audio/");
        }
        this._restoreCloud();
        this._restoreHomedefaultFiles();
        this._checkGUID();
        InputManager.LoadKeyboardMapping();
        TextDataBase.Instance().LangageId(FlxG.Langage, FlxG.GuessLangage);
        TextDataBase.Instance().load();
        DialogDataBase.Instance().load();
        ResourcesLibrary.Instance().DefferedTextureLoadingActivate();
        ResourcesLibrary.Instance().LoadResources();
        LevelDataBase.Instance().load();
        if (InputManager.IsAnyGamepadConnected()) {
            this.m_pressAny.text(TextDataBase.Instance().getText("TXT_ANY_KEY"));
        } else {
            this.m_pressAny.text(TextDataBase.Instance().getText("TXT_ANY_KEY"));
        }
        this.m_bLoadingDone = true;
    }

    protected void _restoreHomedefaultFiles() {
        if (MACRO.USE_EXTERNAL_GAMEDATA_FOLDER) {
            FileManager.Instance().checkHomeFolderPresence("Blocks That Matter Save");
            FileManager.Instance().checkHomeFolderPresence("config");
            FileManager.Instance().checkHomeFolderPresence("Community");
        }
    }

    protected void _restoreCloud() {
        String localDirRootSave = "Blocks That Matter Save/";
        String localDirRootConfig = "config/";
        String localCommunityRootDir = "Community/";
        String localCommunityOnlineDir = "Community/CommunityLevels/";
        FileManager.Instance().createFolder(localDirRootSave);
        FileManager.Instance().createFolder(localDirRootConfig);
        FileManager.Instance().createFolder(localCommunityRootDir);
        FileManager.Instance().createFolder(localCommunityOnlineDir);
        this._restoreCloudFile("User.dat", "config/User.dat");
        this._restoreCloudFile("DisplayOptions.xml", "config/DisplayOptions.xml");
        this._restoreCloudFile("KeyMapping.xml", "config/KeyMapping.xml");
        String saveName = "BTMsave.sav.dat";
        int i = 1;
        while (i <= 4) {
            byte[] saveCloudContent;
            long localSaveTime;
            long cloudSaveTime;
            String saveDir = "Slot0" + i + "/";
            String fullFilename = String.valueOf(saveDir) + saveName;
            if (GameAPIManager.GameAPI().CloudFileExists(fullFilename) && (cloudSaveTime = GameAPIManager.GameAPI().CloudFileTimestamp(fullFilename)) > (localSaveTime = FileManager.Instance().fileTimestampOrZero(fullFilename)) && (saveCloudContent = GameAPIManager.GameAPI().CloudFileRead(fullFilename)) != null && saveCloudContent.length > 0) {
                FileManager.Instance().createFolder(String.valueOf(localDirRootSave) + saveDir);
                FileManager.Instance().writeTextFileContentByte(String.valueOf(localDirRootSave) + fullFilename, false, saveCloudContent);
            }
            ++i;
        }
        this._restoreCloudFile("LastSession", "Blocks That Matter Save/LastSession");
    }

    protected void _restoreCloudFile(String _cloudFileName, String _localFilename) {
        byte[] cloudFileContent;
        long localTime;
        long cloudTime;
        if (GameAPIManager.GameAPI().CloudFileExists(_cloudFileName) && (cloudTime = GameAPIManager.GameAPI().CloudFileTimestamp(_cloudFileName)) > (localTime = FileManager.Instance().fileTimestampOrZero(_localFilename)) && (cloudFileContent = GameAPIManager.GameAPI().CloudFileRead(_cloudFileName)) != null && cloudFileContent.length > 0) {
            FileManager.Instance().writeTextFileContentByte(_localFilename, false, cloudFileContent);
        }
    }

    protected void _checkGUID() {
        String guidContent = FileManager.Instance().getTextFileContent("config/User.dat", true);
        UUID UserUUID = null;
        boolean generate = false;
        if (guidContent != null) {
            try {
                UserUUID = UUID.fromString(guidContent);
            }
            catch (Exception e) {
                generate = true;
            }
        } else {
            generate = true;
        }
        if (generate) {
            UserUUID = UUID.randomUUID();
            byte[] contentUUID = FileManager.Instance().encrypt(UserUUID.toString());
            FileManager.Instance().writeTextFileContentByte("config/User.dat", false, contentUUID);
            GameAPIManager.GameAPI().CloudFileWrite("User.dat", contentUUID);
        }
        GameVars.UserID(UserUUID.toString());
    }

    protected void _loadingPlayerSave() {
        if (MACRO.USE_LOGIN_AND_SLOT) {
            SaveManager.Instance().recoverLastUserName();
        }
        if (!MACRO.DEBUG_DONT_LOAD_SAVEGAME) {
            SaveManager.Instance().loadGameDataNotThreaded();
        }
        this.m_bLoadSaveGameDone = true;
    }

    protected void _endThread() {
        if (this.m_thread != null) {
            try {
                this.m_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_thread = null;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        this.m_tweenManager.update();
        if (this.m_bLoadingDone && ResourcesLibrary.Instance().DefferedLoadingDone()) {
            if (!this.m_bSndTrackLaunched) {
                FlxG.mouse.show(FlxG.Content().LoadTexture2D("sss/textures/menus/Mouse_cursor"), 20, 20);
                if (MACRO.DIALOG_VIEWER) {
                    this.m_pressAny.text("SPOIL ALERT");
                    this.m_pressAny.color(Color.Red());
                    MultipleLinesText spoilDesc = new MultipleLinesText();
                    String spoilAlertDescTxt = "You're about to enter the Dialog and Text editor.[r]The content you're about to see will spoil you the game storyline.[r]Be sure to finish the game before using this editor![r](press anything to launch the dialog editor or ESC to exit)";
                    spoilDesc.initAttributes(spoilAlertDescTxt, Color.White(), (float)FlxG.width * 0.5f, (float)FlxG.height * 0.7f, 2.0f, 1.0f, 1.0f);
                    this.add(spoilDesc);
                }
                this.m_pressAny.visible = true;
                this.m_pressAny.alpha(0.0f);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_pressAny, 1.0f, 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
                this.m_loadingText.visible = false;
                if (!MACRO.DEBUG_DONT_LOAD_SOUND) {
                    MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
                }
                this.m_bSndTrackLaunched = true;
                this.m_tweenManager.ToAlpha((Tweenable)this.m_logoLoading, 0.0f, 0.25f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_logo.alpha(0.0f);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_logo, 1.0f, 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToScale((Tweenable)this.m_logo, Vector2.One(), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
                FlxG.flash.start(Color.White(), 0.2f, null, true);
                this.m_frame.alpha(1.0f);
                this.m_frame.scale(FrameInitScale);
                this.m_tweenManager.ToScale((Tweenable)this.m_frame, new Vector2(FrameFinalScale, FrameFinalScale), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            }
            this.m_thread = null;
            if (InputManager.IsAnyButtonPress(true) || InputManager.IsAnyMouseButtonPress()) {
                if (MACRO.DIALOG_VIEWER && InputManager.IsKeyDown(Microsoft.Xna.Framework.Input.Keys.Escape)) {
                    FlxG.Game.Exit();
                    return;
                }
                if (!this.m_bLoadSaveGameTriggered) {
                    if (!InputManager.IsAnyGamepadButtonPressed()) {
                        FlxGamepad.GamepadConnectedFlagMask(false);
                    }
                    this.m_bLoadSaveGameTriggered = true;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            LauncherState.this._loadingPlayerSave();
                        }
                    };
                    this.m_thread = new Thread(r);
                    this.m_thread.start();
                }
            }
            if (this.m_bLoadSaveGameDone && this.m_bValidKey && !this.m_bValidDone) {
                this.m_thread = null;
                this.m_bValidDone = true;
                if (this.m_bUseHudMenu) {
                    if (MACRO.DEBUG_CAMERA_TEST_STATE) {
                        FlxG.state(new CameraTestState());
                    } else if (MACRO.DIALOG_VIEWER) {
                        FlxG.state(new DialogViewerState());
                    } else {
                        FlxG.state(new MenuMainState(false, true));
                    }
                } else {
                    FlxG.state(new PlayState(m_bPlayOnStart, m_bAllowEdit, this.m_sequence));
                }
                FlxG.flash.start(Color.White(), 0.2f, null, true);
            }
        }
    }
}

