/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.GamerServices.Guide;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.BTM.PlayState;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.BTMInfo;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.SaveManager;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.LoginManager;
import SSS.Managers.MusicManager;
import SSS.States.BTM.CinematicReplayState;
import SSS.States.BTM.LauncherState;
import SSS.States.BTM.MenuChapterSelectionState;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import SSS.Util.MultipleLinesText;
import java.util.ArrayList;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import precompiler.MACRO;

public class LevelSelectionState
extends TemplateGameMenu {
    static String m_levelGroupId = MACRO.MAIN_AVENTURE_NAME;
    LevelGroup m_levelGroup;
    ArrayList<FlxSprite> m_icons = new ArrayList(50);
    int m_selectedLevelId = 0;
    int m_selectedLevelIdValidated = -1;
    int m_nextSelectedLevelId = 0;
    boolean m_bLeftDown = false;
    boolean m_bRightDown = false;
    boolean m_bWaitOneFrame = true;
    boolean m_bNeedFade = false;
    boolean m_bLaunchingLevel = false;
    String m_onStartSelectedLevel = null;
    float m_timeFade = 0.8f;
    FlxText m_txtLevelName = null;
    FlxText m_txtLevelNumber = null;
    FlxText m_txtGameName = null;
    MultipleLinesText m_txtTM = null;
    String m_strBonusLevelComplete;
    String m_strLocked;
    String m_strNeed;
    String m_strBtmToUnlock;
    String m_strStarToUnlock;
    String m_strNotInTrial;
    String m_strDevelopedBy;
    String m_strAvailableOn;
    FlxText m_txtDevelName = null;
    FlxText m_txtPlateform = null;
    float m_timeElapsedTotal = 0.0f;
    float m_maxTime = 0.25f;
    float m_maxTimeMax = 0.25f;
    float m_maxTimeMin = 0.18f;
    float m_timeElapsedToUseMin = 1.25f;
    FlxSprite m_barMain;
    FlxSprite m_perfectCircle;
    FlxSprite m_lockedIcon;
    FlxSprite m_parDoneIcon;
    int m_numBtmFound = 0;
    int m_numStarFound = 0;
    boolean m_bBonusGroup = false;
    static Color ColorText = Color.Black();
    static int ShoulderStep = 5;
    static float BarMainPercX = 0.5f;
    static float BarMainPercY = 0.8f;
    static float TextReappearTime = 0.25f;
    static float TextMainPercX = 0.558f;
    static float TextMainPercY = 0.795f;
    static float TextLvlNumPercX = 0.282f;
    static float TextLvlNumPercY = 0.795f;
    static float TextGameNamePercX = 0.5f;
    static float TextGameNamePercY = 0.12f;
    static float TextGameNameScale = 4.0f;
    static float TextTMPercY = 0.95f;
    static float TextScaleTM = 1.0f;
    static float TextGameDevByPercX = 0.5f;
    static float TextGameDevByPercY = 0.2f;
    static float TextGameDevByScale = 2.0f;
    static float TextGameAvailableOnPercX = 0.5f;
    static float TextGameAvailableOnPercY = 0.23f;
    static float TextGameAvailableOnScale = 2.0f;
    static float BtmMainPercX = 0.5f;
    static float BtmMainPercY = 0.5f;
    static float BtmScaleSelectedTrack = 1.2f;
    static float BtmScaleNotSelectedTrack = 0.7f;
    static float BtmScaleSelected = 1.0f;
    static float BtmScaleNotSelected = 0.5f;
    static int BtmNumVisibleOnSide = 2;
    static float BtmDistanceBetweenLittles = 150.0f;
    static float BtmDistanceBetweenBigAndLittle = 290.0f;
    static float BtmPerfectCircleSpeed = -10.0f;
    static float BtmPerfectCircleScale = 2.5f;
    static float BtmPerfectCircleMaxAlpha = 0.8f;
    static float BtmLockedTrackOffsetY = 10.0f;
    static float BtmLockedScaleRegular = 1.0f;
    static float BtmLockedScaleBeginAppear = 1.2f;
    static float BtmLockedMaxAlpha = 0.8f;
    float BtmParDoneTrackOffsetX = 116.0f;
    float BtmParDoneTrackOffsetY = -64.0f;
    float BtmParDoneScaleRegular = 0.3f;
    float BtmParDoneScaleBeginAppear = 1.2f;
    float BtmParDoneMaxAlpha = 0.99f;
    boolean m_bTweening = false;
    boolean m_bTracksSelection = false;
    boolean m_bSlotSelection = false;
    boolean m_bSlotSelectionEraseConfirm = false;
    boolean m_bFeatureLevel = false;
    FlxFadeListener m_fadeLevelEntranceComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            LevelSelectionState.this._fadeLevelEntranceComplete(_sender, _e);
        }
    };
    FlxFadeListener m_fadeLevelSelectComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            LevelSelectionState.this._fadeLevelSelectComplete(_sender, _e);
        }
    };
    CallbackSimple m_slotChangeForEraseComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LevelSelectionState.this._slotChangeForEraseComplete(_sender, _args);
        }
    };
    CallbackSimple m_slotChangeComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LevelSelectionState.this._slotChangeComplete(_sender, _args);
        }
    };
    private boolean m_bMainMenuStateNextFrame = false;
    private boolean m_bCheckAchievementNextFrame = false;
    CallbackSimple m_tweeningDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LevelSelectionState.this._tweeningDone(_sender, _args);
        }
    };

    public LevelSelectionState(boolean _bNeedFade, String _levelGroupOrNil, String _onStartSelectedLevelOrNil) {
        this.m_bNeedFade = _bNeedFade;
        this.m_onStartSelectedLevel = _onStartSelectedLevelOrNil;
        if (_levelGroupOrNil != null) {
            m_levelGroupId = _levelGroupOrNil;
        }
    }

    protected void _build() {
        this._templateBuildBackground();
        boolean bSearchOnstartId = this.m_onStartSelectedLevel != null;
        LevelDataBase.Instance().load();
        this.m_levelGroup = LevelDataBase.Instance().getLevelGroup(m_levelGroupId);
        this.m_bTracksSelection = this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.Tracks;
        boolean bl = this.m_bSlotSelection = this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.SavesSlots;
        if (this.m_bSlotSelection) {
            LoginManager.Instance().computeCompletions();
        }
        if (this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.FeaturesLevels) {
            GameVars.AvoidSavePlayerProperties(true);
            this.m_bFeatureLevel = true;
        } else {
            GameVars.AvoidSavePlayerProperties(false);
        }
        boolean bl2 = this.m_bBonusGroup = this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.Bonuses;
        if (this.m_bBonusGroup) {
            this._countBTMandStar();
        }
        if (this.m_bBonusGroup) {
            GameVars.GameMode(GameMode.GameMode_Bonus);
        } else if (this.m_bTracksSelection) {
            GameVars.GameMode(GameMode.GameMode_Tracks);
        } else if (this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.None) {
            GameVars.GameMode(GameMode.GameMode_Main);
        } else {
            GameVars.GameMode(GameMode.GameMode_Unknown);
        }
        LevelInfo lvlInfo = null;
        int i = 0;
        while (i < this.m_levelGroup.LevelInfos().size()) {
            lvlInfo = this.m_levelGroup.LevelInfos().get(i);
            if (this.m_bBonusGroup) {
                if (!lvlInfo.Unlocked() && (lvlInfo.BtmNeededToUnlock() > 0 && this.m_numBtmFound >= lvlInfo.BtmNeededToUnlock() || lvlInfo.StarNeededToUnlock() > 0 && this.m_numStarFound >= lvlInfo.StarNeededToUnlock())) {
                    lvlInfo.Unlocked(true);
                }
            } else if (this.m_bSlotSelection) {
                lvlInfo.Unlocked(true);
                lvlInfo.BTMFound(true);
            }
            lvlInfo.updateIconAnim();
            FlxSprite s = lvlInfo.BTM().RepresentationIcon();
            if (bSearchOnstartId) {
                if (this.m_onStartSelectedLevel.equals(lvlInfo.TargetLevelFile())) {
                    this.m_nextSelectedLevelId = this.m_selectedLevelId = this.m_icons.size();
                }
            } else if (!this.m_bTracksSelection && lvlInfo.Unlocked()) {
                this.m_selectedLevelId = i;
            }
            if (this.m_bSlotSelection && i == LoginManager.Instance().currentSlotId()) {
                lvlInfo.changeColor(Color.YellowSub());
            }
            this.m_icons.add(s);
            ++i;
        }
        if (!bSearchOnstartId && !this.m_bTracksSelection && this.m_selectedLevelId >= this.m_levelGroup.LevelInfos().size() - 1) {
            this.m_selectedLevelId = 0;
        }
        if (this.m_bSlotSelection) {
            this.m_selectedLevelId = LoginManager.Instance().currentSlotId();
        }
        this.m_perfectCircle = new FlxSprite();
        this.m_perfectCircle.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_perfect"));
        this.m_perfectCircle.x = (float)FlxG.width * BtmMainPercX - this.m_perfectCircle.width * 0.5f;
        this.m_perfectCircle.y = (float)FlxG.height * BtmMainPercY - this.m_perfectCircle.height * 0.5f;
        this.m_perfectCircle.scale(BtmPerfectCircleScale);
        this.add(this.m_perfectCircle);
        this.m_perfectCircle.alpha(0.0f);
        i = this.m_icons.size() - 1;
        while (i >= 0) {
            this.add(this.m_icons.get(i));
            --i;
        }
        if (this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.None) {
            this.m_parDoneIcon = new FlxSprite();
            this.m_parDoneIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Star_big"));
            this.m_parDoneIcon.alpha(0.0f);
            this.m_parDoneIcon.x = (float)FlxG.width * BtmMainPercX - this.m_parDoneIcon.width * 0.5f + this.BtmParDoneTrackOffsetX;
            this.m_parDoneIcon.y = (float)FlxG.height * BtmMainPercY - this.m_parDoneIcon.height * 0.5f + this.BtmParDoneTrackOffsetY;
            this.m_parDoneIcon.scale(this.BtmParDoneScaleRegular);
            this.add(this.m_parDoneIcon);
        } else {
            this.m_parDoneIcon = null;
        }
        this.m_lockedIcon = ResourcesLibrary.Instance().InstanciateSprite("BTMs_3");
        this.m_lockedIcon.play("9");
        this.m_lockedIcon.alpha(0.0f);
        this.m_lockedIcon.x = (float)FlxG.width * BtmMainPercX - this.m_lockedIcon.width * 0.5f;
        this.m_lockedIcon.y = (float)FlxG.height * BtmMainPercY - this.m_lockedIcon.height * 0.5f;
        this.m_lockedIcon.scale(BtmLockedScaleRegular);
        this.add(this.m_lockedIcon);
        if (this.m_bTracksSelection) {
            this.m_lockedIcon.y += BtmLockedTrackOffsetY;
        }
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        if (this.m_bSlotSelection) {
            this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.ResetSave);
        } else {
            this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
        }
        this.m_barMain = ResourcesLibrary.Instance().InstanciateSprite("menubar");
        if (this.m_bTracksSelection) {
            this.m_barMain.play("small");
        } else {
            this.m_barMain.play("big");
        }
        this.m_barMain.x = (float)FlxG.width * BarMainPercX - this.m_barMain.width * 0.5f;
        this.m_barMain.y = (float)FlxG.height * BarMainPercY - this.m_barMain.height * 0.5f;
        this.add(this.m_barMain);
        this.m_txtLevelName = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtLevelName.setFormat(null, 3.0f, ColorText, FlxText.FlxJustification.Center, ColorText);
        this.m_txtLevelName.text("");
        this.m_txtLevelName.x = this.m_bTracksSelection ? (float)FlxG.width * 0.5f - this.m_txtLevelName.width * 0.5f : (float)FlxG.width * TextMainPercX - this.m_txtLevelName.width * 0.5f;
        this.m_txtLevelName.y = (float)FlxG.height * TextMainPercY - this.m_txtLevelName.height * 0.5f;
        this.m_txtLevelNumber = new FlxText(0.0f, 0.0f, 100.0f);
        this.m_txtLevelNumber.setFormat(null, 3.0f, ColorText, FlxText.FlxJustification.Center, ColorText);
        this.m_txtLevelNumber.text("");
        this.m_txtLevelNumber.x = (float)FlxG.width * TextLvlNumPercX - this.m_txtLevelNumber.width * 0.5f;
        this.m_txtLevelNumber.y = (float)FlxG.height * TextLvlNumPercY - this.m_txtLevelNumber.height * 0.5f;
        this.add(this.m_txtLevelName);
        this.add(this.m_txtLevelNumber);
        this.m_txtGameName = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtGameName.setFormat(null, TextGameNameScale, ColorText, FlxText.FlxJustification.Center, ColorText);
        this.m_txtGameName.x = (float)FlxG.width * TextGameNamePercX - this.m_txtLevelName.width * 0.5f;
        this.m_txtGameName.y = (float)FlxG.height * TextGameNamePercY - this.m_txtLevelName.height * 0.5f;
        this.m_txtTM = new MultipleLinesText();
        this.m_txtTM.Justification(FlxText.FlxJustification.Center);
        this.m_txtTM.initAttributes("", Color.White(), (float)FlxG.width * 0.5f, TextTMPercY * (float)FlxG.height, TextScaleTM, 1.0f, 1.0f);
        this.m_txtDevelName = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtDevelName.setFormat(null, TextGameDevByScale, ColorText, FlxText.FlxJustification.Center, ColorText);
        this.m_txtDevelName.x = (float)FlxG.width * TextGameDevByPercX - this.m_txtDevelName.width * 0.5f;
        this.m_txtDevelName.y = (float)FlxG.height * TextGameDevByPercY - this.m_txtDevelName.height * 0.5f;
        this.m_txtPlateform = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtPlateform.setFormat(null, TextGameAvailableOnScale, ColorText, FlxText.FlxJustification.Center, ColorText);
        this.m_txtPlateform.x = (float)FlxG.width * TextGameAvailableOnPercX - this.m_txtPlateform.width * 0.5f;
        this.m_txtPlateform.y = (float)FlxG.height * TextGameAvailableOnPercY - this.m_txtPlateform.height * 0.5f;
        this.add(this.m_txtGameName);
        this.add(this.m_txtTM);
        this.add(this.m_txtDevelName);
        this.add(this.m_txtPlateform);
        TextDataBase tdb = TextDataBase.Instance();
        BtmScaleSelected = 1.0f;
        BtmScaleNotSelected = 0.5f;
        if (this.m_bTracksSelection) {
            BtmScaleSelected = BtmScaleSelectedTrack;
            BtmScaleNotSelected = BtmScaleNotSelectedTrack;
            MusicManager.Instance().playTracks(null, null, 1.0f, false);
            this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_PLAY"), tdb.getText("TXT_BUY"));
            this.m_txtLevelName.text(TextDataBase.Instance().getText("TXT_TRACKS_ASK"));
        } else if (this.m_bSlotSelection) {
            this._templateChangeIconsTexts(tdb.getText("TXT_QUIT"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_ERASE"));
        } else {
            this.m_bTracksSelection = false;
            MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
            this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_BUY"));
        }
        if (this.m_bTracksSelection) {
            int i2 = 0;
            while (i2 < this.m_icons.size()) {
                this.m_icons.get(i2).play("stoped");
                ++i2;
            }
            this.m_strDevelopedBy = tdb.getText("TXT_COMPOSED_BY_MORUSQUE");
            this.m_strAvailableOn = tdb.getText("TXT_TRACK_AVAILABLE_ON");
        } else if (this.m_bSlotSelection) {
            this.m_strDevelopedBy = tdb.getText("TXT_PROGRESSION");
            this.m_strAvailableOn = "";
        } else {
            this.m_strDevelopedBy = tdb.getText("TXT_DEVELOPED_BY");
            this.m_strAvailableOn = tdb.getText("TXT_AVAILABLE_ON");
        }
        this.m_strLocked = tdb.getText("TXT_LOCKED");
        this.m_strNeed = tdb.getText("TXT_NEED");
        this.m_strBtmToUnlock = tdb.getText("TXT_BTM_TO_UNLOCK");
        this.m_strStarToUnlock = tdb.getText("TXT_STARS_TO_UNLOCK");
        this.m_strNotInTrial = tdb.getText("TXT_NOT_IN_TRIAL");
        this.m_strBonusLevelComplete = tdb.getText("TXT_BONUS_COMPETE");
        this._positionate(true);
        this._triggerLockIconIfNecessary();
        this._triggerParDoneIconIfNecessary();
        this._triggerPerfectCircleIfNecessary();
    }

    protected void _countBTMandStar() {
        this.m_numBtmFound = 0;
        this.m_numStarFound = 0;
        LevelGroup lvlGroupToCount = LevelDataBase.Instance().getLevelGroup(MACRO.MAIN_AVENTURE_NAME);
        if (lvlGroupToCount != null) {
            int i = 0;
            while (i < lvlGroupToCount.LevelInfos().size()) {
                LevelInfo lvlInfoToCount = lvlGroupToCount.LevelInfos().get(i);
                if (lvlInfoToCount != null && !lvlInfoToCount.Cinematic()) {
                    if (lvlInfoToCount.BTMFound()) {
                        ++this.m_numBtmFound;
                    }
                    if (lvlInfoToCount.ParDone()) {
                        ++this.m_numStarFound;
                    }
                }
                ++i;
            }
        }
    }

    protected void _positionate(boolean _bReinitTextAlpha) {
        FlxSprite sp = this.m_icons.get(this.m_selectedLevelId);
        float centerx = (float)FlxG.width * BtmMainPercX;
        float centery = (float)FlxG.height * BtmMainPercY;
        float curCenterx = centerx;
        float curCentery = centery;
        sp.x = curCenterx - sp.width * 0.5f;
        sp.y = curCentery - sp.width * 0.5f;
        sp.scale(BtmScaleSelected);
        sp.visible = true;
        sp.alpha(1.0f);
        boolean bDirectNextBloc = true;
        int visibleCounter = 0;
        curCenterx = centerx;
        curCentery = centery;
        int i = this.m_selectedLevelId - 1;
        while (i >= 0) {
            sp = this.m_icons.get(i);
            curCenterx = bDirectNextBloc ? (curCenterx -= BtmDistanceBetweenBigAndLittle) : (curCenterx -= BtmDistanceBetweenLittles);
            sp.x = curCenterx - sp.width * 0.5f;
            sp.y = curCentery - sp.height * 0.5f;
            sp.scale(BtmScaleNotSelected);
            sp.visible = visibleCounter < BtmNumVisibleOnSide;
            sp.alpha(1.0f);
            bDirectNextBloc = false;
            ++visibleCounter;
            --i;
        }
        bDirectNextBloc = true;
        visibleCounter = 0;
        curCenterx = centerx;
        curCentery = centery;
        i = this.m_selectedLevelId + 1;
        while (i < this.m_icons.size()) {
            sp = this.m_icons.get(i);
            curCenterx = bDirectNextBloc ? (curCenterx += BtmDistanceBetweenBigAndLittle) : (curCenterx += BtmDistanceBetweenLittles);
            sp.x = curCenterx - sp.width * 0.5f;
            sp.y = curCentery - sp.height * 0.5f;
            sp.scale(BtmScaleNotSelected);
            sp.visible = visibleCounter < BtmNumVisibleOnSide;
            sp.alpha(1.0f);
            bDirectNextBloc = false;
            ++visibleCounter;
            ++i;
        }
        if (this.m_bTracksSelection) {
            LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
            BTMInfo btmInfo = lvlInfo.BTM();
            boolean bUnlocked = lvlInfo.Unlocked();
            if (Guide.IsTrialMode()) {
                this.m_txtGameName.text(bUnlocked ? btmInfo.GameName() : "???");
                this.m_txtDevelName.text(bUnlocked ? this.m_strDevelopedBy : "");
                this.m_txtPlateform.text(bUnlocked ? this.m_strAvailableOn : "");
                this.m_txtLevelName.text(this.m_strNotInTrial);
            } else {
                this.m_txtGameName.text(bUnlocked ? btmInfo.GameName() : "???");
                this.m_txtDevelName.text(bUnlocked ? this.m_strDevelopedBy : "");
                this.m_txtPlateform.text(bUnlocked ? this.m_strAvailableOn : "");
            }
            this.m_txtTM.visible = false;
        } else {
            LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
            if (Guide.IsTrialMode()) {
                if (this.m_bBonusGroup) {
                    this.m_txtLevelName.text(this.m_strNotInTrial);
                } else if (m_levelGroupId.equals("Main")) {
                    if (this.m_selectedLevelId <= 10) {
                        this.m_txtLevelName.text(lvlInfo.Unlocked() ? lvlInfo.FriendlyName() : this.m_strLocked);
                        this.m_txtLevelNumber.text(lvlInfo.Number());
                    } else {
                        this.m_txtLevelName.text(this.m_strNotInTrial);
                    }
                }
                this.m_txtLevelNumber.text(lvlInfo.Number());
            } else {
                if (this.m_bBonusGroup && !this.m_bFeatureLevel) {
                    if (lvlInfo.Unlocked()) {
                        this.m_txtLevelName.text(lvlInfo.FriendlyName());
                    } else if (lvlInfo.BtmNeededToUnlock() > 0) {
                        this.m_txtLevelName.text(String.valueOf(lvlInfo.BtmNeededToUnlock() - this.m_numBtmFound) + " " + this.m_strBtmToUnlock);
                    } else {
                        this.m_txtLevelName.text(String.valueOf(lvlInfo.StarNeededToUnlock() - this.m_numStarFound) + " " + this.m_strStarToUnlock);
                    }
                } else {
                    this.m_txtLevelName.text(lvlInfo.Unlocked() ? lvlInfo.FriendlyName() : this.m_strLocked);
                }
                this.m_txtLevelNumber.text(lvlInfo.Number());
            }
            boolean bFound = lvlInfo.BTMFound();
            BTMInfo btmInfo = null;
            if (bFound) {
                btmInfo = lvlInfo.BTM();
            }
            if (lvlInfo.Cinematic()) {
                this.m_txtGameName.text("");
                this.m_txtDevelName.text("");
                this.m_txtPlateform.text("");
                this.m_txtTM.visible = false;
            } else if (this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.Bonuses) {
                this.m_txtGameName.text(lvlInfo.Done() ? this.m_strBonusLevelComplete : "");
                this.m_txtDevelName.text("");
                this.m_txtPlateform.text("");
                this.m_txtTM.visible = false;
            } else if (this.m_bSlotSelection) {
                this.m_txtGameName.text(String.valueOf(this.m_strDevelopedBy) + LoginManager.Instance().getCompletionString(this.m_selectedLevelId));
                this.m_txtTM.visible = false;
            } else if (this.m_bFeatureLevel) {
                TextDataBase tdb = TextDataBase.Instance();
                if (lvlInfo.Done()) {
                    this.m_txtGameName.text(tdb.getText("TXT_BASED_ON_CC"));
                    this.m_txtGameName.scale(3.5f);
                    this.m_txtDevelName.text(String.valueOf(tdb.getText("TXT_DEVELOPED_BY")) + "Lexaloffle Games");
                    this.m_txtPlateform.text(String.valueOf(tdb.getText("TXT_AVAILABLE_ON")) + "Win/Mac/Linux");
                } else {
                    this.m_txtGameName.text("");
                    this.m_txtDevelName.text("");
                    this.m_txtPlateform.text("");
                }
            } else {
                this.m_txtGameName.text(bFound ? btmInfo.GameName() : "???");
                this.m_txtDevelName.text(bFound ? String.valueOf(this.m_strDevelopedBy) + btmInfo.DevTeam() : "");
                this.m_txtPlateform.text(bFound ? String.valueOf(this.m_strAvailableOn) + btmInfo.Platform() : "");
                if (bFound && btmInfo.tmID() != null && btmInfo.tmID().length() > 0) {
                    this.m_txtTM.visible = true;
                    this.m_txtTM.changeText(TextDataBase.Instance().getText(btmInfo.tmID()));
                } else {
                    this.m_txtTM.visible = false;
                }
            }
        }
        if (_bReinitTextAlpha) {
            this.m_txtGameName.alpha(1.0f);
            this.m_txtDevelName.alpha(1.0f);
            this.m_txtPlateform.alpha(1.0f);
            this.m_txtTM.changeAlpha(1.0f);
        }
    }

    @Override
    public void create() {
        super.create();
        this._build();
        if (this.m_bNeedFade) {
            FlxG.fade.start(Color.Black(), this.m_timeFade, this.m_fadeLevelEntranceComplete, true, false);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        if (this.m_bMainMenuStateNextFrame) {
            this.m_bMainMenuStateNextFrame = false;
            FlxG.state(new MenuMainState(false, this.m_bCheckAchievementNextFrame));
            this.m_bCheckAchievementNextFrame = false;
            return;
        }
        if (this.m_bWaitOneFrame) {
            this.m_bWaitOneFrame = false;
            return;
        }
        this.m_perfectCircle.angle(this.m_perfectCircle.angle() + FlxG.elapsed * BtmPerfectCircleSpeed);
        if (!this.m_bLaunchingLevel) {
            this._updateStickFlags();
            if (this.m_bLeftDown || this.m_bRightDown) {
                this.m_timeElapsedTotal += FlxG.elapsed;
                this.m_maxTime = MathHelper.Lerp(this.m_maxTimeMax, this.m_maxTimeMin, this.m_timeElapsedTotal / this.m_timeElapsedToUseMin);
            } else {
                this.m_timeElapsedTotal = 0.0f;
                this.m_maxTime = this.m_maxTimeMax;
            }
            if (!this.m_bTweening) {
                if (InputManager.IsLeftMouseButtonPress()) {
                    if (this.m_icons.get(this.m_selectedLevelId).overlapsPoint(InputManager.MouseX(), InputManager.MouseY())) {
                        this._onSelectPressed();
                    }
                } else if (InputManager.IsJustMouseWheelDown()) {
                    this.m_bRightDown = true;
                } else if (InputManager.IsJustMouseWheelUp()) {
                    this.m_bLeftDown = true;
                }
                if (this.m_bLeftDown) {
                    this._selectNeighbourLevel(false);
                } else if (this.m_bRightDown) {
                    this._selectNeighbourLevel(true);
                } else if (InputManager.IsNewButtonPress(Buttons.RightShoulder)) {
                    this._skipQuick(ShoulderStep);
                } else if (InputManager.IsNewButtonPress(Buttons.LeftShoulder)) {
                    this._skipQuick(-ShoulderStep);
                }
            }
        }
    }

    protected void _skipQuick(int _step) {
        if (this.m_bSlotSelection) {
            this.m_bSlotSelectionEraseConfirm = false;
        }
        int save = this.m_selectedLevelId;
        this.m_selectedLevelId += _step;
        if (this.m_selectedLevelId < 0) {
            this.m_selectedLevelId = 0;
        } else if (this.m_selectedLevelId >= this.m_levelGroup.LevelInfos().size()) {
            this.m_selectedLevelId = this.m_levelGroup.LevelInfos().size() - 1;
        }
        if (save != this.m_selectedLevelId) {
            this.m_tweenManager.Clear();
            this._positionate(true);
            this._triggerLockIconIfNecessary();
            this._triggerParDoneIconIfNecessary();
            this._triggerPerfectCircleIfNecessary();
            FlxSprite sp = this.m_icons.get(this.m_selectedLevelId);
            sp.scale(0.8f);
            this.m_tweenManager.ToScale((Tweenable)sp, new Vector2(BtmScaleSelected), this.m_maxTime, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
        }
    }

    protected void _updateStickFlags() {
        this.m_bLeftDown = InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || InputManager.IsButtonDown(Buttons.DPadLeft);
        this.m_bRightDown = InputManager.IsButtonDown(Buttons.LeftThumbstickRight) || InputManager.IsButtonDown(Buttons.DPadRight);
    }

    protected void _fadeLevelEntranceComplete(Object sender, Object e) {
    }

    protected void _fadeLevelSelectComplete(Object sender, Object e) {
        LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
        if (lvlInfo.Cinematic()) {
            LevelInfo lvlInfoNextLevel = this.m_levelGroup.getNextLevelInfoOrNil(lvlInfo.TargetLevelFile(), true);
            FlxG.state(new CinematicReplayState(lvlInfo.TargetLevelFile(), lvlInfoNextLevel != null ? lvlInfoNextLevel.TargetLevelFile() : null, CinematicReplayState.eSpecialFlag.None, this.m_levelGroup));
        } else {
            FlxG.state(new PlayState(LauncherState.PlayOnStart(), LauncherState.AllowEdit(), lvlInfo.TargetLevelFile(), this.m_levelGroup));
        }
    }

    protected void _selectNeighbourLevel(boolean _bNext) {
        if (!this.m_bTweening) {
            int nextValue;
            if (this.m_bSlotSelection) {
                this.m_bSlotSelectionEraseConfirm = false;
            }
            if ((nextValue = this.m_selectedLevelId + (_bNext ? 1 : -1)) >= 0 && nextValue < this.m_icons.size()) {
                this._launchTween(this.m_selectedLevelId, _bNext);
                this.m_selectedLevelId = nextValue;
                this.m_nextSelectedLevelId = nextValue;
            }
        }
    }

    @Override
    protected void _onThanks() {
        if (this.m_bSlotSelection) {
            if (!this.m_bSlotSelectionEraseConfirm) {
                this.m_txtLevelName.text(TextDataBase.Instance().getText("TXT_CONFIRM"));
                this.m_bSlotSelectionEraseConfirm = true;
            } else if (SaveManager.Instance().isStorageModeExists()) {
                FlxG.flash.start(Color.Red());
                if (this.m_selectedLevelId != LoginManager.Instance().currentSlotId()) {
                    this.m_bLaunchingLevel = true;
                    LoginManager.Instance().changeSlot(this.m_selectedLevelId, this.m_slotChangeForEraseComplete);
                } else {
                    SaveManager.Instance().resetGameData();
                    LoginManager.Instance().computeCompletions();
                    this._positionate(true);
                }
            }
        } else {
            this._launchThanksMap();
        }
    }

    protected void _slotChangeForEraseComplete(Object sender, Object e) {
        SaveManager.Instance().resetGameData();
        LoginManager.Instance().computeCompletions();
        this._positionate(true);
        int i = 0;
        while (i < this.m_levelGroup.LevelInfos().size()) {
            LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(i);
            if (i == LoginManager.Instance().currentSlotId()) {
                lvlInfo.changeColor(Color.YellowSub());
                this.m_txtLevelName.text(lvlInfo.FriendlyName());
            } else {
                lvlInfo.changeColor(Color.White());
            }
            ++i;
        }
        this.m_bSlotSelectionEraseConfirm = false;
        this.m_bLaunchingLevel = false;
    }

    @Override
    protected void _onReturnPressed() {
        if (this.m_bLaunchingLevel) {
            return;
        }
        this.m_bLastEventProcessed = false;
        if (this.m_bSlotSelection || this.m_bFeatureLevel) {
            FlxG.state(new MenuMainState(false, true));
        } else {
            FlxG.state(new MenuChapterSelectionState());
        }
    }

    @Override
    protected void _onSelectPressed() {
        if (!this.m_bLaunchingLevel) {
            if (Guide.IsTrialMode()) {
                if (this.m_bTracksSelection) {
                    return;
                }
                if (this.m_bBonusGroup) {
                    return;
                }
                if (this.m_selectedLevelId > 10) {
                    return;
                }
            }
            LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
            if (!MACRO.DEBUG && !lvlInfo.Unlocked()) {
                return;
            }
            if (lvlInfo != null && lvlInfo.TrackPlayer()) {
                if (lvlInfo.Unlocked() || GameVars.CheatCanSelectLockedContent()) {
                    lvlInfo.Done(true);
                    this.m_selectedLevelIdValidated = this.m_selectedLevelId;
                    String[] tracks = lvlInfo.TargetLevelFile().split("\\|");
                    MusicManager.Instance().playTracks(tracks.length > 0 && tracks[0].length() > 0 ? tracks[0] : null, tracks.length > 1 && tracks[1].length() > 0 ? tracks[1] : null, 1.0f, false);
                    int i = 0;
                    while (i < this.m_icons.size()) {
                        if (i == this.m_selectedLevelId) {
                            this.m_icons.get(i).play("play");
                        } else {
                            this.m_icons.get(i).play("stoped");
                        }
                        ++i;
                    }
                    this._triggerPerfectCircleIfNecessary();
                    this._triggerLockIconIfNecessary();
                    this._triggerParDoneIconIfNecessary();
                    this.m_txtLevelName.text(String.valueOf(TextDataBase.Instance().getText("TXT_TRACKS_PLAYING")) + lvlInfo.BTM().GameName());
                }
            } else if (this.m_bSlotSelection) {
                FlxG.flash.start(Color.White());
                this.m_bLaunchingLevel = true;
                LoginManager.Instance().changeSlot(this.m_selectedLevelId, this.m_slotChangeComplete);
            } else {
                this.m_bLaunchingLevel = true;
                FlxG.fade.start(Color.Black(), this.m_timeFade, this.m_fadeLevelSelectComplete, true, true);
            }
        }
    }

    protected void _slotChangeComplete(Object sender, Object e) {
        this.m_bMainMenuStateNextFrame = true;
        this.m_bCheckAchievementNextFrame = true;
    }

    protected void _launchTween(int _curCenterBlocId, boolean _bNext) {
        Vector2 pos = Vector2.Zero();
        Vector2 scale = Vector2.Zero();
        this.m_bTweening = true;
        float factor = _bNext ? -1.0f : 1.0f;
        int toBeBig = this.m_selectedLevelId + (_bNext ? 1 : -1);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_txtGameName, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_txtDevelName, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_txtPlateform, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        if (GameVars.GameMode() == GameMode.GameMode_Main) {
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtTM, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        if (!this.m_bTracksSelection) {
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtLevelName, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        if (this.m_perfectCircle.alpha() > 0.0f) {
            this.m_tweenManager.ToAlpha((Tweenable)this.m_perfectCircle, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        if (this.m_lockedIcon.alpha() > 0.0f) {
            this.m_tweenManager.ToAlpha((Tweenable)this.m_lockedIcon, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        if (this.m_parDoneIcon != null && this.m_parDoneIcon.alpha() > 0.0f) {
            this.m_tweenManager.RemoveTweenableLooped(this.m_parDoneIcon);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_parDoneIcon, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        FlxSprite sp = this.m_icons.get(this.m_selectedLevelId);
        pos = new Vector2(sp.x + sp.width * 0.5f + BtmDistanceBetweenBigAndLittle * factor, sp.y + sp.height * 0.5f);
        this.m_tweenManager.ToPosition(sp, pos, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, this.m_tweeningDone);
        scale = new Vector2(BtmScaleNotSelected, BtmScaleNotSelected);
        this.m_tweenManager.ToScale((Tweenable)sp, scale, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        int counter = 0;
        int i = this.m_selectedLevelId + 1;
        while (i < this.m_icons.size()) {
            sp = this.m_icons.get(i);
            if (toBeBig == i) {
                pos = new Vector2((float)FlxG.width * BtmMainPercX, (float)FlxG.height * BtmMainPercY);
                this.m_tweenManager.ToPosition(sp, pos, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, null);
                scale = new Vector2(BtmScaleSelected, BtmScaleSelected);
                this.m_tweenManager.ToScale((Tweenable)sp, scale, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            } else {
                if (counter <= BtmNumVisibleOnSide) {
                    pos = new Vector2(sp.x + sp.width * 0.5f + BtmDistanceBetweenLittles * factor, sp.y + sp.height * 0.5f);
                    this.m_tweenManager.ToPosition(sp, pos, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, null);
                }
                if (_bNext) {
                    if (counter == BtmNumVisibleOnSide) {
                        sp.alpha(0.0f);
                        sp.visible = true;
                        this.m_tweenManager.ToAlpha((Tweenable)sp, 1.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                    }
                } else if (counter == BtmNumVisibleOnSide - 1) {
                    sp.alpha(1.0f);
                    sp.visible = true;
                    this.m_tweenManager.ToAlpha((Tweenable)sp, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                }
            }
            ++counter;
            ++i;
        }
        counter = 0;
        i = this.m_selectedLevelId - 1;
        while (i >= 0) {
            sp = this.m_icons.get(i);
            if (toBeBig == i) {
                pos = new Vector2((float)FlxG.width * BtmMainPercX, (float)FlxG.height * BtmMainPercY);
                this.m_tweenManager.ToPosition(sp, pos, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, null);
                scale = new Vector2(BtmScaleSelected, BtmScaleSelected);
                this.m_tweenManager.ToScale((Tweenable)sp, scale, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            } else {
                if (counter <= BtmNumVisibleOnSide) {
                    pos = new Vector2(sp.x + sp.width * 0.5f + BtmDistanceBetweenLittles * factor, sp.y + sp.height * 0.5f);
                    this.m_tweenManager.ToPosition(sp, pos, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, null);
                }
                if (_bNext) {
                    if (counter == BtmNumVisibleOnSide - 1) {
                        sp.alpha(1.0f);
                        sp.visible = true;
                        this.m_tweenManager.ToAlpha((Tweenable)sp, 0.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                    }
                } else if (counter == BtmNumVisibleOnSide) {
                    sp.alpha(0.0f);
                    sp.visible = true;
                    this.m_tweenManager.ToAlpha((Tweenable)sp, 1.0f, this.m_maxTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                }
            }
            ++counter;
            --i;
        }
    }

    protected void _tweeningDone(Object _sender, Object _e) {
        this.m_bTweening = false;
        this._positionate(false);
        this._updateStickFlags();
        if (!this.m_bLeftDown && !this.m_bRightDown || this.m_selectedLevelId == 0 || this.m_selectedLevelId == this.m_icons.size() - 1) {
            this._triggerPerfectCircleIfNecessary();
            this._triggerLockIconIfNecessary();
            this._triggerParDoneIconIfNecessary();
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtGameName, 1.0f, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtDevelName, 1.0f, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtPlateform, 1.0f, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            if (GameVars.GameMode() == GameMode.GameMode_Main) {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtTM, 1.0f, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
            if (!this.m_bTracksSelection) {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtLevelName, 1.0f, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
        }
    }

    protected void _triggerLockIconIfNecessary() {
        boolean bTrigger = false;
        LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
        if (!lvlInfo.Unlocked()) {
            bTrigger = true;
        }
        if (bTrigger) {
            this.m_lockedIcon.scale(BtmLockedScaleBeginAppear);
            this.m_lockedIcon.alpha(0.0f);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_lockedIcon, BtmLockedMaxAlpha, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToScale((Tweenable)this.m_lockedIcon, new Vector2(BtmLockedScaleRegular), TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        } else {
            this.m_tweenManager.RemoveTweenable(this.m_lockedIcon);
            this.m_lockedIcon.alpha(0.0f);
        }
    }

    protected void _triggerParDoneIconIfNecessary() {
        if (this.m_parDoneIcon != null) {
            boolean bTrigger = false;
            LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
            if (lvlInfo.Unlocked() && lvlInfo.ParDone() && !lvlInfo.Cinematic()) {
                bTrigger = true;
            }
            if (bTrigger) {
                this.m_parDoneIcon.scale(this.BtmParDoneScaleBeginAppear);
                this.m_parDoneIcon.alpha(0.0f);
                this.m_parDoneIcon.angle(0.0f);
                if (lvlInfo.ParBestValue() > lvlInfo.ParToReachValue()) {
                    this.m_parDoneIcon.color().change(0.0f, 1.0f, 0.0f);
                } else {
                    this.m_parDoneIcon.color().change(1.0f, 1.0f, 1.0f);
                }
                this.m_tweenManager.ToAlpha((Tweenable)this.m_parDoneIcon, this.BtmParDoneMaxAlpha, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToScale((Tweenable)this.m_parDoneIcon, new Vector2(this.BtmParDoneScaleRegular), TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToScale((Tweenable)this.m_parDoneIcon, new Vector2(this.BtmParDoneScaleRegular * 1.1f), TextReappearTime * 4.0f, TweenManager.EaseType.EASE_INOUTSIN, TextReappearTime, TweenManager.LoopType.PingPong);
            } else {
                this.m_tweenManager.RemoveTweenable(this.m_parDoneIcon);
                this.m_parDoneIcon.alpha(0.0f);
            }
        }
    }

    protected void _triggerPerfectCircleIfNecessary() {
        if (this.m_bSlotSelection) {
            return;
        }
        boolean bTrigger = false;
        if (!this.m_bTracksSelection) {
            LevelInfo lvlInfo = this.m_levelGroup.LevelInfos().get(this.m_selectedLevelId);
            if (this.m_levelGroup.Flag() == LevelGroup.eSpecialFlag.Bonuses) {
                if (lvlInfo.Done()) {
                    bTrigger = true;
                }
            } else if (lvlInfo.BTMFound() && !lvlInfo.Cinematic()) {
                bTrigger = true;
            }
        } else if (this.m_selectedLevelId == this.m_selectedLevelIdValidated) {
            bTrigger = true;
        }
        if (bTrigger) {
            this.m_perfectCircle.alpha(0.0f);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_perfectCircle, BtmPerfectCircleMaxAlpha, TextReappearTime, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        } else {
            this.m_tweenManager.RemoveTweenable(this.m_perfectCircle);
            this.m_perfectCircle.alpha(0.0f);
        }
    }
}

