/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import SSS.BTM.GameVars;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.LoginManager;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.UI.MainMenuEntry;
import SSS.Util.InputManager;
import org.flixel.FlxG;
import org.flixel.FlxText;
import precompiler.MACRO;

public class MenuChapterSelectionState
extends TemplateGameMenu {
    static float DistBetweenChpaterBlocks = 300.0f;
    static float ChapterBlocksPercY = 0.45f;
    static float BarMainPercX = 0.5f;
    static float BarMainPercY = 0.8f;
    static float TitlePercY = 0.1f;
    static float TitleScale = 3.0f;
    static float SecretTextPercY = 0.95f;
    static float SecretTextScale = 1.5f;
    static String[] m_menuEntriesFlags = new String[]{"Main", "Bonus01", "Tracks"};
    static String[] m_menuEntriesAnim = new String[]{"big1", "big2", "big3"};
    static String[] m_menuEntriesTextsId = new String[]{"TXT_THE_UNDERGROUND_RESCUE", "TXT_BONUS", "TXT_TRACKS"};
    SssGroup m_layer;
    MainMenuEntry[] m_menuEntries;
    MainMenuEntry m_barMain;
    FlxText m_txtTitle;
    int m_menuEntrySelectedOld = 0;
    int m_menuEntrySelected = -1;
    boolean m_bValidating = false;

    @Override
    public void create() {
        super.create();
        this._build();
    }

    protected void _build() {
        MenuChapterSelectionState.m_menuEntriesFlags[0] = MACRO.MAIN_AVENTURE_NAME;
        MenuChapterSelectionState.m_menuEntriesFlags[1] = MACRO.MAIN_BONUS_CHAPTER_NAME;
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
        TextDataBase tdb = TextDataBase.Instance();
        this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_BUY"));
        this.m_layer = new SssGroup();
        this.add(this.m_layer);
        this.m_menuEntries = new MainMenuEntry[3];
        float centerx = (float)FlxG.width * 0.5f - (float)(this.m_menuEntries.length / 2) * DistBetweenChpaterBlocks;
        float centery = (float)FlxG.height * ChapterBlocksPercY;
        int i = 0;
        while (i < 3) {
            this.m_menuEntries[i] = new MainMenuEntry(i, this.m_layer, this.m_tweenManager, MainMenuEntry.eType.GameMode, null, m_menuEntriesFlags[i], m_menuEntriesAnim[i]);
            this.m_menuEntries[i].positionateAt(centerx, centery);
            centerx += DistBetweenChpaterBlocks;
            ++i;
        }
        this._templateWatchEntries(this.m_menuEntries);
        this._computeCompletion();
        this.m_barMain = new MainMenuEntry(0, this.m_layer, this.m_tweenManager, MainMenuEntry.eType.GameModeDesc, null, null, null);
        this.m_barMain.positionateAt((float)FlxG.width * BarMainPercX, (float)FlxG.height * BarMainPercY);
        this.m_txtTitle = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtTitle.UseShadow(false);
        this.m_txtTitle.color(Color.Black());
        this.m_txtTitle.text(TextDataBase.Instance().getText("TXT_SELECT_GAME_MODE"));
        this.m_txtTitle.scale(TitleScale);
        this.m_txtTitle.y = (float)FlxG.height * TitlePercY;
        this.add(this.m_txtTitle);
        this._selectEntry(false, 0);
    }

    protected void _computeCompletion() {
        float mainCompletion = 0.0f;
        float bonusCompletion = 0.0f;
        float soundCompletion = 0.0f;
        String mainCompletionStr = "0%";
        String bonusCompletionStr = "0%";
        String soundCompletionStr = "0%";
        LoginManager.Instance().computeCurrentCompletion();
        mainCompletion = LoginManager.Instance().getCurrentSlotMainCompletionValue();
        bonusCompletion = LoginManager.Instance().getCurrentSlotBonusCompletionValue();
        soundCompletion = LoginManager.Instance().getCurrentSlotTrackCompletionValue();
        mainCompletionStr = String.valueOf((int)mainCompletion) + "%";
        bonusCompletionStr = String.valueOf((int)bonusCompletion) + "%";
        soundCompletionStr = String.valueOf((int)soundCompletion) + "%";
        this.m_menuEntries[0].setText(mainCompletionStr);
        this.m_menuEntries[1].setText(bonusCompletionStr);
        this.m_menuEntries[2].setText(soundCompletionStr);
        if (mainCompletion >= 100.0f) {
            this.m_menuEntries[0].setText(String.valueOf(mainCompletionStr) + "*");
            FlxText text = new FlxText(0.0f, 0.0f, FlxG.width);
            if (MACRO.MAIN_AVENTURE_NAME.equals("Main")) {
                if (GameVars.CheatedSave() == 0) {
                    text.text(String.valueOf(TextDataBase.Instance().getText("TXT_ONE_HUNDRED")) + "Buster");
                } else {
                    text.text(TextDataBase.Instance().getText("TXT_ONE_HUNDRED_CHEATED"));
                }
            } else {
                text.text("* Yayz! You completed the tech demo!");
            }
            text.scale(SecretTextScale);
            text.y = (float)FlxG.height * SecretTextPercY - text.height;
            text.alpha(0.1f);
            this.m_tweenManager.ToAlpha((Tweenable)text, 1.0f, 0.2f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
            this.add(text);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update() {
        super.update();
        if (!this.m_bValidating) {
            this._leftStickHandling();
        }
    }

    @Override
    protected void _onThanks() {
        this._launchThanksMap();
    }

    @Override
    protected void _onReturnPressed() {
        FlxG.state(new MenuMainState(false, false));
    }

    @Override
    protected void _onSelectPressed() {
        if (!this.m_bValidating && this.m_timeInState > MinTimeInState) {
            this.m_bValidating = true;
            this.m_menuEntries[this.m_menuEntrySelected].confirm();
        }
    }

    @Override
    protected void _onNewEntryUnderMouse(MainMenuEntry _entry, int slot, int groupId) {
        this._selectEntry(false, slot);
    }

    @Override
    protected void _onEntryUnderMouseSelected(MainMenuEntry _entry, int slot, int groupId) {
        this._onSelectPressed();
    }

    protected void _leftStickHandling() {
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight) || InputManager.IsNewButtonPress(Buttons.DPadRight)) {
            if (this.m_menuEntrySelected < this.m_menuEntries.length - 1) {
                this._selectEntry(false, this.m_menuEntrySelected + 1);
            } else {
                this._selectEntry(false, 0);
            }
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft) || InputManager.IsNewButtonPress(Buttons.DPadLeft)) {
            if (this.m_menuEntrySelected == 0) {
                this._selectEntry(false, this.m_menuEntries.length - 1);
            } else {
                this._selectEntry(false, this.m_menuEntrySelected - 1);
            }
        }
    }

    protected void _selectEntry(boolean _tween, int _slot) {
        if (this.m_menuEntrySelected != _slot) {
            this.m_menuEntrySelectedOld = this.m_menuEntrySelected;
            this.m_menuEntrySelected = _slot;
            if (this.m_menuEntrySelected >= 0 && this.m_menuEntrySelected < this.m_menuEntries.length) {
                this.m_menuEntries[this.m_menuEntrySelected].select();
                this.m_barMain.setText(TextDataBase.Instance().getText(m_menuEntriesTextsId[this.m_menuEntrySelected]));
            }
            if (this.m_menuEntrySelectedOld != this.m_menuEntrySelected && this.m_menuEntrySelectedOld >= 0 && this.m_menuEntrySelectedOld < this.m_menuEntries.length) {
                this.m_menuEntries[this.m_menuEntrySelectedOld].unselect();
            }
        }
    }
}

