/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import SSS.Managers.BTM.NewsFeedManager;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.UI.MainMenuEntry;
import SSS.Util.InputManager;
import org.flixel.FlxG;
import org.flixel.FlxText;
import precompiler.MACRO;

public class MenuCommunityState
extends TemplateGameMenu {
    static float DistBetweenChpaterBlocks = 300.0f;
    static float ChapterBlocksPercY = 0.45f;
    static float BarMainPercX = 0.5f;
    static float BarMainPercY = 0.8f;
    static float TitlePercY = 0.1f;
    static float TitleScale = 3.0f;
    static float SecretTextPercY = 0.95f;
    static float SecretTextScale = 1.5f;
    static MainMenuEntry.eType[] m_menuEntriesType = new MainMenuEntry.eType[]{MainMenuEntry.eType.GameModeOnlineLevel, MainMenuEntry.eType.GameModeLocalLevel};
    static String[] m_menuEntriesFlags = new String[]{"CommunityContent", "UserContent"};
    static String[] m_menuEntriesAnim = new String[]{"big2", "big1"};
    static String[] m_menuEntriesTextsId = new String[]{"TXT_ONLINE_CREATIONS", "TXT_MY_CREATIONS"};
    NewsFeedManager m_newsFeed = new NewsFeedManager();
    SssGroup m_layer;
    MainMenuEntry[] m_menuEntries;
    MainMenuEntry m_barMain;
    FlxText m_txtTitle;
    int m_menuEntrySelectedOld = 0;
    int m_menuEntrySelected = -1;
    boolean m_bValidating = false;

    @Override
    public void create() {
        super.create();
        this._build();
    }

    protected void _build() {
        MenuCommunityState.m_menuEntriesFlags[0] = MACRO.MAIN_AVENTURE_NAME;
        MenuCommunityState.m_menuEntriesFlags[1] = MACRO.MAIN_BONUS_CHAPTER_NAME;
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
        TextDataBase tdb = TextDataBase.Instance();
        this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_BUY"));
        this.m_layer = new SssGroup();
        this.add(this.m_layer);
        this.m_menuEntries = new MainMenuEntry[m_menuEntriesFlags.length];
        float centerx = (float)FlxG.width * 0.5f - (float)(this.m_menuEntries.length - 1) / 2.0f * DistBetweenChpaterBlocks;
        float centery = (float)FlxG.height * ChapterBlocksPercY;
        int i = 0;
        while (i < m_menuEntriesFlags.length) {
            this.m_menuEntries[i] = new MainMenuEntry(i, this.m_layer, this.m_tweenManager, m_menuEntriesType[i], null, m_menuEntriesFlags[i], m_menuEntriesAnim[i]);
            this.m_menuEntries[i].positionateAt(centerx, centery);
            centerx += DistBetweenChpaterBlocks;
            ++i;
        }
        this._templateWatchEntries(this.m_menuEntries);
        this.m_barMain = new MainMenuEntry(0, this.m_layer, this.m_tweenManager, MainMenuEntry.eType.GameModeDesc, null, null, null);
        this.m_barMain.positionateAt((float)FlxG.width * BarMainPercX, (float)FlxG.height * BarMainPercY);
        this.m_txtTitle = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtTitle.UseShadow(false);
        this.m_txtTitle.color(Color.Black());
        this.m_txtTitle.text(TextDataBase.Instance().getText("TXT_SELECT_GAME_MODE"));
        this.m_txtTitle.scale(TitleScale);
        this.m_txtTitle.y = (float)FlxG.height * TitlePercY;
        this.add(this.m_txtTitle);
        this._selectEntry(false, 0);
        this.m_newsFeed.build(this.defaultGroup);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_newsFeed.destroy();
    }

    @Override
    public void update() {
        super.update();
        this.m_newsFeed.update();
        if (!this.m_bValidating) {
            this._leftStickHandling();
        }
    }

    @Override
    protected void _onNewEntryUnderMouse(MainMenuEntry _entry, int slot, int groupId) {
        this._selectEntry(false, slot);
    }

    @Override
    protected void _onEntryUnderMouseSelected(MainMenuEntry _entry, int slot, int groupId) {
        this._onSelectPressed();
    }

    @Override
    protected void _onThanks() {
        this._launchThanksMap();
    }

    @Override
    protected void _onReturnPressed() {
        FlxG.state(new MenuMainState(false, false));
    }

    @Override
    protected void _onSelectPressed() {
        if (!this.m_bValidating && this.m_timeInState > MinTimeInState) {
            this.m_bValidating = true;
            this.m_menuEntries[this.m_menuEntrySelected].confirm();
        }
    }

    protected void _leftStickHandling() {
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight) || InputManager.IsNewButtonPress(Buttons.DPadRight)) {
            if (this.m_menuEntrySelected < this.m_menuEntries.length - 1) {
                this._selectEntry(false, this.m_menuEntrySelected + 1);
            } else {
                this._selectEntry(false, 0);
            }
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft) || InputManager.IsNewButtonPress(Buttons.DPadLeft)) {
            if (this.m_menuEntrySelected == 0) {
                this._selectEntry(false, this.m_menuEntries.length - 1);
            } else {
                this._selectEntry(false, this.m_menuEntrySelected - 1);
            }
        }
    }

    protected void _selectEntry(boolean _tween, int _slot) {
        if (this.m_menuEntrySelected != _slot) {
            this.m_menuEntrySelectedOld = this.m_menuEntrySelected;
            this.m_menuEntrySelected = _slot;
            if (this.m_menuEntrySelected >= 0 && this.m_menuEntrySelected < this.m_menuEntries.length) {
                this.m_menuEntries[this.m_menuEntrySelected].select();
                this.m_barMain.setText(TextDataBase.Instance().getText(m_menuEntriesTextsId[this.m_menuEntrySelected]));
            }
            if (this.m_menuEntrySelectedOld != this.m_menuEntrySelected && this.m_menuEntrySelectedOld >= 0 && this.m_menuEntrySelectedOld < this.m_menuEntries.length) {
                this.m_menuEntries[this.m_menuEntrySelectedOld].unselect();
            }
        }
    }
}

