/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.GamerServices.Guide;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.API.GameAPIManager;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.BTM.PlayState;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.CheatCodeState;
import SSS.States.BTM.LevelSelectionState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.UI.MainMenuEntry;
import SSS.Util.InputManager;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxGame;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import precompiler.MACRO;

public class MenuMainState
extends TemplateGameMenu {
    SssGroup m_layer;
    FlxText m_versionInfo;
    MainMenuEntry[] m_menuEntries;
    static float FirstEntryPercY = 0.4f;
    static String[] EntriesTextsIds = new String[]{"TXT_PLAY_THE_GAME", "TXT_COMMUNITY", "TXT_OPTIONS", "TXT_CREDITS"};
    static String[] EntriesTextsIdsWithFeature = new String[]{"TXT_PLAY_THE_GAME", "TXT_COMMUNITY", "TXT_OPTIONS", "TXT_CREDITS", ""};
    static MainMenuEntry.eType[] EntriesTypeFeature = new MainMenuEntry.eType[]{MainMenuEntry.eType.PlayTheGame, MainMenuEntry.eType.Community, MainMenuEntry.eType.Options, MainMenuEntry.eType.Credits, MainMenuEntry.eType.GameFeatures};
    MainMenuEntry.eType[] EntriesType = new MainMenuEntry.eType[]{MainMenuEntry.eType.PlayTheGame, MainMenuEntry.eType.Community, MainMenuEntry.eType.Options, MainMenuEntry.eType.Credits};
    int m_menuEntrySelectedOld = 0;
    int m_menuEntrySelected = -1;
    FlxSprite m_cursorLeft;
    FlxSprite m_cursorRight;
    boolean m_bValidating = false;
    boolean m_bFadeIn = false;
    boolean m_bCheckAch = false;
    float m_timeCheatPressed = 0.0f;
    static float TimeCheatMax = 3.0f;
    boolean m_cheatMenuActivated = false;
    FlxFadeListener _trialEndSimulationListener = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            MenuMainState.this._trialEndSimulation(_sender, _e);
        }
    };
    CallbackSimple _onGoToCheatListener = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _e) {
            MenuMainState.this._onGoToCheat(_sender, _e);
        }
    };
    FlxFadeListener _onQuitGameListener = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            MenuMainState.this._onQuitGame(_sender, _e);
        }
    };

    public MenuMainState(boolean _bFadeIn, boolean _bCcheckAch) {
        this.m_bFadeIn = _bFadeIn;
        this.m_bCheckAch = _bCcheckAch;
        if (MACRO.ACTIVATE_FEATURE) {
            EntriesTextsIds = EntriesTextsIdsWithFeature;
            this.EntriesType = EntriesTypeFeature;
        }
    }

    @Override
    public void create() {
        super.create();
        GameVars.RestorePlayerProperties();
        GameVars.AvoidSavePlayerProperties(false);
        FlxGame.CanCheckForTrialTimeOut = Guide.IsTrialMode();
        GameVars.GameMode(GameMode.GameMode_Unknown);
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.CenterTopMediumCommunity);
        TextDataBase tdb = TextDataBase.Instance();
        if (MACRO.USE_LOGIN_AND_SLOT) {
            this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Login, TemplateGameMenu.eButtonAction.Quit, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
            this._templateChangeIconsTexts(tdb.getText("TXT_LOGIN"), tdb.getText("TXT_QUIT"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_BUY"));
        } else {
            this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Quit, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
            this._templateChangeIconsTexts(tdb.getText("TXT_QUIT"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_BUY"));
        }
        this.m_versionInfo = new FlxText(0.0f, 0.0f, FlxG.width);
        String plateform = GameAPIManager.GetApiFriendlyName();
        if (plateform.length() > 0) {
            plateform = " (" + plateform + ")";
        }
        this.m_versionInfo.text(TextDataBase.Instance().getText("TXT_VERSION").replace("[v]", String.valueOf(GameVars.GameVersion()) + plateform));
        this.m_versionInfo.scale(1.8f);
        this.m_versionInfo.x = 0.0f;
        this.m_versionInfo.y = (float)FlxG.height - (float)this.m_versionInfo.textHeight() * 1.5f;
        this.add(this.m_versionInfo);
        this.m_layer = new SssGroup();
        this.add(this.m_layer);
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this.m_versionInfo = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_versionInfo.x = 0.0f;
        this.m_versionInfo.y = (float)FlxG.height - this.m_versionInfo.height;
        this.m_menuEntries = new MainMenuEntry[EntriesTextsIds.length];
        float centerx = (float)FlxG.width * 0.5f;
        float centery = (float)FlxG.height * FirstEntryPercY;
        float centeryStep = 100.0f;
        int i = 0;
        while (i < EntriesTextsIds.length) {
            this.m_menuEntries[i] = new MainMenuEntry(i, this.m_layer, this.m_tweenManager, this.EntriesType[i], null, null, null);
            if (this.EntriesType[i] != MainMenuEntry.eType.GameFeatures) {
                this.m_menuEntries[i].positionateAt(centerx, centery);
                centery += centeryStep;
            } else {
                this.m_menuEntries[i].positionateAt(0.15f * (float)FlxG.width, 0.65f * (float)FlxG.height);
            }
            if (EntriesTextsIds[i].length() > 0) {
                this.m_menuEntries[i].setText(TextDataBase.Instance().getText(EntriesTextsIds[i]));
            }
            ++i;
        }
        this._templateWatchEntries(this.m_menuEntries);
        this.m_cursorLeft = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorLeft.play("pointRight");
        this.m_layer.add(this.m_cursorLeft);
        this.m_cursorRight = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorRight.play("pointLeft");
        this.m_layer.add(this.m_cursorRight);
        this._selectEntry(false, 0);
        this._tweenLogo(true, 0.5f, true);
        if (this.m_bFadeIn) {
            FlxG.fade.start(Color.Black(), 0.5f, null, true, false);
        }
        if (this.m_bCheckAch) {
            try {
                AchievementManager.Instance().saveLoadTimeCheckSaveBasedAchievments();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void _selectEntry(boolean _tween, int _slot) {
        if (this.m_menuEntrySelected != _slot) {
            this.m_menuEntrySelectedOld = this.m_menuEntrySelected;
            this.m_menuEntrySelected = _slot;
            if (!_tween) {
                this.m_cursorLeft.x = this.m_menuEntries[this.m_menuEntrySelected].getLeftX() - this.m_cursorLeft.width * 0.5f;
                this.m_cursorRight.x = this.m_menuEntries[this.m_menuEntrySelected].getRightX() - this.m_cursorRight.width * 0.5f;
                this.m_cursorLeft.y = this.m_menuEntries[this.m_menuEntrySelected].getCenterY() - this.m_cursorLeft.height * 0.5f;
                this.m_cursorRight.y = this.m_menuEntries[this.m_menuEntrySelected].getCenterY() - this.m_cursorRight.height * 0.5f;
                this.m_cursorLeft.scale(0.5f);
                this.m_cursorRight.scale(0.5f);
                this.m_tweenManager.ToScale((Tweenable)this.m_cursorLeft, Vector2.One(), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToScale((Tweenable)this.m_cursorRight, Vector2.One(), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            }
            if (this.m_menuEntrySelected >= 0 && this.m_menuEntrySelected < this.m_menuEntries.length) {
                this.m_menuEntries[this.m_menuEntrySelected].select();
            }
            if (this.m_menuEntrySelectedOld != this.m_menuEntrySelected && this.m_menuEntrySelectedOld >= 0 && this.m_menuEntrySelectedOld < this.m_menuEntries.length) {
                this.m_menuEntries[this.m_menuEntrySelectedOld].unselect();
            }
        }
    }

    @Override
    protected void _onNewEntryUnderMouse(MainMenuEntry _entry, int slot, int groupId) {
        this._selectEntry(false, slot);
    }

    @Override
    protected void _onEntryUnderMouseSelected(MainMenuEntry _entry, int slot, int groupId) {
        this._onSelectPressed();
    }

    @Override
    public void update() {
        super.update();
        if (!this.m_bValidating) {
            this._leftStickHandling();
            this._checkCheat();
        }
    }

    protected void _checkCheat() {
        if (!this.m_cheatMenuActivated) {
            if (InputManager.IsButtonDown(Buttons.Start) && InputManager.IsButtonDown(Buttons.Back)) {
                this.m_timeCheatPressed += FlxG.elapsed;
                if (this.m_timeCheatPressed > TimeCheatMax) {
                    if (Guide.IsTrialMode()) {
                        this.m_cheatMenuActivated = true;
                        FlxG.fade.start(Color.Black(), 0.5f, this._trialEndSimulationListener, true, true);
                    } else {
                        this.m_cheatMenuActivated = true;
                        FlxG.flash.start(Color.Blue(), 0.25f, this._onGoToCheatListener, true);
                        FlxG.quake.start(0.01f, 0.25f);
                    }
                }
            } else {
                this.m_timeCheatPressed = 0.0f;
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    protected void _leftStickHandling() {
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown) || InputManager.IsNewButtonPress(Buttons.DPadDown)) {
            if (this.m_menuEntrySelected < this.m_menuEntries.length - 1) {
                this._selectEntry(false, this.m_menuEntrySelected + 1);
            } else {
                this._selectEntry(false, 0);
            }
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp) || InputManager.IsNewButtonPress(Buttons.DPadUp)) {
            if (this.m_menuEntrySelected == 0) {
                this._selectEntry(false, this.m_menuEntries.length - 1);
            } else {
                this._selectEntry(false, this.m_menuEntrySelected - 1);
            }
        } else if (MACRO.ACTIVATE_FEATURE && (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight) || InputManager.IsNewButtonPress(Buttons.DPadRight) || InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft) || InputManager.IsNewButtonPress(Buttons.DPadLeft)) && this.m_menuEntrySelected >= 0 && this.m_menuEntrySelected < this.m_menuEntries.length) {
            if (this.m_menuEntries[this.m_menuEntrySelected].Type() == MainMenuEntry.eType.GameFeatures) {
                if (this.m_menuEntrySelectedOld >= 0 && this.m_menuEntrySelectedOld < this.m_menuEntries.length) {
                    this._selectEntry(false, this.m_menuEntrySelectedOld);
                } else {
                    this._selectEntry(false, 0);
                }
            } else {
                this._selectEntry(false, this.m_menuEntries.length - 1);
            }
        }
    }

    @Override
    protected void _onThanks() {
        this._launchThanksMap();
    }

    @Override
    protected void _onReturnPressed() {
        if (!InputManager.IsButtonDown(Buttons.Start, true)) {
            this.m_bLastEventProcessed = false;
            FlxG.fade.start(Color.Black(), 1.0f, this._onQuitGameListener, true, true);
        }
    }

    @Override
    protected void _onSelectPressed() {
        if (!this.m_bValidating && this.m_timeInState > MinTimeInState) {
            this.m_bValidating = true;
            this.m_menuEntries[this.m_menuEntrySelected].confirm();
        }
    }

    @Override
    protected void _onLoginPressed() {
        if (!this.m_bValidating) {
            FlxG.state(new LevelSelectionState(false, "SaveSlots", null));
        }
    }

    protected void _trialEndSimulation(Object _sender, Object _e) {
        FlxG.state(new PlayState(true, false, "BUY", "Specials"));
    }

    protected void _onGoToCheat(Object _sender, Object _e) {
        FlxG.state(new CheatCodeState());
    }

    protected void _onQuitGame(Object _sender, Object _e) {
        FlxG.Game.Exit();
    }
}

