/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.BTM.PlayState;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.NewsFeedManager;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.FileManager;
import SSS.Managers.LoginManager;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.MenuCommunityState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.UI.LevelItemRateComparator;
import SSS.UI.MainMenuEntry;
import SSS.Util.InputManager;
import SSS.Util.LevelItem;
import SSS.Util.LevelItemAttribs;
import SSS.Util.LevelItemDateComparator;
import SSS.editor.DefaultLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import precompiler.MACRO;

public class OnlineLevelBrowsingState
extends TemplateGameMenu {
    static int NumTabsOnlineMode = 5;
    static String[] TabsTxtId = new String[]{"All", "Feat.", "Top", "DL", "Mine"};
    static eTabAction[] TabsActions = new eTabAction[]{eTabAction.TabAction_ShowAll, eTabAction.TabAction_ShowFeatured, eTabAction.TabAction_ShowTopRated, eTabAction.TabAction_ShowDL, eTabAction.TabAction_ShowMine};
    static eTabAction m_lastTabAction = eTabAction.TabAction_ShowAll;
    static int NumEntriesMaxPerPage = 5;
    static float FirstEntryPercY = 0.2f;
    NewsFeedManager m_newsFeed;
    FlxText[] m_txtThumbUp;
    FlxText[] m_txtThumbDown;
    FlxText[] m_txtLevelAutor;
    FlxSprite[] m_featuredIcons;
    FlxSprite[] m_localIcons;
    FlxSprite[] m_onlineIcons;
    FlxSprite[] m_thumbsUpIcons;
    FlxSprite[] m_thumbDownIcons;
    FlxSprite[] m_updateAvailableIcons;
    FlxSprite[] m_chestIcons;
    FlxSprite[] m_starIcons;
    FlxSprite m_bigThumbUp;
    FlxSprite m_bigThumbDown;
    FlxText m_txtKeyBigThumbUp;
    FlxText m_txtKeyBigThumbDown;
    FlxText m_txtKeySkip;
    FlxText m_txtSkip;
    FlxText m_txtYes;
    FlxText m_txtNo;
    FlxSprite m_btnBigThumUp;
    FlxSprite m_btnBigThumDown;
    FlxSprite m_btnSkip;
    FlxText m_txtFiltering;
    MainMenuEntry[] m_tabEntries;
    int m_watchIdTabEntries = -1;
    static int m_tabSelected = 0;
    FlxText m_txtLeftTab;
    FlxText m_txtRightTab;
    MainMenuEntry[] m_menuEntries;
    int m_watchIdMenuEntries = -1;
    SssGroup m_entriesLayer;
    SssGroup m_tabEntriesLayer;
    int m_menuEntrySelectedOld = -1;
    int m_menuEntrySelected = -1;
    ArrayList<LevelItem> m_levelNamesBackupSearch;
    ArrayList<LevelItem> m_levelNames;
    ArrayList<LevelItem> m_levelSaveLocally;
    ArrayList<LevelItem> m_levelFeatured;
    FlxSprite m_cursorLeft;
    FlxSprite m_cursorRight;
    FlxText m_txtPageInfo;
    int m_numPage;
    int m_idPage = 0;
    boolean m_bOnlineBrowsing = false;
    boolean m_bSearchCurrentLevel = false;
    boolean m_bLoadingStuff = false;
    boolean m_bLaunchingLevel = false;
    float m_timeFade = 0.8f;
    boolean m_bSomethingInBase = false;
    boolean m_bRepositionnateOnLastItem = true;
    boolean m_bLaunchSelectedLevelOnFrame = false;
    boolean m_bWaitingApproval = false;
    boolean m_bAskThingTriggered = false;
    boolean m_bAskThing = false;
    eAskStuffType m_askedType;
    String m_lastSearch = null;
    float m_timeAutoBack = 0.0f;
    float m_timeAutoBackTick = 0.08f;
    FlxSprite m_backgroundQuestion;
    FlxSprite m_backgroundAnwser;
    FlxText m_txtAskQuestion;
    FlxText m_txtAnwser;
    FlxText m_txtEmptyBank;
    FlxSprite m_logoLoading;
    Thread m_threadLoader;
    static eLoadAction m_nextStartAction = eLoadAction.None;
    static eLoadAction m_actionDeferred = eLoadAction.None;
    eLoadAction m_action = eLoadAction.None;
    static String m_nextStartActionArgs;
    boolean m_bCheckAutoplayNextlevel = false;
    String m_autoNextLevelName = null;
    static ArrayList<String> m_finishedLevels;
    static HashMap<String, LevelItemAttribs> m_finishedLevelsAttribs;
    CallbackSimple m_onUploadDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            OnlineLevelBrowsingState.this._onUploadDone();
        }
    };
    CallbackSimple m_onUploadFailed = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            OnlineLevelBrowsingState.this._onUploadFailed();
        }
    };
    CallbackSimple m_onUploadFail = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            OnlineLevelBrowsingState.this._onUploadFail();
        }
    };
    CallbackSimple m_onUploadLevelNeedToBePlayed = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            OnlineLevelBrowsingState.this._onUploadLevelNeedToBePlayed();
        }
    };
    CallbackSimple m_onListingDoneRepositionnate = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            OnlineLevelBrowsingState.this._onListingDone(true);
            OnlineLevelBrowsingState.this._checkLevelErrorMessage();
        }
    };
    CallbackSimple m_onListingDoneNoRepositionnate = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            OnlineLevelBrowsingState.this._onListingDone(false);
            OnlineLevelBrowsingState.this._checkLevelErrorMessage();
        }
    };
    FlxFadeListener m_fadeLevelAutoSelectComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            OnlineLevelBrowsingState.this._fadeLevelAutoSelectComplete(_sender, _e);
        }
    };
    FlxFadeListener m_fadeLevelSelectComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            OnlineLevelBrowsingState.this._fadeLevelSelectComplete(_sender, _e);
        }
    };

    static {
        m_finishedLevels = new ArrayList(20);
        m_finishedLevelsAttribs = new HashMap(20);
    }

    public static void NextStartAction(eLoadAction _action) {
        m_nextStartAction = _action;
    }

    public static void NextStartAction(eLoadAction _action, String _args) {
        m_nextStartAction = _action;
        m_nextStartActionArgs = _args;
    }

    public OnlineLevelBrowsingState(boolean _bOnlineBrowsing, boolean _bSearchCurrentLevel) {
        this.m_bOnlineBrowsing = _bOnlineBrowsing;
        this.m_bSearchCurrentLevel = _bSearchCurrentLevel;
        this.m_action = m_nextStartAction;
        m_nextStartAction = eLoadAction.None;
        this.m_newsFeed = new NewsFeedManager();
    }

    @Override
    public void create() {
        super.create();
        this._build();
    }

    protected void _build() {
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.Hidden);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Login, TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.ShareCommunity);
        TextDataBase tdb = TextDataBase.Instance();
        if (this.m_bOnlineBrowsing) {
            this._templateChangeIconsTexts(tdb.getText("TXT_SEARCH"), tdb.getText("TXT_RETURN"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_REPORT"));
        } else {
            this._templateChangeIconsTexts(tdb.getText("TXT_CREATE_NEW"), tdb.getText("TXT_RETURN"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_SUBMIT"));
        }
        float centerx = (float)FlxG.width * 0.5f;
        float centery = (float)FlxG.height * FirstEntryPercY;
        float centeryStep = 100.0f;
        if (this.m_bOnlineBrowsing) {
            centery += 50.0f;
        }
        this.m_entriesLayer = new SssGroup();
        this.m_entriesLayer.visible = false;
        this.m_tabEntriesLayer = new SssGroup();
        this.add(this.m_entriesLayer);
        this.add(this.m_tabEntriesLayer);
        this.m_menuEntries = new MainMenuEntry[NumEntriesMaxPerPage];
        this.m_txtThumbUp = new FlxText[NumEntriesMaxPerPage];
        this.m_txtThumbDown = new FlxText[NumEntriesMaxPerPage];
        this.m_txtLevelAutor = new FlxText[NumEntriesMaxPerPage];
        this.m_featuredIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_localIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_onlineIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_thumbsUpIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_thumbDownIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_updateAvailableIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_chestIcons = new FlxSprite[NumEntriesMaxPerPage];
        this.m_starIcons = new FlxSprite[NumEntriesMaxPerPage];
        FlxSprite thumbUpIcon = new FlxSprite();
        thumbUpIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_like_yes"));
        FlxSprite thumbDownIcon = new FlxSprite();
        thumbDownIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_like_no"));
        FlxSprite featuredIcon = new FlxSprite();
        featuredIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_featured"));
        FlxSprite onlineIcon = new FlxSprite();
        onlineIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_online"));
        FlxSprite localIcon = new FlxSprite();
        localIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_local"));
        FlxSprite updateIcon = new FlxSprite();
        updateIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_update"));
        FlxSprite chestIcon = new FlxSprite();
        chestIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/blocks64MAP"), true, false, 100, 100);
        chestIcon.addAnimation("0", new int[]{9});
        chestIcon.play("0");
        chestIcon.scale(0.3f);
        FlxSprite starIcon = new FlxSprite();
        starIcon.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Star_big"));
        starIcon.scale(0.115f);
        float txtScaleFactor = this.m_bOnlineBrowsing ? 0.8f : 1.0f;
        int i = 0;
        while (i < NumEntriesMaxPerPage) {
            this.m_menuEntries[i] = new MainMenuEntry(i, this.m_entriesLayer, this.m_tweenManager, this.m_bOnlineBrowsing ? MainMenuEntry.eType.OnlineLevelEntry : MainMenuEntry.eType.LocalLevelEntry, null, null, null, txtScaleFactor);
            this.m_menuEntries[i].positionateAt(centerx, centery);
            this.m_menuEntries[i].setText("");
            this.m_menuEntries[i].visible(false);
            FlxText txtUp = new FlxText(0.0f, 0.0f, 15.0f);
            FlxText txtDown = new FlxText(0.0f, 0.0f, 15.0f);
            FlxText txtAuthor = new FlxText(0.0f, 0.0f, 200.0f);
            txtUp.text("0");
            txtDown.text("0");
            txtAuthor.text("Anonymous Sailor");
            txtUp.color(Color.Green());
            txtDown.color(Color.Red());
            txtAuthor.color(Color.Gray());
            txtUp.scale(1.5f);
            txtDown.scale(1.5f);
            txtUp.alignment = FlxText.FlxJustification.Center;
            txtDown.alignment = FlxText.FlxJustification.Center;
            txtAuthor.alignment = FlxText.FlxJustification.Center;
            txtUp.visible = false;
            txtDown.visible = false;
            txtAuthor.visible = false;
            float offsetx = 240.0f;
            float offsety = 15.0f;
            txtUp.x = centerx + offsetx;
            txtUp.y = centery + offsety;
            txtDown.x = centerx + offsetx + 30.0f;
            txtDown.y = centery + offsety;
            float authorOffsetx = -90.0f;
            float authorOffsety = 20.0f;
            txtAuthor.x = centerx + authorOffsetx;
            txtAuthor.y = centery + authorOffsety;
            this.m_txtLevelAutor[i] = txtAuthor;
            this.m_txtThumbUp[i] = txtUp;
            this.m_txtThumbDown[i] = txtDown;
            this.m_entriesLayer.add(txtUp);
            this.m_entriesLayer.add(txtDown);
            this.m_entriesLayer.add(txtAuthor);
            this.m_featuredIcons[i] = new FlxSprite(featuredIcon);
            this.m_localIcons[i] = new FlxSprite(localIcon);
            this.m_onlineIcons[i] = new FlxSprite(onlineIcon);
            this.m_thumbsUpIcons[i] = new FlxSprite(thumbUpIcon);
            this.m_thumbDownIcons[i] = new FlxSprite(thumbDownIcon);
            this.m_updateAvailableIcons[i] = new FlxSprite(updateIcon);
            this.m_chestIcons[i] = new FlxSprite(chestIcon);
            this.m_starIcons[i] = new FlxSprite(starIcon);
            this.m_featuredIcons[i].x = centerx - 294.0f;
            this.m_featuredIcons[i].y = centery - 50.0f;
            this.m_localIcons[i].x = centerx - 286.0f;
            this.m_localIcons[i].y = centery - 12.0f;
            this.m_onlineIcons[i].x = this.m_localIcons[i].x + this.m_localIcons[i].width * 0.5f - this.m_onlineIcons[i].width * 0.5f;
            this.m_onlineIcons[i].y = this.m_localIcons[i].y + this.m_localIcons[i].height * 0.5f - this.m_onlineIcons[i].height * 0.5f;
            this.m_thumbsUpIcons[i].x = centerx + 215.0f;
            this.m_thumbsUpIcons[i].y = centery - 32.0f;
            this.m_thumbDownIcons[i].x = this.m_thumbsUpIcons[i].x + 30.0f;
            this.m_thumbDownIcons[i].y = this.m_thumbsUpIcons[i].y;
            this.m_updateAvailableIcons[i].x = this.m_localIcons[i].x + this.m_localIcons[i].width * 0.5f - this.m_updateAvailableIcons[i].width * 0.5f;
            this.m_updateAvailableIcons[i].y = this.m_localIcons[i].y + this.m_localIcons[i].height * 0.5f - this.m_updateAvailableIcons[i].height * 0.5f;
            this.m_updateAvailableIcons[i].color(Color.YellowSub());
            this.m_chestIcons[i].x = this.m_onlineIcons[i].x + this.m_chestIcons[i].width * this.m_chestIcons[i].scale() * 0.5f;
            this.m_chestIcons[i].y = this.m_onlineIcons[i].y - this.m_chestIcons[i].height * this.m_chestIcons[i].scale() * 0.5f;
            this.m_chestIcons[i].color(new Color(0.4f, 0.4f, 0.4f));
            this.m_starIcons[i].x = this.m_chestIcons[i].x + this.m_chestIcons[i].width * 0.5f - this.m_starIcons[i].width * 0.5f;
            this.m_starIcons[i].y = this.m_chestIcons[i].y - this.m_starIcons[i].height * 0.4f;
            this.m_tweenManager.ToAlpha((Tweenable)this.m_updateAvailableIcons[i], 0.2f, 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
            this._hideIcons(i);
            this.m_entriesLayer.add(this.m_featuredIcons[i]);
            this.m_entriesLayer.add(this.m_localIcons[i]);
            this.m_entriesLayer.add(this.m_onlineIcons[i]);
            this.m_entriesLayer.add(this.m_thumbsUpIcons[i]);
            this.m_entriesLayer.add(this.m_thumbDownIcons[i]);
            this.m_entriesLayer.add(this.m_updateAvailableIcons[i]);
            this.m_entriesLayer.add(this.m_chestIcons[i]);
            this.m_entriesLayer.add(this.m_starIcons[i]);
            centery += centeryStep;
            ++i;
        }
        this.m_watchIdMenuEntries = this._templateWatchEntries(this.m_menuEntries);
        if (this.m_bOnlineBrowsing) {
            this._buildTabs();
        }
        this.m_cursorLeft = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorLeft.play("pointRight");
        this.m_cursorLeft.visible = false;
        this.m_entriesLayer.add(this.m_cursorLeft);
        this.m_cursorRight = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorRight.play("pointLeft");
        this.m_cursorRight.visible = false;
        this.m_entriesLayer.add(this.m_cursorRight);
        this.m_txtPageInfo = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtPageInfo.alignment = FlxText.FlxJustification.Right;
        this.m_txtPageInfo.color(Color.White());
        this.m_txtPageInfo.scale(2.0f);
        this.m_txtPageInfo.text("page 0/0");
        this.m_txtPageInfo.x = (float)FlxG.width - this.m_txtPageInfo.width;
        this.m_txtPageInfo.y = (float)FlxG.height - this.m_txtPageInfo.height - 15.0f;
        this.add(this.m_txtPageInfo);
        this.m_txtEmptyBank = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtEmptyBank.alignment = FlxText.FlxJustification.Center;
        this.m_txtEmptyBank.scale(2.0f);
        if (!this.m_bOnlineBrowsing && !MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
            this.m_txtEmptyBank.text(tdb.getText("TXT_NOTHING_HERE_DEMO"));
        } else if (!this.m_bOnlineBrowsing) {
            this.m_txtEmptyBank.text(String.valueOf(tdb.getText("TXT_NOTHING_YET")) + " " + tdb.getText("TXT_USE_CREATE_FOR_NEW_LEVEL"));
        } else {
            this.m_txtEmptyBank.text(tdb.getText("TXT_NOTHING_YET"));
        }
        this.m_txtEmptyBank.visible = false;
        this.m_txtEmptyBank.y = (float)FlxG.height * 0.5f - 20.0f;
        this.add(this.m_txtEmptyBank);
        if (this.m_bOnlineBrowsing) {
            this.m_txtFiltering = new FlxText(0.0f, 0.0f, 50.0f);
            this.m_txtFiltering.color(Color.YellowSub());
            this.m_txtFiltering.scale(1.2f);
            this.m_txtFiltering.text(tdb.getText("TXT_FILTERED_VIEW"));
            this.m_txtFiltering.alignment = FlxText.FlxJustification.Center;
            this.m_txtFiltering.x = 80.0f;
            this.m_txtFiltering.y = 120.0f;
            this.m_txtFiltering.visible = false;
            this.add(this.m_txtFiltering);
        }
        this.m_newsFeed.build(this.defaultGroup);
        this._buildAskUI();
        this.m_logoLoading = new FlxSprite();
        this.m_logoLoading.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_logo"), false);
        this.m_logoLoading.x = (float)FlxG.width * 0.5f - this.m_logoLoading.width * 0.5f;
        this.m_logoLoading.y = (float)FlxG.height * 0.5f - this.m_logoLoading.height * 0.5f;
        this.m_logoLoading.visible = false;
        this.add(this.m_logoLoading);
        if (!this.m_bOnlineBrowsing) {
            GameVars.GameMode(GameMode.GameMode_LocalLevelEditor);
            this._loadWorkspaceThreaded();
        } else {
            GameVars.GameMode(GameMode.GameMode_OnlineContent);
            this._loadOnlineThreaded(true);
        }
    }

    protected void _buildIcons() {
        float iconMiddleCenterX = (float)FlxG.width * 0.5f;
        float iconLeftCenterX = (float)FlxG.width * 0.35f;
        float iconRightCenterX = (float)FlxG.width * 0.65f;
        float iconLeftRightCenterY = (float)FlxG.height * 0.65f;
        float iconMiddleCenterY = (float)FlxG.height * 0.55f;
        this.m_bigThumbUp = new FlxSprite();
        this.m_bigThumbUp.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_like_yes_big"));
        this.m_bigThumbUp.x = iconLeftCenterX - this.m_bigThumbUp.width * 0.5f;
        this.m_bigThumbUp.y = iconLeftRightCenterY - this.m_bigThumbUp.height * 0.5f;
        this.m_bigThumbDown = new FlxSprite();
        this.m_bigThumbDown.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/icons/icon_like_no_big"));
        this.m_bigThumbDown.x = iconRightCenterX - this.m_bigThumbDown.width * 0.5f;
        this.m_bigThumbDown.y = iconLeftRightCenterY - this.m_bigThumbDown.height * 0.5f;
        this.m_txtSkip = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtSkip.alignment = FlxText.FlxJustification.Center;
        this.m_txtSkip.color(Color.YellowSub());
        this.m_txtSkip.text("Skip");
        this.m_txtSkip.scale(2.0f);
        this.m_txtSkip.x = iconMiddleCenterX - 100.0f;
        this.m_txtSkip.y = iconLeftRightCenterY - 20.0f;
        this.add(this.m_txtSkip);
        this.m_txtYes = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtYes.alignment = FlxText.FlxJustification.Center;
        this.m_txtYes.color(Color.Red());
        this.m_txtYes.text("Yes");
        this.m_txtYes.scale(3.0f);
        this.m_txtYes.x = this.m_bigThumbUp.x + this.m_bigThumbUp.width * 0.5f - 100.0f;
        this.m_txtYes.y = this.m_bigThumbUp.y + this.m_bigThumbUp.height * 0.5f - 20.0f;
        this.add(this.m_txtYes);
        this.m_txtNo = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtNo.alignment = FlxText.FlxJustification.Center;
        this.m_txtNo.color(Color.Green());
        this.m_txtNo.text("No");
        this.m_txtNo.scale(3.0f);
        this.m_txtNo.x = this.m_bigThumbDown.x + this.m_bigThumbDown.width * 0.5f - 100.0f;
        this.m_txtNo.y = this.m_bigThumbDown.y + this.m_bigThumbDown.height * 0.5f - 20.0f;
        this.add(this.m_txtNo);
        this.m_btnBigThumUp = ResourcesLibrary.Instance().InstanciateSprite("buttons_plalette");
        this.m_btnBigThumUp.play("XBOX_X");
        this.m_btnBigThumUp.x = this.m_bigThumbUp.x + this.m_bigThumbUp.width * 0.5f - this.m_btnBigThumUp.width * 0.5f;
        this.m_btnBigThumUp.y = this.m_bigThumbUp.y + this.m_bigThumbUp.height + this.m_btnBigThumUp.height;
        this.add(this.m_btnBigThumUp);
        this.m_btnBigThumDown = ResourcesLibrary.Instance().InstanciateSprite("buttons_plalette");
        this.m_btnBigThumDown.play("XBOX_B");
        this.m_btnBigThumDown.x = this.m_bigThumbDown.x + this.m_bigThumbDown.width * 0.5f - this.m_btnBigThumDown.width * 0.5f;
        this.m_btnBigThumDown.y = this.m_bigThumbDown.y + this.m_bigThumbDown.height + this.m_btnBigThumDown.height;
        this.add(this.m_btnBigThumDown);
        this.m_btnSkip = ResourcesLibrary.Instance().InstanciateSprite("buttons_plalette");
        this.m_btnSkip.play("XBOX_Y");
        this.m_btnSkip.x = iconMiddleCenterX - this.m_btnSkip.width * 0.5f;
        this.m_btnSkip.y = this.m_txtSkip.y + this.m_btnSkip.height * 2.0f;
        this.add(this.m_btnSkip);
        this.m_txtKeyBigThumbUp = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtKeyBigThumbUp.alignment = FlxText.FlxJustification.Center;
        this.m_txtKeyBigThumbUp.text("[Y]");
        this.m_txtKeyBigThumbUp.x = this.m_btnBigThumUp.x - 100.0f + this.m_btnBigThumUp.width * 0.5f;
        this.m_txtKeyBigThumbUp.y = this.m_btnBigThumUp.y;
        this.m_txtKeyBigThumbUp.scale(2.0f);
        this.add(this.m_txtKeyBigThumbUp);
        this.m_txtKeyBigThumbDown = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtKeyBigThumbDown.alignment = FlxText.FlxJustification.Center;
        this.m_txtKeyBigThumbDown.text("[N]");
        this.m_txtKeyBigThumbDown.x = this.m_btnBigThumDown.x - 100.0f + this.m_btnBigThumDown.width * 0.5f;
        this.m_txtKeyBigThumbDown.y = this.m_btnBigThumDown.y;
        this.m_txtKeyBigThumbDown.scale(2.0f);
        this.add(this.m_txtKeyBigThumbDown);
        this.m_txtKeySkip = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_txtKeySkip.alignment = FlxText.FlxJustification.Center;
        this.m_txtKeySkip.text("[S]");
        this.m_txtKeySkip.x = this.m_btnSkip.x - 100.0f + this.m_btnSkip.width * 0.5f;
        this.m_txtKeySkip.y = this.m_btnSkip.y;
        this.m_txtKeySkip.scale(2.0f);
        this.add(this.m_txtKeySkip);
        this.add(this.m_bigThumbUp);
        this.add(this.m_bigThumbDown);
        this._makeVoteIconsAppearDisappear(true, 0.0f, -1, false);
    }

    protected void _makeVoteIconsAppearDisappear(boolean _bAppear, float _time, int _ysnChoiceOrNeg, boolean _bYesNoQuestion) {
        boolean bGamePad;
        float alpha;
        float f = alpha = _bAppear ? 0.0f : 1.0f;
        if (!_bYesNoQuestion) {
            this.m_bigThumbUp.alpha(alpha);
            this.m_bigThumbDown.alpha(alpha);
            this.m_txtSkip.alpha(alpha);
            this.m_txtYes.alpha(0.0f);
            this.m_txtNo.alpha(0.0f);
        } else {
            this.m_bigThumbUp.alpha(0.0f);
            this.m_bigThumbDown.alpha(0.0f);
            this.m_txtSkip.alpha(0.0f);
            this.m_txtYes.alpha(alpha);
            this.m_txtNo.alpha(alpha);
        }
        this.m_tweenManager.RemoveTweenable(this.m_btnBigThumUp);
        this.m_tweenManager.RemoveTweenable(this.m_btnBigThumDown);
        this.m_tweenManager.RemoveTweenable(this.m_txtKeyBigThumbUp);
        this.m_tweenManager.RemoveTweenable(this.m_txtKeyBigThumbDown);
        this.m_tweenManager.RemoveTweenable(this.m_txtKeySkip);
        this.m_tweenManager.RemoveTweenable(this.m_txtSkip);
        this.m_tweenManager.RemoveTweenable(this.m_btnBigThumUp);
        this.m_tweenManager.RemoveTweenable(this.m_btnBigThumDown);
        this.m_tweenManager.RemoveTweenable(this.m_btnSkip);
        if (_bYesNoQuestion) {
            this.m_tweenManager.RemoveTweenable(this.m_txtYes);
            this.m_tweenManager.RemoveTweenable(this.m_txtNo);
        }
        if (bGamePad = InputManager.IsAnyGamepadConnected()) {
            this.m_txtKeyBigThumbUp.alpha(0.0f);
            this.m_txtKeyBigThumbDown.alpha(0.0f);
            this.m_txtKeySkip.alpha(0.0f);
            this.m_btnBigThumUp.alpha(alpha);
            this.m_btnBigThumDown.alpha(alpha);
            if (!_bYesNoQuestion) {
                this.m_btnSkip.alpha(alpha);
            }
        }
        if (!bGamePad) {
            this.m_txtKeyBigThumbUp.alpha(alpha);
            this.m_txtKeyBigThumbDown.alpha(alpha);
            if (!_bYesNoQuestion) {
                this.m_txtKeySkip.alpha(alpha);
            }
            this.m_btnBigThumUp.alpha(0.0f);
            this.m_btnBigThumDown.alpha(0.0f);
            this.m_btnSkip.alpha(0.0f);
        }
        if (_time > 0.0f) {
            alpha = 1.0f - alpha;
            if (!_bYesNoQuestion) {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtSkip, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            } else {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtNo, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtYes, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
            if (bGamePad) {
                if (!_bYesNoQuestion) {
                    this.m_tweenManager.ToAlpha((Tweenable)this.m_btnSkip, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                }
                this.m_tweenManager.ToAlpha((Tweenable)this.m_btnBigThumUp, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_btnBigThumDown, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
            if (!bGamePad) {
                if (!_bYesNoQuestion) {
                    this.m_tweenManager.ToAlpha((Tweenable)this.m_txtKeySkip, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                }
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtKeyBigThumbUp, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtKeyBigThumbDown, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
            if (_bAppear) {
                if (!_bYesNoQuestion) {
                    this.m_tweenManager.ToScale((Tweenable)this.m_bigThumbUp, new Vector2(1.1f), 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
                    this.m_tweenManager.ToScale((Tweenable)this.m_bigThumbDown, new Vector2(1.1f), 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
                    this.m_tweenManager.ToAlpha((Tweenable)this.m_bigThumbUp, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                    this.m_tweenManager.ToAlpha((Tweenable)this.m_bigThumbDown, alpha, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                }
            } else if (!_bYesNoQuestion) {
                this.m_tweenManager.RemoveTweenable(this.m_bigThumbUp);
                this.m_tweenManager.RemoveTweenable(this.m_bigThumbDown);
                FlxSprite _selectedTween = null;
                if (_ysnChoiceOrNeg == 0) {
                    _selectedTween = this.m_bigThumbUp;
                } else if (_ysnChoiceOrNeg == 2) {
                    _selectedTween = this.m_bigThumbDown;
                }
                if (_selectedTween != null) {
                    this.m_tweenManager.ToScale((Tweenable)_selectedTween, new Vector2(2.2f), _time, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
                }
                this.m_tweenManager.ToAlpha((Tweenable)this.m_bigThumbUp, 0.0f, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_bigThumbDown, 0.0f, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            } else {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtYes, 0.0f, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToAlpha((Tweenable)this.m_txtNo, 0.0f, _time, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
        }
    }

    protected void _buildTabs() {
        float stepx = 150.0f;
        float centerx = (float)FlxG.width * 0.5f + (float)(NumTabsOnlineMode / 2) * stepx;
        float centery = 80.0f;
        this.m_txtLeftTab = new FlxText(0.0f, 0.0f, 100.0f);
        this.m_txtRightTab = new FlxText(0.0f, 0.0f, 100.0f);
        this.m_txtLeftTab.color(Color.Gray());
        this.m_txtRightTab.color(Color.Gray());
        this.m_txtLeftTab.scale(2.0f);
        this.m_txtRightTab.scale(2.0f);
        this.m_txtLeftTab.alignment = FlxText.FlxJustification.Right;
        this.m_txtRightTab.alignment = FlxText.FlxJustification.Left;
        if (InputManager.IsAnyGamepadConnected()) {
            this.m_txtLeftTab.text("<LB");
            this.m_txtRightTab.text("RB>");
        } else {
            this.m_txtLeftTab.text("<" + InputManager.GetFriendlyButtonName(Buttons.LeftShoulder, true));
            this.m_txtRightTab.text(String.valueOf(InputManager.GetFriendlyButtonName(Buttons.RightShoulder, true)) + ">");
        }
        this.m_tabEntriesLayer.add(this.m_txtLeftTab);
        this.m_tabEntriesLayer.add(this.m_txtRightTab);
        this.m_tabEntries = new MainMenuEntry[NumTabsOnlineMode];
        int i = NumTabsOnlineMode - 1;
        while (i >= 0) {
            this.m_tabEntries[i] = new MainMenuEntry(i, this.m_tabEntriesLayer, this.m_tweenManager, MainMenuEntry.eType.CommunityTab, null, null, null, 1.0f);
            this.m_tabEntries[i].positionateAt(centerx, centery);
            this.m_tabEntries[i].setText(TabsTxtId[i]);
            this.m_tabEntries[i].visible(true);
            centerx -= stepx;
            --i;
        }
        float txtOffsetx = 20.0f;
        float txtOffsety = -10.0f;
        this.m_txtLeftTab.x = this.m_tabEntries[0].getLeftX() - 100.0f + txtOffsetx;
        this.m_txtLeftTab.y = this.m_tabEntries[0].getCenterY() + txtOffsety;
        this.m_txtRightTab.x = this.m_tabEntries[NumTabsOnlineMode - 1].getRightX() - txtOffsetx;
        this.m_txtRightTab.y = this.m_tabEntries[NumTabsOnlineMode - 1].getCenterY() + txtOffsety;
        this.m_watchIdTabEntries = this._templateWatchEntries(this.m_tabEntries);
        this._updateTabSelectionColor(-1);
    }

    protected void _loadWorkspaceThreaded() {
        if (!this.m_bLoadingStuff) {
            this.m_bLoadingStuff = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    OnlineLevelBrowsingState.this._tweenLogoOn();
                    if (MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                        if (OnlineLevelBrowsingState.this.m_action == eLoadAction.SaveFinishedLevelContentDat) {
                            byte[] content = null;
                            content = MACRO.ENCRYPT_LEVEL_EDITOR_FILES ? FileManager.Instance().getTextFileContentByte("Community/MyWorkspace/" + GameVars.LastCommunityEditLevelFolderName() + "/" + GameVars.LastCommunityEditLevelXmlName() + ".xml.dat", true) : FileManager.Instance().getTextFileContentByte("Community/MyWorkspace/" + GameVars.LastCommunityEditLevelFolderName() + "/" + GameVars.LastCommunityEditLevelXmlName() + ".xml", false);
                            FileManager.Instance().writeTextFileContent("Community/MyWorkspace/@Packaging/" + GameVars.LastCommunityEditLevelFolderName() + ".dat", true, new String(content));
                            AchievementManager.Instance().unlockAchievement("ACH_PLAYTEST");
                            OnlineLevelBrowsingState.this.m_bCheckAutoplayNextlevel = true;
                        }
                        OnlineLevelBrowsingState.this.m_levelNames = FileManager.Instance().listDirectories("Community/MyWorkspace", "#");
                    } else {
                        OnlineLevelBrowsingState.this.m_levelNames = new ArrayList();
                    }
                    OnlineLevelBrowsingState.this.m_onListingDoneRepositionnate.onCallback(this, null);
                }
            };
            this.m_threadLoader = new Thread(r);
            this.m_threadLoader.start();
        }
    }

    protected void _downloadAndPlayLevelThreaded(String _levelFilename) {
        if (!this.m_bLoadingStuff) {
            this.m_bLoadingStuff = true;
            final String levelFilename = _levelFilename;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    OnlineLevelBrowsingState.this._tweenLogoOn();
                    if (FileManager.Instance().downloadFileFromURL(levelFilename, "/Community/CommunityLevels", false)) {
                        OnlineLevelBrowsingState.this.m_bLaunchSelectedLevelOnFrame = true;
                    }
                }
            };
            this.m_threadLoader = new Thread(r);
            this.m_threadLoader.start();
        }
    }

    protected void _loadOnlineTabThreaded(boolean _bRepositionnateOnLastItem) {
        if (!this.m_bLoadingStuff) {
            this.m_bRepositionnateOnLastItem = _bRepositionnateOnLastItem;
            this.m_bLoadingStuff = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    OnlineLevelBrowsingState.this._tweenLogoOn();
                    m_lastTabAction = TabsActions[m_tabSelected];
                    OnlineLevelBrowsingState.this._filter(null);
                    OnlineLevelBrowsingState.this._updateTab();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (OnlineLevelBrowsingState.this.m_bRepositionnateOnLastItem) {
                        OnlineLevelBrowsingState.this.m_onListingDoneRepositionnate.onCallback(this, null);
                    } else {
                        OnlineLevelBrowsingState.this.m_onListingDoneNoRepositionnate.onCallback(this, null);
                    }
                }
            };
            this.m_threadLoader = new Thread(r);
            this.m_threadLoader.start();
        }
    }

    protected void _updateTab() {
        switch (m_lastTabAction) {
            case TabAction_ShowDL: {
                this._showDLlevels();
                break;
            }
            case TabAction_ShowFeatured: {
                this._showFeaturedLevels();
                break;
            }
            case TabAction_ShowMine: {
                this._showMyCreationOnly();
                break;
            }
            case TabAction_ShowTopRated: {
                this._orderByTopRated();
            }
        }
    }

    protected void _orderByTopRated() {
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            Collections.sort(this.m_levelNames, new LevelItemRateComparator());
        }
    }

    protected void _showMyCreationOnly() {
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            this.m_levelNamesBackupSearch = new ArrayList<LevelItem>(this.m_levelNames);
            this.m_levelNames.clear();
            String userId = GameVars.UserID();
            for (LevelItem item : this.m_levelNamesBackupSearch) {
                if (!item.LevelFileName().contains(userId)) continue;
                this.m_levelNames.add(item);
            }
        }
    }

    protected void _showFeaturedLevels() {
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            this.m_levelNamesBackupSearch = new ArrayList<LevelItem>(this.m_levelNames);
            this.m_levelNames.clear();
            if (this.m_levelFeatured.size() > 0) {
                for (LevelItem item : this.m_levelNamesBackupSearch) {
                    if (!this.m_levelFeatured.contains(item)) continue;
                    this.m_levelNames.add(item);
                }
            }
        }
    }

    protected void _showDLlevels() {
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            this.m_levelNamesBackupSearch = new ArrayList<LevelItem>(this.m_levelNames);
            this.m_levelNames.clear();
            if (this.m_levelSaveLocally.size() > 0) {
                for (LevelItem item : this.m_levelNamesBackupSearch) {
                    if (!this.m_levelSaveLocally.contains(item)) continue;
                    this.m_levelNames.add(item);
                }
            }
        }
    }

    protected void _loadOnlineThreaded(boolean _repositionnateOnLastItem) {
        if (!this.m_bLoadingStuff) {
            this.m_bLoadingStuff = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    boolean bNoPHPError = true;
                    OnlineLevelBrowsingState.this._tweenLogoOn();
                    OnlineLevelBrowsingState.this.m_levelNames = FileManager.Instance().listFiles("Community/CommunityLevels", "#", ".btm");
                    if (OnlineLevelBrowsingState.this.m_levelNames != null) {
                        OnlineLevelBrowsingState.this.m_levelSaveLocally = new ArrayList<LevelItem>(OnlineLevelBrowsingState.this.m_levelNames);
                    } else {
                        OnlineLevelBrowsingState.this.m_levelSaveLocally = new ArrayList(10);
                        OnlineLevelBrowsingState.this.m_levelNames = new ArrayList(10);
                    }
                    if (MACRO.TECH_DEMO) {
                        if (bNoPHPError) {
                            bNoPHPError = FileManager.Instance().listPHPFiles("getBTM_Community_FileList", "#", ".btm", OnlineLevelBrowsingState.this.m_levelNames, OnlineLevelBrowsingState.this.m_levelSaveLocally, false, true);
                        }
                    } else if (MACRO.DEBUG && MACRO.DEBUG_COMMUNITY) {
                        if (bNoPHPError) {
                            bNoPHPError = FileManager.Instance().listPHPFiles("getBTM_Community_FileListDBG", "#", ".btm", OnlineLevelBrowsingState.this.m_levelNames, OnlineLevelBrowsingState.this.m_levelSaveLocally, false, true);
                        }
                    } else if (bNoPHPError) {
                        bNoPHPError = FileManager.Instance().listPHPFiles("getBTM_Community_FileListFull", "#", ".btm", OnlineLevelBrowsingState.this.m_levelNames, OnlineLevelBrowsingState.this.m_levelSaveLocally, false, true);
                    }
                    OnlineLevelBrowsingState.this.m_levelFeatured = new ArrayList(20);
                    if (MACRO.TECH_DEMO) {
                        if (bNoPHPError) {
                            bNoPHPError = FileManager.Instance().listPHPFiles("getBTM_Community_FileListFeatured", "#", ".btm", OnlineLevelBrowsingState.this.m_levelFeatured, null, true, false);
                        }
                    } else if (bNoPHPError) {
                        bNoPHPError = FileManager.Instance().listPHPFiles("getBTM_Community_FileListFeaturedFull", "#", ".btm", OnlineLevelBrowsingState.this.m_levelFeatured, null, true, false);
                    }
                    FileManager.Instance().listPHPLevelAttribs(OnlineLevelBrowsingState.this.m_levelNames, "Community/CommunityLevels/_LocalLevelAttribsDB", !bNoPHPError);
                    if (bNoPHPError) {
                        bNoPHPError = FileManager.Instance().listPHPThumbs(OnlineLevelBrowsingState.this.m_levelNames);
                    }
                    Collections.sort(OnlineLevelBrowsingState.this.m_levelNames, new LevelItemDateComparator());
                    if (OnlineLevelBrowsingState.this.m_action == eLoadAction.CommunityLevelDone) {
                        String lastName = GameVars.LastCommunityPlayedLevelArchiveName();
                        if (!m_finishedLevels.contains(lastName)) {
                            m_finishedLevels.add(GameVars.LastCommunityPlayedLevelArchiveName());
                            FileManager.Instance().writeCommaSeparatedValue("Community/CommunityLevels/_Done", m_finishedLevels);
                        }
                        if (lastName != null) {
                            LevelItemAttribs levelItemAttribSaved = m_finishedLevelsAttribs.get(lastName);
                            LevelItem levelItem = OnlineLevelBrowsingState.this._linearSearchLevelItem(lastName);
                            if (levelItem != null && levelItem.LevelFileName().startsWith(lastName)) {
                                boolean bRefreshInfo = false;
                                if (levelItem.hasCustomChest() && GameVars.LastCommunityPlayedLevelBTMChestFound() && (levelItemAttribSaved == null || !levelItemAttribSaved.customChest())) {
                                    bRefreshInfo = true;
                                    levelItem.customChestFound(true);
                                }
                                if (levelItem.par() != 0 && GameVars.LastCommunityPlayedLevelParValue() >= levelItem.par() && GameVars.LastCommunityPlayedLevelParValue() > levelItem.bestPar() && (levelItemAttribSaved == null || levelItemAttribSaved.par() <= GameVars.LastCommunityPlayedLevelParValue())) {
                                    bRefreshInfo = true;
                                    levelItem.bestPar(GameVars.LastCommunityPlayedLevelParValue());
                                }
                                if (bRefreshInfo) {
                                    LevelItemAttribs levelItemAttribs = m_finishedLevelsAttribs.get(lastName);
                                    if (levelItemAttribs == null) {
                                        levelItemAttribs = new LevelItemAttribs(GameVars.LastCommunityPlayedLevelParValue(), GameVars.LastCommunityPlayedLevelBTMChestFound());
                                        m_finishedLevelsAttribs.put(lastName, levelItemAttribs);
                                    } else {
                                        if (!levelItemAttribs.customChest()) {
                                            levelItemAttribs.customChest(GameVars.LastCommunityPlayedLevelBTMChestFound());
                                        }
                                        if (levelItemAttribs.par() < GameVars.LastCommunityPlayedLevelParValue()) {
                                            levelItemAttribs.par(GameVars.LastCommunityPlayedLevelParValue());
                                        }
                                    }
                                    OnlineLevelBrowsingState.this._writeDoneLevelAttribs();
                                }
                                GameVars.LastCommunityPlayedLevelParValue(0);
                                GameVars.LastCommunityPlayedLevelBTMChestFound(false);
                            }
                        }
                    } else {
                        FileManager.Instance().readCommaSeparatedValue("Community/CommunityLevels/_Done", m_finishedLevels, true);
                        OnlineLevelBrowsingState.this._recoverDoneLevelAttribs();
                    }
                    if (m_tabSelected != 0) {
                        OnlineLevelBrowsingState.this._updateTabSelectionColor(m_tabSelected);
                        OnlineLevelBrowsingState.this._updateTab();
                    }
                    OnlineLevelBrowsingState.this.m_onListingDoneRepositionnate.onCallback(this, null);
                }
            };
            this.m_threadLoader = new Thread(r);
            this.m_threadLoader.start();
        }
    }

    protected void _writeDoneLevelAttribs() {
        ArrayList<String> doneAttribs = new ArrayList<String>(20);
        for (Map.Entry<String, LevelItemAttribs> keys : m_finishedLevelsAttribs.entrySet()) {
            String attribs = keys.getKey();
            LevelItemAttribs levelItemAttribs = keys.getValue();
            attribs = String.valueOf(attribs) + "|" + (levelItemAttribs.customChest() ? "1" : "0");
            attribs = String.valueOf(attribs) + "|" + levelItemAttribs.par();
            doneAttribs.add(attribs);
        }
        FileManager.Instance().writeCommaSeparatedValue("Community/CommunityLevels/_DoneAttribs", doneAttribs);
    }

    protected void _recoverDoneLevelAttribs() {
        if (m_finishedLevelsAttribs.size() == 0) {
            ArrayList<String> doneAttribs = new ArrayList<String>(20);
            FileManager.Instance().readCommaSeparatedValue("Community/CommunityLevels/_DoneAttribs", doneAttribs, true);
            int i = 0;
            while (i < doneAttribs.size()) {
                String attribs = doneAttribs.get(i);
                String[] arrayDatas = attribs.split("\\|");
                if (arrayDatas != null && arrayDatas.length > 2) {
                    String levelNameAttrib = arrayDatas[0];
                    String chestFoundAttrib = arrayDatas[1];
                    String bestParValueAttrib = arrayDatas[2];
                    m_finishedLevelsAttribs.put(levelNameAttrib, new LevelItemAttribs(Integer.parseInt(bestParValueAttrib), Integer.parseInt(chestFoundAttrib) > 0));
                }
                ++i;
            }
        }
    }

    protected void _buildAskUI() {
        float offsety = -60.0f;
        float percYAnswer = 0.55f;
        this.m_backgroundQuestion = new FlxSprite();
        this.m_backgroundQuestion.createGraphic(FlxG.width, FlxG.height, Color.Black());
        this.m_backgroundQuestion.scrollFactor = Vector2.Zero();
        this.m_backgroundQuestion.alpha(0.8f);
        this.m_backgroundQuestion.visible = false;
        this.add(this.m_backgroundQuestion);
        this.m_txtAskQuestion = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtAskQuestion.alignment = FlxText.FlxJustification.Center;
        this.m_txtAskQuestion.color(Color.YellowSub());
        this.m_txtAskQuestion.scale(3.0f);
        this.m_txtAskQuestion.y = (float)FlxG.height * 0.5f + offsety;
        this.m_txtAskQuestion.text("Sample question?");
        this.m_txtAskQuestion.visible = false;
        this.add(this.m_txtAskQuestion);
        this.m_backgroundAnwser = new FlxSprite();
        this.m_backgroundAnwser.createGraphic((int)((float)FlxG.width * 0.5f), 30, Color.Gray());
        this.m_backgroundAnwser.scrollFactor = Vector2.Zero();
        this.m_backgroundAnwser.x = (float)FlxG.width * 0.5f - this.m_backgroundAnwser.width * 0.5f;
        this.m_backgroundAnwser.y = (float)FlxG.height * percYAnswer + offsety;
        this.m_backgroundAnwser.visible = false;
        this.add(this.m_backgroundAnwser);
        this.m_txtAnwser = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtAnwser.alignment = FlxText.FlxJustification.Center;
        this.m_txtAnwser.color(Color.White());
        this.m_txtAnwser.scale(2.0f);
        this.m_txtAnwser.y = (float)FlxG.height * percYAnswer + offsety;
        this.m_txtAnwser.text("Sample answer");
        this.m_txtAnwser.visible = false;
        this.add(this.m_txtAnwser);
        this._buildIcons();
    }

    protected void _makeQuestionAppear(String _question, boolean _bTweenApparition, String _subFakeAwnserOrNil) {
        this.m_txtAskQuestion.text(_question);
        this.m_backgroundQuestion.visible = true;
        this.m_txtAskQuestion.visible = true;
        if (_subFakeAwnserOrNil != null && _subFakeAwnserOrNil.length() > 0) {
            this.m_backgroundAnwser.visible = false;
            this.m_txtAnwser.text(_subFakeAwnserOrNil);
        } else {
            this.m_backgroundAnwser.visible = true;
            this.m_txtAnwser.text("");
        }
        this.m_txtAnwser.visible = true;
        float alpha = _bTweenApparition ? 0.0f : 1.0f;
        this.m_backgroundQuestion.alpha(alpha);
        this.m_txtAskQuestion.alpha(alpha);
        this.m_backgroundAnwser.alpha(alpha);
        this.m_txtAnwser.alpha(alpha);
        if (_bTweenApparition) {
            this.m_tweenManager.RemoveTweenable(this.m_backgroundQuestion);
            this.m_tweenManager.RemoveTweenable(this.m_txtAskQuestion);
            this.m_tweenManager.RemoveTweenable(this.m_backgroundAnwser);
            this.m_tweenManager.RemoveTweenable(this.m_txtAnwser);
            float timeFade = 0.25f;
            this.m_tweenManager.ToAlpha((Tweenable)this.m_backgroundQuestion, 0.8f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtAskQuestion, 1.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_backgroundAnwser, 1.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtAnwser, 1.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
    }

    protected void _makeQuestionDisappear(boolean _bTween) {
        float alpha;
        this.m_askedType = eAskStuffType.eAskStuffType_None;
        this.m_bAskThing = false;
        this.m_bAskThingTriggered = false;
        float f = alpha = _bTween ? 1.0f : 0.0f;
        if (_bTween) {
            this.m_tweenManager.RemoveTweenable(this.m_backgroundQuestion);
            this.m_tweenManager.RemoveTweenable(this.m_txtAskQuestion);
            this.m_tweenManager.RemoveTweenable(this.m_backgroundAnwser);
            this.m_tweenManager.RemoveTweenable(this.m_txtAnwser);
            float timeFade = 0.25f;
            this.m_tweenManager.ToAlpha((Tweenable)this.m_backgroundQuestion, 0.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtAskQuestion, 0.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_backgroundAnwser, 0.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_txtAnwser, 0.0f, timeFade, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        } else {
            this.m_backgroundQuestion.alpha(alpha);
            this.m_txtAskQuestion.alpha(alpha);
            this.m_backgroundAnwser.alpha(alpha);
            this.m_txtAnwser.alpha(alpha);
        }
    }

    protected void _initInfos(int _idPageOrZero, int _idEntryOrZero) {
        this.m_idPage = _idPageOrZero > 0 ? _idPageOrZero : 1;
        this._computeNumPage();
        this._updateEntriesInfoAndVisibility();
        this._updatePageInfo();
        this._selectEntry(_idEntryOrZero > 0 ? _idEntryOrZero : 0);
    }

    protected void _repositionnateCursorOnlastKnownEntry(boolean _bRepositionnateOnLastKnown) {
        if (this.m_levelNames == null || this.m_levelNames.size() == 0) {
            return;
        }
        LevelItem curLI = null;
        String curName = null;
        int index = 0;
        int page = 0;
        if (_bRepositionnateOnLastKnown && (curName = this.m_bOnlineBrowsing ? String.valueOf(GameVars.LastCommunityPlayedLevelArchiveName()) + ".btm" : GameVars.LastCommunityEditLevelFolderName()) != null && curName.length() > 0) {
            for (LevelItem levelItem : this.m_levelNames) {
                if (levelItem.LevelFileName().equals(curName)) {
                    curLI = levelItem;
                    break;
                }
                ++index;
            }
        }
        if (curLI == null) {
            index = 0;
        }
        if (index >= 0) {
            page = index / NumEntriesMaxPerPage + 1;
            index %= NumEntriesMaxPerPage;
        }
        this._initInfos(page, index);
        this._updateEntriesInfoAndVisibility();
    }

    protected void _onUploadDone() {
        this.m_bLoadingStuff = false;
        this._repositionnateCursorOnlastKnownEntry(true);
        this._tweenLogoOff();
        this._triggerAsk(eAskStuffType.eAskStuffType_LevelSubmitted);
    }

    protected void _onUploadFailed() {
        this.m_bLoadingStuff = false;
        this._repositionnateCursorOnlastKnownEntry(true);
        this._tweenLogoOff();
        this._triggerAsk(eAskStuffType.eAskStuffType_LevelSubmittedFailed);
    }

    protected void _onUploadFail() {
        this.m_bLoadingStuff = false;
        this._tweenLogoOff();
    }

    protected void _onUploadLevelNeedToBePlayed() {
        this.m_bLoadingStuff = false;
        this._tweenLogoOff();
        this._triggerAsk(eAskStuffType.eAskStuffType_RequirePlay);
    }

    protected void _checkLevelErrorMessage() {
        if (this.m_action == eLoadAction.ErrorTryToLoadLevelFromFuture) {
            this._triggerAsk(eAskStuffType.eAskStuffType_LevelFromTheFuture);
        }
    }

    protected void _onListingDone(boolean _repositionnate) {
        String lastName;
        if (this.m_levelNames == null) {
            return;
        }
        boolean bl = this.m_bSomethingInBase = this.m_levelNames.size() > 0;
        if (!this.m_bSomethingInBase) {
            this.m_txtEmptyBank.visible = true;
            this.m_entriesLayer.visible = false;
        } else {
            this.m_txtEmptyBank.visible = false;
            this.m_entriesLayer.visible = true;
        }
        this.m_bLoadingStuff = false;
        this._repositionnateCursorOnlastKnownEntry(_repositionnate);
        this._tweenLogoOff();
        if (!this.m_bOnlineBrowsing) {
            if (this.m_action == eLoadAction.SaveFinishedLevelContentDat && m_actionDeferred == eLoadAction.Upload) {
                this._onSharePressed();
            }
        } else if (this.m_action == eLoadAction.CommunityLevelDone && (lastName = GameVars.LastCommunityPlayedLevelArchiveName()) != null) {
            if (!lastName.contains(GameVars.UserID())) {
                this._triggerAsk(eAskStuffType.eAskStuffType_Rate);
            } else {
                this.m_bCheckAutoplayNextlevel = true;
            }
        }
        m_actionDeferred = eLoadAction.None;
    }

    protected void _tweenLogoOn() {
        this.m_entriesLayer.visible = false;
        this.m_logoLoading.visible = true;
        this.m_logoLoading.alpha(0.0f);
        this.m_logoLoading.scale(1.0f);
        this.m_tweenManager.RemoveTweenable(this.m_logoLoading);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_logoLoading, 1.0f, 0.1f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_logoLoading, 1.0f, 0.1f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        this.m_tweenManager.ToScale((Tweenable)this.m_logoLoading, new Vector2(1.2f), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, TweenManager.LoopType.PingPong);
    }

    protected void _tweenLogoOff() {
        this.m_tweenManager.RemoveTweenable(this.m_logoLoading);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_logoLoading, 0.0f, 0.1f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
    }

    void _computeNumPage() {
        this.m_numPage = this.m_levelNames.size() / NumEntriesMaxPerPage;
        if (this.m_levelNames.size() % NumEntriesMaxPerPage != 0) {
            ++this.m_numPage;
        }
    }

    int _getIndexLevelOnPage() {
        return (this.m_idPage - 1) * NumEntriesMaxPerPage + (this.m_menuEntrySelected >= 0 ? this.m_menuEntrySelected : 0);
    }

    int _getFirstIndexLevelOnPage() {
        return (this.m_idPage - 1) * NumEntriesMaxPerPage;
    }

    protected void _selectEntry(int _slot) {
        if (!this.m_bSomethingInBase) {
            return;
        }
        if (_slot != this.m_menuEntrySelected) {
            this.m_menuEntrySelectedOld = this.m_menuEntrySelected;
            this.m_menuEntrySelected = _slot;
            this._updateCursorPos();
            this._tiltCursors();
            this._selectNewUnselectOldEntry();
        }
    }

    void _selectNewUnselectOldEntry() {
        if (!this.m_bSomethingInBase) {
            return;
        }
        if (this.m_menuEntrySelected >= 0 && this.m_menuEntrySelected < this.m_menuEntries.length) {
            this.m_menuEntries[this.m_menuEntrySelected].select();
        }
        if (this.m_menuEntrySelectedOld != this.m_menuEntrySelected && this.m_menuEntrySelectedOld >= 0 && this.m_menuEntrySelectedOld < this.m_menuEntries.length) {
            this.m_menuEntries[this.m_menuEntrySelectedOld].unselect();
        }
    }

    void _recomputeSelectEntryOnNewPage() {
        if (!this.m_bSomethingInBase) {
            return;
        }
        int maxMenuEntry = 0;
        int i = 0;
        while (i < NumEntriesMaxPerPage) {
            if (!this.m_menuEntries[i].visible()) break;
            maxMenuEntry = i++;
        }
        if (maxMenuEntry < this.m_menuEntrySelected) {
            this._selectEntry(maxMenuEntry);
        }
    }

    void _updateCursorPos() {
        if (!this.m_bSomethingInBase) {
            return;
        }
        this.m_cursorLeft.visible = true;
        this.m_cursorRight.visible = true;
        this.m_cursorLeft.x = this.m_menuEntries[this.m_menuEntrySelected].getLeftX() - this.m_cursorLeft.width * 0.5f;
        this.m_cursorRight.x = this.m_menuEntries[this.m_menuEntrySelected].getRightX() - this.m_cursorRight.width * 0.5f;
        this.m_cursorLeft.y = this.m_menuEntries[this.m_menuEntrySelected].getCenterY() - this.m_cursorLeft.height * 0.5f;
        this.m_cursorRight.y = this.m_menuEntries[this.m_menuEntrySelected].getCenterY() - this.m_cursorRight.height * 0.5f;
    }

    void _tiltCursors() {
        if (!this.m_bSomethingInBase) {
            return;
        }
        this.m_cursorLeft.scale(0.5f);
        this.m_cursorRight.scale(0.5f);
        this.m_tweenManager.ToScale((Tweenable)this.m_cursorLeft, Vector2.One(), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
        this.m_tweenManager.ToScale((Tweenable)this.m_cursorRight, Vector2.One(), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
    }

    protected void _updateEntriesInfoAndVisibility() {
        if (!this.m_bSomethingInBase) {
            return;
        }
        int indexLevel = this._getFirstIndexLevelOnPage();
        LevelItem item = null;
        int i = 0;
        while (i < NumEntriesMaxPerPage) {
            int realIndex = indexLevel + i;
            if (this.m_levelNames.size() > realIndex) {
                try {
                    item = this.m_levelNames.get(realIndex);
                }
                catch (Exception e) {
                    item = null;
                }
                if (item != null) {
                    this.m_menuEntries[i].visible(true);
                    this.m_menuEntries[i].setText(this._getLevelFriendlyName(item.LevelFileName()));
                    if (this.m_bOnlineBrowsing) {
                        this.m_featuredIcons[i].visible = this.m_levelFeatured != null && this.m_levelFeatured.contains(item);
                        if (this.m_levelSaveLocally != null && this.m_levelSaveLocally.contains(item)) {
                            this.m_onlineIcons[i].visible = false;
                            this.m_localIcons[i].visible = true;
                            String nameWithoutExt = item.LevelFileName().substring(0, item.LevelFileName().lastIndexOf(46));
                            if (!item.upToDate()) {
                                this.m_menuEntries[i].setTextColor(Color.Red());
                                this.m_updateAvailableIcons[i].visible = true;
                            } else {
                                if (m_finishedLevels != null && m_finishedLevels.contains(nameWithoutExt)) {
                                    this.m_menuEntries[i].setTextColor(new Color(215, 154, 0, 255));
                                } else {
                                    this.m_menuEntries[i].setTextColor(Color.Black());
                                }
                                this.m_updateAvailableIcons[i].visible = false;
                            }
                            LevelItemAttribs levelItemAttribs = m_finishedLevelsAttribs.get(nameWithoutExt);
                            if (levelItemAttribs != null) {
                                item.customChestFound(levelItemAttribs.customChest());
                                item.bestPar(levelItemAttribs.par());
                            }
                        } else {
                            this.m_onlineIcons[i].visible = true;
                            this.m_localIcons[i].visible = false;
                            this.m_updateAvailableIcons[i].visible = false;
                            this.m_menuEntries[i].setTextColor(Color.Gray());
                        }
                        this.m_txtThumbUp[i].visible = true;
                        this.m_txtThumbDown[i].visible = true;
                        this.m_txtLevelAutor[i].visible = true;
                        this.m_txtThumbUp[i].text(Integer.toString(item.thumbUp()));
                        this.m_txtThumbDown[i].text(Integer.toString(item.thumbDown()));
                        if (item.thumbUp() > 99 || item.thumbDown() > 99) {
                            this.m_txtThumbUp[i].scale(1.1f);
                            this.m_txtThumbDown[i].scale(1.1f);
                        } else {
                            this.m_txtThumbUp[i].scale(1.5f);
                            this.m_txtThumbDown[i].scale(1.5f);
                        }
                        this.m_chestIcons[i].visible = item.hasCustomChest();
                        if (this.m_chestIcons[i].visible) {
                            if (item.customChestFound()) {
                                this.m_chestIcons[i].color(Color.White());
                            } else {
                                this.m_chestIcons[i].color(new Color(0.4f, 0.4f, 0.4f));
                            }
                        }
                        boolean bl = this.m_starIcons[i].visible = item.par() > 0;
                        if (this.m_starIcons[i].visible) {
                            if (item.bestPar() > item.par()) {
                                this.m_starIcons[i].color(new Color(0, 255, 0, 255));
                            } else if (item.bestPar() == item.par()) {
                                this.m_starIcons[i].color(Color.White());
                            } else {
                                this.m_starIcons[i].color(new Color(0.2f, 0.2f, 0.2f));
                            }
                        }
                        this.m_thumbsUpIcons[i].visible = true;
                        this.m_thumbDownIcons[i].visible = true;
                        this.m_txtLevelAutor[i].text(item.Author());
                    }
                } else {
                    this.m_menuEntries[i].visible(false);
                    this._hideIcons(i);
                }
            } else {
                this._hideIcons(i);
            }
            ++i;
        }
    }

    protected void _hideIcons(int i) {
        this.m_menuEntries[i].visible(false);
        this.m_txtThumbUp[i].visible = false;
        this.m_txtThumbDown[i].visible = false;
        this.m_txtLevelAutor[i].visible = false;
        this.m_featuredIcons[i].visible = false;
        this.m_localIcons[i].visible = false;
        this.m_thumbsUpIcons[i].visible = false;
        this.m_onlineIcons[i].visible = false;
        this.m_thumbDownIcons[i].visible = false;
        this.m_updateAvailableIcons[i].visible = false;
        this.m_chestIcons[i].visible = false;
        this.m_starIcons[i].visible = false;
    }

    protected void _updatePageInfo() {
        this.m_txtPageInfo.text(String.valueOf(this.m_idPage) + "/" + this.m_numPage);
    }

    protected String _getLevelFriendlyName(String _longName) {
        if (_longName.contains("#")) {
            return _longName.substring(0, _longName.lastIndexOf(35));
        }
        return _longName;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_newsFeed.destroy();
    }

    @Override
    protected void _onNewEntryUnderMouse(MainMenuEntry _entry, int slot, int groupId) {
        if (this.m_bLoadingStuff || this.m_bLaunchingLevel) {
            return;
        }
        if (_entry.visible()) {
            if (this.m_watchIdTabEntries == groupId) {
                this._updateTabSelectionColor(slot);
            } else {
                this._selectEntry(slot);
            }
        }
    }

    @Override
    protected void _onNewEntryMouseLeave(MainMenuEntry _entry, int slot, int groupId) {
        if (this.m_bLoadingStuff || this.m_bLaunchingLevel) {
            return;
        }
        if (_entry.visible() && this.m_watchIdTabEntries == groupId) {
            this._updateTabSelectionColor(-1);
        }
    }

    protected void _updateTabSelectionColor(int _mouseOverIdOrNeg) {
        int i = 0;
        while (i < this.m_tabEntries.length) {
            if (i == m_tabSelected) {
                this.m_tabEntries[i].changeBarColor(Color.YellowSub());
            } else if (i == _mouseOverIdOrNeg) {
                this.m_tabEntries[i].changeBarColor(Color.Gray());
            } else {
                this.m_tabEntries[i].changeBarColor(Color.White());
            }
            ++i;
        }
    }

    @Override
    protected void _onEntryUnderMouseSelected(MainMenuEntry _entry, int slot, int groupId) {
        if (_entry.visible()) {
            if (this.m_watchIdTabEntries == groupId) {
                if (!this.m_bLoadingStuff && m_tabSelected != slot) {
                    m_tabSelected = slot;
                    this._updateTabSelectionColor(slot);
                    this._filterTab(true);
                }
            } else {
                this._onSelectPressed();
            }
        }
    }

    protected void _skipTab(int _shift) {
        if (!this.m_bLoadingStuff && this.m_tabEntries != null) {
            int nextTab = m_tabSelected + _shift;
            if (nextTab >= this.m_tabEntries.length) {
                nextTab = 0;
            } else if (nextTab < 0) {
                nextTab = this.m_tabEntries.length - 1;
            }
            if (nextTab != m_tabSelected) {
                m_tabSelected = nextTab;
                this._updateTabSelectionColor(nextTab);
                this._filterTab(true);
            }
        }
    }

    @Override
    public void update() {
        block86: {
            block88: {
                block91: {
                    block90: {
                        block89: {
                            block87: {
                                super.update();
                                this.m_newsFeed.update();
                                if (this.m_bCheckAutoplayNextlevel) {
                                    this.m_bCheckAutoplayNextlevel = false;
                                    if (GameVars.NextCommunityAutoplayLevelName() != null) {
                                        this._checkAutoLoadLevel();
                                        return;
                                    }
                                }
                                if (this.m_bLaunchSelectedLevelOnFrame) {
                                    this.m_bLaunchSelectedLevelOnFrame = false;
                                    this.m_bLoadingStuff = false;
                                    this._launchSelectedLevel();
                                }
                                if (!this.m_bAskThing) break block86;
                                if (this.m_askedType != eAskStuffType.eAskStuffType_Rate) break block87;
                                if (InputManager.IsNewButtonPress(Buttons.X, true) || InputManager.IsNewKeyPress(Keys.Y)) {
                                    this._thumbs(true);
                                    this._makeQuestionDisappear(true);
                                    this._templateAllowIconListening(true);
                                    this._makeVoteIconsAppearDisappear(false, 0.25f, 0, false);
                                    this.m_bCheckAutoplayNextlevel = true;
                                } else if (InputManager.IsNewButtonPress(Buttons.Y, true) || InputManager.IsNewKeyPress(Keys.S)) {
                                    this._makeQuestionDisappear(true);
                                    this._templateAllowIconListening(true);
                                    this._makeVoteIconsAppearDisappear(false, 0.25f, 1, false);
                                    if (this.m_action == eLoadAction.CommunityLevelDone) {
                                        this.m_action = eLoadAction.None;
                                    }
                                    this.m_bCheckAutoplayNextlevel = true;
                                } else if (InputManager.IsNewButtonPress(Buttons.B, true) || InputManager.IsNewKeyPress(Keys.N)) {
                                    this._thumbs(false);
                                    this._makeQuestionDisappear(true);
                                    this._templateAllowIconListening(true);
                                    this._makeVoteIconsAppearDisappear(false, 0.25f, 2, false);
                                    this.m_bCheckAutoplayNextlevel = true;
                                }
                                break block88;
                            }
                            if (this.m_askedType != eAskStuffType.eAskStuffType_DeleteCreation) break block89;
                            if (InputManager.IsNewButtonPress(Buttons.X, true) || InputManager.IsNewKeyPress(Keys.Y)) {
                                this._makeQuestionDisappear(true);
                                this._templateAllowIconListening(true);
                                this._makeVoteIconsAppearDisappear(false, 0.25f, 0, true);
                                LevelItem selection = this._getSelectedLevelItem();
                                if (selection != null && !selection.online()) {
                                    if (this.m_levelNames != null) {
                                        this.m_levelNames.remove(selection);
                                    }
                                    if (this.m_levelNamesBackupSearch != null) {
                                        this.m_levelNamesBackupSearch.remove(selection);
                                    }
                                    FileManager.Instance().deleteFolder("/Community/MyWorkspace/" + selection.LevelFileName());
                                    this._selectNextEntry(true);
                                    this._computeNumPage();
                                    this._updatePageInfo();
                                    this._updateEntriesInfoAndVisibility();
                                    this._recomputeSelectEntryOnNewPage();
                                }
                            } else if (InputManager.IsNewButtonPress(Buttons.B, true) || InputManager.IsNewKeyPress(Keys.N) || InputManager.IsNewKeyPress(Keys.Escape)) {
                                this._makeQuestionDisappear(true);
                                this._templateAllowIconListening(true);
                                this._makeVoteIconsAppearDisappear(false, 0.25f, 2, true);
                            }
                            break block88;
                        }
                        if (!InputManager.IsNewKeyPress(Keys.Escape) && !InputManager.IsNewButtonPress(Buttons.B, true)) break block90;
                        if (this.m_askedType == eAskStuffType.eAskStuffType_Report || this.m_askedType == eAskStuffType.eAskStuffType_Search || this.m_askedType == eAskStuffType.eAskStuffType_LevelName || this.m_askedType == eAskStuffType.eAskStuffType_RequirePlay || this.m_askedType == eAskStuffType.eAskStuffType_DuplicateCreation) {
                            this._makeQuestionDisappear(true);
                            this._templateAllowIconListening(true);
                        }
                        break block88;
                    }
                    if (!InputManager.IsNewKeyPress(Keys.Enter) && !InputManager.IsNewButtonPress(Buttons.A, true) && !InputManager.IsLeftMouseButtonPress()) break block91;
                    switch (OnlineLevelBrowsingState.$SWITCH_TABLE$SSS$States$BTM$OnlineLevelBrowsingState$eAskStuffType()[this.m_askedType.ordinal()]) {
                        case 12: {
                            if (this.m_txtAnwser.text().length() > 0) {
                                String duplicateLevelName = this.m_txtAnwser.text();
                                String duplicateLevelFolderName = String.valueOf(duplicateLevelName) + "#" + GameVars.UserID();
                                String duplicateLevelFullDir = "/Community/MyWorkspace/" + duplicateLevelFolderName + "/";
                                LevelItem currentLevelItem = this._getSelectedLevelItem();
                                if (currentLevelItem != null) {
                                    String originalLevelFullDir = "/Community/MyWorkspace/" + currentLevelItem.LevelFileName() + "/";
                                    if (FileManager.Instance().duplicateDirectory(originalLevelFullDir, duplicateLevelFullDir, true)) {
                                        String friendlyLevelName = String.valueOf(duplicateLevelFullDir) + currentLevelItem.FrienldyLevelName();
                                        String friendlyLevelNameDuplicated = String.valueOf(duplicateLevelFullDir) + duplicateLevelName;
                                        if (MACRO.DEBUG) {
                                            FileManager.Instance().renameFileOrFolder(String.valueOf(friendlyLevelName) + ".xml", String.valueOf(friendlyLevelNameDuplicated) + ".xml");
                                        }
                                        FileManager.Instance().renameFileOrFolder(String.valueOf(friendlyLevelName) + ".xml.dat", String.valueOf(friendlyLevelNameDuplicated) + ".xml.dat");
                                    }
                                }
                            }
                            this._makeQuestionDisappear(true);
                            this._templateAllowIconListening(true);
                            this._loadWorkspaceThreaded();
                            break;
                        }
                        case 2: {
                            if (this.m_txtAnwser.text().length() > 0) {
                                String levelName = this.m_txtAnwser.text();
                                String levelFolderName = String.valueOf(levelName) + "#" + GameVars.UserID();
                                String levelFullDir = "/Community/MyWorkspace/" + levelFolderName + "/";
                                String levelData = DefaultLevel.GetDefaultContent().replace("[n]", levelName);
                                if (MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                                    FileManager.Instance().createLevelEditDir(levelFullDir);
                                    if (MACRO.ENCRYPT_LEVEL_EDITOR_FILES) {
                                        FileManager.Instance().writeTextFileContent(String.valueOf(levelFullDir) + levelName + ".xml.dat", true, levelData);
                                    } else {
                                        FileManager.Instance().writeTextFileContent(String.valueOf(levelFullDir) + levelName + ".xml", false, levelData);
                                    }
                                } else {
                                    GameVars.LastLevelFakeEdit(levelName);
                                    GameVars.LastLevelFakeEditContent(levelData);
                                }
                                GameVars.LastCommunityEditLevelFolderName(levelFolderName);
                                GameVars.LastCommunityEditLevelXmlName(levelName);
                                FlxG.fade.start(Color.Black());
                                FlxG.state(new PlayState(false, true, GameVars.LastCommunityEditLevelXmlName(), "Community"));
                                break;
                            }
                            break block88;
                        }
                        case 4: {
                            this._templateAllowIconListening(true);
                            this._makeQuestionDisappear(true);
                            m_actionDeferred = eLoadAction.Upload;
                            this._onSelectPressed();
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 10: {
                            this._makeQuestionDisappear(true);
                            this._templateAllowIconListening(true);
                            this._onListingDone(true);
                            break;
                        }
                        case 3: {
                            String search = this.m_txtAnwser.text();
                            if (this.m_lastSearch == null || this.m_lastSearch.equals(search)) {
                                if (search.length() == 0) {
                                    this._filter(null);
                                    this._onListingDone(false);
                                } else {
                                    this._filter(search);
                                    this._onListingDone(true);
                                }
                            }
                            this._templateAllowIconListening(true);
                            this._makeQuestionDisappear(true);
                            break;
                        }
                        case 5: {
                            String report;
                            LevelItem li = this._getSelectedLevelItem();
                            if (li != null && FileManager.Instance().fileExists("/Community/CommunityLevels", li.LevelFileName()) && (report = this.m_txtAnwser.text()) != null && report.length() > 0) {
                                this._reportLevel(li, report);
                            }
                            this._templateAllowIconListening(true);
                            this._makeQuestionDisappear(true);
                            break;
                        }
                        case 9: {
                            String userName = this.m_txtAnwser.text().trim();
                            if (userName.length() <= 0) break block88;
                            LoginManager.Instance().currentUserName(userName, true);
                            this._templateAllowIconListening(true);
                            this._makeQuestionDisappear(true);
                            this._launchPackageThread();
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block88;
                }
                if (InputManager.IsKeyDown(Keys.Back)) {
                    this.m_timeAutoBack = InputManager.IsNewKeyPress(Keys.Back) ? -1.0f : (this.m_timeAutoBack -= FlxG.elapsed);
                    if (this.m_timeAutoBack < 0.0f) {
                        this.m_timeAutoBack = this.m_timeAutoBackTick;
                        if (this.m_txtAnwser.text().length() > 0 && this.m_backgroundQuestion.visible) {
                            this.m_txtAnwser.text(this.m_txtAnwser.text().substring(0, this.m_txtAnwser.text().length() - 1));
                        }
                    }
                } else {
                    this.m_timeAutoBack = this.m_timeAutoBackTick;
                    switch (this.m_askedType) {
                        case eAskStuffType_LevelName: 
                        case eAskStuffType_Search: 
                        case eAskStuffType_Report: 
                        case eAskStuffType_UserNameBeforeUpload: 
                        case eAskStuffType_DuplicateCreation: {
                            char letter;
                            int limitChar = 40;
                            if (this.m_askedType == eAskStuffType.eAskStuffType_LevelName || this.m_askedType == eAskStuffType.eAskStuffType_DuplicateCreation) {
                                limitChar = 22;
                            }
                            if (!this._acceptableLetter(letter = InputManager.GetNewKeyboardReadableKeyPress()) || this.m_txtAnwser.text().length() >= limitChar) break;
                            this.m_txtAnwser.text(String.valueOf(this.m_txtAnwser.text()) + letter);
                        }
                    }
                }
            }
            return;
        }
        if (this.m_bAskThingTriggered && !this.m_bAskThing) {
            this.m_bAskThingTriggered = false;
            this.m_bAskThing = true;
            this._templateAllowIconListening(false);
            TextDataBase tdb = TextDataBase.Instance();
            switch (this.m_askedType) {
                case eAskStuffType_LevelName: {
                    this._makeQuestionAppear(tdb.getText("TXT_NAME_OF_THE_LEVEL"), true, null);
                    break;
                }
                case eAskStuffType_DuplicateCreation: {
                    this._makeQuestionAppear(tdb.getText("TXT_LVL_DUP_1"), true, null);
                    break;
                }
                case eAskStuffType_Search: {
                    this._makeQuestionAppear(tdb.getText("TXT_SEARCH_FILTER"), true, null);
                    break;
                }
                case eAskStuffType_RequirePlay: {
                    this._makeQuestionAppear(tdb.getText("TXT_NEED_PLAY"), true, tdb.getText("TXT_VALIDATE_TO_PLAY"));
                    break;
                }
                case eAskStuffType_LevelSubmitted: {
                    if (this.m_bWaitingApproval) {
                        this._makeQuestionAppear(tdb.getText("TXT_WAITING_APPROVAL"), true, tdb.getText("TXT_WAITING_APPROVAL_DESC"));
                        break;
                    }
                    this._makeQuestionAppear(tdb.getText("TXT_LEVEL_UPLOADED"), true, tdb.getText("TXT_FIND_IT_IN_COMMUNITY"));
                    break;
                }
                case eAskStuffType_LevelFromTheFuture: {
                    String subInfo = tdb.getText("TXT_LVL_VERSION_COMPARE");
                    subInfo = subInfo.replace("[y]", GameVars.GameVersion());
                    subInfo = subInfo.replace("[v]", m_nextStartActionArgs);
                    this._makeQuestionAppear(tdb.getText("TXT_LVL_REQUIRE_GAME_UPDATE"), true, subInfo);
                    break;
                }
                case eAskStuffType_LevelSubmittedFailed: {
                    this._makeQuestionAppear(tdb.getText("TXT_FAIL_UPLOAD"), true, tdb.getText("TXT_SOME_PROBLEM"));
                    break;
                }
                case eAskStuffType_Rate: {
                    this._makeQuestionAppear(tdb.getText("TXT_WAS_THIS_LEVEL_COOL"), true, " ");
                    this._makeVoteIconsAppearDisappear(true, 1.0f, -1, false);
                    break;
                }
                case eAskStuffType_DeleteCreation: {
                    this._makeQuestionAppear(tdb.getText("TXT_LVL_DEL_1"), true, tdb.getText("TXT_LVL_DEL_2"));
                    this._makeVoteIconsAppearDisappear(true, 1.0f, -1, true);
                    break;
                }
                case eAskStuffType_Report: {
                    this._makeQuestionAppear(tdb.getText("TXT_WHATS_WRONG_LEVEL"), true, null);
                    break;
                }
                case eAskStuffType_UserNameBeforeUpload: {
                    this._makeQuestionAppear(tdb.getText("TXT_USERNAME"), true, null);
                }
            }
        }
        if (this.m_bLoadingStuff || this.m_bLaunchingLevel || this.m_bAskThing) {
            return;
        }
        if (InputManager.IsNewButtonPress(Buttons.LeftShoulder)) {
            this._skipTab(-1);
        } else if (InputManager.IsNewButtonPress(Buttons.RightShoulder)) {
            this._skipTab(1);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight) || InputManager.IsNewButtonPress(Buttons.DPadRight)) {
            this._skipPage(1);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft) || InputManager.IsNewButtonPress(Buttons.DPadLeft)) {
            this._skipPage(-1);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown) || InputManager.IsNewButtonPress(Buttons.DPadDown)) {
            this._selectNextEntry(false);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp) || InputManager.IsNewButtonPress(Buttons.DPadUp)) {
            this._selectNextEntry(true);
        } else if (InputManager.IsNewKeyPress(Keys.Delete)) {
            if (this.m_bOnlineBrowsing) {
                LevelItem selection = this._getSelectedLevelItem();
                if (selection != null && this.m_levelSaveLocally.contains(selection)) {
                    this.m_levelSaveLocally.remove(selection);
                    if (!selection.online()) {
                        if (this.m_levelNames != null) {
                            this.m_levelNames.remove(selection);
                        }
                        if (this.m_levelNamesBackupSearch != null) {
                            this.m_levelNamesBackupSearch.remove(selection);
                        }
                    }
                    FileManager.Instance().deleteFile("/Community/CommunityLevels/" + selection.LevelFileName());
                    this._updateEntriesInfoAndVisibility();
                }
            } else {
                this._triggerAsk(eAskStuffType.eAskStuffType_DeleteCreation);
            }
        } else if (InputManager.IsNewKeyPress(Keys.Insert) && !this.m_bOnlineBrowsing) {
            this._triggerAsk(eAskStuffType.eAskStuffType_DuplicateCreation);
        }
    }

    protected void _checkAutoLoadLevel() {
        String nextLevel = GameVars.NextCommunityAutoplayLevelName();
        GameVars.NextCommunityAutoplayLevelName(null);
        if (nextLevel != null) {
            LevelItem item = null;
            item = this.m_bOnlineBrowsing ? this._linearSearchLevelItem(nextLevel, true) : this._linearSearchLevelItem(nextLevel, false);
            if (item != null) {
                this.m_autoNextLevelName = item.LevelFileName();
                this._launchNextAutoSelectedLevel();
            }
        }
        this.m_bCheckAutoplayNextlevel = false;
    }

    protected boolean _acceptableLetter(char letter) {
        return letter >= 'a' && letter <= 'z' || letter >= 'A' && letter <= 'Z' || letter >= '0' && letter <= '9' || letter == ' ' || letter == '_' || letter == '-';
    }

    protected void _thumbs(boolean _bUp) {
        if (this.m_bOnlineBrowsing) {
            LevelItem item = this._getSelectedLevelItem();
            if (item != null) {
                if (_bUp) {
                    item.thumbUp(item.thumbUp() + 1);
                } else {
                    item.thumbDown(item.thumbDown() + 1);
                }
            }
            final String levelName = GameVars.LastCommunityPlayedLevelArchiveName();
            final boolean bUp = _bUp;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FileManager.Instance().thumbsPHPLevel(levelName, bUp);
                }
            };
            Thread voteThread = new Thread(r);
            voteThread.start();
            AchievementManager.Instance().unlockAchievement("ACH_CITIZEN");
            this._updateEntriesInfoAndVisibility();
        }
        if (this.m_action == eLoadAction.CommunityLevelDone) {
            this.m_action = eLoadAction.None;
        }
    }

    protected void _filter(String _filterSearch) {
        if (_filterSearch == null || _filterSearch.length() == 0) {
            this.m_txtFiltering.visible = false;
            this.m_tweenManager.RemoveTweenable(this.m_txtFiltering);
            if (this.m_levelNamesBackupSearch != null) {
                this.m_levelNames = new ArrayList<LevelItem>(this.m_levelNamesBackupSearch);
            }
            return;
        }
        if (this.m_levelNamesBackupSearch != null && this.m_levelNamesBackupSearch.size() > 0) {
            this.m_levelNames = new ArrayList<LevelItem>(this.m_levelNamesBackupSearch);
            this.m_levelNamesBackupSearch.clear();
        }
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            this.m_levelNamesBackupSearch = new ArrayList<LevelItem>(this.m_levelNames);
            this.m_levelNames.clear();
            Pattern p = Pattern.compile(_filterSearch, 8);
            Matcher m = null;
            for (LevelItem item : this.m_levelNamesBackupSearch) {
                m = p.matcher(item.LevelFileName().toUpperCase());
                if (m == null || !m.find()) continue;
                this.m_levelNames.add(item);
            }
        }
        this.m_txtFiltering.visible = true;
        this.m_txtFiltering.alpha(1.0f);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_txtFiltering, 0.2f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
    }

    protected void _filterTab(boolean _reinitPage) {
        if (m_tabSelected >= 0 && m_tabSelected < TabsActions.length) {
            eTabAction action = TabsActions[m_tabSelected];
            switch (action) {
                case TabAction_ShowAll: {
                    this._loadOnlineThreaded(!_reinitPage);
                    break;
                }
                default: {
                    this._loadOnlineTabThreaded(!_reinitPage);
                }
            }
            if (_reinitPage) {
                this._resetPage();
                this._selectEntry(0);
            }
        }
    }

    protected void _selectNextEntry(boolean _bPrevious) {
        if (!this.m_bSomethingInBase) {
            return;
        }
        int nextEntry = this.m_menuEntrySelected + (_bPrevious ? -1 : 1);
        if (nextEntry < 0) {
            if (this.m_numPage > 1) {
                this._selectEntry(NumEntriesMaxPerPage - 1);
                this._skipPage(-1);
            } else {
                this._selectEntry(NumEntriesMaxPerPage - 1);
                this._recomputeSelectEntryOnNewPage();
            }
        } else if (nextEntry >= NumEntriesMaxPerPage) {
            this._selectEntry(0);
            this._skipPage(1);
        } else if (this.m_menuEntries[nextEntry].visible()) {
            this._selectEntry(nextEntry);
        } else {
            this._selectEntry(0);
            this._skipPage(1);
        }
    }

    protected void _resetPage() {
        if (this.m_idPage != 1) {
            this.m_idPage = 1;
            this._updateEntriesInfoAndVisibility();
            this._recomputeSelectEntryOnNewPage();
            this._updatePageInfo();
        }
    }

    protected void _skipPage(int stepPage) {
        if (!this.m_bSomethingInBase) {
            return;
        }
        int nextPageId = this.m_idPage + stepPage;
        if (nextPageId <= 0) {
            nextPageId = this.m_numPage;
        } else if (nextPageId > this.m_numPage) {
            nextPageId = 1;
        }
        if (nextPageId != this.m_idPage) {
            this.m_idPage = nextPageId;
            this._updateEntriesInfoAndVisibility();
            this._recomputeSelectEntryOnNewPage();
        }
        this._updatePageInfo();
    }

    @Override
    protected void _onThanks() {
    }

    @Override
    protected void _onBuySelected() {
        this._onSharePressed();
    }

    @Override
    protected void _onSharePressed() {
        if (!this.m_bLoadingStuff && !this.m_bLaunchingLevel) {
            if (this.m_bOnlineBrowsing) {
                this._triggerAsk(eAskStuffType.eAskStuffType_Report);
            } else if (MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                if (LoginManager.Instance().isDefaultUserName()) {
                    this._triggerAsk(eAskStuffType.eAskStuffType_UserNameBeforeUpload);
                } else {
                    this._launchPackageThread();
                }
            }
        }
    }

    protected void _launchPackageThread() {
        if (!this.m_bSomethingInBase || this.m_bLoadingStuff) {
            return;
        }
        this.m_bLoadingStuff = true;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FileManager.Instance().createFolder("/Community/MyWorkspace/@Packaging/");
                FileManager.Instance().createFolder("/Community/MyWorkspace/@Packaging/_CRC");
                int indexLevel = OnlineLevelBrowsingState.this._getFirstIndexLevelOnPage() + OnlineLevelBrowsingState.this.m_menuEntrySelected;
                boolean bUploadDone = false;
                String longName = "";
                boolean bCustomChestFromContent = false;
                int parFromContent = 0;
                if (indexLevel < OnlineLevelBrowsingState.this.m_levelNames.size()) {
                    byte[] btmImageDatas;
                    longName = OnlineLevelBrowsingState.this.m_levelNames.get(indexLevel).LevelFileName();
                    GameVars.LastCommunityEditLevelFolderName(longName);
                    if (longName.contains("@")) {
                        longName = longName.substring(0, longName.lastIndexOf(64));
                    }
                    String friendlyName = OnlineLevelBrowsingState.this._getLevelFriendlyName(longName);
                    boolean bNeedPlayValidation = true;
                    String cacheContent = FileManager.Instance().getTextFileContent("/Community/MyWorkspace/@Packaging/" + longName + ".dat", true);
                    if (cacheContent != null) {
                        String currentContent = null;
                        currentContent = MACRO.ENCRYPT_LEVEL_EDITOR_FILES ? FileManager.Instance().getTextFileContent("/Community/MyWorkspace/" + longName + "/" + friendlyName + ".xml.dat", true) : FileManager.Instance().getTextFileContent("/Community/MyWorkspace/" + longName + "/" + friendlyName + ".xml", false);
                        if (cacheContent.equals(currentContent)) {
                            bNeedPlayValidation = false;
                        }
                    }
                    if (bNeedPlayValidation) {
                        OnlineLevelBrowsingState.this.m_onUploadLevelNeedToBePlayed.onCallback(this, null);
                        return;
                    }
                    OnlineLevelBrowsingState.this._tweenLogoOn();
                    String folderNameLocal = "/Community/MyWorkspace/" + longName;
                    String folderNamePackage = "/Community/MyWorkspace/@Packaging/" + friendlyName + "#" + GameVars.UserID() + "@" + LoginManager.Instance().currentUserName();
                    FileManager.Instance().createFolder(folderNamePackage);
                    String contentLevel = null;
                    if (MACRO.ENCRYPT_BY_COMPRESSING_PACKAGED_LEVEL) {
                        if (MACRO.ENCRYPT_LEVEL_EDITOR_FILES) {
                            contentLevel = FileManager.Instance().getTextFileContent(String.valueOf(folderNameLocal) + "/" + friendlyName + ".xml.dat", true);
                            byte[] compressLevel = FileManager.Instance().compressData(contentLevel.getBytes());
                            FileManager.Instance().writeTextFileContentByte(String.valueOf(folderNamePackage) + "/" + friendlyName + ".xml.dat", false, compressLevel);
                        } else {
                            FileManager.Instance().copyFile(String.valueOf(friendlyName) + ".xml.dat", folderNameLocal, folderNamePackage, true);
                        }
                    } else if (MACRO.ENCRYPT_LEVEL_EDITOR_FILES) {
                        contentLevel = FileManager.Instance().getTextFileContent(String.valueOf(folderNameLocal) + "/" + friendlyName + ".xml", true);
                        FileManager.Instance().writeTextFileContent(String.valueOf(folderNamePackage) + "/" + friendlyName + ".xml", false, contentLevel);
                    } else {
                        FileManager.Instance().copyFile(String.valueOf(friendlyName) + ".xml", folderNameLocal, folderNamePackage, false);
                    }
                    OnlineLevelBrowsingState.this.m_bWaitingApproval = false;
                    if (FileManager.Instance().isImageSizeValid(String.valueOf(folderNameLocal) + "/" + "btm.png", 256, 256) && (bCustomChestFromContent = OnlineLevelBrowsingState.this._customChestFromContent(contentLevel)) && (btmImageDatas = FileManager.Instance().getTextFileContentByte(String.valueOf(folderNameLocal) + "/" + "btm.png", false)) != null) {
                        FileManager.Instance().writeTextFileContentByte(String.valueOf(folderNamePackage) + "/" + "btm.png", false, btmImageDatas);
                        OnlineLevelBrowsingState.this.m_bWaitingApproval = true;
                    }
                    parFromContent = OnlineLevelBrowsingState.this._customParFromContent(contentLevel);
                    byte[] dialogDatas = FileManager.Instance().getTextFileContentByte(String.valueOf(folderNameLocal) + "/" + "Dialogs.xml", false);
                    if (dialogDatas != null) {
                        FileManager.Instance().writeTextFileContentByte(String.valueOf(folderNamePackage) + "/" + "Dialogs.xml", false, dialogDatas);
                    }
                    if (FileManager.Instance().zipFolder(folderNamePackage)) {
                        FileManager.Instance().deleteFolder(folderNamePackage);
                        int numTryLeft = 5;
                        String crcPath = "/Community/MyWorkspace/@Packaging/_CRC";
                        String realFileName = String.valueOf(longName) + "@" + LoginManager.Instance().currentUserName() + ".btm";
                        do {
                            block22: {
                                if (!(bUploadDone = FileManager.Instance().uploadFileToFTP(String.valueOf(folderNamePackage) + ".btm", OnlineLevelBrowsingState.this.m_bWaitingApproval))) continue;
                                try {
                                    Thread.sleep(48L);
                                }
                                catch (Exception e) {
                                    if (!MACRO.DEBUG) break block22;
                                    e.printStackTrace();
                                }
                            }
                            FileManager.Instance().downloadFileFromURL(realFileName, crcPath, OnlineLevelBrowsingState.this.m_bWaitingApproval);
                            if (!FileManager.Instance().checkArchiveOpens(crcPath, realFileName)) {
                                bUploadDone = false;
                            }
                            FileManager.Instance().deleteFile(String.valueOf(crcPath) + "/" + realFileName);
                        } while (--numTryLeft > 0 && !bUploadDone);
                        if (!bUploadDone) {
                            FileManager.Instance().deletePHPLevel(realFileName);
                        }
                    }
                }
                if (bUploadDone) {
                    LevelItem li;
                    String levelNameID = String.valueOf(longName) + "@" + LoginManager.Instance().currentUserName();
                    FileManager.Instance().updateAttribsPHPLevel(levelNameID, bCustomChestFromContent && OnlineLevelBrowsingState.this.m_bWaitingApproval, parFromContent);
                    if (OnlineLevelBrowsingState.this.m_bWaitingApproval && (li = OnlineLevelBrowsingState.this.m_levelNames.get(indexLevel)) != null) {
                        OnlineLevelBrowsingState.this._reportLevel(li, "BTM CUSTOM This level uses a btm png file and needs approval");
                    }
                    OnlineLevelBrowsingState.this.m_onUploadDone.onCallback(this, null);
                } else {
                    OnlineLevelBrowsingState.this.m_onUploadFailed.onCallback(this, null);
                }
            }
        };
        this.m_threadLoader = new Thread(r);
        this.m_threadLoader.start();
    }

    protected boolean _customChestFromContent(String _levelContent) {
        return _levelContent != null && _levelContent.contains("friendly=\"chestBTMBloc\"");
    }

    protected int _customParFromContent(String _levelContent) {
        int indexEnd;
        int index;
        int indexStart;
        String dirtyToken;
        if (_levelContent != null && _levelContent.contains(dirtyToken = "id=\"Par\" type=\"int\" value=\"") && (indexStart = (index = _levelContent.indexOf(dirtyToken)) + dirtyToken.length()) < (indexEnd = _levelContent.indexOf("\"", indexStart))) {
            String value = _levelContent.substring(indexStart, indexEnd);
            int parValue = 0;
            try {
                parValue = Integer.parseInt(value);
            }
            catch (Exception e) {
                parValue = 0;
            }
            return parValue;
        }
        return 0;
    }

    @Override
    protected void _onLoginPressed() {
        if (!this.m_bLoadingStuff && !this.m_bLaunchingLevel) {
            if (this.m_bOnlineBrowsing) {
                this._triggerAsk(eAskStuffType.eAskStuffType_Search);
            } else {
                this._triggerAsk(eAskStuffType.eAskStuffType_LevelName);
            }
        }
    }

    protected void _triggerAsk(eAskStuffType _type) {
        if (!this.m_bAskThingTriggered) {
            this.m_bAskThingTriggered = true;
            this.m_askedType = _type;
        }
    }

    @Override
    protected void _onReturnPressed() {
        FlxG.state(new MenuCommunityState());
    }

    @Override
    protected void _onSelectPressed() {
        if (!this.m_bSomethingInBase || this.m_bLoadingStuff) {
            return;
        }
        if (this.m_bOnlineBrowsing) {
            LevelItem selection = this._getSelectedLevelItem();
            if (selection.upToDate() && this.m_levelSaveLocally.contains(selection)) {
                this._launchSelectedLevel();
            } else {
                this._downloadAndPlayLevelThreaded(selection.LevelFileName());
            }
        } else {
            this._launchSelectedLevel();
        }
    }

    protected String _getSelectedLevelName() {
        int indexLevel = this._getFirstIndexLevelOnPage();
        int realIndex = indexLevel + this.m_menuEntrySelected;
        if (this.m_levelNames.size() > realIndex) {
            return this.m_levelNames.get(realIndex).LevelFileName();
        }
        return null;
    }

    protected LevelItem _getSelectedLevelItem() {
        int indexLevel = this._getFirstIndexLevelOnPage();
        int realIndex = indexLevel + this.m_menuEntrySelected;
        if (this.m_levelNames.size() > realIndex) {
            try {
                return this.m_levelNames.get(realIndex);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected LevelItem _linearSearchLevelItem(String _levelName) {
        LevelItem res = null;
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            int i = 0;
            while (i < this.m_levelNames.size()) {
                res = this.m_levelNames.get(i);
                if (res.LevelFileName().startsWith(_levelName)) {
                    return res;
                }
                ++i;
            }
        }
        return null;
    }

    protected LevelItem _linearSearchLevelItem(String _levelName, boolean _bFromCurrentCreator) {
        String creatorName = "@" + LoginManager.Instance().currentUserName().toUpperCase();
        String searchLevel = _levelName.toUpperCase();
        LevelItem res = null;
        if (this.m_levelNames != null && this.m_levelNames.size() > 0) {
            int i = 0;
            while (i < this.m_levelNames.size()) {
                res = this.m_levelNames.get(i);
                String upperCaseLevelFilename = res.LevelFileName().toUpperCase();
                if (upperCaseLevelFilename.startsWith(searchLevel)) {
                    if (_bFromCurrentCreator) {
                        if (upperCaseLevelFilename.contains(creatorName)) {
                            return res;
                        }
                    } else {
                        return res;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected void _launchSelectedLevel() {
        if (!this.m_bLoadingStuff && !this.m_bLaunchingLevel) {
            this.m_bLaunchingLevel = true;
            FlxG.fade.start(Color.Black(), this.m_timeFade, this.m_fadeLevelSelectComplete, true, true);
        }
    }

    protected void _launchNextAutoSelectedLevel() {
        if (!this.m_bLoadingStuff && !this.m_bLaunchingLevel) {
            this.m_bLaunchingLevel = true;
            FlxG.fade.start(Color.Black(), this.m_timeFade, this.m_fadeLevelAutoSelectComplete, true, true);
        }
    }

    protected void _fadeLevelSelectComplete(Object sender, Object e) {
        int indexLevel = this._getFirstIndexLevelOnPage();
        int realIndex = indexLevel + this.m_menuEntrySelected;
        if (this.m_levelNames.size() > realIndex) {
            String name = this.m_levelNames.get(realIndex).LevelFileName();
            this._launchLevelState(name);
        }
    }

    protected void _fadeLevelAutoSelectComplete(Object sender, Object e) {
        if (this.m_autoNextLevelName != null) {
            this._launchLevelState(this.m_autoNextLevelName);
            this.m_autoNextLevelName = null;
        }
    }

    protected void _launchLevelState(String levelName) {
        if (!this.m_bOnlineBrowsing) {
            GameVars.LastCommunityEditLevelFolderName(levelName);
            GameVars.LastCommunityEditLevelXmlName(levelName.substring(0, levelName.lastIndexOf(35)));
            if (m_actionDeferred == eLoadAction.Upload) {
                FlxG.state(new PlayState(true, true, GameVars.LastCommunityEditLevelXmlName(), "Community"));
            } else {
                FlxG.state(new PlayState(false, true, GameVars.LastCommunityEditLevelXmlName(), "Community"));
            }
        } else {
            GameVars.LastCommunityPlayedLevelArchiveName(levelName.substring(0, levelName.lastIndexOf(46)));
            GameVars.LastCommunityPlayedLevelXmlName(levelName.substring(0, levelName.lastIndexOf(35)));
            FlxG.state(new PlayState(true, false, GameVars.LastCommunityPlayedLevelXmlName(), "Community"));
        }
    }

    public void _reportLevel(LevelItem _level, String messageStr) {
        if (_level != null) {
            FileManager.Instance().reportLevelByMail(GameVars.UserID(), LoginManager.Instance().currentUserName(), _level.LevelFileName(), messageStr);
        }
    }

    static enum eAskStuffType {
        eAskStuffType_None,
        eAskStuffType_LevelName,
        eAskStuffType_Search,
        eAskStuffType_RequirePlay,
        eAskStuffType_Report,
        eAskStuffType_LevelSubmitted,
        eAskStuffType_LevelSubmittedFailed,
        eAskStuffType_Rate,
        eAskStuffType_UserNameBeforeUpload,
        eAskStuffType_LevelFromTheFuture,
        eAskStuffType_DeleteCreation,
        eAskStuffType_DuplicateCreation;

    }

    public static enum eLoadAction {
        None,
        Upload,
        SaveFinishedLevelContentDat,
        CommunityLevelDone,
        AutoLaunchLevel,
        ErrorTryToLoadLevelFromFuture;

    }

    static enum eTabAction {
        TabAction_ShowAll,
        TabAction_ShowFeatured,
        TabAction_ShowTopRated,
        TabAction_ShowDL,
        TabAction_ShowMine;

    }
}

