/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.BTM.PlayState;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.BTM.TextDataBase;
import SSS.States.BTM.CinematicReplayState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class PauseFakeState
extends TemplateGameMenu {
    static float TitlePosPercY = 0.025f;
    static float PausePosPercYMiddle = 0.5f;
    static float PausePosPercYBot = 0.94f;
    static float TimeAppear = 0.5f;
    static float TimeDisappear = 0.25f;
    static float FrameInitScale = 1.2f;
    static float FrameFinalScale = 1.0f;
    static float AlphaBackgroundPauseOn = 0.5f;
    static float AlphaBackgroundPauseOff = 0.0f;
    boolean m_bPause = false;
    protected boolean m_bTweenDone = true;
    protected PlayState m_playStateOrNil = null;
    protected CinematicReplayState m_cinematicState = null;
    protected FlxText m_title;
    protected FlxText m_paused;
    FlxSprite m_fullscreenQuad = null;
    CallbackSimple m_tweenShowUpDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PauseFakeState.this._tweenShowUpDone(_sender, _args);
        }
    };
    CallbackSimple m_tweenHideDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PauseFakeState.this._tweenHideDone(_sender, _args);
        }
    };

    public boolean Pause() {
        return this.m_bPause;
    }

    public PauseFakeState(PlayState _playStateOrNil, CinematicReplayState _cinematicStateOrNil) {
        this.m_playStateOrNil = _playStateOrNil;
        this.m_cinematicState = _cinematicStateOrNil;
    }

    @Override
    public void create() {
        super.create();
        this._templateDefineKeysOverride(Keys.None, Keys.Escape, Keys.None);
        if (this.m_playStateOrNil != null) {
            this.m_fullscreenQuad = new FlxSprite();
            this.m_fullscreenQuad.createGraphic(FlxG.width, FlxG.height, Color.Black());
            this.m_fullscreenQuad.scrollFactor = Vector2.Zero();
            this.m_fullscreenQuad.visible = false;
            this.add(this.m_fullscreenQuad);
        } else {
            this.m_fullscreenQuad = null;
        }
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        TextDataBase tdb = TextDataBase.Instance();
        if (this.m_playStateOrNil != null) {
            this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
            this._templateChangeIconsTexts(tdb.getText("TXT_QUIT"), tdb.getText("TXT_RESUME"), tdb.getText("TXT_BUY"));
        } else {
            this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
            this._templateChangeIconsTexts(tdb.getText("TXT_SKIP"), tdb.getText("TXT_RESUME"), tdb.getText("TXT_BUY"));
        }
        this._templateHideAllButtons();
        this.m_title = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_title.y = TitlePosPercY * (float)FlxG.height;
        this.m_title.scale(2.0f);
        this.m_title.alignment = FlxText.FlxJustification.Center;
        this.m_title.visible = false;
        this.add(this.m_title);
        this.m_paused = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_paused.scale(2.0f);
        this.m_paused.text(TextDataBase.Instance().getText("TXT_PAUSED"));
        this.m_paused.alignment = FlxText.FlxJustification.Center;
        this.m_paused.x = (float)FlxG.width * 0.5f - this.m_paused.width * 0.5f;
        this.m_paused.visible = false;
        this.m_paused.y = this.m_playStateOrNil != null ? PausePosPercYMiddle * (float)FlxG.height - this.m_paused.height * 0.5f : PausePosPercYBot * (float)FlxG.height - this.m_paused.height * 0.5f;
        this.add(this.m_paused);
        this.m_frame.visible = false;
    }

    public void updatePauseScreenTitle() {
        if (this.m_playStateOrNil != null) {
            if (GameVars.GameCommunityMode()) {
                if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                    this.m_title.text(GameVars.LastCommunityEditLevelXmlName());
                } else {
                    this.m_title.text(GameVars.LastCommunityPlayedLevelXmlName());
                }
            } else {
                LevelInfo lvlInfo = LevelDataBase.Instance().getLevelInfo(this.m_playStateOrNil.Level());
                if (lvlInfo != null) {
                    this.m_title.text(lvlInfo.FriendlyName());
                }
            }
        }
    }

    @Override
    public void update() {
        if (!this.m_bTweenDone || this.m_bPause) {
            super.update();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected void _onReturnPressed() {
        if (this.m_playStateOrNil != null) {
            if (this.m_playStateOrNil.Level() != null) {
                LevelGroup lvlGroup = this.m_playStateOrNil.Level().Group();
                if (lvlGroup == null || lvlGroup.Flag() == LevelGroup.eSpecialFlag.Specials) {
                    this.m_playStateOrNil.Level().returnToMainMenu(true);
                } else {
                    this.m_playStateOrNil.Level().returnToLevelHub();
                }
            }
        } else if (this.m_cinematicState != null) {
            this.m_cinematicState.onReturnPressed();
        }
        AchievementManager.Instance().resetAchievementDeferred();
    }

    @Override
    protected void _onThanks() {
        this._launchThanksMap();
    }

    @Override
    protected void _onSelectPressed() {
    }

    public void registerLayer() {
        if (this.m_playStateOrNil != null) {
            this.m_playStateOrNil.addOverall(this.defaultGroup);
        } else if (this.m_cinematicState != null) {
            this.m_cinematicState.addOverall(this.defaultGroup);
        }
    }

    public void togglePause() {
        if (this.m_bTweenDone) {
            this.m_bTweenDone = false;
            boolean bl = this.m_bPause = !this.m_bPause;
            if (this.m_bPause) {
                this._showUp();
            } else {
                this._hide();
            }
        }
    }

    protected void _showUp() {
        this.m_bTweenDone = false;
        this._templateAllButtonsTransparent();
        this.m_frame.visible = true;
        this.m_frame.alpha(1.0f);
        this.m_frame.scale(FrameInitScale);
        this.m_tweenManager.ToScale((Tweenable)this.m_frame, new Vector2(FrameFinalScale, FrameFinalScale), TimeAppear, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, this.m_tweenShowUpDone);
        this.m_title.visible = true;
        this.m_title.alpha(0.0f);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_title, 1.0f, TimeAppear, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        if (this.m_fullscreenQuad != null) {
            this.m_fullscreenQuad.visible = true;
            this.m_fullscreenQuad.alpha(AlphaBackgroundPauseOff);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_fullscreenQuad, AlphaBackgroundPauseOn, TimeAppear, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        this.m_paused.visible = true;
        this.m_paused.alpha(0.0f);
        this.m_tweenManager.ToAlpha((Tweenable)this.m_paused, 1.0f, 0.2f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this._tweenAlphaToButtons(0.0f, 1.0f, TimeAppear);
    }

    protected void _hide() {
        this.m_bTweenDone = false;
        this.m_frame.visible = true;
        this.m_frame.scale(FrameFinalScale);
        this.m_tweenManager.ToScale((Tweenable)this.m_frame, new Vector2(FrameInitScale, FrameInitScale), TimeDisappear, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, this.m_tweenHideDone);
        if (this.m_fullscreenQuad != null) {
            this.m_fullscreenQuad.visible = true;
            this.m_fullscreenQuad.alpha(AlphaBackgroundPauseOn);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_fullscreenQuad, AlphaBackgroundPauseOff, TimeDisappear, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        this.m_logo.visible = true;
        this.m_tweenManager.ToAlpha((Tweenable)this.m_title, 0.0f, TimeDisappear, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        this._tweenAlphaToButtons(1.0f, 0.0f, TimeDisappear);
        this.m_tweenManager.BreakLoop(TimeDisappear);
    }

    protected void _tweenShowUpDone(Object _sender, Object _e) {
        this.m_bTweenDone = true;
    }

    protected void _tweenHideDone(Object _sender, Object _e) {
        this.m_frame.visible = false;
        this.m_title.visible = false;
        this.m_paused.visible = false;
        if (this.m_fullscreenQuad != null) {
            this.m_fullscreenQuad.visible = false;
        }
        this.m_bTweenDone = true;
        this._templateHideAllButtons();
    }
}

