/*
 * Decompiled with CFR 0.152.
 */
package SSS.States.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.SaveManager;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.MenuMainState;
import SSS.States.BTM.TemplateGameMenu;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.UI.MainMenuEntry;
import SSS.Util.InputManager;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class SettingsState
extends TemplateGameMenu {
    float FirstEntryPercCenterY = 0.22f;
    float StepBetweenEntries = 88.0f;
    static float TitlePercY = 0.1f;
    static float TitleScale = 3.0f;
    FlxSprite[] m_arrows = new FlxSprite[4];
    static float ArrowsScale = 0.5f;
    static float ArrowMarginOffset = 5.0f;
    SssGroup m_layer;
    MainMenuEntry[] m_menuEntries;
    static String[] EntriesTextsIds = new String[]{"TXT_SETTING_VOLUME", "TXT_KEYBOARD_CONFIG", "TXT_GAMEPAD_CONFIG", "TXT_SCREEN_RESOLUTION", "TXT_SCREEN_SIZE", "TXT_LANGUAGE"};
    MainMenuEntry.eType[] EntriesType = new MainMenuEntry.eType[]{MainMenuEntry.eType.Volume, MainMenuEntry.eType.KeyboardConfig, MainMenuEntry.eType.GamepadConfig, MainMenuEntry.eType.ScreenResolution, MainMenuEntry.eType.ScreenSize, MainMenuEntry.eType.Language};
    int m_menuEntrySelectedOld = 0;
    int m_menuEntrySelected = -1;
    boolean m_bValidating = false;
    FlxText m_txtTitle;
    FlxSprite m_cursorLeft;
    FlxSprite m_cursorRight;
    int m_entrySelectedId = 0;
    private boolean m_bReturnToPreviousScreen = false;
    CallbackSimple m_autoSaveComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            SettingsState.this._autoSaveComplete(_sender, _args);
        }
    };

    public SettingsState() {
    }

    public SettingsState(int _entrySelectedId) {
        this.m_entrySelectedId = _entrySelectedId;
    }

    @Override
    public void create() {
        super.create();
        this._templateBuildBackground();
        this._templateBuildFrameAndLogo(TemplateGameMenu.eLogoPosition.LeftTiny);
        this._templateBuildCornerIcons(TemplateGameMenu.eButtonAction.Return, TemplateGameMenu.eButtonAction.Select, TemplateGameMenu.eButtonAction.Buy);
        TextDataBase tdb = TextDataBase.Instance();
        this._templateChangeIconsTexts(tdb.getText("TXT_RETURN"), tdb.getText("TXT_SELECT"), tdb.getText("TXT_BUY"));
        this.m_layer = new SssGroup();
        this.add(this.m_layer);
        MusicManager.Instance().playTracks("menu01", null, 1.0f, false);
        this.m_menuEntries = new MainMenuEntry[EntriesTextsIds.length];
        float centerx = (float)FlxG.width * 0.5f;
        float centery = (float)FlxG.height * this.FirstEntryPercCenterY;
        int i = 0;
        while (i < EntriesTextsIds.length) {
            this.m_menuEntries[i] = new MainMenuEntry(i, this.m_layer, this.m_tweenManager, this.EntriesType[i], null, null, null);
            this.m_menuEntries[i].positionateAt(centerx, centery);
            this.m_menuEntries[i].setText(TextDataBase.Instance().getText(EntriesTextsIds[i]));
            centery += this.StepBetweenEntries;
            ++i;
        }
        this.m_menuEntries[EntriesTextsIds.length - 1].AlternativeTextId("TXT_ERASE_SAVE_DONE");
        this._templateWatchEntries(this.m_menuEntries);
        this.m_txtTitle = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtTitle.UseShadow(false);
        this.m_txtTitle.color(Color.Black());
        this.m_txtTitle.text(TextDataBase.Instance().getText("TXT_SETTINGS"));
        this.m_txtTitle.scale(TitleScale);
        this.m_txtTitle.y = (float)FlxG.height * TitlePercY;
        this.add(this.m_txtTitle);
        this.m_cursorLeft = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorLeft.play("pointLeft");
        this.m_layer.add(this.m_cursorLeft);
        this.m_cursorRight = ResourcesLibrary.Instance().InstanciateSprite("menu_arrows");
        this.m_cursorRight.play("pointRight");
        this.m_layer.add(this.m_cursorRight);
        i = 0;
        while (i < this.m_arrows.length) {
            this.m_arrows[i] = ResourcesLibrary.Instance().InstanciateSprite("look_arrow");
            this.m_arrows[i].scale(ArrowsScale);
            this.m_arrows[i].visible = false;
            this.m_layer.add(this.m_arrows[i]);
            ++i;
        }
        float offset = ArrowMarginOffset + this.m_arrows[0].width * ArrowsScale * 0.5f;
        this.m_arrows[0].x = (float)FlxG.width * 0.5f - this.m_arrows[0].width * 0.5f;
        this.m_arrows[0].y = 0.0f - offset;
        this.m_arrows[0].angle(0.0f);
        this.m_arrows[1].x = (float)FlxG.width * 0.5f - this.m_arrows[1].width * 0.5f;
        this.m_arrows[1].y = (float)FlxG.height - this.m_arrows[1].height + offset;
        this.m_arrows[1].angle(180.0f);
        this.m_arrows[2].x = 0.0f - offset;
        this.m_arrows[2].y = (float)FlxG.height * 0.5f - this.m_arrows[2].height * 0.5f;
        this.m_arrows[2].angle(-90.0f);
        this.m_arrows[3].x = (float)FlxG.width - this.m_arrows[3].width + offset;
        this.m_arrows[3].y = (float)FlxG.height * 0.5f - this.m_arrows[3].height * 0.5f;
        this.m_arrows[3].angle(90.0f);
        this._selectEntry(false, this.m_entrySelectedId);
    }

    @Override
    protected void _onNewEntryUnderMouse(MainMenuEntry _entry, int slot, int groupId) {
        this._selectEntry(false, slot);
    }

    @Override
    protected void _onEntryUnderMouseSelected(MainMenuEntry _entry, int slot, int groupId) {
        this._onSelectPressed();
    }

    @Override
    protected void _onEntryUnderMouseMouseWheel(MainMenuEntry _entry, int slot, int value, int groupId) {
        if (value != 0) {
            _entry.rightDown((float)value * 0.02f);
        }
    }

    protected void _selectEntry(boolean _tween, int _slot) {
        if (this.m_menuEntrySelected != _slot) {
            this.m_menuEntrySelectedOld = this.m_menuEntrySelected;
            this.m_menuEntrySelected = _slot;
            if (!_tween) {
                this.m_cursorLeft.x = this.m_menuEntries[this.m_menuEntrySelected].getLeftX() - this.m_cursorLeft.width * 0.5f;
                this.m_cursorRight.x = this.m_menuEntries[this.m_menuEntrySelected].getRightX() - this.m_cursorRight.width * 0.5f;
                this.m_cursorLeft.y = this.m_menuEntries[this.m_menuEntrySelected].getCenterY() - this.m_cursorLeft.height * 0.5f;
                this.m_cursorRight.y = this.m_menuEntries[this.m_menuEntrySelected].getCenterY() - this.m_cursorRight.height * 0.5f;
                float factor = this.m_menuEntries[this.m_menuEntrySelected].getCursorScaleX();
                this.m_cursorLeft.scale(0.5f * factor);
                this.m_cursorRight.scale(0.5f * factor);
                this.m_tweenManager.ToScale((Tweenable)this.m_cursorLeft, new Vector2(factor), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
                this.m_tweenManager.ToScale((Tweenable)this.m_cursorRight, new Vector2(factor), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            }
            if (this.m_menuEntrySelected >= 0 && this.m_menuEntrySelected < this.m_menuEntries.length) {
                if (this.m_menuEntries[this.m_menuEntrySelected].Type() == MainMenuEntry.eType.ScreenSize) {
                    this._tweenShowArrows();
                }
                this.m_menuEntries[this.m_menuEntrySelected].select();
            }
            if (this.m_menuEntrySelectedOld != this.m_menuEntrySelected && this.m_menuEntrySelectedOld >= 0 && this.m_menuEntrySelectedOld < this.m_menuEntries.length) {
                if (this.m_menuEntries[this.m_menuEntrySelectedOld].Type() == MainMenuEntry.eType.ScreenSize) {
                    this._tweenHideArrows();
                }
                this.m_menuEntries[this.m_menuEntrySelectedOld].unselect();
            }
        }
    }

    protected void _tweenShowArrows() {
        int i = 0;
        while (i < this.m_arrows.length) {
            this.m_tweenManager.RemoveTweenable(this.m_arrows[i]);
            this.m_arrows[i].visible = true;
            this.m_arrows[i].alpha(0.2f);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_arrows[i], 1.0f, 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
            ++i;
        }
    }

    protected void _tweenHideArrows() {
        int i = 0;
        while (i < this.m_arrows.length) {
            this.m_tweenManager.RemoveTweenable(this.m_arrows[i]);
            this.m_arrows[i].visible = true;
            this.m_tweenManager.ToAlpha((Tweenable)this.m_arrows[i], 0.0f, 0.2f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            ++i;
        }
    }

    @Override
    public void update() {
        try {
            super.update();
            if (this.m_bReturnToPreviousScreen) {
                this.m_bReturnToPreviousScreen = false;
                FlxG.state(new MenuMainState(false, false));
            }
            if (!this.m_bValidating) {
                this._leftStickHandling();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void _leftStickHandling() {
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft) || InputManager.IsNewButtonPress(Buttons.DPadLeft)) {
            this.m_menuEntries[this.m_menuEntrySelected].leftJustDown();
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight) || InputManager.IsNewButtonPress(Buttons.DPadRight)) {
            this.m_menuEntries[this.m_menuEntrySelected].rightJustDown();
        } else if (InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || InputManager.IsButtonDown(Buttons.DPadLeft)) {
            this.m_menuEntries[this.m_menuEntrySelected].leftDown(1.0f);
        } else if (InputManager.IsButtonDown(Buttons.LeftThumbstickRight) || InputManager.IsButtonDown(Buttons.DPadRight)) {
            this.m_menuEntries[this.m_menuEntrySelected].rightDown(1.0f);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown) || InputManager.IsNewButtonPress(Buttons.DPadDown)) {
            if (this.m_menuEntrySelected < this.m_menuEntries.length - 1) {
                this._selectEntry(false, this.m_menuEntrySelected + 1);
            } else {
                this._selectEntry(false, 0);
            }
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp) || InputManager.IsNewButtonPress(Buttons.DPadUp)) {
            if (this.m_menuEntrySelected == 0) {
                this._selectEntry(false, this.m_menuEntries.length - 1);
            } else {
                this._selectEntry(false, this.m_menuEntrySelected - 1);
            }
        }
    }

    @Override
    protected void _onThanks() {
        this._launchThanksMap();
    }

    @Override
    protected void _onReturnPressed() {
        if (this.m_bLastEventProcessed) {
            this.m_bLastEventProcessed = false;
            if (this._anyBarValueChanged()) {
                try {
                    FlxG.SaveDisplaySettings();
                    SaveManager.Instance().saveGameDataThreaded(this.m_autoSaveComplete);
                }
                catch (Exception e) {
                    this._autoSaveComplete(null, null);
                }
            } else {
                this._autoSaveComplete(null, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean _anyBarValueChanged() {
        try {
            int i = 0;
            while (true) {
                if (i >= 3) {
                    return false;
                }
                if (this.m_menuEntries[i].WrappedValueChanged()) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void _autoSaveComplete(Object _sender, Object _e) {
        this.m_bReturnToPreviousScreen = true;
    }

    @Override
    protected void _onSelectPressed() {
        if (this.m_timeInState > MinTimeInState) {
            this.m_menuEntries[this.m_menuEntrySelected].confirm();
            int i = 0;
            while (i < this.m_menuEntries.length) {
                this.m_menuEntries[i].updateSlider();
                ++i;
            }
        }
    }
}

