/*
 * Decompiled with CFR 0.152.
 */
package SSS.Tween;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.TextDataBase;
import SSS.SssGroup;
import SSS.Tween.SssStageImageItem;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class AnimationStage {
    protected static HashMap<String, eEventType> EventTypeFromString = new HashMap<String, eEventType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("moveTo", eEventType.MoveTo);
            this.put("scaleTo", eEventType.ScaleTo);
            this.put("alphaTo", eEventType.AlphaTo);
            this.put("angleTo", eEventType.AngleTo);
            this.put("colorTo", eEventType.ColorTo);
            this.put("fadeIn", eEventType.FadeIn);
            this.put("fadeOut", eEventType.FadeOut);
            this.put("flash", eEventType.Flash);
            this.put("playTracks", eEventType.PlayTracks);
            this.put("playSound", eEventType.PlaySound);
        }
    };
    protected static HashMap<String, TweenManager.EaseType> EaseTypeFromString = new HashMap<String, TweenManager.EaseType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("outbounce", TweenManager.EaseType.EASE_OUTBOUNCE);
            this.put("inoutsin", TweenManager.EaseType.EASE_INOUTSIN);
            this.put("linear", TweenManager.EaseType.EASE_LINEAR);
        }
    };
    boolean m_bStepByStep = false;
    boolean m_bTickThisFrame = false;
    boolean m_bLoaded = false;
    FlxSprite m_fadeInOutItem;
    HashMap<String, SssStageImageItem> m_itemsImg;
    SssGroup m_mainLayer;
    TweenManager m_tweenManager;
    float m_version = 0.0f;
    float m_duration = 0.0f;
    float m_elapsedTime = 0.0f;
    FlxText m_time = null;
    String m_timeStr = "t: ";
    boolean m_bFinished = false;

    public boolean finished() {
        return this.m_bFinished;
    }

    public AnimationStage(SssGroup _mainLayer) {
        this.m_mainLayer = _mainLayer;
        this.m_tweenManager = new TweenManager();
        this.m_itemsImg = new HashMap(40);
    }

    public void load(String _filename) {
        if (this.m_bLoaded) {
            this._unload();
        }
        this.m_fadeInOutItem = new FlxSprite();
        this.m_fadeInOutItem.createGraphic(FlxG.width + 2, FlxG.height + 2, Color.Black());
        this.m_fadeInOutItem.scrollFactor = Vector2.Zero();
        this.m_fadeInOutItem.UseRounding(false);
        this.m_fadeInOutItem.alpha(0.0f);
        this.m_bFinished = false;
        Document doc = null;
        doc = FlxG.Content().LoadXDocument("sss/cinematics/" + _filename);
        this._load(doc);
        this.m_mainLayer.add(this.m_fadeInOutItem);
    }

    protected void _unload() {
        for (Map.Entry<String, SssStageImageItem> kvp : this.m_itemsImg.entrySet()) {
            this.m_mainLayer.remove(kvp.getValue());
        }
        this.m_mainLayer.remove(this.m_fadeInOutItem);
        this.m_itemsImg.clear();
        this.m_tweenManager.Clear();
        this.m_bLoaded = false;
    }

    protected void _load(Document _doc) {
        if (_doc != null) {
            Element elemCinematic = (Element)_doc.getElementsByTagName("Cinematic").item(0);
            this.m_version = Float.parseFloat(elemCinematic.getAttribute("version"));
            this._loadStageItems(elemCinematic);
            this._loadStageTimeline(elemCinematic);
            this.m_bLoaded = true;
        }
    }

    protected void _loadStageItems(Element _elemCinematic) {
        Element elemStageItems = (Element)_elemCinematic.getElementsByTagName("StageItems").item(0);
        NodeList elemStageItemNodeList = elemStageItems.getElementsByTagName("StageItem");
        int elemStageItemId = 0;
        while (elemStageItemId < elemStageItemNodeList.getLength()) {
            Element elemStageItem = (Element)elemStageItemNodeList.item(elemStageItemId);
            String type = elemStageItem.getAttribute("type");
            String friendly = elemStageItem.getAttribute("friendly");
            if (type.equals("img")) {
                this._loadImgStageItem(friendly, elemStageItem);
            } else if (type.equals("rect")) {
                this._loadRect(friendly, elemStageItem);
            } else if (type.equals("text")) {
                this._loadTextStageItem(friendly, elemStageItem);
            }
            ++elemStageItemId;
        }
    }

    protected void _loadRect(String _friendly, Element _stageItem) {
        float w = (float)FlxG.width * Float.parseFloat(_stageItem.getAttribute("w"));
        float h = (float)FlxG.height * Float.parseFloat(_stageItem.getAttribute("h"));
        SssStageImageItem imageItem = new SssStageImageItem(w, h, this._getColorAttribute(_stageItem, "c"));
        this._commonGraphicalItemLoad(imageItem, _friendly, _stageItem);
    }

    protected void _loadImgStageItem(String _friendly, Element _stageItem) {
        SssStageImageItem imageItem = new SssStageImageItem(_stageItem.getAttribute("content"));
        this._commonGraphicalItemLoad(imageItem, _friendly, _stageItem);
    }

    protected void _loadTextStageItem(String _friendly, Element _stageItem) {
        SssStageImageItem textItem = new SssStageImageItem(TextDataBase.Instance().getText(_stageItem.getAttribute("id")), this._getColorAttribute(_stageItem, "c"), Float.parseFloat(_stageItem.getAttribute("interline")));
        this._commonGraphicalItemLoad(textItem, _friendly, _stageItem);
        String shadowColor = _stageItem.getAttribute("sc");
        String shadowOffset = _stageItem.getAttribute("soff");
        if (shadowColor != null && shadowColor.length() > 0) {
            float offset = shadowOffset != null && shadowOffset.length() > 0 ? Float.parseFloat(shadowOffset) : 1.0f;
            textItem.updateShadowColor(this._getColorAttribute(shadowColor), offset);
        }
    }

    protected void _commonGraphicalItemLoad(SssStageImageItem imageItem, String _friendly, Element _stageItem) {
        float initY;
        float initX;
        float initAlpha = 1.0f;
        float initScale = 1.0f;
        String xInit = _stageItem.getAttribute("x");
        String yInit = _stageItem.getAttribute("y");
        String scaleInit = _stageItem.getAttribute("s");
        String alphaInit = _stageItem.getAttribute("a");
        String colorAttrib = _stageItem.getAttribute("c");
        if (xInit != null && xInit.length() > 0) {
            initX = Float.parseFloat(xInit);
            initX *= (float)FlxG.width;
        } else {
            initX = (float)FlxG.width * 0.5f;
        }
        if (yInit != null && yInit.length() > 0) {
            initY = Float.parseFloat(yInit);
            initY *= (float)FlxG.height;
        } else {
            initY = (float)FlxG.height * 0.5f;
        }
        if (alphaInit != null && alphaInit.length() > 0) {
            initAlpha = Float.parseFloat(alphaInit);
        }
        if (scaleInit != null && scaleInit.length() > 0) {
            initScale = Float.parseFloat(scaleInit);
        }
        if (colorAttrib != null && colorAttrib.length() > 0) {
            Color color = this._getColorAttribute(colorAttrib);
            imageItem.TweenColor((float)color.R / 255.0f, (float)color.G / 255.0f, (float)color.B / 255.0f);
        }
        imageItem.TweenPosition(initX, initY);
        imageItem.TweenAlpha(initAlpha);
        imageItem.TweenScale(initScale, initScale);
        this.m_itemsImg.put(_friendly, imageItem);
        this.m_mainLayer.add(imageItem);
    }

    protected void _loadStageTimeline(Element _elemCinematic) {
        try {
            Element elemTimeline = (Element)_elemCinematic.getElementsByTagName("Timeline").item(0);
            this.m_duration = Float.parseFloat(elemTimeline.getAttribute("duration"));
            float previousDelayOffset = 0.0f;
            Element elemEvent = null;
            NodeList elemEventNodeList = elemTimeline.getElementsByTagName("Event");
            int elemEventId = 0;
            while (elemEventId < elemEventNodeList.getLength()) {
                elemEvent = (Element)elemEventNodeList.item(elemEventId);
                String type = elemEvent.getAttribute("type");
                String relativeToPrevious = elemEvent.getAttribute("relative");
                String targetAttrib = elemEvent.getAttribute("target");
                String target = targetAttrib != null && targetAttrib.length() > 0 ? targetAttrib : null;
                float delay = Float.parseFloat(elemEvent.getAttribute("start"));
                if (relativeToPrevious != null && relativeToPrevious.equals("1")) {
                    delay += previousDelayOffset;
                } else {
                    previousDelayOffset = delay;
                }
                String durationAttrib = elemEvent.getAttribute("duration");
                float duration = durationAttrib != null && durationAttrib.length() > 0 ? Float.parseFloat(elemEvent.getAttribute("duration")) : 0.0f;
                switch (EventTypeFromString.get(type)) {
                    case MoveTo: {
                        float x = Float.parseFloat(elemEvent.getAttribute("x")) * (float)FlxG.width;
                        float y = Float.parseFloat(elemEvent.getAttribute("y")) * (float)FlxG.height;
                        this.m_tweenManager.ToPosition(this.m_itemsImg.get(target), new Vector2(x, y), duration, this._getEaseType(elemEvent), delay, null);
                        break;
                    }
                    case ScaleTo: {
                        float s = Float.parseFloat(elemEvent.getAttribute("s"));
                        this.m_tweenManager.ToScale((Tweenable)this.m_itemsImg.get(target), new Vector2(s, s), duration, this._getEaseType(elemEvent), delay, (CallbackSimple)null);
                        break;
                    }
                    case AlphaTo: {
                        float a = Float.parseFloat(elemEvent.getAttribute("a"));
                        this.m_tweenManager.ToAlpha((Tweenable)this.m_itemsImg.get(target), a, duration, this._getEaseType(elemEvent), delay, this._getLoopType(elemEvent));
                        break;
                    }
                    case AngleTo: {
                        float a = Float.parseFloat(elemEvent.getAttribute("a"));
                        this.m_tweenManager.ToAngle((Tweenable)this.m_itemsImg.get(target), a, duration, this._getEaseType(elemEvent), delay, this._getLoopType(elemEvent));
                        break;
                    }
                    case ColorTo: {
                        this.m_tweenManager.ToColor(this.m_itemsImg.get(target), this._getColorAttributeVector3(elemEvent, "c"), duration, TweenManager.EaseType.EASE_INOUTSIN, delay, null);
                        break;
                    }
                    case FadeIn: {
                        this.m_tweenManager.Fade(this.m_fadeInOutItem, duration, this._getColorAttribute(elemEvent, "color"), true, delay);
                        break;
                    }
                    case FadeOut: {
                        this.m_tweenManager.Fade(this.m_fadeInOutItem, duration, this._getColorAttribute(elemEvent, "color"), false, delay);
                        break;
                    }
                    case Flash: {
                        this.m_tweenManager.Flash(duration, this._getColorAttribute(elemEvent, "color"), delay);
                        break;
                    }
                    case PlayTracks: {
                        String track1 = elemEvent.getAttribute("track1OrNil");
                        String track2 = elemEvent.getAttribute("track2OrNil");
                        this.m_tweenManager.TriggerTracks(track1.length() > 0 ? track1 : null, track2.length() > 0 ? track2 : null, duration, delay);
                        break;
                    }
                    case PlaySound: {
                        String track1 = elemEvent.getAttribute("soundId");
                        this.m_tweenManager.TriggerSound(track1, delay);
                    }
                }
                ++elemEventId;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TweenManager.EaseType _getEaseType(Element _elem) {
        String xattrib = _elem.getAttribute("ease");
        if (xattrib != null && xattrib.length() > 0) {
            return EaseTypeFromString.get(xattrib);
        }
        return TweenManager.EaseType.EASE_INOUTSIN;
    }

    protected TweenManager.LoopType _getLoopType(Element _elem) {
        String xattrib = _elem.getAttribute("loop");
        if (xattrib != null && xattrib.length() > 0) {
            if (xattrib.equals("l")) {
                return TweenManager.LoopType.Loop;
            }
            if (xattrib.equals("p")) {
                return TweenManager.LoopType.PingPong;
            }
        }
        return TweenManager.LoopType.None;
    }

    protected Vector3 _getColorAttributeVector3(Element _elem, String _attribName) {
        return this._getColorAttributeVector3(_elem.getAttribute(_attribName));
    }

    protected Vector3 _getColorAttributeVector3(String _attrib) {
        String[] color = _attrib.split(",");
        int r = Integer.parseInt(color[0]);
        int g = Integer.parseInt(color[1]);
        int b = Integer.parseInt(color[2]);
        return new Vector3((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    protected Color _getColorAttribute(Element _elem, String _attribName) {
        return this._getColorAttribute(_elem.getAttribute(_attribName));
    }

    protected Color _getColorAttribute(String _attrib) {
        String[] color = _attrib.split(",");
        int r = Integer.parseInt(color[0]);
        int g = Integer.parseInt(color[1]);
        int b = Integer.parseInt(color[2]);
        return new Color(r, g, b);
    }

    public void update() {
        if (MACRO.CINEMATIC_EDITOR) {
            if (InputManager.IsNewKeyPress(Keys.Space)) {
                this.m_bStepByStep = !this.m_bStepByStep;
            } else if (this.m_bStepByStep) {
                if (InputManager.IsNewKeyPress(Keys.Right)) {
                    this.m_bTickThisFrame = true;
                } else if (InputManager.IsKeyDown(Keys.Up)) {
                    this.m_bTickThisFrame = true;
                }
            }
        }
        if (!this.finished() && this.m_bLoaded) {
            if (!this.m_bStepByStep || this.m_bTickThisFrame) {
                this.m_bTickThisFrame = false;
                this.m_tweenManager.update();
                this.m_duration -= FlxG.elapsed;
                if (MACRO.CINEMATIC_EDITOR) {
                    this.m_elapsedTime += FlxG.elapsed;
                    this.m_time.text(String.valueOf(this.m_timeStr) + this.m_elapsedTime);
                }
            }
            if (this.m_duration < 0.0f) {
                this.m_bFinished = true;
            }
        }
    }

    protected static enum eEventType {
        MoveTo,
        ScaleTo,
        AlphaTo,
        AngleTo,
        ColorTo,
        FadeIn,
        FadeOut,
        Flash,
        PlayTracks,
        PlaySound;

    }
}

