/*
 * Decompiled with CFR 0.152.
 */
package SSS.Tween;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Tween.Tweenable;
import SSS.Util.MultipleLinesText;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class SssStageImageItem
extends FlxSprite
implements Tweenable {
    Type m_type = Type.Sprite;
    static Color ColorDefault = Color.Red();
    static Color ColorSelected = Color.Green();
    FlxSprite m_encapsulatedSprite = null;
    MultipleLinesText m_encaptulsatedText = null;
    public static boolean RenderDebugAnchor = false;

    public SssStageImageItem(String _spriteName) {
        this.m_type = Type.Sprite;
        this.m_encapsulatedSprite = new FlxSprite();
        this.m_encapsulatedSprite.UseRounding(false);
        this.m_encapsulatedSprite.loadGraphic(FlxG.Content().LoadTexture2D(_spriteName));
        this.m_encapsulatedSprite.scrollFactor = Vector2.Zero();
        this.createGraphic(20, 20, ColorDefault);
        this.scrollFactor = Vector2.Zero();
    }

    public SssStageImageItem(float _w, float _h, Color _color) {
        this.m_type = Type.Rect;
        this.m_encapsulatedSprite = new FlxSprite();
        this.m_encapsulatedSprite.UseRounding(false);
        this.m_encapsulatedSprite.createGraphic((int)_w, (int)_h, _color);
        this.m_encapsulatedSprite.scrollFactor = Vector2.Zero();
        this.createGraphic(20, 20, ColorDefault);
        this.scrollFactor = Vector2.Zero();
    }

    public SssStageImageItem(String _textValue, Color _color, float _interlineOrZero) {
        this.m_type = Type.Text;
        this.m_encaptulsatedText = new MultipleLinesText();
        this.m_encaptulsatedText.Justification(FlxText.FlxJustification.Center);
        this.m_encaptulsatedText.initAttributes(_textValue, _color, 0.0f, 0.0f, 1.0f, 1.0f, _interlineOrZero);
        this.m_encaptulsatedText.UseRounding(false);
        this.scrollFactor = Vector2.Zero();
    }

    public void updateShadowColor(Color _color, float _offset) {
        if (this.m_type == Type.Text && this.m_encaptulsatedText != null) {
            this.m_encaptulsatedText.updateShadowColor(_color, _offset);
        }
    }

    public void onMouseOver() {
        this.color(ColorSelected);
    }

    public void onMouseLeft() {
        this.color(ColorDefault);
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (this.m_type == Type.Text) {
            if (this.m_encaptulsatedText.alpha() > 0.0f) {
                this.m_encaptulsatedText.updateAttributes(this.x + this.width * 0.5f - this.m_encaptulsatedText.width * 0.5f, this.y + this.height * 0.5f - this.m_encaptulsatedText.height * 0.5f, this.scaleX(), this.angle(), this.m_encaptulsatedText.alpha());
                this.m_encaptulsatedText.render(spriteBatch);
            }
        } else if (this.m_encapsulatedSprite.alpha() > 0.0f) {
            this.m_encapsulatedSprite.x = this.x + this.width * 0.5f - this.m_encapsulatedSprite.width * 0.5f;
            this.m_encapsulatedSprite.y = this.y + this.height * 0.5f - this.m_encapsulatedSprite.height * 0.5f;
            this.m_encapsulatedSprite.angle(this.angle());
            this.m_encapsulatedSprite.scaleX(this.scaleX());
            this.m_encapsulatedSprite.scaleY(this.scaleY());
            this.m_encapsulatedSprite.render(spriteBatch);
        }
        if (RenderDebugAnchor) {
            super.render(spriteBatch);
        }
    }

    @Override
    public void TweenPosition(float _cx, float _cy) {
        this.x = _cx - this.width * 0.5f;
        this.y = _cy - this.height * 0.5f;
    }

    @Override
    public void TweenColor(float _r, float _g, float _b) {
        if (this.m_type == Type.Text) {
            this.m_encaptulsatedText.color(new Color(_r, _g, _b));
        } else {
            this.m_encapsulatedSprite.color(new Color(_r, _g, _b));
        }
    }

    @Override
    public void TweenAlpha(float _a) {
        if (this.m_type == Type.Text) {
            this.m_encaptulsatedText.setAlpha(_a);
        } else {
            this.m_encapsulatedSprite.alpha(_a);
        }
    }

    @Override
    public void TweenAngle(float _angle) {
        this.angle(_angle);
    }

    @Override
    public void TweenScale(float _scalex, float _scaley) {
        this.scaleX(_scalex);
        this.scaleY(_scaley);
    }

    @Override
    public Vector2 GetTweenPosition() {
        return new Vector2(this.x + this.width * 0.5f, this.y + this.height * 0.5f);
    }

    @Override
    public Vector2 GetTweenScale() {
        return new Vector2(this.scaleX(), this.scaleY());
    }

    @Override
    public float GetTweenAlpha() {
        if (this.m_type == Type.Text) {
            return this.m_encaptulsatedText.alpha();
        }
        return this.m_encapsulatedSprite.alpha();
    }

    @Override
    public Vector3 GetTweenColor() {
        if (this.m_type == Type.Text) {
            return new Vector3((float)this.m_encaptulsatedText.color().R / 255.0f, (float)this.m_encaptulsatedText.color().G / 255.0f, (float)this.m_encaptulsatedText.color().B / 255.0f);
        }
        return new Vector3((float)this.m_encapsulatedSprite.color().R / 255.0f, (float)this.m_encapsulatedSprite.color().G / 255.0f, (float)this.m_encapsulatedSprite.color().B / 255.0f);
    }

    static enum Type {
        Sprite,
        Rect,
        Text;

    }
}

