/*
 * Decompiled with CFR 0.152.
 */
package SSS.Tween;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Events.CallbackSimple;
import SSS.Tween.AlphaTweener;
import SSS.Tween.AngleTweener;
import SSS.Tween.ColorTweener;
import SSS.Tween.FadeTriggerTweener;
import SSS.Tween.FlashTriggerTweener;
import SSS.Tween.PositionTweener;
import SSS.Tween.ScaleTweener;
import SSS.Tween.SoundTriggerTweener;
import SSS.Tween.TracksTriggerTweener;
import SSS.Tween.Tweenable;
import SSS.Tween.Tweener;
import SSS.Tween.VolumeTweener;
import java.util.ArrayList;
import org.flixel.FlxG;

public class TweenManager {
    ArrayList<Tweener> m_activeTweeners = new ArrayList(100);
    ArrayList<Tweener> m_toRemoveTweeners = new ArrayList(100);
    float m_time = 0.0f;
    boolean m_bUpdating = false;

    public void update() {
        this.m_bUpdating = true;
        this.m_time += FlxG.elapsed;
        int i = 0;
        while (i < this.m_activeTweeners.size()) {
            this.m_activeTweeners.get(i).Update();
            ++i;
        }
        this._garbageCollect();
        this.m_bUpdating = false;
    }

    protected void _garbageCollect() {
        int i = 0;
        while (i < this.m_toRemoveTweeners.size()) {
            this.m_activeTweeners.remove(this.m_toRemoveTweeners.get(i));
            ++i;
        }
        this.m_toRemoveTweeners.clear();
    }

    public void ToPosition(Tweenable _tweenable, Vector2 end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        PositionTweener pt = new PositionTweener(this, _tweenable, _tweenable.GetTweenPosition(), end, time, easeType, _delay, _callbackFunctionOrNill);
        this.m_activeTweeners.add(pt);
    }

    public void FromToPosition(Tweenable _tweenable, Vector2 start, Vector2 end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        PositionTweener pt = new PositionTweener(this, _tweenable, start, end, time, easeType, _delay, _callbackFunctionOrNill);
        pt.SetTweenableToBegin();
        this.m_activeTweeners.add(pt);
    }

    public void ToScale(Tweenable _tweenable, Vector2 end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        ScaleTweener st = new ScaleTweener(this, _tweenable, _tweenable.GetTweenScale(), end, time, easeType, _delay, _callbackFunctionOrNill);
        this.m_activeTweeners.add(st);
    }

    public void ToScale(Tweenable _tweenable, Vector2 end, float time, EaseType easeType, float _delay, LoopType _loop) {
        ScaleTweener st = new ScaleTweener(this, _tweenable, _tweenable.GetTweenScale(), end, time, easeType, _delay, null);
        if (_loop == LoopType.PingPong) {
            st.Pingpong(true);
        } else if (_loop == LoopType.Loop) {
            st.Loop(true);
        }
        this.m_activeTweeners.add(st);
    }

    public void ToVolume(Tweenable _tweenable, float end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        VolumeTweener vt = new VolumeTweener(this, _tweenable, _tweenable.GetTweenVolume(), end, time, easeType, _delay, _callbackFunctionOrNill);
        this.m_activeTweeners.add(vt);
    }

    public void ToVolume(Tweenable _tweenable, float end, float time, EaseType easeType, float _delay, LoopType _loop) {
        VolumeTweener vt = new VolumeTweener(this, _tweenable, _tweenable.GetTweenVolume(), end, time, easeType, _delay, null);
        if (_loop == LoopType.PingPong) {
            vt.Pingpong(true);
        } else if (_loop == LoopType.Loop) {
            vt.Loop(true);
        }
        this.m_activeTweeners.add(vt);
    }

    public void ToAlpha(Tweenable _tweenable, float end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        AlphaTweener at = new AlphaTweener(this, _tweenable, _tweenable.GetTweenAlpha(), end, time, easeType, _delay, _callbackFunctionOrNill);
        this.m_activeTweeners.add(at);
    }

    public void ToAlpha(Tweenable _tweenable, float end, float time, EaseType easeType, float _delay, LoopType _loop) {
        AlphaTweener at = new AlphaTweener(this, _tweenable, _tweenable.GetTweenAlpha(), end, time, easeType, _delay, null);
        if (_loop == LoopType.PingPong) {
            at.Pingpong(true);
        } else if (_loop == LoopType.Loop) {
            at.Loop(true);
        }
        this.m_activeTweeners.add(at);
    }

    public void ToAngle(Tweenable _tweenable, float end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        AngleTweener at = new AngleTweener(this, _tweenable, _tweenable.GetTweenAlpha(), end, time, easeType, _delay, _callbackFunctionOrNill);
        this.m_activeTweeners.add(at);
    }

    public void ToAngle(Tweenable _tweenable, float end, float time, EaseType easeType, float _delay, LoopType _loop) {
        AngleTweener at = new AngleTweener(this, _tweenable, _tweenable.GetTweenAlpha(), end, time, easeType, _delay, null);
        if (_loop == LoopType.PingPong) {
            at.Pingpong(true);
        } else if (_loop == LoopType.Loop) {
            at.Loop(true);
        }
        this.m_activeTweeners.add(at);
    }

    public void ToColor(Tweenable _tweenable, Vector3 end, float time, EaseType easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        ColorTweener ct = new ColorTweener(this, _tweenable, _tweenable.GetTweenColor(), end, time, easeType, _delay, _callbackFunctionOrNill);
        this.m_activeTweeners.add(ct);
    }

    public void Fade(Tweenable _tweenable, float time, Color _color, boolean _fadeIn, float _delay) {
        FadeTriggerTweener ftt = new FadeTriggerTweener(this, _tweenable, time, _color, _fadeIn, _delay, null);
        this.m_activeTweeners.add(ftt);
        if (_delay <= 0.0f) {
            ftt.Update();
        }
    }

    public void Flash(float time, Color _color, float _delay) {
        FlashTriggerTweener ftt = new FlashTriggerTweener(this, time, _color, _delay, null);
        this.m_activeTweeners.add(ftt);
    }

    public void TriggerTracks(String _track1OrNil, String _track2OrNil, float time, float _delay) {
        TracksTriggerTweener ttt = new TracksTriggerTweener(this, _track1OrNil, _track2OrNil, time, _delay, null);
        this.m_activeTweeners.add(ttt);
    }

    public void TriggerSound(String _soundId, float _delay) {
        SoundTriggerTweener stt = new SoundTriggerTweener(this, _soundId, _delay, null);
        this.m_activeTweeners.add(stt);
    }

    public void Clear() {
        this.m_activeTweeners.clear();
        this.m_toRemoveTweeners.clear();
    }

    public void BreakLoop(float _maxTime) {
        int i = 0;
        while (i < this.m_activeTweeners.size()) {
            this.m_activeTweeners.get(i).BreakLoop(_maxTime);
            ++i;
        }
    }

    public float Ease(float t, EaseType easeType) {
        float b = 0.0f;
        float c = 1.0f;
        float d = 1.0f;
        float td = t / d;
        switch (easeType) {
            case EASE_INQUAD: {
                return c * td * td + b;
            }
            case EASE_OUTQUAD: {
                return -c * td * (t - 2.0f) + b;
            }
            case EASE_INOUTQUAD: {
                if (td / 2.0f < 1.0f) {
                    return c / 2.0f * (td * td) + b;
                }
                return -c / 2.0f * ((td -= 1.0f) * (td - 2.0f) - 1.0f) + b;
            }
            case EASE_INSIN: {
                return (float)((double)(-c) * Math.cos(t / d * 1.5708f) + (double)c + (double)b);
            }
            case EASE_OUTSIN: {
                return (float)((double)c * Math.sin(t / d * 1.5708f) + (double)b);
            }
            case EASE_INOUTSIN: {
                return (float)((double)(-c / 2.0f) * (Math.cos(3.14159f * t / d) - 1.0) + (double)b);
            }
            case EASE_INBOUNCE: {
                return c - this.Ease(1.0f - t, EaseType.EASE_OUTBOUNCE) + b;
            }
            case EASE_OUTBOUNCE: {
                t /= d;
                if (t < 0.36363637f) {
                    return c * (7.5625f * t * t) + b;
                }
                if (t < 0.72727275f) {
                    return c * (7.5625f * (t -= 0.54545456f) * t + 0.75f) + b;
                }
                if (t < 0.90909094f) {
                    return c * (7.5625f * (t -= 0.8181818f) * t + 0.9375f) + b;
                }
                return c * (7.5625f * (t -= 0.95454544f) * t + 0.984375f) + b;
            }
            case EASE_INOUTBOUNCE: {
                if (t < d / 2.0f) {
                    return this.Ease(t * 2.0f, EaseType.EASE_INBOUNCE) * 0.5f + b;
                }
                return this.Ease(t * 2.0f - d, EaseType.EASE_OUTBOUNCE) * 0.5f + c * 0.5f + b;
            }
        }
        return t;
    }

    public void Remove(Tweener _tweener) {
        this.m_toRemoveTweeners.add(_tweener);
    }

    public void RemoveTweenableLooped(Tweenable _tweenable) {
        int i = 0;
        while (i < this.m_activeTweeners.size()) {
            if (this.m_activeTweeners.get(i).Tweenable().equals(_tweenable) && this.m_activeTweeners.get(i).PingPongOrLoop()) {
                this.Remove(this.m_activeTweeners.get(i));
            }
            ++i;
        }
        if (!this.m_bUpdating) {
            this._garbageCollect();
        }
    }

    public void RemoveTweenable(Tweenable _tweenable) {
        int i = 0;
        while (i < this.m_activeTweeners.size()) {
            if (this.m_activeTweeners.get(i).Tweenable().equals(_tweenable)) {
                this.Remove(this.m_activeTweeners.get(i));
            }
            ++i;
        }
        if (!this.m_bUpdating) {
            this._garbageCollect();
        }
    }

    public static enum EaseType {
        EASE_LINEAR,
        EASE_INOUTSIN,
        EASE_INSIN,
        EASE_OUTSIN,
        EASE_INQUAD,
        EASE_OUTQUAD,
        EASE_INOUTQUAD,
        EASE_INBOUNCE,
        EASE_OUTBOUNCE,
        EASE_INOUTBOUNCE,
        EASE_MAX;

    }

    public static enum LoopType {
        None,
        PingPong,
        Loop;

    }
}

