/*
 * Decompiled with CFR 0.152.
 */
package SSS.Tween;

import SSS.Events.CallbackSimple;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import org.flixel.FlxG;

public abstract class Tweener {
    protected float m_delay = 0.0f;
    protected float m_timer;
    protected float m_time;
    protected TweenManager.EaseType m_easeType;
    protected Tweenable m_tweenable;
    protected TweenManager m_manager;
    protected boolean m_bPingpong = false;
    protected boolean m_bLoop = false;
    protected CallbackSimple m_callbackFunctionOrNill = null;

    public float Delay() {
        return this.m_delay;
    }

    public Tweenable Tweenable() {
        return this.m_tweenable;
    }

    public boolean Pingpong() {
        return this.m_bPingpong;
    }

    public void Pingpong(boolean value) {
        this.m_bPingpong = value;
    }

    public boolean Loop() {
        return this.m_bLoop;
    }

    public void Loop(boolean value) {
        this.m_bLoop = value;
    }

    public boolean PingPongOrLoop() {
        return this.Loop() || this.Pingpong();
    }

    public Tweener() {
    }

    public Tweener(TweenManager _manager, Tweenable _tweenable, float _time, TweenManager.EaseType _easeType, float _delay, CallbackSimple _callbackFunctionOrNill) {
        this.m_timer = 0.0f;
        this.m_time = _time;
        this.m_easeType = _easeType;
        this.m_tweenable = _tweenable;
        this.m_manager = _manager;
        this.m_delay = _delay;
        this.m_callbackFunctionOrNill = _callbackFunctionOrNill;
    }

    public void BreakLoop(float _maxTime) {
        if (this.m_bLoop || this.m_bPingpong) {
            this.m_bLoop = false;
            this.m_bPingpong = false;
            if (this.m_delay > _maxTime) {
                this.m_delay = _maxTime;
            }
        }
    }

    public void Update() {
        if (this.m_delay > 0.0f) {
            this.m_delay -= FlxG.elapsed;
            if (this.m_delay <= 0.0f) {
                this.SetTweenerToTweenableCurrentTween();
            }
        }
        if (this.m_delay <= 0.0f) {
            this.m_timer += FlxG.elapsed;
            if (this.m_timer > this.m_time) {
                this.m_timer = this.m_time;
            }
            float p = this.m_time > 0.0f ? this.m_timer / this.m_time : 1.0f;
            p = this.m_manager.Ease(p, this.m_easeType);
            this.SetValue(p);
            if (this.m_timer >= this.m_time) {
                if (!this.m_bLoop && !this.m_bPingpong) {
                    if (this.m_callbackFunctionOrNill != null) {
                        this.m_callbackFunctionOrNill.onCallback(this, null);
                    }
                    this.m_manager.Remove(this);
                } else {
                    this.m_timer = 0.0f;
                    if (this.m_bPingpong) {
                        this.SwitchBeginEndValues();
                    }
                }
            }
        }
    }

    public abstract void SetValue(float var1);

    public abstract void SetTweenableToBegin();

    protected abstract void SetTweenerToTweenableCurrentTween();

    protected abstract void SwitchBeginEndValues();
}

