/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.MathHelper;
import SSS.SssGroup;
import org.flixel.FlxSprite;

public class GameSettingBar {
    static int CursorWidth = 5;
    static int CursorHeight = 20;
    static int MedianBarHeight = 10;
    static Color BorderColor = Color.Black();
    static Color CursorColor = Color.DarkRed();
    SssGroup m_group;
    float m_min;
    float m_max;
    float m_value;
    FlxSprite m_medianBar;
    FlxSprite m_cursor;

    public GameSettingBar(float _min, float _max, int _width, SssGroup _layer) {
        this.m_min = _min;
        this.m_max = _max;
        this.m_value = _min;
        this.m_group = _layer;
        this.m_medianBar = new FlxSprite();
        this.m_medianBar.createGraphic(_width, MedianBarHeight, BorderColor);
        this.m_cursor = new FlxSprite();
        this.m_cursor.createGraphic(CursorWidth, CursorHeight, CursorColor);
        this.m_group.add(this.m_medianBar);
        this.m_group.add(this.m_cursor);
    }

    public void positionateAt(float centerX, float centerY) {
        this.m_medianBar.x = centerX - this.m_medianBar.width * 0.5f;
        this.m_medianBar.y = centerY - this.m_medianBar.height * 0.5f;
        this._positionnateCursor();
    }

    protected void _positionnateCursor() {
        float perc = (this.m_value - this.m_min) / (this.m_max - this.m_min);
        this.m_cursor.x = MathHelper.Lerp(this.m_medianBar.x + this.m_cursor.width * 0.5f, this.m_medianBar.x + this.m_medianBar.width - this.m_cursor.width * 0.5f, perc);
        this.m_cursor.x -= this.m_cursor.width * 0.5f;
        this.m_cursor.y = this.m_medianBar.y + this.m_medianBar.height * 0.5f - this.m_cursor.height * 0.5f;
    }

    public void setValue(float _value) {
        this.m_value = _value;
        this._positionnateCursor();
    }
}

