/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.GraphicsDeviceManager;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Managers.BTM.SaveManager;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.MusicManager;
import SSS.SssGroup;
import SSS.States.BTM.CinematicReplayState;
import SSS.States.BTM.CommunityPlaceHolder;
import SSS.States.BTM.ConfigureGamepadState;
import SSS.States.BTM.ConfigureKeyboardState;
import SSS.States.BTM.LevelSelectionState;
import SSS.States.BTM.MenuChapterSelectionState;
import SSS.States.BTM.MenuCommunityState;
import SSS.States.BTM.OnlineLevelBrowsingState;
import SSS.States.BTM.SettingsState;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.UI.GameSettingBar;
import SSS.Util.MultipleLinesText;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import precompiler.MACRO;

public class MainMenuEntry {
    String[] m_arraySubListOrNil = null;
    int m_arraySubListSelection = 0;
    static int SliderWidth = 140;
    static float SliderOffsetX = 210.0f;
    static float SliderOffsetY = 20.0f;
    static float SliderSpeed = 0.2f;
    static float ScreenScaleMin = 0.7f;
    static float ScreenScaleMax = 1.5f;
    static float BrightnessMin = 0.0f;
    static float BrightnessMax = 2.0f;
    static float ContrastMin = 0.0f;
    static float ContrastMax = 2.0f;
    static float SaturationMin = 0.0f;
    static float SaturationMax = 2.0f;
    static float TimeAlphaGlowInOut = 0.2f;
    static float AlphaGlowMin = 0.0f;
    static float AlphaGlowMedium = 0.25f;
    static float AlphaGlowMax = 0.8f;
    static float ScaleTextBar = 3.0f;
    static float ScaleTextChapter = 3.0f;
    static float TextOffsetX = 10.0f;
    static float TextOffsetY = -5.0f;
    static float TextChapterOffsetX = 10.0f;
    static float TextChapterOffsetY = -125.0f;
    static Color TextColor = Color.Black();
    int m_numSuccessiveValidation = 0;
    boolean m_bWrappedValueChanged = false;
    eType m_type;
    SssGroup m_layer;
    TweenManager m_tweenManager;
    float m_margin = 150.0f;
    String m_argumentsOrNil = null;
    FlxSprite m_bar;
    FlxSprite m_barGlow;
    FlxText m_text;
    FlxSprite m_icon;
    GameSettingBar m_slider = null;
    String m_mainText = null;
    String m_altTextIdOrNil = null;
    MultipleLinesText m_additionalText = null;
    float m_scaleHitBoxX = 1.0f;
    float m_scaleHitBoxY = 1.0f;
    boolean m_bSelected = false;
    int m_id = 0;
    boolean m_bVisible = true;
    FlxFadeListener m_onLaunchCredits = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            MainMenuEntry.this._onLaunchCredits(_sender, _e);
        }
    };

    public boolean WrappedValueChanged() {
        return this.m_bWrappedValueChanged;
    }

    public eType Type() {
        return this.m_type;
    }

    public void AlternativeTextId(String value) {
        this.m_altTextIdOrNil = value;
    }

    public MainMenuEntry(int _id, SssGroup _layer, TweenManager _tweenMgr, eType _type, String _mainTextIdOrNil, String _argumentsOrNil, String _animBarOrNil, float _scaleFactor) {
        this._constructor(_id, _layer, _tweenMgr, _type, _mainTextIdOrNil, _argumentsOrNil, _animBarOrNil, _scaleFactor);
    }

    public MainMenuEntry(int _id, SssGroup _layer, TweenManager _tweenMgr, eType _type, String _mainTextIdOrNil, String _argumentsOrNil, String _animBarOrNil) {
        this._constructor(_id, _layer, _tweenMgr, _type, _mainTextIdOrNil, _argumentsOrNil, _animBarOrNil, 1.0f);
    }

    protected void _constructor(int _id, SssGroup _layer, TweenManager _tweenMgr, eType _type, String _mainTextIdOrNil, String _argumentsOrNil, String _animBarOrNil, float _scaleFactor) {
        this.m_id = _id;
        this.m_tweenManager = _tweenMgr;
        this.m_argumentsOrNil = _argumentsOrNil;
        this.m_type = _type;
        this.m_layer = _layer;
        if (_type == eType.GameMode || _type == eType.GameModeOnlineLevel || _type == eType.GameModeLocalLevel) {
            this.m_barGlow = ResourcesLibrary.Instance().InstanciateSprite("menu_chapter");
            this.m_barGlow.play("big_glow");
            this.m_barGlow.alpha(0.0f);
            if (_type == eType.GameModeOnlineLevel) {
                this.m_bar = new FlxSprite();
                this.m_bar.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_chapter2"), true);
                this.m_bar.addAnimation("0", new int[1]);
                this.m_bar.play("0");
            } else if (_type == eType.GameModeLocalLevel) {
                this.m_bar = new FlxSprite();
                this.m_bar.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_chapter2"), true);
                this.m_bar.addAnimation("0", new int[]{1});
                this.m_bar.play("0");
            } else {
                this.m_bar = ResourcesLibrary.Instance().InstanciateSprite("menu_chapter");
            }
            this.m_scaleHitBoxX = 0.8f;
            if (_animBarOrNil != null) {
                this.m_bar.play(_animBarOrNil);
            } else {
                this.m_bar.play("big");
            }
            this.m_text = new FlxText(0.0f, 0.0f, 200.0f);
            this.m_text.scale(ScaleTextChapter * _scaleFactor);
        } else if (_type == eType.CommunityTab) {
            this.m_bar = new FlxSprite();
            this.m_bar.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_barres2"), true, false, 512, 128);
            this.m_bar.addAnimation("0", new int[]{2});
            this.m_bar.play("0");
            this.m_barGlow = new FlxSprite();
            this.m_barGlow.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_barres2"), true, false, 512, 128);
            this.m_barGlow.addAnimation("1", new int[]{3});
            this.m_barGlow.play("1");
            this.m_barGlow.alpha(0.0f);
            this.m_text = new FlxText(0.0f, 0.0f, 200.0f);
            this.m_text.scale(ScaleTextChapter * _scaleFactor);
            this.m_scaleHitBoxX = 0.3f;
            this.m_scaleHitBoxY = 0.9f;
        } else if (_type == eType.GameFeatures) {
            this.m_bar = new FlxSprite();
            this.m_bar.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/blocks64MAP"), true, false, 100, 100);
            this.m_bar.addAnimation("0", new int[]{41});
            this.m_bar.play("0");
            this.m_barGlow = new FlxSprite();
            this.m_barGlow.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_gow_1bloc"), true, false, 256, 128);
            this.m_barGlow.addAnimation("1", new int[1]);
            this.m_barGlow.play("1");
            this.m_barGlow.alpha(0.0f);
            this.m_text = new FlxText(0.0f, 0.0f, 200.0f);
            this.m_text.scale(ScaleTextChapter * _scaleFactor);
            this.m_scaleHitBoxX = 0.3f;
            this.m_scaleHitBoxY = 0.9f;
            this.m_margin = -35.0f;
            this.m_scaleHitBoxX = 1.0f;
            this.m_scaleHitBoxY = 1.0f;
            this.m_additionalText = new MultipleLinesText();
            this.m_additionalText.initAttributes("Humble Bundle[r]Update", Color.White(), 0.0f, 0.0f, 2.0f, 0.0f, 1.0f);
        } else {
            this.m_barGlow = ResourcesLibrary.Instance().InstanciateSprite("menubar");
            this.m_barGlow.play("small_glow");
            this.m_barGlow.alpha(0.0f);
            this.m_bar = ResourcesLibrary.Instance().InstanciateSprite("menubar");
            this.m_bar.play("small");
            this.m_text = new FlxText(0.0f, 0.0f, FlxG.width);
            this.m_text.scale(ScaleTextBar * _scaleFactor);
            this.m_scaleHitBoxX = 0.6f;
            this.m_scaleHitBoxY = 0.7f;
        }
        this.m_text.color(TextColor);
        this.m_text.UseShadow(false);
        _layer.add(this.m_barGlow);
        _layer.add(this.m_bar);
        _layer.add(this.m_text);
        if (this.m_additionalText != null) {
            _layer.add(this.m_additionalText);
        }
        if (_mainTextIdOrNil != null) {
            this.setText(TextDataBase.Instance().getText(_mainTextIdOrNil));
        }
        block0 : switch (_type) {
            case Volume: {
                this.m_slider = new GameSettingBar(MusicManager.Instance().GeneralVolumeMin(), MusicManager.Instance().GeneralVolumeMax(), SliderWidth, _layer);
                break;
            }
            case ScreenSize: {
                this.m_slider = new GameSettingBar(ScreenScaleMin, ScreenScaleMax, SliderWidth, _layer);
                break;
            }
            case Brightness: {
                this.m_slider = new GameSettingBar(BrightnessMin, BrightnessMax, SliderWidth, _layer);
                break;
            }
            case Constrast: {
                this.m_slider = new GameSettingBar(ContrastMin, ContrastMax, SliderWidth, _layer);
                break;
            }
            case Saturation: {
                this.m_slider = new GameSettingBar(SaturationMin, SaturationMax, SliderWidth, _layer);
                break;
            }
            case Language: {
                this.m_arraySubListOrNil = new String[2];
                this.m_arraySubListOrNil[0] = "en";
                this.m_arraySubListOrNil[1] = "fr";
                String languageId = TextDataBase.Instance().LangageId();
                this.m_arraySubListSelection = 0;
                int i = 0;
                while (i < this.m_arraySubListOrNil.length) {
                    if (languageId.equals(this.m_arraySubListOrNil[i])) {
                        this.m_arraySubListSelection = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case ScreenResolution: {
                this.m_arraySubListSelection = this._determineResolutionId();
                this.m_arraySubListOrNil = new String[6];
                this.m_arraySubListOrNil[0] = "native (full)";
                this.m_arraySubListOrNil[1] = "native stretched (full)";
                this.m_arraySubListOrNil[2] = "pixperfect (full)";
                this.m_arraySubListOrNil[3] = "pixperfect (win)";
                this.m_arraySubListOrNil[4] = "80 % (full)";
                this.m_arraySubListOrNil[5] = "80 % (win)";
            }
        }
        if (this.m_slider != null) {
            this._leftRightDown(true, 0.0f, true, true);
        }
    }

    protected int _determineResolutionId() {
        GraphicsDeviceManager gdm = FlxG.Game.getGraphicDeviceManager();
        boolean fullscreen = gdm.IsFullScreen();
        int width = gdm.PreferredBackBufferWidth();
        int height = gdm.PreferredBackBufferHeight();
        if (fullscreen) {
            if (FlxG.RenderingStreched()) {
                return 1;
            }
            if (width == 1280 && height == 720) {
                return 2;
            }
            if (width > 1280 && height > 720) {
                return 0;
            }
            return 4;
        }
        if (width == 1280 && height == 720) {
            return 3;
        }
        return 5;
    }

    public void setText(String _text) {
        this.m_mainText = _text;
        this.m_text.text(_text);
        this._customizeTextDependingType();
    }

    public void setTextColor(Color _color) {
        this.m_text.color(_color);
    }

    protected void _customizeTextDependingType() {
        if (this.m_type == eType.EraseData && this.m_text.text() != null) {
            if (SaveManager.Instance().isStorageModeExists()) {
                if (SaveManager.Instance().isStorageModeLookLikeHDD()) {
                    this.m_text.text().concat(" (HDD)");
                } else {
                    this.m_text.text().concat(" (MU)");
                }
            } else {
                this.m_text.text(TextDataBase.Instance().getText("TXT_NO_STORAGE_MODE"));
            }
        } else if (this.m_type == eType.Language) {
            this.m_text.text(String.valueOf(this.m_mainText) + " " + this.m_arraySubListOrNil[this.m_arraySubListSelection]);
        } else if (this.m_type == eType.ScreenResolution) {
            this.m_text.text(String.valueOf(this.m_mainText) + " " + this.m_arraySubListOrNil[this.m_arraySubListSelection]);
        }
    }

    public void select() {
        if (!this.m_bSelected) {
            this.m_bSelected = true;
            this.m_tweenManager.ToAlpha((Tweenable)this.m_barGlow, AlphaGlowMax, TimeAlphaGlowInOut, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_barGlow, AlphaGlowMedium, TimeAlphaGlowInOut * 2.0f, TweenManager.EaseType.EASE_INOUTSIN, TimeAlphaGlowInOut, TweenManager.LoopType.PingPong);
            this.m_bar.scale(0.98f);
            this.m_tweenManager.ToScale((Tweenable)this.m_bar, Vector2.One(), 0.25f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            if (this.m_type == eType.GameMode) {
                this.m_barGlow.scale(0.98f);
                this.m_tweenManager.ToScale((Tweenable)this.m_barGlow, Vector2.One(), 0.25f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            } else {
                this.m_barGlow.scale(0.98f);
                this.m_tweenManager.ToScale((Tweenable)this.m_barGlow, Vector2.One(), 0.25f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            }
            if (this.m_additionalText != null) {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_additionalText, 1.0f, TimeAlphaGlowInOut, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
        }
    }

    public void unselect() {
        if (this.m_bSelected) {
            if (this.m_altTextIdOrNil == null || this.m_numSuccessiveValidation <= 1) {
                if (this.m_altTextIdOrNil != null && this.m_mainText != null) {
                    this.m_text.text(this.m_mainText);
                    this._customizeTextDependingType();
                }
                this.m_numSuccessiveValidation = 0;
            }
            this.m_bSelected = false;
            this.m_tweenManager.RemoveTweenableLooped(this.m_barGlow);
            this.m_tweenManager.ToAlpha((Tweenable)this.m_barGlow, AlphaGlowMin, TimeAlphaGlowInOut, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            if (this.m_additionalText != null) {
                this.m_tweenManager.ToAlpha((Tweenable)this.m_additionalText, 0.0f, TimeAlphaGlowInOut, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            }
        }
    }

    public void leftDown(float factorSpeed) {
        this._leftRightDown(false, FlxG.elapsed * factorSpeed, false, false);
    }

    public void leftJustDown() {
        this._leftRightDown(false, FlxG.elapsed, false, true);
    }

    public void rightDown(float factorSpeed) {
        this._leftRightDown(true, FlxG.elapsed * factorSpeed, false, false);
    }

    public void rightJustDown() {
        this._leftRightDown(true, FlxG.elapsed, false, true);
    }

    protected void _leftRightDown(boolean _bRight, float _deltaTime, boolean _bForce, boolean _bJustDown) {
        if (this.m_bSelected || _bForce) {
            float value = 0.0f;
            switch (this.m_type) {
                case ScreenSize: {
                    value = _deltaTime * SliderSpeed * (ScreenScaleMax - ScreenScaleMin) * (_bRight ? 1.0f : -1.0f);
                    FlxG.RenderingScale(FlxG.RenderingScale() + value);
                    this.m_bWrappedValueChanged = true;
                    FlxG.RenderingScale(MathHelper.Clamp(FlxG.RenderingScale(), ScreenScaleMin, ScreenScaleMax));
                    value = FlxG.RenderingScale();
                    break;
                }
                case Volume: {
                    value = _deltaTime * SliderSpeed * (MusicManager.Instance().GeneralVolumeMax() - MusicManager.Instance().GeneralVolumeMin()) * (_bRight ? 1.0f : -1.0f);
                    MusicManager.Instance().increaseGeneralVolumeAutoClamped(value);
                    this.m_bWrappedValueChanged = true;
                    value = MusicManager.Instance().GeneralVolume();
                    break;
                }
                case Brightness: {
                    value = _deltaTime * SliderSpeed * (BrightnessMax - BrightnessMin) * (_bRight ? 1.0f : -1.0f);
                    FlxG.RenderingBrightness(FlxG.RenderingBrightness() + value);
                    this.m_bWrappedValueChanged = true;
                    FlxG.RenderingBrightness(MathHelper.Clamp(FlxG.RenderingBrightness(), BrightnessMin, BrightnessMax));
                    value = FlxG.RenderingBrightness();
                    break;
                }
                case Constrast: {
                    value = _deltaTime * SliderSpeed * (ContrastMax - ContrastMin) * (_bRight ? 1.0f : -1.0f);
                    FlxG.RenderingContrast(FlxG.RenderingContrast() + value);
                    this.m_bWrappedValueChanged = true;
                    FlxG.RenderingContrast(MathHelper.Clamp(FlxG.RenderingContrast(), ContrastMin, ContrastMax));
                    value = FlxG.RenderingContrast();
                    break;
                }
                case Saturation: {
                    value = _deltaTime * SliderSpeed * (SaturationMax - SaturationMin) * (_bRight ? 1.0f : -1.0f);
                    FlxG.RenderingSaturation(FlxG.RenderingSaturation() + value);
                    this.m_bWrappedValueChanged = true;
                    FlxG.RenderingSaturation(MathHelper.Clamp(FlxG.RenderingSaturation(), SaturationMin, SaturationMax));
                    value = FlxG.RenderingSaturation();
                    break;
                }
                case ScreenResolution: 
                case Language: {
                    if (!_bJustDown) break;
                    if (_bRight) {
                        this.m_arraySubListSelection = (this.m_arraySubListSelection + 1) % this.m_arraySubListOrNil.length;
                    } else {
                        --this.m_arraySubListSelection;
                        if (this.m_arraySubListSelection < 0) {
                            this.m_arraySubListSelection = this.m_arraySubListOrNil.length - 1;
                        }
                    }
                    this.m_text.text(String.valueOf(this.m_mainText) + " " + this.m_arraySubListOrNil[this.m_arraySubListSelection]);
                }
            }
            if (this.m_slider != null) {
                this.m_slider.setValue(value);
            }
        }
    }

    public void changeBarColor(Color _color) {
        this.m_bar.color(_color);
    }

    public void confirm() {
        if (this.m_bSelected) {
            ++this.m_numSuccessiveValidation;
            block0 : switch (this.m_type) {
                case GameFeatures: {
                    FlxG.state(new LevelSelectionState(false, "Chocolate", null));
                    break;
                }
                case PlayTheGame: {
                    FlxG.state(new MenuChapterSelectionState());
                    break;
                }
                case Community: {
                    GameVars.BackUpPlayerProperties();
                    if (MACRO.ACTIVATE_COMMUNITY) {
                        FlxG.state(new MenuCommunityState());
                        break;
                    }
                    FlxG.state(new CommunityPlaceHolder());
                    break;
                }
                case Options: {
                    FlxG.state(new SettingsState());
                    break;
                }
                case Credits: {
                    FlxG.fade.start(Color.Black(), 0.5f, this.m_onLaunchCredits, true, true);
                    break;
                }
                case GameMode: {
                    FlxG.state(new LevelSelectionState(false, this.m_argumentsOrNil, null));
                    break;
                }
                case GameModeOnlineLevel: {
                    FlxG.state(new OnlineLevelBrowsingState(true, false));
                    break;
                }
                case GameModeLocalLevel: {
                    FlxG.state(new OnlineLevelBrowsingState(false, false));
                    break;
                }
                case ScreenSize: {
                    FlxG.RenderingScale(FlxG.DefaultArrayScreenCorrections[0]);
                    break;
                }
                case Saturation: {
                    FlxG.RenderingSaturation(FlxG.DefaultArrayScreenCorrections[1]);
                    break;
                }
                case Constrast: {
                    FlxG.RenderingContrast(FlxG.DefaultArrayScreenCorrections[2]);
                    break;
                }
                case Brightness: {
                    FlxG.RenderingBrightness(FlxG.DefaultArrayScreenCorrections[3]);
                    break;
                }
                case Volume: {
                    MusicManager.Instance().defaultVolume();
                    break;
                }
                case GamepadConfig: {
                    if (this.m_numSuccessiveValidation != 1) break;
                    FlxG.state(new ConfigureGamepadState());
                    break;
                }
                case KeyboardConfig: {
                    if (this.m_numSuccessiveValidation != 1) break;
                    FlxG.state(new ConfigureKeyboardState());
                    break;
                }
                case EraseData: {
                    if (this.m_numSuccessiveValidation == 1) {
                        if (this.m_altTextIdOrNil == null) break;
                        if (SaveManager.Instance().isStorageModeExists()) {
                            this.m_text.text(TextDataBase.Instance().getText("TXT_CONFIRM"));
                            break;
                        }
                        this.m_text.text(TextDataBase.Instance().getText("TXT_NO_STORAGE_MODE"));
                        break;
                    }
                    if (this.m_numSuccessiveValidation != 2) break;
                    if (SaveManager.Instance().isStorageModeExists()) {
                        FlxG.flash.start(Color.Red().clone(), 0.2f, null, true);
                        SaveManager.Instance().resetGameData();
                        if (this.m_altTextIdOrNil == null) break;
                        this.m_text.text(TextDataBase.Instance().getText(this.m_altTextIdOrNil));
                        break;
                    }
                    this.m_text.text(TextDataBase.Instance().getText("TXT_NO_STORAGE_MODE"));
                    break;
                }
                case Language: {
                    if (!TextDataBase.Instance().ChangeLangageId(this.m_arraySubListOrNil[this.m_arraySubListSelection])) break;
                    FlxG.state(new SettingsState(this.m_id));
                    break;
                }
                case ScreenResolution: {
                    FlxG.RenderingStreched(false);
                    boolean vsync = FlxG.Game.getGraphicDeviceManager().SynchronizeWithVerticalRetrace();
                    switch (this.m_arraySubListSelection) {
                        case 0: {
                            FlxG.ChangeResolution(true, 2048, 2048, vsync);
                            break block0;
                        }
                        case 1: {
                            FlxG.RenderingStreched(true);
                            FlxG.ChangeResolution(true, 2048, 2048, vsync);
                            break block0;
                        }
                        case 2: {
                            FlxG.ChangeResolution(true, 1280, 720, vsync);
                            break block0;
                        }
                        case 3: {
                            FlxG.ChangeResolution(false, 1280, 720, vsync);
                            break block0;
                        }
                        case 4: {
                            FlxG.ChangeResolution(true, 1024, 576, vsync);
                            break block0;
                        }
                        case 5: {
                            FlxG.ChangeResolution(false, 1024, 576, vsync);
                        }
                    }
                }
            }
            this.updateSlider();
        }
    }

    public void updateSlider() {
        if (this.m_slider != null) {
            this._leftRightDown(true, 0.0f, true, false);
        }
    }

    protected void _onLaunchCredits(Object _sender, Object _e) {
        FlxG.state(new CinematicReplayState("CREDITS", null, CinematicReplayState.eSpecialFlag.ReturnToMainMenuOnFinish, "Specials"));
    }

    public void bounce() {
    }

    public void positionateAt(float _centerX, float _centerY) {
        this.m_bar.x = _centerX - this.m_bar.width * 0.5f;
        this.m_bar.y = _centerY - this.m_bar.height * 0.5f;
        this.m_barGlow.x = _centerX - this.m_barGlow.width * 0.5f;
        this.m_barGlow.y = _centerY - this.m_barGlow.height * 0.5f;
        if (this.m_type == eType.GameMode) {
            this.m_text.x = this.m_bar.x + this.m_bar.width * 0.5f - this.m_text.width * 0.5f + TextChapterOffsetX;
            this.m_text.y = this.m_bar.y + this.m_bar.height - this.m_text.height + TextChapterOffsetY;
        } else {
            this.m_text.x = this.m_bar.x + this.m_bar.width * 0.5f - this.m_text.width * 0.5f + TextOffsetX;
            this.m_text.y = this.m_bar.y + this.m_bar.height * 0.5f - this.m_text.height * 0.5f + TextOffsetY;
        }
        if (this.m_additionalText != null) {
            this.m_additionalText.changePosition(_centerX, _centerY - this.m_bar.height * 1.2f);
        }
        if (this.m_slider != null) {
            this.m_slider.positionateAt(_centerX + SliderOffsetX, _centerY + SliderOffsetY);
        }
    }

    public float getRightX() {
        return this.m_bar.x + this.m_bar.width - this.m_margin;
    }

    public float getLeftX() {
        return this.m_bar.x + this.m_margin;
    }

    public float getCursorScaleX() {
        if (this.m_type == eType.EraseData || this.m_type == eType.GamepadConfig || this.m_type == eType.KeyboardConfig) {
            return -1.0f;
        }
        return 1.0f;
    }

    public float getCenterY() {
        return this.m_bar.y + this.m_bar.height * 0.5f;
    }

    public void update() {
    }

    public boolean isUnderMouse(float mousex, float mousey) {
        if (!this.m_bVisible) {
            return false;
        }
        return this.m_bar.overlapsPointWithScale(mousex, mousey, this.m_scaleHitBoxX, this.m_scaleHitBoxY);
    }

    public boolean visible() {
        return this.m_bVisible;
    }

    public void visible(boolean _bValue) {
        if (_bValue != this.m_bVisible) {
            this.m_bVisible = _bValue;
            this.m_bar.visible = _bValue;
            if (this.m_barGlow != null) {
                this.m_barGlow.visible = _bValue;
            }
            if (this.m_text != null) {
                this.m_text.visible = _bValue;
            }
        }
    }

    public static enum eType {
        PlayTheGame,
        Community,
        Options,
        Credits,
        GameMode,
        GameModeDesc,
        Volume,
        Constrast,
        Brightness,
        Saturation,
        EraseData,
        GamepadConfig,
        KeyboardConfig,
        ScreenResolution,
        ScreenSize,
        Language,
        GameModeOnlineLevel,
        GameModeLocalLevel,
        LocalLevelEntry,
        OnlineLevelEntry,
        CommunityTab,
        GameFeatures;

    }
}

