/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Vector2;
import SSS.Events.CallbackSimple;
import SSS.Util.Debug;
import java.util.ArrayList;
import org.flixel.FlxButton;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxObject;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

class Menu {
    int m_confirmationEraseCount = 0;
    FlxText m_confirmText = null;
    ArrayList<FlxButton> m_entries = new ArrayList();
    int m_currentEntryIndex = -1;
    FlxButton m_currentEntryBtn = null;
    FlxGroup m_layer = new FlxGroup();
    boolean m_bVisible = false;

    public FlxButton CurrentEntry() {
        return this.m_currentEntryBtn;
    }

    public FlxGroup Layer() {
        return this.m_layer;
    }

    public boolean Visible() {
        return this.m_bVisible;
    }

    public void Visible(boolean value) {
        this.m_bVisible = value;
        this._showHide();
    }

    public Menu() {
        this.m_layer.scrollFactor = Vector2.Zero();
    }

    protected void _destroyButtons() {
        for (FlxButton b : this.m_entries) {
            this.Layer().remove(b);
            b.kill();
        }
        this.m_entries.clear();
    }

    protected void _addEntry(boolean _default, String _text, float _y, CallbackSimple _callback) {
        FlxSprite rect = new FlxSprite();
        rect.loadGraphic(null, false, false, 200, 20);
        rect.color(Color.Red());
        rect.scrollFactor = Vector2.Zero();
        FlxSprite rect2 = new FlxSprite();
        rect2.loadGraphic(null, false, false, 200, 20);
        rect2.color(Color.White());
        rect2.scrollFactor = Vector2.Zero();
        FlxText txt = new FlxText(0.0f, 0.0f, 50.0f, _text);
        txt.color(Color.Black());
        txt.alignment = FlxText.FlxJustification.Center;
        txt.scrollFactor = Vector2.Zero();
        txt.x = rect.width * 0.5f;
        FlxButton btn = new FlxButton(0, 0, _callback, true);
        btn.scrollFactor = Vector2.Zero();
        btn.loadGraphic(rect, rect2);
        btn.loadText(txt, txt);
        btn.x = (float)FlxG.width * 0.5f - rect.width * 0.5f;
        btn.y = _y;
        this.m_layer.add(btn);
        if (_default) {
            if (this.m_currentEntryBtn != null) {
                this.m_currentEntryBtn.onSimulateMouseLeft();
            }
            this.m_currentEntryIndex = this.m_entries.size();
            this.m_currentEntryBtn = btn;
            this.m_currentEntryBtn.onSimulateMouseOver();
        }
        this.m_entries.add(btn);
    }

    protected void _hideEntries() {
        for (FlxButton btn : this.m_entries) {
            btn.visible = false;
        }
    }

    protected void _updateButtonEntry(int _shift) {
        this.m_currentEntryIndex += _shift;
        if (this.m_currentEntryIndex < 0) {
            this.m_currentEntryIndex = this.m_entries.size() - 1;
        } else if (this.m_currentEntryIndex >= this.m_entries.size()) {
            this.m_currentEntryIndex = 0;
        }
        if (this.m_currentEntryBtn != null) {
            this.m_currentEntryBtn.onSimulateMouseLeft();
        }
        this.m_currentEntryBtn = this.m_entries.get(this.m_currentEntryIndex);
        this.m_currentEntryBtn.onSimulateMouseOver();
        if (_shift != 0) {
            this.m_confirmationEraseCount = 0;
            if (this.m_confirmText != null) {
                this.m_confirmText.visible = false;
            }
        }
    }

    protected void _showHide() {
        if (this.m_layer.visible != this.m_bVisible) {
            for (FlxObject flxObject : this.m_entries) {
                if (flxObject == null) continue;
                flxObject.visible = this.m_bVisible;
            }
        }
        this.m_layer.visible = this.m_bVisible;
        if (this.m_bVisible) {
            this.m_currentEntryBtn.active = true;
        }
        this.m_confirmationEraseCount = 0;
        if (this.m_confirmText != null) {
            this.m_confirmText.visible = false;
        }
    }

    protected void _shftButtons(float _shiftY) {
        for (FlxButton btn : this.m_entries) {
            btn.shift(0.0f, _shiftY);
            btn.update();
        }
    }

    protected void _makeButtonSelected(FlxButton _btn) {
        if (this.m_currentEntryBtn != null) {
            this.m_currentEntryBtn.onSimulateMouseLeft();
        }
        this.m_currentEntryIndex = 0;
        for (FlxButton b : this.m_entries) {
            if (b.equals(_btn)) break;
            ++this.m_currentEntryIndex;
        }
        Debug.Assert(this.m_currentEntryIndex < this.m_entries.size());
        this.m_currentEntryBtn = _btn;
        this.m_currentEntryBtn.onSimulateMouseOver();
    }

    protected void _selectFirstEntryByLetter(String _letter) {
        if (this.m_entries.size() > 0) {
            int nextId = -1;
            int i = 0;
            while (nextId < 0 && i < this.m_entries.size()) {
                if (this.m_entries.get(i).OnTextValue().regionMatches(true, 0, _letter, 0, 1)) {
                    nextId = i;
                }
                ++i;
            }
            if (nextId > 0 && this.m_currentEntryIndex != nextId) {
                this._makeButtonSelected(this.m_entries.get(nextId));
                this._makeButtonVisible(this.m_entries.get(nextId));
            }
        }
    }

    protected void _selectNearEntry(boolean _bDown) {
        if (this.m_entries.size() > 0) {
            int shift = _bDown ? 1 : -1;
            int nextId = this.m_currentEntryIndex + shift;
            if (nextId < 0) {
                nextId = this.m_entries.size() - 1;
            } else if (nextId >= this.m_entries.size()) {
                nextId = 0;
            }
            if (nextId >= 0) {
                this._makeButtonSelected(this.m_entries.get(nextId));
                this._makeButtonVisible(this.m_entries.get(nextId));
            }
        }
    }

    protected void _makeButtonVisible(FlxButton _btn) {
        if (_btn.y < 0.0f) {
            this._shftButtons(30.0f);
            this._makeButtonVisible(_btn);
        } else if (_btn.y + _btn.height >= (float)FlxG.height) {
            this._shftButtons(-30.0f);
            this._makeButtonVisible(_btn);
        }
    }
}

