/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.Behaviour;
import SSS.BehaviourParameter;
import SSS.UI.EditParamComparator;
import SSS.Util.InputManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class MenuActorParamEdit {
    boolean m_bVisible = false;
    FlxGroup m_layer;
    Actor m_tweakingActor = null;
    FlxSprite m_background = null;
    FlxText m_title = null;
    FlxText m_progression = null;
    FlxText m_paramId = null;
    FlxText m_paramValue = null;
    FlxText m_paramDesc = null;
    int m_behaviourCount = 0;
    ArrayList<EditParam> m_listBehaviourParams = new ArrayList();
    int m_behaviourParamId = 0;
    boolean m_bEraseValue = true;
    ref<Integer> HelperOutValue = new ref<Integer>(0);

    public boolean Visible() {
        return this.m_bVisible;
    }

    public MenuActorParamEdit(FlxGroup _layer) {
        this.m_layer = _layer;
        this._buildMenu();
        this._showHide(false);
    }

    protected void _buildMenu() {
        this.m_background = new FlxSprite();
        this.m_background.createGraphic(FlxG.width, FlxG.height, Color.Black());
        this.m_background.scrollFactor = Vector2.Zero();
        this.m_background.alpha(0.6f);
        float y = (float)FlxG.height * 0.5f;
        this.m_title = new FlxText(0.0f, y, FlxG.width);
        this.m_title.scrollFactor = Vector2.Zero();
        this.m_title.text("Title");
        this.m_progression = new FlxText(0.0f, y += 20.0f, FlxG.width);
        this.m_progression.scrollFactor = Vector2.Zero();
        this.m_progression.text("Progression");
        this.m_paramId = new FlxText(0.0f, y += 20.0f, FlxG.width);
        this.m_paramId.scrollFactor = Vector2.Zero();
        this.m_paramId.text("ParamId");
        this.m_paramValue = new FlxText(0.0f, y += 20.0f, FlxG.width);
        this.m_paramValue.scrollFactor = Vector2.Zero();
        this.m_paramValue.text("ParamValue");
        this.m_paramDesc = new FlxText(0.0f, y += 20.0f, FlxG.width);
        this.m_paramDesc.scrollFactor = Vector2.Zero();
        this.m_paramDesc.text("ParamDesc");
        this.m_layer.add(this.m_background);
        this.m_layer.add(this.m_progression);
        this.m_layer.add(this.m_paramId);
        this.m_layer.add(this.m_paramValue);
        this.m_layer.add(this.m_paramDesc);
    }

    protected void _showHide(boolean _bVisible) {
        this.m_bVisible = _bVisible;
        this.m_background.visible = _bVisible;
        this.m_progression.visible = _bVisible;
        this.m_paramId.visible = _bVisible;
        this.m_paramValue.visible = _bVisible;
        this.m_paramDesc.visible = _bVisible;
    }

    public void tweakActor(Actor _actor) {
        this.m_tweakingActor = _actor;
        this.m_bEraseValue = true;
        if (this.m_tweakingActor.HasBehavioursParams()) {
            this.m_behaviourCount = _actor.Behaviours().size();
            this._initBehaviourParamList();
            this._updateTexts();
            this._showHide(true);
        } else {
            FlxG.flash.start(Color.Red());
            this._showHide(false);
        }
    }

    protected void _updateTexts() {
        int behaviourID = this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_index;
        String paramCounter = " (param " + (this.m_behaviourParamId + 1) + "/" + this.m_listBehaviourParams.size() + ")";
        this.m_title.text("Edit params for " + this.m_tweakingActor.FriendlyName());
        this.m_progression.text("Behaviour " + this.m_tweakingActor.Behaviours().get(behaviourID).Id() + " (behaviour " + (behaviourID + 1) + "/" + this.m_behaviourCount + ")" + paramCounter);
        if (this.m_behaviourParamId < this.m_listBehaviourParams.size()) {
            this.m_paramId.text("<" + this._getTypeStringDependingTypeId(this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_type) + "> " + this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_name);
            this.m_paramValue.text(this._getParamValueDependingTypeId(behaviourID, this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_type, this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_name));
            this.m_paramDesc.text("Desc: " + this._getParamDescription(behaviourID, this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_name));
        }
    }

    protected void _validateCurrentParams() {
        this._setParamValueDependingTypeId(this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_index, this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_type, this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_name, this.m_paramValue.text());
    }

    protected String _getParamDescription(int _behaviourID, String _paramId) {
        return this.m_tweakingActor.Behaviours().get(_behaviourID).getParameterDescription(_paramId);
    }

    protected String _getParamValueDependingTypeId(int _behaviourIndex, int _typeId, String _paramId) {
        if (_typeId == 0) {
            return Integer.toString(this.m_tweakingActor.Behaviours().get(_behaviourIndex).getIntParameter(_paramId));
        }
        if (_typeId == 1) {
            return Float.toString(this.m_tweakingActor.Behaviours().get(_behaviourIndex).getFloatParameter(_paramId));
        }
        if (_typeId == 2) {
            return this.m_tweakingActor.Behaviours().get(_behaviourIndex).getStringParameter(_paramId);
        }
        return "error";
    }

    protected void _setParamValueDependingTypeId(int _behaviourId, int _typeId, String _paramId, String _paramValue) {
        int newValue;
        int oldValue;
        if (_typeId == 0 && (oldValue = this.m_tweakingActor.Behaviours().get(_behaviourId).getIntParameter(_paramId)) != (newValue = Integer.parseInt(_paramValue))) {
            this.m_tweakingActor.Behaviours().get(_behaviourId).setIntParameter(_paramId, newValue);
        }
        if (_typeId == 1 && (oldValue = this.m_tweakingActor.Behaviours().get(_behaviourId).getFloatParameter(_paramId)) != (newValue = Float.parseFloat(_paramValue))) {
            this.m_tweakingActor.Behaviours().get(_behaviourId).setFloatParameter(_paramId, newValue);
        }
        if (_typeId == 2 && !(oldValue = this.m_tweakingActor.Behaviours().get(_behaviourId).getStringParameter(_paramId)).equals(newValue = _paramValue)) {
            this.m_tweakingActor.Behaviours().get(_behaviourId).setStringParameter(_paramId, newValue);
        }
    }

    protected String _getTypeStringDependingTypeId(int _typeId) {
        if (_typeId == 0) {
            return "int";
        }
        if (_typeId == 1) {
            return "float";
        }
        if (_typeId == 2) {
            return "string";
        }
        return "none";
    }

    protected void _initBehaviourParamList() {
        this.m_listBehaviourParams.clear();
        int i = 0;
        while (i < this.m_tweakingActor.Behaviours().size()) {
            Behaviour b = this.m_tweakingActor.Behaviours().get(i);
            if (b.HasParam()) {
                EditParam eparam;
                BehaviourParameter<Object> param;
                if (b.IntParamsDictionary() != null) {
                    for (Map.Entry<String, BehaviourParameter<Number>> entry : b.IntParamsDictionary().entrySet()) {
                        param = entry.getValue();
                        if (!param.isEditable()) continue;
                        eparam = new EditParam();
                        eparam.m_index = i;
                        eparam.m_type = 0;
                        eparam.m_name = entry.getKey();
                        this.m_listBehaviourParams.add(eparam);
                    }
                }
                if (b.FloatParamsDictionary() != null) {
                    for (Map.Entry<String, BehaviourParameter<Object>> entry : b.FloatParamsDictionary().entrySet()) {
                        param = entry.getValue();
                        if (!param.isEditable()) continue;
                        eparam = new EditParam();
                        eparam.m_index = i;
                        eparam.m_type = 1;
                        eparam.m_name = entry.getKey();
                        this.m_listBehaviourParams.add(eparam);
                    }
                }
                if (b.StringParamsDictionary() != null) {
                    for (Map.Entry<String, BehaviourParameter<Object>> entry : b.StringParamsDictionary().entrySet()) {
                        param = entry.getValue();
                        if (!param.isEditable()) continue;
                        eparam = new EditParam();
                        eparam.m_index = i;
                        eparam.m_type = 2;
                        eparam.m_name = entry.getKey();
                        this.m_listBehaviourParams.add(eparam);
                    }
                }
                if (this.m_listBehaviourParams != null && this.m_listBehaviourParams.size() > 0) {
                    Collections.sort(this.m_listBehaviourParams, new EditParamComparator());
                }
                this.m_behaviourParamId = 0;
            }
            ++i;
        }
    }

    public void update() {
        if (this.Visible()) {
            if (InputManager.IsNewKeyPress(Keys.Tab)) {
                FlxG.flash.start(Color.White());
                this._showHide(false);
                return;
            }
            if (InputManager.IsNewKeyPress(Keys.Enter)) {
                this._validateCurrentParams();
                ++this.m_behaviourParamId;
                this.m_bEraseValue = true;
                if (this.m_behaviourParamId < this.m_listBehaviourParams.size()) {
                    this._updateTexts();
                } else {
                    this.m_tweakingActor.notifyBehavioursParameterChanges();
                    this._showHide(false);
                }
            } else {
                this._handleInputDependingParamType();
            }
        }
    }

    protected void _handleInputDependingParamType() {
        int type = this.m_listBehaviourParams.get((int)this.m_behaviourParamId).m_type;
        if (InputManager.IsNewKeyPress(Keys.Back)) {
            this.m_bEraseValue = false;
            if (this.m_paramValue.text().length() > 0) {
                this.m_paramValue.text(this.m_paramValue.text().substring(0, this.m_paramValue.text().length() - 1));
            }
        } else if (type == 0) {
            this._handleIntegerTyping();
        } else if (type == 1) {
            this._handleFloatTyping();
        } else if (type == 2) {
            this._handleStringTyping();
        }
    }

    protected void _handleIntegerTyping() {
        int value = 0;
        if (InputManager.IsNewIntergerKeyPress(this.HelperOutValue)) {
            value = this.HelperOutValue.get();
            this._updateEraseFlag();
            this.m_paramValue.text(String.valueOf(this.m_paramValue.text()) + value);
        } else if (InputManager.IsNewMinusKeyPress()) {
            this.m_paramValue.text("-");
        }
    }

    protected void _handleFloatTyping() {
        int value = 0;
        if (InputManager.IsNewIntergerKeyPress(this.HelperOutValue)) {
            value = this.HelperOutValue.get();
            this._updateEraseFlag();
            this.m_paramValue.text(String.valueOf(this.m_paramValue.text()) + value);
        } else if (InputManager.IsNewMinusKeyPress()) {
            this.m_paramValue.text("-");
        } else if (InputManager.IsNewFloatDotKeyPress() && this.m_paramValue.text().length() > 0 && !this.m_paramValue.text().contains(",")) {
            this.m_paramValue.text(String.valueOf(this.m_paramValue.text()) + ".");
        }
    }

    protected void _handleStringTyping() {
        char c = InputManager.IsNewCharKeyPress(true);
        int integer = 0;
        if (c != '\u0000') {
            this.m_paramValue.text(String.valueOf(this.m_paramValue.text()) + c);
        } else if (InputManager.IsNewIntergerKeyPress(this.HelperOutValue)) {
            integer = this.HelperOutValue.get();
            this.m_paramValue.text(String.valueOf(this.m_paramValue.text()) + integer);
        }
    }

    protected void _updateEraseFlag() {
        if (this.m_bEraseValue) {
            this.m_paramValue.text("");
            this.m_bEraseValue = false;
        }
    }

    class EditParam {
        public int m_index;
        public int m_type;
        public String m_name;

        EditParam() {
        }
    }
}

