/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.Level;
import SSS.Managers.BTM.SaveManager;
import SSS.UI.Menu;
import SSS.UI.MenuEditorLevelSelection;
import SSS.UI.MenuInputText;
import SSS.UI.MenuSettingBars;
import SSS.Util.InputManager;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.flixel.FlxText;

public class MenuEditor
extends Menu {
    Level m_level = null;
    float m_cury = 0.0f;
    boolean m_bWaitingForAsync = false;
    MenuEditorLevelSelection m_levelSelection = null;
    MenuInputText m_levelSaveInput = null;
    FlxText m_txt;
    FlxText m_txtAdditionnal;
    FlxSprite m_helpBackground;
    FlxText m_txtHelp;
    MenuSettingBars m_screenSettings;
    CallbackSimple m_onScreenSettingsValidate = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this._onScreenSettingsValidate();
        }
    };
    CallbackSimple m_onInputDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onInputDone(_sender, _args);
        }
    };
    CallbackSimple m_onInputCancel = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onInputCancel(_sender, _args);
        }
    };
    CallbackSimple m_onLevelSelectionDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onLevelSelectionDone(_sender, _args);
        }
    };
    CallbackSimple m_onLevelSelectionCancel = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onLevelSelectionCancel(_sender, _args);
        }
    };
    CallbackSimple m_onNewLevel = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onNewLevel();
        }
    };
    CallbackSimple m_onUpdateGameSave = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onUpdateGameSave();
        }
    };
    CallbackSimple m_onToggleConsole = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onToggleConsole();
        }
    };
    CallbackSimple m_onFullPowerGameSave = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onFullPowerGameSave();
        }
    };
    CallbackSimple m_onSaveComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this._onSaveComplete(_sender, _args);
        }
    };
    CallbackSimple m_onResetGameSave = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onResetGameSave();
        }
    };
    CallbackSimple m_onReturnToHub = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onReturnToHub();
        }
    };
    CallbackSimple m_onResetLevel = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onResetLevel();
        }
    };
    CallbackSimple m_onTestEdit = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onTestEdit();
        }
    };
    CallbackSimple m_onPlayEdit = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onPlayEdit();
        }
    };
    CallbackSimple m_onSaveWithoutAskName = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onSaveWithoutAsk();
        }
    };
    CallbackSimple m_onSave = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onSave();
        }
    };
    CallbackSimple m_onLoadSequence = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onLoadSequence();
        }
    };
    CallbackSimple m_onRecomputeGround = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onRecomputeGround();
        }
    };
    CallbackSimple m_onScreenSetting = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onScreenSetting();
        }
    };
    CallbackSimple m_onLoad = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditor.this.onLoad();
        }
    };

    public MenuEditor(Level _level) {
        this.m_level = _level;
        this.m_cury = GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor ? 60.0f : 70.0f;
        this.m_txt = new FlxText(0.0f, 0.0f, 56.0f, "Menu WIP");
        this.m_txt.alignment = FlxText.FlxJustification.Center;
        this.m_txt.color(Color.White());
        this.m_txt.scrollFactor = Vector2.Zero();
        this.m_txt.antialiasing = true;
        this.m_txtAdditionnal = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txt.x = (float)FlxG.width * 0.5f - this.m_txt.width * 0.5f;
        this.m_txt.y = this.m_cury;
        this.Layer().add(this.m_txt);
        this.Layer().add(this.m_txtAdditionnal);
        boolean bDisplayHelp = true;
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            this.m_cury += 25.0f;
            this._addEntry(true, "Test/Edit", this.m_cury, this.m_onTestEdit);
            this.m_cury += 25.0f;
            this._addEntry(false, "Play/Edit", this.m_cury, this.m_onPlayEdit);
            this.m_cury += 25.0f;
            this._addEntry(false, "Save", this.m_cury, this.m_onSaveWithoutAskName);
            this.m_cury += 25.0f;
            this._addEntry(false, "Reset the level", this.m_cury, this.m_onResetLevel);
            this.m_cury += 25.0f;
            this._addEntry(false, "Return to Level Hub", this.m_cury, this.m_onReturnToHub);
        } else if (GameVars.GameMode() != GameMode.GameMode_OnlineContent) {
            this.m_cury += 30.0f;
            this._addEntry(false, "New Level", this.m_cury, this.m_onNewLevel);
            this.m_cury += 30.0f;
            this._addEntry(true, "Test/Edit", this.m_cury, this.m_onTestEdit);
            this.m_cury += 30.0f;
            this._addEntry(false, "Play/Edit", this.m_cury, this.m_onPlayEdit);
            this.m_cury += 30.0f;
            this._addEntry(false, "Save", this.m_cury, this.m_onSave);
            this.m_cury += 30.0f;
            this._addEntry(false, "Load", this.m_cury, this.m_onLoad);
            this.m_cury += 30.0f;
            this._addEntry(false, "Recompute Ground", this.m_cury, this.m_onRecomputeGround);
            this.m_cury += 30.0f;
            this._addEntry(false, "Screen Setting", this.m_cury, this.m_onScreenSetting);
            this.m_cury += 30.0f;
            this._addEntry(false, "Return to Level Hub", this.m_cury, this.m_onReturnToHub);
            this.m_cury += 30.0f;
            this._addEntry(false, "Reset Game Save", this.m_cury, this.m_onResetGameSave);
            this.m_cury += 30.0f;
            this._addEntry(false, "Update Game Save", this.m_cury, this.m_onUpdateGameSave);
            this.m_cury += 30.0f;
            this._addEntry(false, "Full Power Game Save", this.m_cury, this.m_onFullPowerGameSave);
            this.m_cury += 30.0f;
            this._addEntry(false, "Full Power Game Save", this.m_cury, this.m_onToggleConsole);
            this._buildMenuFromSequences();
            bDisplayHelp = false;
        }
        this.m_confirmText = new FlxText(0.0f, 0.0f, 200.0f);
        this.m_confirmText.scrollFactor = Vector2.Zero();
        this.m_confirmText.color(Color.Red());
        this.m_confirmText.alignment = FlxText.FlxJustification.Left;
        this.m_confirmText.text("Confirm?");
        this.m_confirmText.visible = false;
        this.m_layer.add(this.m_confirmText);
        this.m_helpBackground = new FlxSprite();
        if (bDisplayHelp) {
            this.m_helpBackground.createGraphic((int)((float)FlxG.width * 0.75f), (int)((float)FlxG.height * 0.67f), Color.Gray());
            this.m_helpBackground.x = (float)FlxG.width * 0.5f - this.m_helpBackground.width * 0.5f;
            this.m_helpBackground.y = (float)FlxG.height * 0.64f - this.m_helpBackground.height * 0.5f;
            this.m_helpBackground.alpha(0.85f);
            this.m_helpBackground.scrollFactor = Vector2.Zero();
            this.m_layer.add(this.m_helpBackground);
        }
        this.m_txtHelp = new FlxText(0.0f, 0.0f, FlxG.width);
        if (bDisplayHelp) {
            this.m_txtHelp.alignment = FlxText.FlxJustification.Left;
            this.m_txtHelp.UseShadow(true);
            this.m_txtHelp.ShadowOffset(1.0f);
            this.m_txtHelp.color(Color.YellowSub());
            this.m_txtHelp.shadow(Color.Black());
            String helpContent = "INFOS\nYour level is saved each time you Play or Test it\nWARN: in the Tech Demo, NOTHING is saved, but only pretend to by saved! And not all the editor stuff is available (to avoid spoil!)\nThis is a pretty WIP Editor, so it may crash sometimes (if you put wrong this as arguments to some attribs etc.)\nYou can use your gamepad to build levels, but you will have to guess the buttons (common', there is not a lot of buttons!)\n-------------------------------\nSHORCUTS\nF1: Show/hide help and editor wip menu\nF2: Test/Edit shortcut: to test subpart of your level without restarting from begining\nF3: Play/Edit shortcut: to play your ENTIRE level from the begining\nF5: Toggle show/hide all actors/actors in the current layer\nF6: Toggle show/hide Actor Library and Layer HUD\nArrows keys: move Tetrobot (Edit or not Edit)\nEnter: edit attribs of the cursor actor or the actor in the scene (see left bottom info text)\nRightstick/right control: grab/ungrab Tetrobot in test mode. When grabbed, use directions to flyyyyy\nDpad Up-Down/NumPad8-2: increase/decrease the current material count in test mode\n-------------------------------\nMOUSE\nMove: move the cursor in the scene, with the cursor actor attached\nLC: (Left Click) instanciate selected actor in the scene\nRC: (Right Click) remove under cursor actor in the scene\nMW: (Mouse Wheel) change the selected cursor actor with the next/previous in Actor Library\nShift + MW: change the layer (will change the Actor Library as well)\nShift + LC on an existing actor in the scene: copy all attributes of this actor and put it in the cursor actor\nCltr: put the Tetrobot under the mouse\nCltr + mouse move: attrack Tetobot where the cursor is\n-------------------------------\nWIP MENU NAVIGATION\nUse arrows to navigate, and Enter to make your choice\n";
            this.m_txtHelp.text(helpContent);
            this.m_txtHelp.x = this.m_helpBackground.x + 5.0f;
            this.m_txtHelp.y = this.m_helpBackground.y;
            this.m_layer.add(this.m_txtHelp);
        }
        this.m_levelSelection = new MenuEditorLevelSelection();
        this.m_levelSelection.addOnSelectionDoneCallback(this.m_onLevelSelectionDone);
        this.m_levelSelection.addOnSelectionCanceledCallback(this.m_onLevelSelectionCancel);
        this.m_levelSaveInput = new MenuInputText();
        this.m_levelSaveInput.addOnInputDoneCallback(this.m_onInputDone);
        this.m_levelSaveInput.addOnInputCanceledCallback(this.m_onInputCancel);
        this.m_screenSettings = new MenuSettingBars(this.Layer());
        this.m_screenSettings.showHide(false);
        this.m_screenSettings.addOnMenuValidation(this.m_onScreenSettingsValidate);
        this._showHide();
    }

    @Override
    protected void _showHide() {
        super._showHide();
        if (this.Visible() && !this.m_level.allowEdit()) {
            this.m_txt.text("Paused");
            this.m_txt.alignment = FlxText.FlxJustification.Center;
            this.m_txt.x = (float)FlxG.width * 0.5f - this.m_txt.width * 0.5f;
            this.m_txt.y = (float)FlxG.height * 0.5f - this.m_txt.height * 0.5f;
            this.m_txtAdditionnal.text("Press [Y] to return to level hub");
            this.m_txtAdditionnal.x = (float)FlxG.width * 0.5f - this.m_txtAdditionnal.width * 0.5f;
            this.m_txtAdditionnal.y = this.m_txt.y + this.m_txt.height;
            this._hideEntries();
        }
        this.m_helpBackground.visible = this.Visible();
        this.m_txtHelp.visible = this.Visible();
        if (!this.Visible()) {
            this.m_screenSettings.showHide(false);
        }
        this.m_level.AllowMaincharacterMove(!this.Visible());
    }

    protected void _buildMenuFromSequences() {
        ArrayList<String> refListSequenceName = this.m_level.getLevelsSequences();
        if (refListSequenceName != null) {
            for (String sequenceName : refListSequenceName) {
                this.m_cury += 30.0f;
                this._addEntry(false, sequenceName, this.m_cury, this.m_onLoadSequence);
            }
        }
    }

    protected void _onScreenSettingsValidate() {
        this.m_screenSettings.showHide(false);
    }

    public void onInputDone(Object sender, Object e) {
        String typedText = this.m_levelSaveInput.endInput();
        if (typedText != null && typedText.length() > 0) {
            this.m_level.SaveLevel(typedText);
        }
        this.m_bWaitingForAsync = false;
    }

    public void onInputCancel(Object sender, Object e) {
        this.m_levelSaveInput.endInput();
        this.m_bWaitingForAsync = false;
    }

    public void onLevelSelectionDone(Object sender, Object e) {
        this.m_bWaitingForAsync = false;
        this.m_level.LoadLevel(this.m_levelSelection.LevelSelected(), true);
        this.Visible(false);
    }

    public void onLevelSelectionCancel(Object sender, Object e) {
        this.m_bWaitingForAsync = false;
    }

    public void update() {
        if (this.m_screenSettings.Visible()) {
            this.m_screenSettings.update();
            return;
        }
        if (this.m_bWaitingForAsync) {
            if (this.m_levelSelection.Visible()) {
                this.m_levelSelection.update();
            } else if (this.m_levelSaveInput.Visible()) {
                this.m_levelSaveInput.update();
            }
            return;
        }
        if (this.m_level.allowEdit()) {
            if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp)) {
                this._updateButtonEntry(-1);
            } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown)) {
                this._updateButtonEntry(1);
            } else if (InputManager.IsNewButtonPress(Buttons.A)) {
                this.CurrentEntry().onSimulateMouseClick();
            } else if (InputManager.IsNewKeyPress(Keys.Enter)) {
                this.CurrentEntry().onSimulateMouseClick();
            }
        }
    }

    public void onNewLevel() {
        this.m_level.newLevel();
        this.Visible(false);
    }

    public void onUpdateGameSave() {
        SaveManager.Instance().saveGameDataThreaded(this.m_onSaveComplete);
    }

    public void onToggleConsole() {
        FlxG.Console().toggle();
    }

    public void onFullPowerGameSave() {
        this.m_level.MainPlayerBehaviour().unlockAllPower();
        SaveManager.Instance().saveGameDataThreaded(this.m_onSaveComplete);
    }

    protected void _onSaveComplete(Object _sender, Object _args) {
        FlxG.flash.start(Color.Green());
    }

    public void onResetGameSave() {
        SaveManager.Instance().resetGameData();
        FlxG.flash.start(Color.Red());
    }

    public void onReturnToHub() {
        this.m_level.returnToLevelHub();
    }

    public void onResetLevel() {
        if (this.m_confirmationEraseCount == 0) {
            ++this.m_confirmationEraseCount;
            this.m_confirmText.x = this.m_currentEntryBtn.x + this.m_currentEntryBtn.width + 2.0f;
            this.m_confirmText.y = this.m_currentEntryBtn.y + 2.0f;
            this.m_confirmText.visible = true;
        } else {
            this.m_confirmationEraseCount = 0;
            this.m_confirmText.visible = false;
            FlxG.flash.start(Color.White());
            this.m_level.enterEditMode();
            this.m_level.resetContent();
        }
    }

    public void onTestEdit() {
        if (this.m_level.inEditMode()) {
            this.m_level.enterTestMode();
        } else {
            this.m_level.enterEditMode();
        }
        this.Visible(false);
    }

    public void onPlayEdit() {
        if (this.m_level.inEditMode()) {
            this.m_level.enterPlayMode(true);
        } else {
            this.m_level.enterEditMode();
        }
        this.Visible(false);
    }

    public void onSaveWithoutAsk() {
        this.m_level.enterEditMode();
        this.m_level.save(GameVars.LastCommunityEditLevelXmlName());
        FlxG.flash.start(Color.White());
        this.Visible(false);
    }

    public void onSave() {
        this.m_level.enterEditMode();
        this.m_bWaitingForAsync = true;
        this.m_levelSaveInput.beginInput("Enter the name of the level with the keyboard", this.m_level.Name());
    }

    public void onLoadSequence() {
        String curButtonName = this.CurrentEntry().OnTextValue();
        if (this.m_level.hasLevelsSequence(curButtonName)) {
            this.m_level.launchFirstLevelInSequence(curButtonName);
        }
    }

    public void onRecomputeGround() {
        this.m_level.recomputeGround();
    }

    public void onScreenSetting() {
        this.m_screenSettings.showHide(true);
    }

    public void onLoad() {
        this.m_level.enterEditMode();
        this.m_bWaitingForAsync = true;
        this.m_levelSelection.startSelection();
    }

    public void registerLayer(FlxState _ownerState) {
        _ownerState.add(this.Layer());
        this.m_levelSelection.registerLayer(_ownerState);
        this.m_levelSaveInput.registerLayer(_ownerState);
    }

    public void checkShortcuts() {
        boolean ctrl;
        boolean bl = ctrl = InputManager.IsKeyDown(Keys.LeftControl) || InputManager.IsKeyDown(Keys.RightControl);
        if (InputManager.IsNewKeyPress(Keys.F2) || ctrl && InputManager.IsNewKeyPress(Keys.T)) {
            this.m_onTestEdit.onCallback(this, null);
        } else if (InputManager.IsNewKeyPress(Keys.F3) || ctrl && InputManager.IsNewKeyPress(Keys.P)) {
            this.m_onPlayEdit.onCallback(this, null);
        }
    }
}

