/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.Events.CallbackSimple;
import SSS.UI.Menu;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxState;

public class MenuEditorLevelSelection
extends Menu {
    ArrayList<CallbackSimple> OnSelectionDoneCallback = null;
    ArrayList<CallbackSimple> OnSelectionCanceledCallback = null;
    FlxSprite m_background;
    boolean m_bFocus = false;
    char m_keyChar = '\u0000';
    static final float m_timeBetweenMove = 0.11f;
    float m_timeLeftToMove = 0.0f;
    String m_levelSelected = "";
    FilenameFilter m_filterXmlExtension = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    };
    CallbackSimple m_onLoadItem = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            MenuEditorLevelSelection.this.onLoadItem();
        }
    };

    public void addOnSelectionDoneCallback(CallbackSimple callback) {
        if (this.OnSelectionDoneCallback == null) {
            this.OnSelectionDoneCallback = new ArrayList();
        }
        this.OnSelectionDoneCallback.add(callback);
    }

    public void addOnSelectionCanceledCallback(CallbackSimple callback) {
        if (this.OnSelectionCanceledCallback == null) {
            this.OnSelectionCanceledCallback = new ArrayList();
        }
        this.OnSelectionCanceledCallback.add(callback);
    }

    public String LevelSelected() {
        return this.m_levelSelected;
    }

    public MenuEditorLevelSelection() {
        this.m_background = new FlxSprite();
        this.m_background.width = FlxG.width;
        this.m_background.height = FlxG.height;
        this.m_background.color(Color.Black());
        this.m_background.x = 0.0f;
        this.m_background.y = 0.0f;
        this.m_background.scrollFactor = Vector2.Zero();
        this.m_background.visible = this.Visible();
        this.Layer().add(this.m_background);
    }

    public void startSelection() {
        if (!this.Visible()) {
            this.m_bFocus = true;
            this._buildButtons();
            this.m_background.visible = true;
            this.Visible(true);
        }
    }

    protected void _endSelection() {
        if (this.Visible()) {
            this.m_bFocus = false;
            this.Visible(false);
            this.m_background.visible = false;
        }
    }

    protected void _buildButtons() {
        this._destroyButtons();
        String contentPath = Utility.GetContentPath(Utility.eContentPath.eContentPath_Level);
        File dir = new File(contentPath);
        String[] children = dir.list(this.m_filterXmlExtension);
        float cury = 10.0f;
        boolean bDefault = true;
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this._addEntry(bDefault, children[i].replace(".xml", ""), cury, this.m_onLoadItem);
                cury += 30.0f;
                ++i;
            }
        }
    }

    public void update() {
        if (this.m_bFocus) {
            this.m_keyChar = InputManager.IsNewCharKeyPress(false);
            if (this.m_keyChar != '\u0000' && this.m_keyChar != ' ') {
                this._selectFirstEntryByLetter(String.valueOf(this.m_keyChar));
            }
            if (InputManager.IsNewButtonPress(Buttons.B)) {
                this._cancelLoad();
            } else if (InputManager.IsNewButtonPress(Buttons.A)) {
                this._confirmLoad();
            }
            if (InputManager.IsButtonDown(Buttons.LeftThumbstickDown)) {
                if (this._checkTimeMoves()) {
                    this._selectNearEntry(true);
                }
            } else if (InputManager.IsButtonDown(Buttons.LeftThumbstickUp)) {
                if (this._checkTimeMoves()) {
                    this._selectNearEntry(false);
                }
            } else {
                this.m_timeLeftToMove = 0.0f;
            }
        }
    }

    protected boolean _checkTimeMoves() {
        boolean res = false;
        this.m_timeLeftToMove -= FlxG.elapsed;
        if (this.m_timeLeftToMove <= 0.0f) {
            this.m_timeLeftToMove = 0.11f;
            res = true;
        }
        return res;
    }

    protected void onLoadItem() {
        if (this.OnSelectionDoneCallback != null) {
            int i = 0;
            while (i < this.OnSelectionDoneCallback.size()) {
                this.OnSelectionDoneCallback.get(i).onCallback(this, null);
                ++i;
            }
        }
        this._endSelection();
    }

    protected void _confirmLoad() {
        if (this.CurrentEntry() != null) {
            this.m_levelSelected = this.CurrentEntry().OnTextValue();
            this.CurrentEntry().onSimulateMouseClick();
        }
    }

    protected void _cancelLoad() {
        if (this.OnSelectionCanceledCallback != null) {
            int i = 0;
            while (i < this.OnSelectionCanceledCallback.size()) {
                this.OnSelectionCanceledCallback.get(i).onCallback(this, null);
                ++i;
            }
        }
        this._endSelection();
    }

    public void registerLayer(FlxState _ownerState) {
        _ownerState.add(this.Layer());
    }
}

