/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Events.CallbackSimple;
import SSS.Util.InputManager;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.flixel.FlxText;

public class MenuInputText {
    ArrayList<CallbackSimple> OnInputDoneCallback = null;
    ArrayList<CallbackSimple> OnInputCanceledCallback = null;
    protected String m_inputTextString = "";
    protected boolean m_bVisible = false;
    FlxText m_inputText;
    FlxText m_labelText;
    FlxSprite m_background;

    public void addOnInputDoneCallback(CallbackSimple callback) {
        if (this.OnInputDoneCallback == null) {
            this.OnInputDoneCallback = new ArrayList();
        }
        this.OnInputDoneCallback.add(callback);
    }

    public void addOnInputCanceledCallback(CallbackSimple callback) {
        if (this.OnInputCanceledCallback == null) {
            this.OnInputCanceledCallback = new ArrayList();
        }
        this.OnInputCanceledCallback.add(callback);
    }

    public boolean Visible() {
        return this.m_bVisible;
    }

    public MenuInputText() {
        this._buildMenu();
        this._hide();
    }

    protected void _buildMenu() {
        this.m_background = new FlxSprite();
        this.m_background.createGraphic(FlxG.width, FlxG.height, Color.Black());
        this.m_labelText = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_labelText.alignment = FlxText.FlxJustification.Center;
        this.m_labelText.text("");
        this.m_inputText = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_inputText.alignment = FlxText.FlxJustification.Center;
        this.m_inputText.text("");
        this.m_background.scrollFactor = Vector2.Zero();
        this.m_labelText.scrollFactor = Vector2.Zero();
        this.m_labelText.y = 10.0f;
        this.m_inputText.scrollFactor = Vector2.Zero();
        this.m_inputText.y = (float)FlxG.height * 0.5f;
    }

    protected void _hide() {
        this.m_background.visible = false;
        this.m_labelText.visible = false;
        this.m_inputText.visible = false;
        this.m_bVisible = false;
    }

    protected void _show() {
        this.m_background.visible = true;
        this.m_labelText.visible = true;
        this.m_inputText.visible = true;
        this.m_bVisible = true;
    }

    public void registerLayer(FlxState _ownerState) {
        _ownerState.add(this.m_background);
        _ownerState.add(this.m_labelText);
        _ownerState.add(this.m_inputText);
    }

    public void beginInput(String _textDesc, String _inputInit) {
        this.m_labelText.text(_textDesc);
        this.m_inputTextString = _inputInit;
        this.m_inputText.text(_inputInit);
        this._show();
    }

    public String endInput() {
        this._hide();
        return this.m_inputTextString;
    }

    public void update() {
        if (InputManager.IsNewKeyPress(Keys.Enter)) {
            if (this.OnInputDoneCallback != null) {
                int i = 0;
                while (i < this.OnInputDoneCallback.size()) {
                    this.OnInputDoneCallback.get(i).onCallback(this, null);
                    ++i;
                }
            }
        } else if (InputManager.IsNewKeyPress(Keys.Tab)) {
            if (this.OnInputCanceledCallback != null) {
                int i = 0;
                while (i < this.OnInputCanceledCallback.size()) {
                    this.OnInputCanceledCallback.get(i).onCallback(this, null);
                    ++i;
                }
            }
        } else if (InputManager.IsNewKeyPress(Keys.Back)) {
            if (this.m_inputTextString.length() > 0) {
                this.m_inputTextString = this.m_inputTextString.substring(0, this.m_inputTextString.length() - 1);
                this.m_inputText.text(this.m_inputTextString);
            }
        } else {
            char key = InputManager.GetNewKeyboardReadableKeyPress();
            if (key != '\u0000') {
                this.m_inputTextString = String.valueOf(this.m_inputTextString) + key;
                this.m_inputText.text(this.m_inputTextString);
            }
        }
    }
}

