/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Input.Buttons;
import SSS.Events.CallbackSimple;
import SSS.UI.SettingBar;
import SSS.Util.InputManager;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxGroup;

public class MenuSettingBars {
    protected ArrayList<CallbackSimple> OnMenuValidation = null;
    SettingBar[] m_settingBars;
    int m_curBarId = 0;
    FlxGroup m_layer;
    boolean m_bVisible = true;

    public void addOnMenuValidation(CallbackSimple _callback) {
        if (this.OnMenuValidation == null) {
            this.OnMenuValidation = new ArrayList();
        }
        this.OnMenuValidation.add(_callback);
    }

    public boolean Visible() {
        return this.m_bVisible;
    }

    public MenuSettingBars(FlxGroup _layer) {
        this.m_layer = _layer;
        this.m_settingBars = new SettingBar[7];
        float barcx = (float)FlxG.width * 0.5f;
        float barcy = (float)FlxG.height * 0.25f;
        this._addBar(FlxG.eScreenCorrection.Saturation, 0, barcx, barcy, 0.0f, 2.5f, 1.0f);
        this._addBar(FlxG.eScreenCorrection.Scale, 1, barcx, barcy += 30.0f, 0.5f, 1.5f, 1.0f);
        this._addBar(FlxG.eScreenCorrection.Brightness, 2, barcx, barcy += 30.0f, 0.1f, 1.5f, 1.0f);
        this._addBar(FlxG.eScreenCorrection.Contrast, 3, barcx, barcy += 30.0f, 0.1f, 1.5f, 1.0f);
        this._addBar(FlxG.eScreenCorrection.RedBalance, 4, barcx, barcy += 30.0f, -0.5f, 0.5f, 0.0f);
        this._addBar(FlxG.eScreenCorrection.GreenBalance, 5, barcx, barcy += 30.0f, -0.5f, 0.5f, 0.0f);
        this._addBar(FlxG.eScreenCorrection.BlueBalance, 6, barcx, barcy += 30.0f, -0.5f, 0.5f, 0.0f);
        barcy += 30.0f;
        this._setCurrentBarActive(true);
    }

    protected void _setCurrentBarActive(boolean _bActive) {
        this.m_settingBars[this.m_curBarId].setActive(_bActive);
    }

    protected void _addBar(FlxG.eScreenCorrection _idType, int _slot, float _centerx, float _centery, float _min, float _max, float _default) {
        SettingBar bar;
        this.m_settingBars[_slot] = bar = new SettingBar(_idType, _min, _max, this.m_layer, _centerx, _centery, _default);
    }

    public void update() {
        if (InputManager.IsNewButtonPress(Buttons.A)) {
            if (this.OnMenuValidation != null) {
                int i = 0;
                while (i < this.OnMenuValidation.size()) {
                    this.OnMenuValidation.get(i).onCallback(this, null);
                    ++i;
                }
            }
        } else {
            boolean leftRight;
            boolean bl = leftRight = InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || InputManager.IsButtonDown(Buttons.LeftThumbstickRight);
            if (!leftRight) {
                if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown)) {
                    this._setCurrentBarActive(false);
                    ++this.m_curBarId;
                    if (this.m_curBarId >= this.m_settingBars.length) {
                        this.m_curBarId = 0;
                    }
                    this._setCurrentBarActive(true);
                } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp)) {
                    this._setCurrentBarActive(false);
                    --this.m_curBarId;
                    if (this.m_curBarId < 0) {
                        this.m_curBarId = this.m_settingBars.length - 1;
                    }
                    this._setCurrentBarActive(true);
                }
            }
        }
        this.m_settingBars[this.m_curBarId].update();
    }

    public void showHide(boolean _bShow) {
        this.m_bVisible = _bShow;
        int i = 0;
        while (i < this.m_settingBars.length) {
            this.m_settingBars[i].showHide(_bShow);
            ++i;
        }
    }
}

