/*
 * Decompiled with CFR 0.152.
 */
package SSS.UI;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.Util.InputManager;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class SettingBar {
    FlxText m_text;
    FlxSprite m_barBackground;
    FlxSprite m_barForeGround;
    FlxG.eScreenCorrection m_associatedValue;
    float m_value;
    float m_defaultValue;
    float m_min;
    float m_max;
    FlxGroup m_layer;
    boolean m_bActive = false;
    float m_centerx;
    float m_centery;

    public SettingBar(FlxG.eScreenCorrection _associatedValue, float _min, float _max, FlxGroup _layer, float _centerx, float _centery, float _defaultValue) {
        this.m_associatedValue = _associatedValue;
        this.m_layer = _layer;
        this.m_min = _min;
        this.m_max = _max;
        this.m_centerx = _centerx;
        this.m_centery = _centery;
        this.m_defaultValue = _defaultValue;
        this.m_value = FlxG.ArrayScreenCorrections[this.m_associatedValue.ordinal()];
        this._build();
    }

    protected void _build() {
        String text = "none";
        switch (this.m_associatedValue) {
            case Saturation: {
                text = "Saturation";
                break;
            }
            case Scale: {
                text = "Screen Size";
                break;
            }
            case Brightness: {
                text = "Brightness";
                break;
            }
            case Contrast: {
                text = "Constrast";
                break;
            }
            case RedBalance: {
                text = "Red Color Balance";
                break;
            }
            case GreenBalance: {
                text = "Green Color Balance";
                break;
            }
            case BlueBalance: {
                text = "Blue Color Balance";
            }
        }
        this.m_text = new FlxText(0.0f, 0.0f, (float)FlxG.width, text);
        this.m_text.alignment = FlxText.FlxJustification.Center;
        this.m_text.x = this.m_centerx - this.m_text.width * 0.5f;
        this.m_text.y = this.m_centery - this.m_text.height * 0.5f;
        this.m_barBackground = new FlxSprite();
        this.m_barBackground.createGraphic((int)((float)FlxG.width * 0.25f), (int)(this.m_text.height * 2.0f), Color.Black());
        this.m_barBackground.scrollFactor = Vector2.Zero();
        this.m_barBackground.x = this.m_text.x + this.m_text.width * 0.5f - this.m_barBackground.width * 0.5f;
        this.m_barBackground.y = this.m_text.y + this.m_text.height * 0.5f - this.m_barBackground.height * 0.5f;
        this.m_barForeGround = new FlxSprite();
        this.m_barForeGround.createGraphic(0, (int)(this.m_barBackground.height - this.m_barBackground.height * 0.2f), Color.RoyalBlue());
        this.m_barForeGround.scrollFactor = Vector2.Zero();
        this.m_layer.add(this.m_barBackground);
        this.m_layer.add(this.m_barForeGround);
        this.m_layer.add(this.m_text);
        this._refreshProgressBar();
    }

    public void setActive(boolean _bActive) {
        this.m_bActive = _bActive;
        if (_bActive) {
            this.m_text.color(Color.Red());
        } else {
            this.m_text.color(Color.White());
        }
    }

    protected void _refreshProgressBar() {
        this.m_barForeGround.x = this.m_barBackground.x;
        this.m_barForeGround.y = this.m_barBackground.y + this.m_barBackground.height * 0.5f - this.m_barForeGround.height * 0.5f;
        float perc = (this.m_value - this.m_min) / (this.m_max - this.m_min);
        this.m_barForeGround.width = perc * this.m_barBackground.width;
    }

    public void update() {
        float factor = 0.1f;
        if (this.m_bActive) {
            boolean refresh = false;
            float step = 0.0f;
            if (InputManager.IsButtonDown(Buttons.LeftThumbstickLeft)) {
                step = -FlxG.elapsed * 0.1f;
            } else if (InputManager.IsButtonDown(Buttons.LeftThumbstickRight)) {
                step = FlxG.elapsed * 0.1f;
            }
            if (InputManager.IsNewButtonPress(Buttons.Y)) {
                this.m_value = this.m_defaultValue;
                refresh = true;
                step = 0.0f;
            }
            if (step != 0.0f) {
                this.m_value += step;
                if (this.m_value > this.m_max) {
                    this.m_value = this.m_max;
                } else if (this.m_value < this.m_min) {
                    this.m_value = this.m_min;
                }
                refresh = true;
            }
            if (refresh) {
                this._refreshProgressBar();
                FlxG.ArrayScreenCorrections[this.m_associatedValue.ordinal()] = this.m_value;
            }
        }
    }

    public void showHide(boolean _bShow) {
        this.m_text.visible = _bShow;
        this.m_barBackground.visible = _bShow;
        this.m_barForeGround.visible = _bShow;
    }
}

